/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import com.jgoodies.binding.list.ArrayListModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.ExportLinksTask;
import cz.vity.freerapid.core.tasks.ImportLinksTask;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.NewLinksDialog;
import cz.vity.freerapid.gui.dialogs.filechooser.OpenSaveDialogFactory;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.TaskServiceManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.container.ContainerPlugin;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;

@ProxyActions(value={"select-all", "copy", "cut", "paste", "delete"})
public class FileActions
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(FileActions.class.getName());
    private static final String ID_CONTAINER = "container";
    private final MainApp app;
    private final PluginsManager pluginsManager;
    private final DataManager dataManager;
    private final TaskServiceManager taskServiceManager;
    private final ContentPanel contentPanel;
    private NewLinksDialog dialog;
    private long restart;
    private boolean restartHookInstalled;

    public FileActions(ApplicationContext applicationContext) {
        this.app = (MainApp)applicationContext.getApplication();
        this.pluginsManager = this.app.getManagerDirector().getPluginsManager();
        this.dataManager = this.app.getManagerDirector().getDataManager();
        this.taskServiceManager = this.app.getManagerDirector().getTaskServiceManager();
        this.contentPanel = this.app.getManagerDirector().getContentManager().getContentPanel();
        this.restartHookInstalled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void addNewLinksAction(ActionEvent actionEvent) {
        ArrayListModel<DownloadFile> arrayListModel;
        boolean bl;
        final ManagerDirector managerDirector = this.app.getManagerDirector();
        ArrayListModel<DownloadFile> arrayListModel2 = null;
        boolean bl2 = bl = this.dialog != null;
        if (actionEvent.getSource() instanceof List) {
            arrayListModel2 = (ArrayListModel<DownloadFile>)actionEvent.getSource();
            if (arrayListModel2.isEmpty()) {
                return;
            }
            if (!bl) {
                Object object = this.dataManager.getLock();
                synchronized (object) {
                    arrayListModel = this.dataManager.getDownloadFiles();
                    int n = 0;
                    for (DownloadFile downloadFile : arrayListModel) {
                        URL uRL = downloadFile.getFileUrl();
                        if (!arrayListModel2.contains(uRL)) continue;
                        ++n;
                    }
                    if (n == arrayListModel2.size()) {
                        return;
                    }
                }
            }
        }
        if (!bl) {
            this.dialog = new NewLinksDialog(managerDirector, this.app.getMainFrame());
        }
        if (arrayListModel2 != null) {
            boolean bl3 = AppPrefs.getProperty("bringToFrontWhenPasted", true);
            if (bl3) {
                Swinger.bringToFront(this.app.getMainFrame(), bl3);
            } else if (!bl) {
                Swinger.bringToFront(this.app.getMainFrame(), bl3);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            arrayListModel = arrayListModel2;
            SwingUtilities.invokeLater(new Runnable((List)arrayListModel){
                final /* synthetic */ List val$urlList1;
                {
                    this.val$urlList1 = list;
                }

                @Override
                public void run() {
                    if (FileActions.this.dialog != null) {
                        FileActions.this.dialog.setURLs(this.val$urlList1);
                    } else {
                        logger.warning("Dialog is null");
                    }
                }
            });
        }
        if (!bl) {
            List<DownloadFile> list;
            this.app.prepareDialog(this.dialog, true);
            if (this.dialog.getModalResult() == 0 && !(list = this.dialog.getDownloadFiles()).isEmpty()) {
                this.dataManager.addToList(list);
                final boolean bl4 = !this.dialog.isStartPaused();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (bl4) {
                            FileActions.this.dataManager.addToQueue(list);
                        }
                        managerDirector.getContentManager().getContentPanel().selectAdded(list);
                    }
                });
            }
            this.dialog = null;
        }
    }

    @Action
    public void restartApplication() {
        this.installShutdownHook();
        this.restart = System.currentTimeMillis();
        this.app.exit();
    }

    private void installShutdownHook() {
        if (this.restartHookInstalled) {
            return;
        }
        final SystemCommander systemCommander = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.app.getContext());
        if (!systemCommander.isSupported(OSCommand.RESTART_APPLICATION)) {
            Swinger.showErrorMessage(this.app.getContext().getResourceMap(), "systemCommandNotSupported", OSCommand.RESTART_APPLICATION.toString().toLowerCase());
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() - FileActions.this.restart < 4000L) {
                    systemCommander.shutDown(OSCommand.RESTART_APPLICATION, false);
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
        this.restartHookInstalled = true;
    }

    @Action
    public void importLinksAction(ActionEvent actionEvent) {
        this.importLinks();
    }

    @Action
    public void exportSelectedLinksAction(ActionEvent actionEvent) {
        this.exportLinks(this.dataManager.getSelectionToList(this.contentPanel.getSelectedRows()));
    }

    @Action
    public void exportAllLinksAction(ActionEvent actionEvent) {
        this.exportLinks(this.dataManager.getActualDownloadFiles());
    }

    public void importLinks() {
        File[] fileArray;
        ContainerPlugin containerPlugin = this.getContainerPlugin();
        if (containerPlugin != null && (fileArray = OpenSaveDialogFactory.getInstance(this.app.getContext()).getImportLinks(containerPlugin.getSupportedFiles())) != null && fileArray.length > 0) {
            ImportLinksTask importLinksTask = new ImportLinksTask(this.app, containerPlugin, fileArray);
            this.taskServiceManager.runTask("workWithFile", importLinksTask);
        }
    }

    public void exportLinks(List<DownloadFile> list) {
        File file;
        ContainerPlugin containerPlugin;
        if (!list.isEmpty() && (containerPlugin = this.getContainerPlugin()) != null && (file = OpenSaveDialogFactory.getInstance(this.app.getContext()).getExportLinks(containerPlugin.getSupportedFiles())) != null) {
            ExportLinksTask exportLinksTask = new ExportLinksTask(this.app, containerPlugin, list, file);
            this.taskServiceManager.runTask("workWithFile", exportLinksTask);
        }
    }

    private ContainerPlugin getContainerPlugin() {
        if (!this.pluginsManager.isPluginDisabled(ID_CONTAINER)) {
            try {
                return (ContainerPlugin)this.pluginsManager.getPluginManager().getPlugin(ID_CONTAINER);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        }
        return null;
    }
}

