/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.hoster.PremiumAccount;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFileDownloadTask;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginContext;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginRunner;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.registry.PluginAttribute;
import org.java.plugin.registry.PluginDescriptor;

public abstract class AbstractFileShareService
extends Plugin
implements ShareDownloadService {
    private static final Logger logger = Logger.getLogger(AbstractFileShareService.class.getName());
    private PluginContext pluginContext;
    private Icon image;

    protected final void doStart() throws Exception {
        PluginClassLoader pluginClassLoader;
        PluginDescriptor pluginDescriptor = this.getDescriptor();
        PluginAttribute pluginAttribute = pluginDescriptor.getAttribute("faviconImage");
        if (pluginAttribute != null && (pluginClassLoader = this.getManager().getPluginClassLoader(pluginDescriptor)) != null) {
            URL uRL = pluginClassLoader.getResource(pluginAttribute.getValue());
            if (uRL == null) {
                logger.warning("Icon image for plugin '" + pluginDescriptor.getId() + "' was not found");
            } else {
                try {
                    this.image = new ImageIcon(ImageIO.read(uRL));
                }
                catch (IOException iOException) {
                    logger.warning("Icon image for plugin '" + pluginDescriptor.getId() + "' reading failed");
                }
            }
        }
        this.pluginInit();
    }

    @Override
    public void pluginInit() {
    }

    @Override
    public void pluginStop() {
    }

    protected final void doStop() throws Exception {
        this.pluginStop();
    }

    @Override
    public Icon getFaviconImage() {
        return this.image;
    }

    @Override
    public String getId() {
        return this.getDescriptor().getId();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void run(HttpFileDownloadTask httpFileDownloadTask) throws Exception {
        PluginRunner pluginRunner = this.getPluginRunnerInstance();
        if (pluginRunner == null) {
            throw new NullPointerException("getPluginRunnerInstance must no return null");
        }
        pluginRunner.init(this, httpFileDownloadTask);
        pluginRunner.run();
    }

    @Override
    public void runCheck(HttpFileDownloadTask httpFileDownloadTask) throws Exception {
        PluginRunner pluginRunner = this.getPluginRunnerInstance();
        if (pluginRunner == null) {
            throw new NullPointerException("getPluginRunnerInstance must no return null");
        }
        pluginRunner.init(this, httpFileDownloadTask);
        pluginRunner.runCheck();
    }

    @Override
    public boolean supportsRunCheck() {
        return false;
    }

    @Override
    public void showOptions() throws Exception {
    }

    @Override
    public PluginContext getPluginContext() {
        return this.pluginContext;
    }

    @Override
    public void setPluginContext(PluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    protected PremiumAccount showAccountDialog(PremiumAccount premiumAccount, String string, String string2) {
        DialogSupport dialogSupport = this.getPluginContext().getDialogSupport();
        try {
            PremiumAccount premiumAccount2 = dialogSupport.showAccountDialog(premiumAccount, string);
            if (premiumAccount2 != null) {
                this.getPluginContext().getConfigurationStorageSupport().storeConfigToFile(premiumAccount2, string2);
                return premiumAccount2;
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        return premiumAccount;
    }

    protected PremiumAccount getAccountConfigFromFile(String string) {
        if (this.getPluginContext().getConfigurationStorageSupport().configFileExists(string)) {
            try {
                return this.getPluginContext().getConfigurationStorageSupport().loadConfigFromFile(string, PremiumAccount.class);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                return new PremiumAccount();
            }
        }
        return new PremiumAccount();
    }

    protected abstract PluginRunner getPluginRunnerInstance();
}

