/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DefaultFileStreamRecognizer;
import cz.vity.freerapid.plugins.webclient.HostConfigurationWithStickyProtocol;
import cz.vity.freerapid.plugins.webclient.ProxySocketFactory;
import cz.vity.freerapid.plugins.webclient.interfaces.FileStreamRecognizer;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.utils.HttpUtils;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.URIUtil;

public class DownloadClient
implements HttpDownloadClient {
    private static final Logger logger = Logger.getLogger(DownloadClient.class.getName());
    protected HttpClient client = new HttpClient();
    protected Protocol protocol = null;
    protected String referer = "";
    protected String asString;
    private int redirect;
    private volatile ConnectionSettings settings;
    public static final String START_POSITION = "startPosition";
    public static final String SUPPOSE_TO_DOWNLOAD = "supposeToDownload";
    private int timeout = 120000;
    private FileStreamRecognizer streamRecognizer;

    @Override
    public void initClient(ConnectionSettings connectionSettings) {
        if (connectionSettings == null) {
            throw new NullPointerException("Internet connection settings cannot be null");
        }
        this.settings = connectionSettings;
        HttpClientParams httpClientParams = this.client.getParams();
        httpClientParams.setCookiePolicy("compatibility");
        httpClientParams.setParameter("http.protocol.single-cookie-header", (Object)true);
        httpClientParams.setSoTimeout(this.timeout);
        httpClientParams.setConnectionManagerTimeout((long)this.timeout);
        httpClientParams.setHttpElementCharset("UTF-8");
        this.client.setHttpConnectionManager((HttpConnectionManager)new SimpleHttpConnectionManager(true));
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(this.timeout);
        HttpState httpState = new HttpState();
        HostConfiguration hostConfiguration = new HostConfiguration();
        if (connectionSettings.getProxyType() == Proxy.Type.SOCKS) {
            hostConfiguration = new HostConfigurationWithStickyProtocol();
            Proxy proxy = new Proxy(connectionSettings.getProxyType(), new InetSocketAddress(connectionSettings.getProxyURL(), connectionSettings.getProxyPort()));
            this.protocol = new Protocol("http", (ProtocolSocketFactory)new ProxySocketFactory(proxy), 80);
        } else if (connectionSettings.getProxyType() == Proxy.Type.HTTP) {
            hostConfiguration.setProxy(connectionSettings.getProxyURL(), connectionSettings.getProxyPort());
            if (connectionSettings.getUserName() != null) {
                httpState.setProxyCredentials(AuthScope.ANY, (Credentials)new NTCredentials(connectionSettings.getUserName(), connectionSettings.getPassword(), "", ""));
            }
        }
        this.client.setHostConfiguration(hostConfiguration);
        httpClientParams.setBooleanParameter("http.protocol.allow-circular-redirects", true);
        this.client.setState(httpState);
    }

    private boolean hasAuthentification() {
        if (this.settings == null) {
            throw new IllegalStateException("Client not initialized");
        }
        return this.settings.isProxySet() && this.settings.getUserName() != null;
    }

    protected void setDefaultsForMethod(HttpMethod httpMethod) {
        if (this.client.getParams().isParameterSet("userAgent")) {
            httpMethod.setRequestHeader("User-Agent", this.client.getParams().getParameter("userAgent").toString());
        } else {
            httpMethod.setRequestHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.12) Gecko/20101026 Firefox/3.6.12");
        }
        httpMethod.setRequestHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        httpMethod.setRequestHeader("Accept-Language", "cs,en-us;q=0.7,en;q=0.3");
        httpMethod.setRequestHeader("Accept-Charset", "windows-1250,utf-8;q=0.7,*;q=0.7");
        httpMethod.setRequestHeader("Accept-Encoding", "gzip,deflate");
        httpMethod.setRequestHeader("Keep-Alive", "30");
        if (this.referer != null && this.referer.length() > 0) {
            httpMethod.setRequestHeader("Referer", this.referer);
        }
        httpMethod.setFollowRedirects(false);
    }

    @Override
    public PostMethod getPostMethod(String string) {
        PostMethod postMethod;
        try {
            postMethod = new PostMethod(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warning("Invalid URI detected for PostMethod: " + string + " Trying to reencode ");
            try {
                postMethod = new PostMethod(URIUtil.encodePathQuery((String)string));
            }
            catch (URIException uRIException) {
                throw illegalArgumentException;
            }
        }
        this.setDefaultsForMethod((HttpMethod)postMethod);
        postMethod.setDoAuthentication(this.hasAuthentification());
        return postMethod;
    }

    @Override
    public String getReferer() {
        return this.referer;
    }

    @Override
    public InputStream makeFinalRequestForFile(HttpMethod httpMethod, HttpFile httpFile, boolean bl) throws IOException {
        if (httpMethod == null) {
            throw new NullPointerException("HttpMethod cannot be null");
        }
        if (httpFile == null) {
            throw new NullPointerException("File cannot be null");
        }
        httpFile.getProperties().remove(START_POSITION);
        httpFile.getProperties().remove(SUPPOSE_TO_DOWNLOAD);
        return this.makeRequestFile(httpMethod, httpFile, 0, bl);
    }

    private InputStream makeRequestFile(HttpMethod httpMethod, HttpFile httpFile, int n, boolean bl) throws IOException {
        this.asString = "";
        if (bl && httpMethod instanceof GetMethod) {
            httpMethod.setFollowRedirects(true);
        }
        this.addRangeHeader(httpFile, httpMethod);
        this.toString(httpMethod);
        this.processHttpMethod(httpMethod);
        int n2 = httpMethod.getStatusCode();
        if (n2 == 500 || n2 == 403) {
            logger.severe("Status code je 500");
            this.updateAsString(httpMethod);
            return null;
        }
        if (n2 >= 500) {
            logger.severe("Status code > 500: " + n2);
            this.updateAsString(httpMethod);
            return null;
        }
        boolean bl2 = this.isRedirect(n2);
        if (n2 != 200 && n2 != 206 && !bl2) {
            logger.warning("Loading file failed - invalid HTTP return status code: " + n2);
            this.updateAsString(httpMethod);
            return null;
        }
        if (bl && bl2 && n < 2) {
            Header header = httpMethod.getResponseHeader("location");
            if (header != null) {
                String string = header.getValue();
                if (string == null || "".equals(string)) {
                    string = "/";
                }
                if (!string.contains("http://")) {
                    string = "http://" + httpMethod.getURI().getHost() + string;
                }
                logger.info("Redirect target: " + string);
                if (this.client.getParams().getBooleanParameter("useRefererWhenRedirect", false)) {
                    this.setReferer(string);
                }
                httpMethod.releaseConnection();
                GetMethod getMethod = this.getGetMethod(string);
                InputStream inputStream = this.makeRequestFile((HttpMethod)getMethod, httpFile, n + 1, bl);
                logger.info("Redirect: " + getMethod.getStatusLine().toString());
                return inputStream;
            }
            logger.warning("Invalid redirect");
            return null;
        }
        return this.processFileForDownload(httpMethod, httpFile);
    }

    private void addRangeHeader(HttpFile httpFile, HttpMethod httpMethod) {
        long l;
        if (!httpFile.isResumeSupported()) {
            logger.info("Resume is not supported");
            return;
        }
        File file = httpFile.getStoreFile();
        if (file != null && file.exists() && (l = Math.max(httpFile.getRealDownload(), 0L)) != 0L) {
            String string = "bytes=" + l + "-";
            httpMethod.addRequestHeader("Range", string);
            logger.info("Setting range to " + string);
        }
    }

    private InputStream processFileForDownload(HttpMethod httpMethod, HttpFile httpFile) throws IOException {
        Object object;
        String string;
        Header header = this.getContentType(httpMethod);
        boolean bl = this.checkContentTypeStream(httpMethod, true);
        String string2 = HttpUtils.getFileName(httpMethod);
        if (string2 != null && !string2.isEmpty()) {
            if (!this.client.getParams().isParameterTrue("dontUseHeaderFilename")) {
                httpFile.setFileName(string2);
            }
            if (this.client.getParams().isParameterTrue("noContentTypeInHeader")) {
                bl = true;
            }
        } else if (httpMethod.getResponseHeader("Content-Range") == null) {
            logger.warning("No Content-Disposition (filename) header in file");
        }
        if ((string = httpFile.getFileName()) == null) {
            throw new IOException("No defined file name");
        }
        httpFile.setFileName(HttpUtils.replaceInvalidCharsForFileSystem(PlugUtils.unescapeHtml(string), "_"));
        if (!bl && header != null && this.client.getParams().isParameterSet("considerAsStream")) {
            object = this.client.getParams().getParameter("considerAsStream").toString();
            if (header.getValue().equalsIgnoreCase((String)object)) {
                logger.info("considering as stream '" + (String)object + "'");
                bl = true;
            }
        }
        if (bl && this.client.getParams().isParameterFalse("noContentLengthAvailable")) {
            object = httpMethod.getResponseHeader("Content-Length");
            if (object == null) {
                bl = false;
                logger.warning("No Content-Length in header");
            } else {
                Long l = Long.valueOf(object.getValue());
                Header header2 = httpMethod.getResponseHeader("Content-Range");
                if (header2 != null) {
                    String string3 = header2.getValue();
                    Matcher matcher = Pattern.compile("(\\d+)-\\d+/(\\d+)").matcher(string3);
                    if (matcher.find()) {
                        httpFile.getProperties().put(START_POSITION, Long.valueOf(matcher.group(1)));
                        httpFile.setFileSize(Long.valueOf(matcher.group(2)));
                    } else {
                        httpFile.getProperties().put(START_POSITION, 0L);
                    }
                    httpFile.setResumeSupported(true);
                } else {
                    if (!this.client.getParams().isParameterTrue("ignoreAcceptRanges")) {
                        Header header3 = httpMethod.getResponseHeader("Accept-Ranges");
                        if (httpFile.isResumeSupported()) {
                            httpFile.setResumeSupported(header3 != null && "bytes".equals(header3.getValue()));
                        }
                    }
                    httpFile.setFileSize(l);
                }
                httpFile.getProperties().put(SUPPOSE_TO_DOWNLOAD, l);
            }
        }
        if (bl) {
            return httpMethod.getResponseBodyAsStream();
        }
        logger.warning("Loading file failed");
        this.updateAsString(httpMethod);
        return null;
    }

    private Header getContentType(HttpMethod httpMethod) {
        return httpMethod.getResponseHeader("Content-Type");
    }

    private boolean checkContentTypeStream(HttpMethod httpMethod, boolean bl) {
        FileStreamRecognizer fileStreamRecognizer = (FileStreamRecognizer)this.client.getParams().getParameter("fileStreamRecognizer");
        if (fileStreamRecognizer == null) {
            if (this.streamRecognizer == null) {
                this.streamRecognizer = new DefaultFileStreamRecognizer();
            }
            fileStreamRecognizer = this.streamRecognizer;
        }
        return fileStreamRecognizer.isStream(httpMethod, bl);
    }

    @Override
    public InputStream makeRequestForFile(HttpMethod httpMethod) throws IOException {
        this.toString(httpMethod);
        this.processHttpMethod(httpMethod);
        int n = httpMethod.getStatusCode();
        if (n == 200) {
            this.checkContentTypeStream(httpMethod, true);
            Header header = httpMethod.getResponseHeader("Content-Encoding");
            if (null != header && !header.getValue().isEmpty()) {
                if ("gzip".equalsIgnoreCase(header.getValue())) {
                    logger.info("Found GZIP stream");
                    return new GZIPInputStream(httpMethod.getResponseBodyAsStream());
                }
                if ("deflate".equalsIgnoreCase(header.getValue())) {
                    logger.info("Found deflate stream");
                    return new InflaterInputStream(httpMethod.getResponseBodyAsStream());
                }
                logger.warning("Unknown Content-Encoding: " + header.getValue());
            }
            return httpMethod.getResponseBodyAsStream();
        }
        logger.warning("Loading file failed");
        this.updateAsString(httpMethod);
        return null;
    }

    private void processHttpMethod(HttpMethod httpMethod) throws IOException {
        if (this.protocol != null) {
            this.client.getHostConfiguration().setHost(httpMethod.getURI().getHost(), 80, this.protocol);
        }
        this.client.executeMethod(httpMethod);
    }

    @Override
    public int makeRequest(HttpMethod httpMethod, boolean bl) throws IOException {
        this.asString = "";
        if (bl && httpMethod instanceof GetMethod) {
            httpMethod.setFollowRedirects(true);
        }
        this.processHttpMethod(httpMethod);
        int n = httpMethod.getStatusCode();
        boolean bl2 = this.isRedirect(n);
        if (!bl2) {
            this.redirect = 0;
        }
        if (n == 500 || n == 403) {
            logger.severe("Status code je 500");
        } else if (n >= 500) {
            logger.severe("Status code > 500: " + n);
        }
        if (bl && bl2 && this.redirect != 1) {
            this.redirect = 1;
            Header header = httpMethod.getResponseHeader("location");
            if (header != null) {
                String string = header.getValue();
                if (string == null || "".equals(string)) {
                    string = "/";
                }
                if (!string.matches("(?i)https?://.+")) {
                    if (!string.startsWith("/")) {
                        string = "/" + string;
                    }
                    string = httpMethod.getURI().getScheme() + "://" + httpMethod.getURI().getHost() + string;
                }
                logger.info("Redirect target: " + string);
                if (this.client.getParams().getBooleanParameter("useRefererWhenRedirect", false)) {
                    this.setReferer(string);
                }
                GetMethod getMethod = this.getGetMethod(string);
                int n2 = this.makeRequest((HttpMethod)getMethod, bl);
                logger.info("Redirect: " + getMethod.getStatusLine().toString());
                return n2;
            }
            logger.warning("Invalid redirect");
        } else {
            this.redirect = 0;
            if (!this.checkContentTypeStream(httpMethod, false)) {
                this.updateAsString(httpMethod);
            } else {
                this.asString = "Text content type expected, but binary stream was found";
                logger.warning(this.asString);
            }
        }
        httpMethod.releaseConnection();
        return n;
    }

    private void updateAsString(HttpMethod httpMethod) throws IOException {
        Header header = httpMethod.getResponseHeader("Content-Encoding");
        this.asString = "";
        if (null != header && !header.getValue().isEmpty()) {
            if ("gzip".equalsIgnoreCase(header.getValue())) {
                logger.info("Extracting GZIP");
                this.asString = this.inflate(httpMethod.getResponseBodyAsStream(), "gzip");
            } else if ("deflate".equalsIgnoreCase(header.getValue())) {
                logger.info("Extracting deflate");
                this.asString = this.inflate(httpMethod.getResponseBodyAsStream(), "deflate");
            } else {
                logger.warning("Unknown Content-Encoding: " + header.getValue());
            }
        } else {
            InputStream inputStream = httpMethod.getResponseBodyAsStream();
            this.asString = inputStream == null ? "" : this.streamToString(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String streamToString(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[4000];
        try {
            int n;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.getContentPageCharset()));
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n);
            }
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Error during reading content of page", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return "";
    }

    protected boolean isRedirect(int n) {
        return n == 302 || n == 301 || n == 303 || n == 307;
    }

    @Override
    public GetMethod getGetMethod(String string) {
        GetMethod getMethod;
        try {
            getMethod = new GetMethod(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warning("Invalid URI detected for GetMethod: " + string + " Trying to reencode ");
            try {
                getMethod = new GetMethod(URIUtil.encodePathQuery((String)string));
            }
            catch (URIException uRIException) {
                throw illegalArgumentException;
            }
        }
        this.setDefaultsForMethod((HttpMethod)getMethod);
        getMethod.setDoAuthentication(this.hasAuthentification());
        return getMethod;
    }

    protected void toString(HttpMethod httpMethod) {
        logger.info("===============HTTP METHOD===============");
        String string = httpMethod.getPath();
        logger.info("path = " + string);
        PostMethod postMethod = httpMethod.getRequestHeaders();
        StringBuilder stringBuilder = new StringBuilder();
        for (Header header : postMethod) {
            if (header == null) continue;
            stringBuilder.append(header.toString());
        }
        logger.info("header = \n" + stringBuilder.toString().trim());
        if (httpMethod instanceof PostMethod) {
            NameValuePair[] nameValuePairArray;
            PostMethod postMethod2 = (PostMethod)httpMethod;
            stringBuilder = new StringBuilder();
            for (NameValuePair nameValuePair : nameValuePairArray = postMethod2.getParameters()) {
                stringBuilder.append(nameValuePair.getName()).append("=").append(nameValuePair.getValue()).append("\n");
            }
        }
        logger.info("post parameters: \n" + stringBuilder.toString().trim());
        logger.info("query string = " + httpMethod.getQueryString());
        logger.info("=========================================");
    }

    protected String inflate(InputStream inputStream, String string) throws IOException {
        int n;
        InflaterInputStream inflaterInputStream;
        if (inputStream == null || string == null) {
            throw new NullPointerException();
        }
        byte[] byArray = new byte[4000];
        if (string.equalsIgnoreCase("gzip")) {
            inflaterInputStream = new GZIPInputStream(inputStream);
        } else if (string.equalsIgnoreCase("deflate")) {
            inflaterInputStream = new InflaterInputStream(inputStream);
        } else {
            throw new IllegalArgumentException("Format must be either 'gzip' or 'deflate'");
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inflaterInputStream.read(byArray)) != -1) {
            stringBuilder.append(new String(byArray, 0, n, this.getContentPageCharset()));
        }
        return stringBuilder.toString();
    }

    protected String getContentPageCharset() {
        Object object = this.getHTTPClient().getParams().getParameter("pageCharset");
        if (object == null) {
            return "UTF-8";
        }
        return object.toString();
    }

    @Override
    public void setReferer(String string) {
        if (string == null) {
            throw new NullPointerException("Referer cannot be null");
        }
        logger.info("Setting referer to " + string);
        this.referer = string;
    }

    @Override
    public ConnectionSettings getSettings() {
        return this.settings;
    }

    @Override
    public HttpClient getHTTPClient() {
        return this.client;
    }

    @Override
    public String getContentAsString() {
        return this.asString;
    }

    @Override
    public void setConnectionTimeOut(int n) {
        this.timeout = n;
    }
}

