/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaKeyboardFocusManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import sun.awt.CausedFocusEvent;

public class QuaquaTextFieldFocusHandler
implements FocusListener {
    private static QuaquaTextFieldFocusHandler instance;

    public static QuaquaTextFieldFocusHandler getInstance() {
        if (instance == null) {
            instance = new QuaquaTextFieldFocusHandler();
        }
        return instance;
    }

    public void focusGained(FocusEvent event) {
        QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
        JTextComponent tc = (JTextComponent)event.getSource();
        if (tc.isEditable() && tc.isEnabled()) {
            CausedFocusEvent cfEvent;
            String uiProperty = tc instanceof JPasswordField ? "PasswordField.autoSelect" : (tc instanceof JFormattedTextField ? "FormattedTextField.autoSelect" : "TextField.autoSelect");
            if ((tc.getClientProperty("Quaqua.TextComponent.autoSelect") == Boolean.TRUE || tc.getClientProperty("Quaqua.TextComponent.autoSelect") == null && UIManager.getBoolean(uiProperty)) && event instanceof CausedFocusEvent && ((cfEvent = (CausedFocusEvent)event).getCause() == CausedFocusEvent.Cause.TRAVERSAL_FORWARD || cfEvent.getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD)) {
                tc.selectAll();
            }
        }
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager() instanceof QuaquaKeyboardFocusManager) {
            QuaquaKeyboardFocusManager kfm = (QuaquaKeyboardFocusManager)KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.setLastKeyboardTraversingComponent(null);
        }
    }

    public void focusLost(FocusEvent event) {
        QuaquaUtilities.repaintBorder((JComponent)event.getComponent());
    }
}

