/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.filechooser;

import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.filechooser.FileInfo;
import ch.randelshofer.quaqua.filechooser.OSXCollator;
import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import ch.randelshofer.quaqua.osx.OSXFile;
import ch.randelshofer.quaqua.util.ArrayUtil;
import ch.randelshofer.quaqua.util.ConcurrentDispatcher;
import ch.randelshofer.quaqua.util.IteratorEnumeration;
import ch.randelshofer.quaqua.util.SequentialDispatcher;
import ch.randelshofer.quaqua.util.Worker;
import java.awt.IllegalComponentStateException;
import java.io.File;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileSystemTreeModel
implements TreeModel {
    private static final boolean DEBUG = false;
    public static final File COMPUTER = new File("/");
    public static final int INVALID = 0;
    public static final int VALIDATING = 1;
    public static final int VALID = 2;
    protected EventListenerList listenerList = new EventListenerList();
    private JFileChooser fileChooser;
    private RootNode root;
    private Comparator nodeComparator;
    private boolean isAutoValidate = true;
    private boolean isResolveAliasesToFiles = true;
    private boolean isResolveFileLabels = true;
    private static Collator collator;
    private SequentialDispatcher fileInfoDispatcher;
    private ConcurrentDispatcher directoryDispatcher;
    private SequentialDispatcher aliasResolutionDispatcher;
    private boolean doItFast;

    public FileSystemTreeModel(JFileChooser fileChooser) {
        this.fileChooser = fileChooser;
        this.root = new RootNode();
        this.fileInfoDispatcher = new SequentialDispatcher();
        this.directoryDispatcher = new ConcurrentDispatcher();
        this.aliasResolutionDispatcher = new SequentialDispatcher();
        this.doItFast = UIManager.getBoolean("FileChooser.speed");
    }

    public void dispatchDirectoryUpdater(Runnable r) {
        this.directoryDispatcher.dispatch(r);
    }

    public void dispatchFileUpdater(Runnable r) {
        this.fileInfoDispatcher.dispatch(r);
    }

    public void dispatchAliasResolution(Runnable r) {
        this.aliasResolutionDispatcher.dispatch(r);
    }

    public void clear() {
        int[] removedIndices = new int[this.root.getChildCount()];
        Object[] removedChildren = new Object[removedIndices.length];
        for (int i = 0; i < removedIndices.length; ++i) {
            removedIndices[i] = i;
            removedChildren[i] = this.root.getChildAt(0);
            this.root.remove(0);
        }
        this.fireTreeNodesRemoved(this, new Object[]{this.root}, removedIndices, removedChildren);
    }

    public void dispose() {
        this.stopValidation();
        this.clear();
    }

    public Node getPrototypeValue() {
        return new Node(new File(QuaquaManager.getProperty("user.home")), "Prototype", false);
    }

    public Object getChild(Object parent, int index) {
        return ((Node)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((Node)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((Node)parent).getIndex((Node)child);
    }

    private int getIndexOfChildForFile(Node parent, File file) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (!((Node)parent.getChildAt(i)).getResolvedFile().equals(file)) continue;
            return i;
        }
        return -1;
    }

    private Comparator getNodeComparator() {
        if (this.nodeComparator == null) {
            this.nodeComparator = UIManager.getBoolean("FileChooser.orderByType") ? new FoldersFirstComparator() : new ByNameComparator();
        }
        return this.nodeComparator;
    }

    private Collator getCollator() {
        if (collator == null) {
            Locale locale;
            try {
                locale = this.fileChooser.getLocale();
            }
            catch (IllegalComponentStateException e) {
                locale = Locale.getDefault();
            }
            collator = new OSXCollator(locale);
        }
        return collator;
    }

    private int getInsertionIndexForNode(Node parent, Node child) {
        int i;
        Comparator comparator = this.getNodeComparator();
        for (i = 0; i < parent.getChildCount(); ++i) {
            if (comparator.compare(parent.getChildAt(i), child) < 0) continue;
            return i;
        }
        return i;
    }

    private void insertNodeInto(Node newChild, Node parent, int index) {
        parent.insert(newChild, index);
        int[] newIndices = new int[]{index};
        this.fireTreeNodesInserted(this, parent.getPath(), newIndices, new Object[]{newChild});
    }

    public Object getRoot() {
        return this.root;
    }

    private QuaquaFileSystemView getFileSystemView() {
        FileSystemView fcFileSystemView = this.fileChooser.getFileSystemView();
        if (fcFileSystemView instanceof QuaquaFileSystemView) {
            return (QuaquaFileSystemView)fcFileSystemView;
        }
        return QuaquaFileSystemView.getQuaquaFileSystemView();
    }

    protected Node createNode(File f) {
        boolean isTraversable;
        boolean isAlias;
        File resolvedFile = null;
        int fileType = OSXFile.getFileType(f);
        boolean isDirectory = false;
        boolean isHidden = this.getFileSystemView().isHiddenFile(f);
        boolean bl = isAlias = fileType == 2;
        if (isAlias) {
            resolvedFile = OSXFile.resolveAlias(f, false);
            isDirectory = resolvedFile.isDirectory();
            if (!this.isResolveAliasesToFiles() && !isDirectory) {
                isAlias = false;
                resolvedFile = f;
            }
        } else {
            resolvedFile = f;
            boolean bl2 = isDirectory = fileType == 1;
        }
        if (UIManager.getBoolean("FileChooser.speed")) {
            isTraversable = isDirectory;
        } else {
            boolean bl3 = isTraversable = isDirectory && this.fileChooser.isTraversable(resolvedFile);
        }
        Node node = isAlias ? (isDirectory && isTraversable ? new AliasDirectoryNode(f, resolvedFile, isHidden) : new AliasNode(f, resolvedFile, isHidden)) : (isDirectory && isTraversable ? new DirectoryNode(f, isHidden) : new Node(f, isHidden));
        return node;
    }

    public TreePath toPath(File file, TreePath templatePath) {
        Node node;
        int i;
        QuaquaFileSystemView fsv;
        if ((file = OSXFile.getAbsoluteFile(file)).equals((fsv = this.getFileSystemView()).getComputer())) {
            return new TreePath(this.getRoot());
        }
        LinkedList<File> list = new LinkedList<File>();
        File dir = file;
        boolean exists = false;
        do {
            if (exists |= dir.exists()) {
                list.addFirst(dir);
            }
            if (!fsv.isRoot(dir)) continue;
            if (!fsv.getComputer().equals(dir)) break;
            list.set(0, fsv.getSystemVolume());
            break;
        } while ((dir = exists ? fsv.getParentDirectory(dir) : dir.getParentFile()) != null);
        LinkedList<Object> components = new LinkedList<Object>();
        components.add(this.getRoot());
        int mergeIndex = 0;
        if (templatePath != null) {
            block1: for (i = list.size() - 1; i >= 0; --i) {
                File f = (File)list.get(i);
                for (int j = templatePath.getPathCount() - 1; j >= 1; --j) {
                    Node node2 = (Node)templatePath.getPathComponent(j);
                    if (!node2.getResolvedFile().equals(f) && !node2.getFile().equals(f)) continue;
                    for (int k = 1; k <= j; ++k) {
                        components.add(templatePath.getPathComponent(k));
                    }
                    mergeIndex = i + 1;
                    break block1;
                }
            }
        }
        for (i = mergeIndex; i < list.size() && !(node = (Node)components.getLast()).isLeaf() && !node.isAlias(); ++i) {
            File childFile = (File)list.get(i);
            int index = this.getIndexOfChildForFile(node, childFile);
            if (index == -1) {
                Node newChild = this.createNode(childFile);
                this.insertNodeInto(newChild, node, this.getInsertionIndexForNode(node, newChild));
                node = newChild;
            } else {
                node = (Node)node.getChildAt(index);
            }
            components.add(node);
        }
        return new TreePath(components.toArray());
    }

    public TreePath toPath0(File file) {
        file = OSXFile.getAbsoluteFile(file);
        LinkedList<File> list = new LinkedList<File>();
        QuaquaFileSystemView fsv = this.getFileSystemView();
        File dir = file;
        boolean exists = false;
        do {
            boolean bl = exists = exists || dir.exists();
            if (!exists) continue;
            list.addFirst(dir);
        } while (!((FileSystemView)fsv).isRoot(dir) && (dir = exists ? ((FileSystemView)fsv).getParentDirectory(dir) : dir.getParentFile()) != null);
        LinkedList<Node> components = new LinkedList<Node>();
        Node node = (Node)this.getRoot();
        for (int i = 0; i < list.size() && !node.isLeaf() && !node.isAlias(); ++i) {
            components.add(node);
            File childFile = (File)list.get(i);
            int index = this.getIndexOfChildForFile(node, childFile);
            if (index == -1) {
                Node newChild = this.createNode(childFile);
                this.insertNodeInto(newChild, node, this.getInsertionIndexForNode(node, newChild));
                node = newChild;
                continue;
            }
            node = (Node)node.getChildAt(index);
        }
        components.add(node);
        return new TreePath(components.toArray());
    }

    public boolean isLeaf(Object node) {
        return ((Node)node).isLeaf();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void setAutoValidate(boolean b) {
        this.isAutoValidate = b;
    }

    public boolean isAutoValidate() {
        return this.isAutoValidate;
    }

    public void setResolveAliasesToFiles(boolean newValue) {
        if (this.isResolveAliasesToFiles != newValue) {
            this.isResolveAliasesToFiles = newValue;
            this.invalidateAll();
        }
    }

    public boolean isResolveAliasesToFiles() {
        return this.isResolveAliasesToFiles;
    }

    public void setResolveFileLabels(boolean newValue) {
        this.isResolveFileLabels = newValue;
    }

    public boolean isResolveFileLabels() {
        return this.isResolveFileLabels;
    }

    public void invalidateCache() {
        this.root.invalidateTree();
    }

    public void invalidatePath(TreePath path) {
        if (path != null) {
            for (int i = 0; i < path.getPathCount(); ++i) {
                Node node = (Node)path.getPathComponent(i);
                node.invalidateChildren();
            }
            if (path.getPathComponent(0) != this.root) {
                this.root.invalidateChildren();
            }
        }
    }

    public void invalidateAll() {
        this.root.invalidateTree();
    }

    public void stopValidation() {
        this.root.stopValidationSubtree();
        this.aliasResolutionDispatcher.stop();
        this.fileInfoDispatcher.stop();
        this.directoryDispatcher.stop();
    }

    public void lazyInvalidatePath(TreePath path) {
        if (path != null && this.isAutoValidate) {
            this.root.lazyInvalidateChildren();
            if (path.getPathComponent(0) != this.root) {
                ((Node)path.getPathComponent(0)).lazyInvalidateChildren();
            }
            if (path.getPathCount() > 1) {
                ((Node)path.getPathComponent(path.getPathCount() - 1)).lazyInvalidateChildren();
                if (path.getPathCount() > 2) {
                    ((Node)path.getPathComponent(path.getPathCount() - 2)).lazyInvalidateChildren();
                }
            }
        }
    }

    public void validatePath(TreePath path) {
        for (int i = 0; i < path.getPathCount(); ++i) {
            Node node = (Node)path.getPathComponent(i);
            node.validateChildren();
        }
        if (path.getPathComponent(0) != this.root) {
            this.root.validateChildren();
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodeChanged(Node node) {
        Node parent = (Node)node.getParent();
        if (parent != null) {
            this.fireTreeNodesChanged(this, parent.getPath(), new int[]{parent.getIndex(node)}, new Object[]{node});
        }
    }

    protected void fireTreeNodesChanged(TreeModel source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    protected void fireTreeNodesInserted(TreeModel source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    protected void fireTreeNodesRemoved(TreeModel source, Object[] path, int[] childIndices, Object[] children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    protected void fireTreeStructureChanged(TreeModel source, Object[] path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private void fireTreeStructureChanged(TreeModel source, TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent((Object)source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private boolean accept(File f) {
        return this.fileChooser.accept(f);
    }

    private static class FoldersFirstComparator
    implements Comparator {
        private FoldersFirstComparator() {
        }

        public int compare(Object o1, Object o2) {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            if (n1.isLeaf() == n2.isLeaf()) {
                return n1.getCollationKey().compareTo(n2.getCollationKey());
            }
            return n1.isLeaf() ? 1 : -1;
        }
    }

    private static class ByNameComparator
    implements Comparator {
        private ByNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Node)o1).getCollationKey().compareTo(((Node)o2).getCollationKey());
        }
    }

    public class AliasDirectoryNode
    extends DirectoryNode {
        private File resolvedFile;
        private Worker<File> resolver;

        public AliasDirectoryNode(File aliasFile, File resolvedFile, boolean isHidden) {
            super(aliasFile, isHidden);
            this.resolvedFile = resolvedFile;
        }

        public String getFileKind() {
            return "alias";
        }

        public boolean isAlias() {
            return true;
        }

        public File lazyGetResolvedFile() {
            if (this.resolvedFile == null && this.resolver == null) {
                this.resolver = new Worker<File>(){

                    @Override
                    public File construct() {
                        return OSXFile.resolveAlias(AliasDirectoryNode.this.file, false);
                    }

                    @Override
                    public void done(File value) {
                        AliasDirectoryNode.this.resolvedFile = value;
                    }

                    @Override
                    public void finished() {
                        AliasDirectoryNode.this.resolver = null;
                        if (AliasDirectoryNode.this.getRoot() == FileSystemTreeModel.this.getRoot()) {
                            FileSystemTreeModel.this.fireTreeNodeChanged(AliasDirectoryNode.this);
                        }
                    }
                };
                FileSystemTreeModel.this.dispatchAliasResolution(this.resolver);
            }
            return this.resolvedFile;
        }

        public File getResolvedFile() {
            if (this.resolvedFile == null) {
                this.resolvedFile = OSXFile.resolveAlias(this.file, false);
            }
            return this.resolvedFile == null ? this.file : this.resolvedFile;
        }

        public boolean isValidatingChildren() {
            return super.isValidatingChildren() || this.resolver != null;
        }
    }

    public class AliasNode
    extends Node {
        private File resolvedFile;
        private Worker<File> resolver;

        public AliasNode(File aliasFile, File resolvedFile, boolean isHidden) {
            super(aliasFile, isHidden);
            this.resolvedFile = resolvedFile;
        }

        public File lazyGetResolvedFile() {
            if (this.resolvedFile == null && this.resolver == null) {
                this.resolver = new Worker<File>(){

                    @Override
                    public File construct() {
                        return OSXFile.resolveAlias(AliasNode.this.file, false);
                    }

                    @Override
                    public void done(File value) {
                        AliasNode.this.resolvedFile = value;
                    }

                    @Override
                    public void finished() {
                        AliasNode.this.resolver = null;
                        if (AliasNode.this.getRoot() == FileSystemTreeModel.this.getRoot()) {
                            FileSystemTreeModel.this.fireTreeNodeChanged(AliasNode.this);
                            FileSystemTreeModel.this.fireTreeStructureChanged((TreeModel)FileSystemTreeModel.this, AliasNode.this.getPath());
                        }
                    }
                };
                FileSystemTreeModel.this.dispatchAliasResolution(this.resolver);
            }
            return this.resolvedFile;
        }

        public File getResolvedFile() {
            if (this.resolvedFile == null) {
                this.resolvedFile = OSXFile.resolveAlias(this.file, false);
            }
            return this.resolvedFile == null ? this.file : this.resolvedFile;
        }

        public String getFileKind() {
            return "alias";
        }

        public boolean isAlias() {
            return true;
        }
    }

    private class RootNode
    extends DirectoryNode {
        public RootNode() {
            super(COMPUTER, false);
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            return "Root#" + this.hashCode();
        }

        protected long getDirectoryTTL() {
            return 1000L;
        }

        protected File[] getFiles() {
            LinkedList<File> list = new LinkedList<File>();
            File[] files = FileSystemTreeModel.this.getFileSystemView().getRoots();
            for (int i = 0; i < files.length; ++i) {
                list.add(files[i]);
            }
            return list.toArray(new File[list.size()]);
        }

        public void validateChildren() {
            super.validateChildren();
        }

        public Icon getIcon() {
            this.validateInfo();
            if (this.icon == null) {
                return UIManager.getIcon("FileView.computerIcon");
            }
            return this.icon;
        }
    }

    public class DirectoryNode
    extends Node {
        private volatile long cacheInvalidationTime;
        int childrenState;
        private ArrayList children;
        private Runnable validator;
        private long bestBeforeTimeMillis;

        public DirectoryNode(File file, boolean isHidden) {
            super(file, isHidden);
            this.bestBeforeTimeMillis = 0L;
        }

        public long getFileLength() {
            return -1L;
        }

        public String getFileKind() {
            return "folder";
        }

        public void invalidateChildren() {
            this.childrenState = 0;
            this.validator = null;
        }

        public void lazyInvalidateChildren() {
            if (this.validator == null && this.bestBeforeTimeMillis < System.currentTimeMillis()) {
                this.childrenState = 0;
            }
        }

        public boolean isValidatingChildren() {
            return this.validator != null;
        }

        public void stopValidationSubtree() {
            this.validator = null;
            Enumeration i = super.children();
            while (i.hasMoreElements()) {
                ((Node)i.nextElement()).stopValidationSubtree();
            }
        }

        public void invalidateTree() {
            this.invalidateInfo();
            if (this.childrenState == 2) {
                this.invalidateChildren();
                Enumeration i = this.children();
                while (i.hasMoreElements()) {
                    ((Node)i.nextElement()).invalidateTree();
                }
            }
        }

        public void validateChildren() {
            if (this.childrenState == 0) {
                this.childrenState = 1;
                this.validator = new DirectoryValidator();
                FileSystemTreeModel.this.directoryDispatcher.dispatch(this.validator, this.bestBeforeTimeMillis == 0L);
                Node nodeRoot = (Node)this.getRoot();
                if (nodeRoot == FileSystemTreeModel.this.root) {
                    FileSystemTreeModel.this.fireTreeNodeChanged(this);
                }
                this.bestBeforeTimeMillis = System.currentTimeMillis() + this.getDirectoryTTL();
            }
        }

        public void autoValidateChildren() {
            if (FileSystemTreeModel.this.isAutoValidate && this.childrenState == 0) {
                this.validateChildren();
            }
        }

        public Enumeration children() {
            this.autoValidateChildren();
            if (this.children == null) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return new IteratorEnumeration(this.children.iterator());
        }

        private void removeAll(LinkedList deletedChildren) {
            this.children.removeAll(deletedChildren);
            for (Node n : deletedChildren) {
                n.parent = null;
            }
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public TreeNode getChildAt(int childIndex) {
            if (this.children == null) {
                throw new IndexOutOfBoundsException(childIndex + " >= 0");
            }
            this.autoValidateChildren();
            return (TreeNode)this.children.get(childIndex);
        }

        public int getChildCount() {
            this.autoValidateChildren();
            return this.children == null ? 0 : this.children.size();
        }

        public int getIndex(TreeNode node) {
            this.autoValidateChildren();
            return this.children == null ? -1 : this.children.indexOf(node);
        }

        public void insert(MutableTreeNode newChild, int childIndex) {
            this.invalidateChildren();
            if (newChild == null) {
                throw new IllegalArgumentException("new child is null");
            }
            if (this.isNodeAncestor(newChild)) {
                throw new IllegalArgumentException("new child is an ancestor");
            }
            MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
            if (oldParent != null) {
                oldParent.remove(newChild);
            }
            newChild.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(childIndex, newChild);
        }

        public boolean isLeaf() {
            return false;
        }

        public void remove(MutableTreeNode aChild) {
            if (aChild == null) {
                throw new IllegalArgumentException("argument is null");
            }
            if (aChild.getParent() != this) {
                throw new IllegalArgumentException("argument is not a child");
            }
            this.remove(this.getIndex(aChild));
        }

        public void remove(int childIndex) {
            this.invalidateChildren();
            MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
            this.children.remove(childIndex);
            child.setParent(null);
        }

        protected File[] getFiles() {
            File[] files = FileSystemTreeModel.this.getFileSystemView().getFiles(this.lazyGetResolvedFile(), FileSystemTreeModel.this.fileChooser.isFileHidingEnabled());
            return files;
        }

        protected long getDirectoryTTL() {
            return 2000L;
        }

        private class DirectoryValidator
        implements Runnable {
            private DirectoryValidator() {
            }

            public void run() {
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                final long startTime = System.currentTimeMillis();
                final boolean exists = DirectoryNode.this.file != null && DirectoryNode.this.file.exists();
                final File[] freshFiles = exists ? DirectoryNode.this.getFiles() : new File[]{};
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                boolean isDirectoriesOnly = FileSystemTreeModel.this.fileChooser.getFileSelectionMode() == 1;
                ArrayList<Node> freshNodeList = new ArrayList<Node>(freshFiles.length);
                boolean isFileHidingEnabled = FileSystemTreeModel.this.fileChooser.isFileHidingEnabled();
                QuaquaFileSystemView fsv = FileSystemTreeModel.this.getFileSystemView();
                for (int i = 0; i < freshFiles.length; ++i) {
                    boolean freshIsTraversable;
                    File freshFile = freshFiles[i];
                    int freshFileType = OSXFile.getFileType(freshFile);
                    boolean freshIsDirectory = freshFileType == 1;
                    File resolvedFreshFile = null;
                    boolean freshIsAlias = FileSystemTreeModel.this.isResolveAliasesToFiles() ? freshFileType == 2 : false;
                    if (freshIsAlias) {
                        resolvedFreshFile = OSXFile.resolveAlias(freshFile, true);
                        if (resolvedFreshFile == null) {
                            freshIsDirectory = false;
                            freshIsTraversable = false;
                        } else {
                            freshIsTraversable = freshIsDirectory = FileSystemTreeModel.this.fileChooser.isTraversable(resolvedFreshFile);
                        }
                    } else {
                        freshIsTraversable = freshIsDirectory = FileSystemTreeModel.this.fileChooser.isTraversable(freshFile);
                        resolvedFreshFile = freshFile;
                    }
                    boolean freshIsHidden = fsv.isHiddenFile(freshFile);
                    if (isDirectoriesOnly && (!freshIsDirectory || !freshIsTraversable) || isFileHidingEnabled && freshIsHidden) continue;
                    if (freshIsAlias) {
                        if (freshIsDirectory && freshIsTraversable) {
                            freshNodeList.add(new AliasDirectoryNode(freshFile, resolvedFreshFile, freshIsHidden));
                            continue;
                        }
                        freshNodeList.add(new AliasNode(freshFile, resolvedFreshFile, freshIsHidden));
                        continue;
                    }
                    if (freshIsDirectory && freshIsTraversable) {
                        freshNodeList.add(new DirectoryNode(freshFile, freshIsHidden));
                        continue;
                    }
                    freshNodeList.add(new Node(freshFile, freshIsHidden));
                }
                final Node[] freshNodes = freshNodeList.toArray(new Node[freshNodeList.size()]);
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                Arrays.sort(freshNodes, FileSystemTreeModel.this.getNodeComparator());
                if (this != DirectoryNode.this.validator) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (DirectoryValidator.this != DirectoryNode.this.validator || DirectoryNode.this.getRoot() != FileSystemTreeModel.this.getRoot()) {
                            return;
                        }
                        ArrayList<Node> mergedChildren = new ArrayList<Node>(freshFiles.length);
                        LinkedList<Node> newChildren = new LinkedList<Node>();
                        int[] newChildIndices = new int[freshFiles.length];
                        LinkedList<Node> deletedChildren = new LinkedList<Node>();
                        int[] deletedChildIndices = new int[DirectoryNode.this.getChildCount()];
                        Node[] oldNodes = DirectoryNode.this.children == null ? new Node[]{} : DirectoryNode.this.children.toArray(new Node[DirectoryNode.this.children.size()]);
                        int count = freshNodes.length + oldNodes.length;
                        int freshIndex = 0;
                        int oldIndex = 0;
                        int mergeIndex = 0;
                        int lastFreshIndex = -1;
                        Object resolvedFreshFile = null;
                        Comparator comparator = FileSystemTreeModel.this.getNodeComparator();
                        for (int i = 0; i < count; ++i) {
                            int comparison;
                            if (freshIndex >= freshNodes.length) {
                                comparison = oldIndex >= oldNodes.length ? 0 : 1;
                            } else if (oldIndex >= oldNodes.length) {
                                comparison = -1;
                            } else {
                                comparison = comparator.compare(freshNodes[freshIndex], oldNodes[oldIndex]);
                                if (comparison == 0 && freshNodes[freshIndex].isLeaf() != oldNodes[oldIndex].isLeaf()) {
                                    comparison = -1;
                                }
                            }
                            if (comparison < 0) {
                                newChildIndices[newChildren.size()] = mergeIndex++;
                                Node newNode = freshNodes[freshIndex];
                                newNode.parent = DirectoryNode.this;
                                newChildren.add(newNode);
                                mergedChildren.add(newNode);
                                ++freshIndex;
                                continue;
                            }
                            if (comparison == 0) {
                                if (oldIndex < oldNodes.length) {
                                    Node oldNode = oldNodes[oldIndex];
                                    if (!FileSystemTreeModel.this.doItFast) {
                                        oldNode.invalidateInfo();
                                    }
                                    mergedChildren.add(oldNode);
                                }
                                ++oldIndex;
                                ++freshIndex;
                                ++mergeIndex;
                                continue;
                            }
                            deletedChildIndices[deletedChildren.size()] = mergeIndex + deletedChildren.size() - newChildren.size();
                            deletedChildren.add(oldNodes[oldIndex]);
                            ++oldIndex;
                        }
                        if (!exists) {
                            Node parent = DirectoryNode.this;
                            while ((parent = (Node)parent.getParent()) != null) {
                                parent.lazyInvalidateChildren();
                                parent.validateChildren();
                            }
                        }
                        if (newChildren.size() > 0 || deletedChildren.size() > 0) {
                            for (Node n : deletedChildren) {
                                n.parent = null;
                                n.invalidateChildren();
                            }
                            if (newChildren.size() > 0 && deletedChildren.size() == 0) {
                                DirectoryNode.this.children = mergedChildren;
                                FileSystemTreeModel.this.fireTreeNodesInserted(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(newChildIndices, 0, newChildren.size()), newChildren.toArray());
                            } else if (newChildren.size() == 0 && deletedChildren.size() > 0) {
                                DirectoryNode.this.children = mergedChildren;
                                FileSystemTreeModel.this.fireTreeNodesRemoved(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(deletedChildIndices, 0, deletedChildren.size()), deletedChildren.toArray());
                            } else if (newChildren.size() > 0 && deletedChildren.size() > 0) {
                                DirectoryNode.this.removeAll(deletedChildren);
                                FileSystemTreeModel.this.fireTreeNodesRemoved(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(deletedChildIndices, 0, deletedChildren.size()), deletedChildren.toArray());
                                DirectoryNode.this.children = mergedChildren;
                                FileSystemTreeModel.this.fireTreeNodesInserted(FileSystemTreeModel.this, DirectoryNode.this.getPath(), ArrayUtil.truncate(newChildIndices, 0, newChildren.size()), newChildren.toArray());
                            }
                        }
                        DirectoryNode.this.validator = null;
                        Node nodeRoot = (Node)DirectoryNode.this.getRoot();
                        if (nodeRoot == FileSystemTreeModel.this.root) {
                            FileSystemTreeModel.this.fireTreeNodeChanged(DirectoryNode.this);
                        }
                        long endTime = System.currentTimeMillis();
                        DirectoryNode.this.bestBeforeTimeMillis = endTime + DirectoryNode.this.getDirectoryTTL() + (endTime - startTime) * 3L;
                        DirectoryNode.this.childrenState = 2;
                    }
                });
            }
        }
    }

    public class Node
    implements MutableTreeNode,
    FileInfo {
        protected TreeNode parent;
        protected File file;
        protected String userName;
        protected CollationKey collationKey;
        protected int fileLabel = -1;
        protected Icon icon;
        private int infoState = 0;
        protected Boolean isAcceptable;
        protected boolean isHidden;

        public Node(File f, boolean isHidden) {
            this(f, null, isHidden);
        }

        public Node(File f, String userName, boolean isHidden) {
            this.file = f;
            this.userName = userName;
            this.isHidden = isHidden;
        }

        public File lazyGetResolvedFile() {
            return this.file;
        }

        public File getFile() {
            return this.file;
        }

        public long getFileLength() {
            if (this.lazyGetResolvedFile() == null) {
                return -1L;
            }
            return this.getResolvedFile().isDirectory() ? -1L : this.file.length();
        }

        public String getUserName() {
            if (this.userName == null) {
                this.userName = FileSystemTreeModel.this.fileChooser.getName(this.file);
            }
            return this.userName;
        }

        public int getFileLabel() {
            this.validateInfo();
            return this.fileLabel;
        }

        public Icon getIcon() {
            this.validateInfo();
            if (this.icon == null) {
                return this.isLeaf() ? UIManager.getIcon("FileView.fileIcon") : UIManager.getIcon("FileView.directoryIcon");
            }
            return this.icon;
        }

        public CollationKey getCollationKey() {
            if (this.collationKey == null) {
                this.collationKey = FileSystemTreeModel.this.getCollator().getCollationKey(this.getUserName());
            }
            return this.collationKey;
        }

        public boolean isAlias() {
            return false;
        }

        public boolean isAcceptable() {
            if (this.isAcceptable == null) {
                this.isAcceptable = FileSystemTreeModel.this.accept(this.getFile()) ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.isAcceptable;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public String getFileKind() {
            if (this.file.isDirectory()) {
                String path = this.file.getPath();
                if (path.endsWith(".app")) {
                    return "application";
                }
                if (path.endsWith(".wdgt")) {
                    return "widget";
                }
                return "folder";
            }
            return "document";
        }

        public void invalidateInfo() {
            this.infoState = 0;
            this.userName = null;
            this.collationKey = null;
            this.isAcceptable = null;
        }

        public void validateInfo() {
            if (this.infoState == 0) {
                this.infoState = 1;
                FileSystemTreeModel.this.fileInfoDispatcher.dispatch(new Worker<Boolean>(){

                    @Override
                    public Boolean construct() {
                        if (!FileSystemTreeModel.this.doItFast) {
                            Icon oldIcon = Node.this.icon;
                            int oldFileLabel = Node.this.fileLabel;
                            Node.this.icon = FileSystemTreeModel.this.fileChooser.getIcon(Node.this.file);
                            if (FileSystemTreeModel.this.isResolveFileLabels) {
                                Node.this.fileLabel = OSXFile.getLabel(Node.this.file);
                            }
                            return oldIcon != Node.this.icon || oldFileLabel != Node.this.fileLabel ? Boolean.TRUE : Boolean.FALSE;
                        }
                        return Boolean.FALSE;
                    }

                    @Override
                    public void done(Boolean value) {
                        if (value == Boolean.TRUE && Node.this.getRoot() == FileSystemTreeModel.this.getRoot()) {
                            FileSystemTreeModel.this.fireTreeNodeChanged(Node.this);
                        }
                        Node.this.infoState = 2;
                    }
                });
            }
        }

        public void invalidateChildren() {
        }

        public void lazyInvalidateChildren() {
        }

        public void stopValidationSubtree() {
        }

        public void invalidateTree() {
            this.invalidateInfo();
        }

        public void validateChildren() {
        }

        public boolean isValidating() {
            return this.isValidatingChildren();
        }

        public boolean isValidatingChildren() {
            return false;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void setParent(MutableTreeNode newParent) {
            this.parent = newParent;
        }

        public void removeFromParent() {
            if (this.parent != null) {
                ((MutableTreeNode)this.parent).remove(this);
            }
        }

        public void setUserObject(Object object) {
            this.file = (File)object;
        }

        public TreeNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
            TreeNode[] retNodes;
            if (aNode == null) {
                if (depth == 0) {
                    return null;
                }
                retNodes = new TreeNode[depth];
            } else {
                retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
                retNodes[retNodes.length - depth] = aNode;
            }
            return retNodes;
        }

        public TreeNode getRoot() {
            Node previous;
            TreeNode ancestor = this;
            do {
                previous = ancestor;
            } while ((ancestor = ancestor.getParent()) != null);
            return previous;
        }

        public boolean isNodeAncestor(TreeNode anotherNode) {
            if (anotherNode == null) {
                return false;
            }
            TreeNode ancestor = this;
            do {
                if (ancestor != anotherNode) continue;
                return true;
            } while ((ancestor = ancestor.getParent()) != null);
            return false;
        }

        public String toString() {
            return this.userName == null ? this.file.getName() : this.userName;
        }

        public Enumeration children() {
            return DefaultMutableTreeNode.EMPTY_ENUMERATION;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public TreeNode getChildAt(int childIndex) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        public int getChildCount() {
            return 0;
        }

        public int getIndex(TreeNode node) {
            return -1;
        }

        public void insert(MutableTreeNode child, int index) {
            throw new IllegalStateException("node does not allow children");
        }

        public boolean isLeaf() {
            return true;
        }

        public void remove(MutableTreeNode node) {
            throw new IllegalArgumentException("argument is not a child");
        }

        public void remove(int index) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }

        public boolean isTraversable() {
            return !this.isLeaf();
        }

        public File getResolvedFile() {
            return this.file;
        }
    }
}

