/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import javax.swing.JSplitPane;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.SplitPaneState;

public class SplitPaneProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JSplitPane)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component component) {
        this.checkComponent(component);
        JSplitPane jSplitPane = (JSplitPane)component;
        return new SplitPaneState(jSplitPane.getUI().getDividerLocation(jSplitPane), jSplitPane.getOrientation());
    }

    @Override
    public void setSessionState(Component component, Object object) {
        this.checkComponent(component);
        if (object == null) {
            return;
        }
        if (object instanceof SplitPaneState) {
            JSplitPane jSplitPane = (JSplitPane)component;
            SplitPaneState splitPaneState = (SplitPaneState)object;
            if (jSplitPane.getOrientation() == splitPaneState.getOrientation()) {
                jSplitPane.setDividerLocation(splitPaneState.getDividerLocation());
            }
        } else {
            throw new IllegalArgumentException("invalid state");
        }
    }
}

