/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import javax.swing.JTabbedPane;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.TabbedPaneState;

public class TabbedPaneProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JTabbedPane)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component component) {
        this.checkComponent(component);
        JTabbedPane jTabbedPane = (JTabbedPane)component;
        return new TabbedPaneState(jTabbedPane.getSelectedIndex(), jTabbedPane.getTabCount());
    }

    @Override
    public void setSessionState(Component component, Object object) {
        this.checkComponent(component);
        if (object == null) {
            return;
        }
        if (object instanceof TabbedPaneState) {
            JTabbedPane jTabbedPane = (JTabbedPane)component;
            TabbedPaneState tabbedPaneState = (TabbedPaneState)object;
            if (jTabbedPane.getTabCount() == tabbedPaneState.getTabCount()) {
                jTabbedPane.setSelectedIndex(tabbedPaneState.getSelectedIndex());
            }
        } else {
            throw new IllegalArgumentException("invalid state");
        }
    }
}

