/*
 * $Id: config.cpp,v 1.2 2004/05/01 22:50:34 fredrik Exp $
 * 
 * Humanblue KWin client configuration module
 *
 * Copyright (C) 2002 Fredrik H�lund <fredrik@kde.org>
 *
 * Based on the Quartz configuration module,
 *     Copyright (c) 2001 Karol Szwed <gallium@kde.org>
 *  
 * Humanblue KWin client (version 1.0a)
 *
 * Copyright (C) 2004 Jose Rafael Castillo <jrch99@cantv.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the license, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kglobal.h>
#include <klocale.h>

#include <qcheckbox.h>
#include <qradiobutton.h>
#include <kcolorbutton.h>
#include <qcombobox.h>
#include <qslider.h>
#include <qcolor.h>
#include <qfiledialog.h>
#include <qlineedit.h>
#include <qdir.h>
#include <qlabel.h>
#include "config.h"
#include "config.moc"

extern "C" {
	QObject * allocate_config(KConfig *conf, QWidget *parent) {
		return (new HumanblueConfig(conf, parent));
	}
}


/* NOTE:
 * 'conf'   is a pointer to the kwindecoration modules open kwin config,
 *  		and is by default set to the "Style" group.
 *
 * 'parent' is the parent of the QObject, which is a VBox inside the
 *  		Configure tab in kwindecoration
 */

HumanblueConfig::HumanblueConfig(KConfig *conf, QWidget *parent):QObject(parent) {
	KGlobal::locale()->insertCatalogue("kwin_humanblue_config");
	c = new KConfig("kwinhumanbluerc");
	ui = new HumanblueConfigUI(parent);

	connect(ui->showAppIcons, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->useShadowedText, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->shadow1, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->shadow2, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->shadow3, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->left, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->right, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->center, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->ShadowColor, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->ishadowcolor, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->useKDEColors, SIGNAL(clicked()), SIGNAL(changed()));
	connect(ui->useThemeColors, SIGNAL(clicked()), SIGNAL(changed()));
	load(conf);
	ui->show();
}


HumanblueConfig::~HumanblueConfig() {
	delete ui;
	delete c;
}

void HumanblueConfig::load(KConfig *) {
	c->setGroup("General");
	ui->showAppIcons->setChecked(c->readBoolEntry("ShowAppIcons", false));
	ui->useShadowedText->setChecked(c->readBoolEntry("UseShadowedText", true));
	ui->ShadowColor->setColor(c->readColorEntry("UseShadowedTextColor"));
	ui->ishadowcolor->setColor(c->readColorEntry("UseShadowedInactiveTextColor"));
	Read_Config.textpos = c->readNumEntry("TextPosition", 0);
	Read_Config.colorize = c->readNumEntry("Colorize", 0);
	Read_Config.shadowtype = c->readNumEntry("UseShadowedTextType", 1);
	Read_Config.coloroption = c->readNumEntry("UseColorOption", 0);
	Read_Config.effects = c->readNumEntry("Effect", 0);
	Read_Config.ava = c->readNumEntry("Avatar", 0);
	Read_Config.avafunc = c->readNumEntry("AvatarFunc", 0);
	Read_Config.tsize = c->readBoolEntry("ThemeSize", false);
	if (Read_Config.textpos == 0)
		ui->left->setChecked(true);
	else if (Read_Config.textpos == 1)
		ui->center->setChecked(true);
	else if (Read_Config.textpos == 2)
		ui->right->setChecked(true);
	if (Read_Config.shadowtype == 1)
		ui->shadow1->setChecked(true);
	else if (Read_Config.shadowtype == 2)
		ui->shadow2->setChecked(true);
	else if (Read_Config.shadowtype == 0)
		ui->shadow3->setChecked(true);

	if (Read_Config.colorize == 1)
		ui->useThemeColors->setChecked(true);
	else
		ui->useKDEColors->setChecked(true);
}

void HumanblueConfig::save(KConfig *) {
	if (ui->left->isChecked())
		Config_Params.position = 0;
	else if (ui->center->isChecked())
		Config_Params.position = 1;
	else if (ui->right->isChecked())
		Config_Params.position = 2;
	if (ui->shadow1->isChecked())
		Config_Params.shadowtype = 1;
	else if (ui->shadow2->isChecked())
		Config_Params.shadowtype = 2;
	else if (ui->shadow3->isChecked())
		Config_Params.shadowtype = 0;

	if (ui->useKDEColors->isChecked())
		Config_Params.colorize = 1;
	else if (ui->useThemeColors->isChecked())
		Config_Params.colorize = 0;

	bool size;
	c->setGroup("General");
	c->writeEntry("ShowAppIcons", ui->showAppIcons->isChecked());
	c->writeEntry("TextPosition", Config_Params.position);
	c->writeEntry("Colorize", Config_Params.colorize);
	c->writeEntry("UseShadowedText", ui->useShadowedText->isChecked());
	c->writeEntry("UseShadowedTextColor", ui->ShadowColor->color());
	c->writeEntry("UseShadowedInactiveTextColor", ui->ishadowcolor->color());
	c->writeEntry("UseShadowedTextType", Config_Params.shadowtype);
	c->writeEntry("Effect", Config_Params.effect);
	c->writeEntry("UseColorOption", Config_Params.coloropt);
	c->writeEntry("Avatar", Config_Params.avatar);
	c->writeEntry("AvatarFunc", Config_Params.avatarfunc);
	c->writeEntry("AvatarFuncType", Config_Params.Type);
	c->writeEntry("AvatarFuncURL", Config_Params.Func);
	c->writeEntry("ThemeSize", size);
	c->sync();
}

void HumanblueConfig::defaults() {
	ui->showAppIcons->setChecked(false);
	ui->useShadowedText->setChecked(true);
	ui->left->setChecked(true);
	ui->shadow2->setChecked(true);
	ui->useKDEColors->setChecked(true);
	ui->ShadowColor->setColor(QColor(213, 213, 221));
	ui->ishadowcolor->setColor(QColor(213, 213, 221));
	emit changed();
}


// vim: set noet ts=4 sw=4:
// kate: indent-width 4; replace-tabs off; tab-width 4; space-indent off;
