/*
 * $Id: humanblue.cpp,v 1.0a 2004/01/09 18:20:29 giessl Exp $
 *
 * Keramik KWin client (version 0.8)
 *
 * Copyright (C) 2002 Fredrik H�lund <fredrik@kde.org>
 *
 * Humanblue KWin client (version 1.0a)
 *
 * Copyright (C) 2004 Jose Rafael Castillo <jrch99@cantv.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the license, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kconfig.h>
#include <klocale.h>
#include <kiconeffect.h>
#include <qcursor.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qbitmap.h>
#include <qstyle.h>
#include <qtooltip.h>
#include <qwidget.h>
#include <qlabel.h>
#include <kprocess.h>
#include <X11/Xlib.h>
#include <kdeversion.h>

#include "humanblue.h"
#include "humanblue.moc"
// -------------------------------------------------------------------------------------------
namespace Humanblue {
	HumanblueHandler	   *clientHandler	= NULL;
	// -------------------------------------------------------------------------------------------
	HumanblueHandler::HumanblueHandler() {
		for (register int i = 0; i < NumTiles; i++) {
			activeTiles[i] = NULL;
			inactiveTiles[i] = NULL;
			#ifdef ALLOWHUGETHEME

			hugeInactiveTiles[i] = NULL;
			hugeActiveTiles[i] = NULL;
			#endif
		}
		for (register int b = 0; b < NumButtons; b++) {
			activeButtons[b] = NULL;
			inactiveButtons[b] = NULL;
			#ifdef ALLOWDISBTT  
			disabledButtons[b] = NULL;
			#endif  
			#ifdef ALLOWHUGETHEME

			hugeActiveButtons[b] = NULL;
			hugeInactiveButtons[b] = NULL;
			#ifdef ALLOWDISBTT  
			hugeDisabledButtons[b] = NULL;
			#endif  
			#endif
		}
		imageDb = HumanblueImageDb::instance();
		FastImageIO.setShmPolicy(KPixmapIO::ShmKeepAndGrow);
		FastImageIO.preAllocShm(30000); 	 
		readConfig();
		if (Settings_Param.Colorize == 1)
			createPixmaps(true);
		else
			createPixmaps(false);
		humanblue_initialized = true;
	}

	HumanblueHandler::~HumanblueHandler() {
		humanblue_initialized = false;
		destroyPixmaps();
		HumanblueImageDb::release();
		imageDb = NULL;
		clientHandler = NULL;
	}

	inline void HumanblueHandler::createPixmaps(bool recolor) {
		//qDebug("createPixmaps()");
		register int heightOffset;
		register int widthOffset;
		switch (options()->preferredBorderSize(this)) {
		  case BorderLarge:
			widthOffset = 4;
			heightOffset = 0;
			break;
		  case BorderVeryLarge:
			widthOffset = 8;
			heightOffset = 0;
			break;
		  case BorderTiny:
		  case BorderNormal:
		  default:
			widthOffset = 0;
			heightOffset = 0;
		}//end
		//+revisar
		register int fontHeight = QFontMetrics(options()->font(true)).height();
		if (fontHeight > heightOffset + 20)
			heightOffset = fontHeight - 20;
		QString	size	= (heightOffset < 8) ? "" : (heightOffset < 20) ? "-large" : "-huge";
		QColor	titleColor, captionColor, buttonColor;
		//+
		// Active tiles
		// -------------------------------------------------------------------------
		captionColor = KDecoration::options()->color(ColorTitleBar, true);
		titleColor = KDecoration::options()->color(ColorTitleBlend, true);

		activeTiles[TitleLeft] = loadPixmap("titlebar-left-act", recolor);//,  titleColor );
		#ifdef RIGHTRISTATE

		activeTiles[TitleRight1] = loadPixmap("titlebar-right1-act", recolor);//, titleColor );
		activeTiles[TitleRight2] = loadPixmap("titlebar-right2-act", recolor);//, titleColor );
		activeTiles[TitleRight3] = loadPixmap("titlebar-right3-act", recolor);//, titleColor );
		#else

		activeTiles[TitleRight] = loadPixmap("titlebar-right-act", recolor);//, titleColor );
		#endif

		activeTiles[TitleCenter] = loadPixmap("titlebar-center-act", recolor);
		activeTiles[BorderLeft] = loadPixmap("border-left", recolor);//,  titleColor );
		activeTiles[BorderRight] = loadPixmap("border-right", recolor);//, titleColor );
		if (Settings_Param.largeGrabBars) {
			activeTiles[GrabBarLeft] = loadPixmap("grabbar-left", recolor);//,   titleColor );
			activeTiles[GrabBarRight] = loadPixmap("grabbar-right", recolor);//,  titleColor );
			activeTiles[GrabBarCenter] = loadPixmap("grabbar-center", recolor);//, titleColor );
		} else {
			activeTiles[GrabBarLeft] = loadPixmap("bottom-left", recolor);//,   titleColor );
			activeTiles[GrabBarRight] = loadPixmap("bottom-right", recolor);//,  titleColor );
			activeTiles[GrabBarCenter] = loadPixmap("bottom-center", recolor);//, titleColor );
		}
		// Inactive tiles
		// -------------------------------------------------------------------------
		captionColor = KDecoration::options()->color(ColorTitleBar, false);
		titleColor = KDecoration::options()->color(ColorTitleBlend, false);

		inactiveTiles[TitleLeft] = loadPixmap("titlebar-left-dis", recolor);//,  titleColor );
		#ifdef RIGHTRISTATE

		inactiveTiles[TitleRight1] = loadPixmap("titlebar-right1-dis", recolor);//, titleColor );
		inactiveTiles[TitleRight2] = loadPixmap("titlebar-right2-dis", recolor);//, titleColor );
		inactiveTiles[TitleRight3] = loadPixmap("titlebar-right3-dis", recolor);//, titleColor );
		#else

		inactiveTiles[TitleRight] = loadPixmap("titlebar-right-dis", recolor);//, titleColor );
		#endif

		inactiveTiles[TitleCenter] = loadPixmap("titlebar-center-dis", recolor);
		inactiveTiles[BorderLeft] = loadPixmap("border-left-dis", recolor);//,  titleColor );
		inactiveTiles[BorderRight] = loadPixmap("border-right-dis", recolor);//, titleColor );
		if (Settings_Param.largeGrabBars) {
			inactiveTiles[GrabBarLeft] = loadPixmap("grabbar-left", recolor);//,   titleColor );
			inactiveTiles[GrabBarRight] = loadPixmap("grabbar-right", recolor);//,  titleColor );
			inactiveTiles[GrabBarCenter] = loadPixmap("grabbar-center", recolor);//, titleColor );
		} else {
			inactiveTiles[GrabBarLeft] = loadPixmap("bottom-left-dis", recolor);//,   titleColor );
			inactiveTiles[GrabBarRight] = loadPixmap("bottom-right-dis", recolor);//,  titleColor );
			inactiveTiles[GrabBarCenter] = loadPixmap("bottom-center-dis", recolor);//, titleColor );
		}
		#ifdef ALLOWHUGETHEME

		hugeActiveTiles[TitleLeft] = loadPixmap("titlebar-left-act-huge", recolor);//,  titleColor );
		#ifdef RIGHTRISTATE

		hugeActiveTiles[TitleRight1] = loadPixmap("titlebar-right1-act-huge", recolor);//, titleColor );
		hugeActiveTiles[TitleRight2] = loadPixmap("titlebar-right2-act-huge", recolor);//, titleColor );
		hugeActiveTiles[TitleRight3] = loadPixmap("titlebar-right3-act-huge", recolor);//, titleColor );
		#else

		hugeActiveTiles[TitleRight] = loadPixmap("titlebar-right-act-huge", recolor);//, titleColor );
		#endif

		hugeActiveTiles[TitleCenter] = loadPixmap("titlebar-center-act-huge", recolor);
		hugeActiveTiles[BorderLeft] = loadPixmap("border-left-huge", recolor);//,  titleColor );
		hugeActiveTiles[BorderRight] = loadPixmap("border-right-huge", recolor);//, titleColor );
		if (Settings_Param.largeGrabBars) {
			hugeActiveTiles[GrabBarLeft] = loadPixmap("grabbar-left-huge", recolor);//,   titleColor );
			hugeActiveTiles[GrabBarRight] = loadPixmap("grabbar-right-huge", recolor);//,  titleColor );
			hugeActiveTiles[GrabBarCenter] = loadPixmap("grabbar-center-huge", recolor);//, titleColor );
		} else {
			hugeActiveTiles[GrabBarLeft] = loadPixmap("bottom-left-huge", recolor);//,   titleColor );
			hugeActiveTiles[GrabBarRight] = loadPixmap("bottom-right-huge", recolor);//,  titleColor );
			hugeActiveTiles[GrabBarCenter] = loadPixmap("bottom-center-huge", recolor);//, titleColor );
		}
		// Inactive tiles
		// -------------------------------------------------------------------------
		captionColor = KDecoration::options()->color(ColorTitleBar, false);
		titleColor = KDecoration::options()->color(ColorTitleBlend, false);

		hugeInactiveTiles[TitleLeft] = loadPixmap("titlebar-left-dis-huge", recolor);//,  titleColor );
		#ifdef RIGHTRISTATE

		hugeInactiveTiles[TitleRight1] = loadPixmap("titlebar-right1-dis-huge", recolor);//, titleColor );
		hugeInactiveTiles[TitleRight2] = loadPixmap("titlebar-right2-dis-huge", recolor);//, titleColor );
		hugeInactiveTiles[TitleRight3] = loadPixmap("titlebar-right3-dis-huge", recolor);//, titleColor );
		#else

		hugeInactiveTiles[TitleRight] = loadPixmap("titlebar-right-dis-huge", recolor);//, titleColor );
		#endif

		hugeInactiveTiles[TitleCenter] = loadPixmap("titlebar-center-dis-huge", recolor);
		hugeInactiveTiles[BorderLeft] = loadPixmap("border-left-dis-huge", recolor);//,  titleColor );
		hugeInactiveTiles[BorderRight] = loadPixmap("border-right-dis-huge", recolor);//, titleColor );
		if (Settings_Param.largeGrabBars) {
			hugeInactiveTiles[GrabBarLeft] = loadPixmap("grabbar-left-huge", recolor);//,   titleColor );
			hugeInactiveTiles[GrabBarRight] = loadPixmap("grabbar-right-huge", recolor);//,  titleColor );
			hugeInactiveTiles[GrabBarCenter] = loadPixmap("grabbar-center-huge", recolor);//, titleColor );
		} else {
			hugeInactiveTiles[GrabBarLeft] = loadPixmap("bottom-left-dis-huge", recolor);//,   titleColor );
			hugeInactiveTiles[GrabBarRight] = loadPixmap("bottom-right-dis-huge", recolor);//,  titleColor );
			hugeInactiveTiles[GrabBarCenter] = loadPixmap("bottom-center-dis-huge", recolor);//, titleColor );
		}
		#endif
		//active Buttons
		// -------------------------------------------------------------------------
		//  buttonColor  =  KDecoration::options()->color( ButtonBg, false );
		#ifndef CUSTOMBUTTONS
		activeButtons[MenuButton] = loadPixmap("menu-btt", recolor);
		activeButtons[OnAllDesktopsButton] = loadPixmap("alldesktop-btt", recolor);
		activeButtons[NotOnAllDesktops] = loadPixmap("noalldesktop-btt", recolor);
		#endif

		activeButtons[HelpButton] = loadPixmap("help-btt", recolor);
		activeButtons[MinButton] = loadPixmap("minimize-btt", recolor);
		activeButtons[MaxButton] = loadPixmap("maximize-btt", recolor);
		activeButtons[Restore] = loadPixmap("restore-btt", recolor);
		activeButtons[CloseButton] = loadPixmap("close-btt", recolor);
		//inactive Buttons deco
		// -------------------------------------------------------------------------
		//  buttonColor  =  KDecoration::options()->color( ButtonBg, false );
		#ifndef CUSTOMBUTTONS

		inactiveButtons[MenuButton] = loadPixmap("menu-btt-inactive", recolor);
		inactiveButtons[OnAllDesktopsButton] = loadPixmap("alldesktop-btt-inactive", recolor);
		inactiveButtons[NotOnAllDesktops] = loadPixmap("noalldesktop-btt-inactive", recolor);
		#endif

		inactiveButtons[HelpButton] = loadPixmap("help-btt-inactive", recolor);
		inactiveButtons[MinButton] = loadPixmap("minimize-btt-inactive", recolor);
		inactiveButtons[MaxButton] = loadPixmap("maximize-btt-inactive", recolor);
		inactiveButtons[Restore] = loadPixmap("restore-btt-inactive", recolor);
		inactiveButtons[CloseButton] = loadPixmap("close-btt-inactive", recolor);

		#ifdef ALLOWDISBTT
		//inactive Buttons deco
		// -------------------------------------------------------------------------
		//  buttonColor  =  KDecoration::options()->color( ButtonBg, false );
		disabledButtons[MinButton] = loadPixmap("minimize-btt-dis", recolor);
		disabledButtons[MaxButton] = loadPixmap("maximize-btt-dis", recolor);
		disabledButtons[CloseButton] = loadPixmap("close-btt-dis", recolor);
		#endif

		#ifdef ALLOWHUGETHEME
		//active Buttons Huge
		// -------------------------------------------------------------------------
		//  buttonColor  =  KDecoration::options()->color( ButtonBg, false );
		#ifndef CUSTOMBUTTONS

		hugeActiveButtons[MenuButton] = loadPixmap("menu-btt-huge", recolor);
		hugeActiveButtons[OnAllDesktopsButton] = loadPixmap("alldesktop-btt-huge", recolor);
		hugeActiveButtons[NotOnAllDesktops] = loadPixmap("noalldesktop-btt-huge", recolor);
		#endif

		//hugeActiveButtons[HelpButton] = loadPixmap("help-btt-huge", recolor);
		hugeActiveButtons[MinButton] = loadPixmap("minimize-btt-huge", recolor);
		hugeActiveButtons[MaxButton] = loadPixmap("maximize-btt-huge", recolor);
		hugeActiveButtons[Restore] = loadPixmap("restore-btt-huge", recolor);
		hugeActiveButtons[CloseButton] = loadPixmap("close-btt-huge", recolor);
		//inactive Buttons deco
		// -------------------------------------------------------------------------
		//  buttonColor  =  KDecoration::options()->color( ButtonBg, false );
		#ifndef CUSTOMBUTTONS

		hugeInactiveButtons[MenuButton] = loadPixmap("menu-btt-inactive-huge", recolor);
		hugeInactiveButtons[OnAllDesktopsButton] = loadPixmap("alldesktop-btt-inactive-huge", recolor);
		hugeInactiveButtons[NotOnAllDesktops] = loadPixmap("noalldesktop-btt-inactive-huge", recolor);
		#endif

		//hugeInactiveButtons[HelpButton] = loadPixmap("help-btt-inactive-huge", recolor);
		hugeInactiveButtons[MinButton] = loadPixmap("minimize-btt-inactive-huge", recolor);
		hugeInactiveButtons[MaxButton] = loadPixmap("maximize-btt-inactive-huge", recolor);
		hugeInactiveButtons[Restore] = loadPixmap("restore-btt-inactive-huge", recolor);
		hugeInactiveButtons[CloseButton] = loadPixmap("close-btt-inactive-huge", recolor);

		#ifdef ALLOWDISBTT
		//inactive Buttons deco
		// -------------------------------------------------------------------------
		//  buttonColor  =  KDecoration::options()->color( ButtonBg, false );
		hugeDisabledButtons[MinButton] = loadPixmap("minimize-btt-dis-huge", recolor);
		hugeDisabledButtons[MaxButton] = loadPixmap("maximize-btt-dis-huge", recolor);
		hugeDisabledButtons[CloseButton] = loadPixmap("close-btt-dis-huge", recolor);
		#endif
		#endif
		// Prepare the tiles for use
		// -------------------------------------------------------------------------
		if (QApplication::reverseLayout()) {
			flip(activeTiles[TitleCenter]);
			flip(inactiveTiles[TitleCenter]);
			#ifndef RIGHTRISTATE	
			flip(activeTiles[TitleLeft], activeTiles[TitleRight]);
			flip(inactiveTiles[TitleLeft], inactiveTiles[TitleRight]);
			#endif  
			flip(activeTiles[BorderLeft], activeTiles[BorderRight]);
			flip(inactiveTiles[BorderLeft], inactiveTiles[BorderRight]);
			flip(activeTiles[GrabBarLeft], activeTiles[GrabBarRight]);
			flip(inactiveTiles[GrabBarLeft], inactiveTiles[GrabBarRight]);
		}

		// Pretile the center & border tiles for optimal performance
		pretile(activeTiles[TitleCenter], 64, Qt::Horizontal);
		pretile(activeTiles[GrabBarCenter], 128, Qt::Horizontal);
		pretile(activeTiles[BorderLeft], 128, Qt::Vertical);
		pretile(activeTiles[BorderRight], 128, Qt::Vertical);
		pretile(inactiveTiles[TitleCenter], 64, Qt::Horizontal);
		pretile(inactiveTiles[GrabBarCenter], 128, Qt::Horizontal);
		pretile(inactiveTiles[BorderLeft], 128, Qt::Vertical);
		pretile(inactiveTiles[BorderRight], 128, Qt::Vertical);
		if (heightOffset > 0) {
			addHeight(heightOffset, activeTiles[TitleLeft]);
			addHeight(heightOffset, activeTiles[TitleCenter]);
			#ifndef RIGHTRISTATE

			addHeight(heightOffset, activeTiles[TitleRight]);
			#endif

			addHeight(heightOffset, inactiveTiles[TitleLeft]);
			addHeight(heightOffset, inactiveTiles[TitleCenter]);
			#ifndef RIGHTRISTATE

			addHeight(heightOffset, inactiveTiles[TitleRight]);
			#endif
		}

		if (widthOffset > 0) {
			addWidth(widthOffset, activeTiles[BorderLeft], true, activeTiles[GrabBarCenter]);
			addWidth(widthOffset, activeTiles[BorderRight], false, activeTiles[GrabBarCenter]);
			addWidth(widthOffset, inactiveTiles[BorderLeft], true, inactiveTiles[GrabBarCenter]);
			addWidth(widthOffset, inactiveTiles[BorderRight], false, inactiveTiles[GrabBarCenter]);

			if (Settings_Param.largeGrabBars)
				widthOffset = widthOffset * 3 / 2;

			addHeight(widthOffset, activeTiles[GrabBarLeft]);
			addHeight(widthOffset, activeTiles[GrabBarCenter]);
			addHeight(widthOffset, activeTiles[GrabBarRight]);
			addHeight(widthOffset, inactiveTiles[GrabBarLeft]);
			addHeight(widthOffset, inactiveTiles[GrabBarCenter]);
			addHeight(widthOffset, inactiveTiles[GrabBarRight]);
		}

		#ifdef ALLOWHUGETHEME
		if (QApplication::reverseLayout()) {
			flip(hugeActiveTiles[TitleCenter]);
			flip(hugeInactiveTiles[TitleCenter]);
			#ifndef RIGHTRISTATE	
			flip(hugeActiveTiles[TitleLeft], hugeActiveTiles[TitleRight]);
			flip(hugeInactiveTiles[TitleLeft], hugeInactiveTiles[TitleRight]);
			#endif  
			flip(hugeActiveTiles[BorderLeft], hugeActiveTiles[BorderRight]);
			flip(hugeInactiveTiles[BorderLeft], hugeInactiveTiles[BorderRight]);
			flip(hugeActiveTiles[GrabBarLeft], hugeActiveTiles[GrabBarRight]);
			flip(hugeInactiveTiles[GrabBarLeft], hugeInactiveTiles[GrabBarRight]);
		}

		// Pretile the center & border tiles for optimal performance
		pretile(hugeActiveTiles[TitleCenter], 64, Qt::Horizontal);
		pretile(hugeActiveTiles[GrabBarCenter], 128, Qt::Horizontal);
		pretile(hugeActiveTiles[BorderLeft], 128, Qt::Vertical);
		pretile(hugeActiveTiles[BorderRight], 128, Qt::Vertical);
		pretile(hugeInactiveTiles[TitleCenter], 64, Qt::Horizontal);
		pretile(hugeInactiveTiles[GrabBarCenter], 128, Qt::Horizontal);
		pretile(hugeInactiveTiles[BorderLeft], 128, Qt::Vertical);
		pretile(hugeInactiveTiles[BorderRight], 128, Qt::Vertical);
		if (heightOffset > 0) {
			addHeight(heightOffset, hugeActiveTiles[TitleLeft]);
			addHeight(heightOffset, hugeActiveTiles[TitleCenter]);
			#ifndef RIGHTRISTATE

			addHeight(heightOffset, hugeActiveTiles[TitleRight]);
			#endif

			addHeight(heightOffset, hugeInactiveTiles[TitleLeft]);
			addHeight(heightOffset, hugeInactiveTiles[TitleCenter]);
			#ifndef RIGHTRISTATE

			addHeight(heightOffset, hugeInactiveTiles[TitleRight]);
			#endif
		}

		if (widthOffset > 0) {
			addWidth(widthOffset, hugeActiveTiles[BorderLeft], true, hugeActiveTiles[GrabBarCenter]);
			addWidth(widthOffset, hugeActiveTiles[BorderRight], false,
					 hugeActiveTiles[GrabBarCenter]);
			addWidth(widthOffset, hugeInactiveTiles[BorderLeft], true,
					 hugeInactiveTiles[GrabBarCenter]);
			addWidth(widthOffset, hugeInactiveTiles[BorderRight], false,
					 hugeInactiveTiles[GrabBarCenter]);

			if (Settings_Param.largeGrabBars)
				widthOffset = widthOffset * 3 / 2;

			addHeight(widthOffset, hugeActiveTiles[GrabBarLeft]);
			addHeight(widthOffset, hugeActiveTiles[GrabBarCenter]);
			addHeight(widthOffset, hugeActiveTiles[GrabBarRight]);
			addHeight(widthOffset, hugeInactiveTiles[GrabBarLeft]);
			addHeight(widthOffset, hugeInactiveTiles[GrabBarCenter]);
			addHeight(widthOffset, hugeInactiveTiles[GrabBarRight]);
		}

		#endif
	}

	inline void HumanblueHandler::destroyPixmaps() {
		//qDebug("destroyPixmaps()");
		for (register int i = 0; i < NumTiles; i++) {
			delete activeTiles[i];
			delete inactiveTiles[i];
			activeTiles[i] = NULL;
			inactiveTiles[i] = NULL;
			#ifdef ALLOWHUGETHEME

			delete hugeInactiveTiles[i];
			delete hugeActiveTiles[i];
			hugeInactiveTiles[i] = NULL;
			hugeActiveTiles[i] = NULL;
			#endif
		}
		for (register int a = 0; a < NumButtons; a++) {
			delete activeButtons[a];
			delete inactiveButtons[a];
			activeButtons[a] = NULL;
			inactiveButtons[a] = NULL;
			#ifdef ALLOWDISBTT  
			disabledButtons[a] = NULL;
			delete disabledButtons[a];
			#endif
			#ifdef ALLOWHUGETHEME

			delete hugeActiveButtons[a];
			delete hugeInactiveButtons[a];
			hugeActiveButtons[a] = NULL;
			hugeInactiveButtons[a] = NULL;
			#ifdef ALLOWDISBTT  	
			hugeDisabledButtons[a] = NULL;
			delete hugeDisabledButtons[a];  
			#endif  
			#endif
		}
	}

	void HumanblueHandler::addWidth(register int width, QPixmap *&pix, bool left, QPixmap *bottomPix) {
		//qDebug("addWidth()");
		register int w = pix->width() + width;
		register int h = pix->height();
		QPixmap	   *tmp	= new QPixmap(w, h);
		tmp->fill();
		QPainter	p;
		p.begin(tmp);
		for (register int i = 0; i < h; i++)
			p.drawPixmap(0, i, *bottomPix, i % 2, 0, w, 1);
		if (left)
			p.drawPixmap(0, 0, *pix);
		else
			p.drawPixmap(width, 0, *pix);
		p.end();
		delete pix;
		pix = tmp;
	}

	void HumanblueHandler::addHeight(register int height, QPixmap *&pix) {
		//qDebug("addHeight()");
		register int w = pix->width();
		register int h = pix->height() + height;
		QPixmap	   *tmp	= new QPixmap(w, h);
		QPainter	p;
		p.begin(tmp);
		if (pix->height() > 10) {
			p.drawPixmap(0, 0, *pix, 0, 0, w, 11);
			for (register int i = 0; i < height; i += 2)
				p.drawPixmap(0, 11 + i, *pix, 0, 11, w, 2);
			p.drawPixmap(0, 11 + height, *pix, 0, 11, w, -1);
		} else {
			register int lines = h - 3;
			register int factor = pix->height() - 3;
			for (register int i = 0; i < lines; i++)
				p.drawPixmap(0, i, *pix, 0, i * factor / lines, w, 1);
			p.drawPixmap(0, lines, *pix, 0, factor, w, 3);
		}
		p.end();
		delete pix;
		pix = tmp;
	}

	void HumanblueHandler::flip(QPixmap *&pix1, QPixmap *&pix2) {
		//qDebug("flip()");
		// Flip the pixmaps horizontally
		QPixmap	   *tmp	= new QPixmap(pix1->xForm(QWMatrix(-1, 0, 0, 1, pix1->width(), 0)));
		delete pix1;
		pix1 = new QPixmap(pix2->xForm(QWMatrix(-1, 0, 0, 1, pix2->width(), 0)));
		delete pix2;
		pix2 = tmp;
	}

	void HumanblueHandler::flip(QPixmap *&pix) {
		//qDebug("flip()[2]");
		// Flip the pixmap horizontally
		QPixmap	   *tmp	= new QPixmap(pix->xForm(QWMatrix(-1, 0, 0, 1, pix->width(), 0)));
		delete pix;
		pix = tmp;
	}

	void HumanblueHandler::pretile(QPixmap *&pix, register int size, Qt::Orientation dir) {
		//qDebug("pretile()");
		QPixmap	   *newpix;
		QPainter	p;
		if (dir == Qt::Horizontal)
			newpix = new QPixmap(size, pix->height());
		else
			newpix = new QPixmap(pix->width(), size);
		p.begin(newpix);
		p.drawTiledPixmap(newpix->rect(), *pix) ;
		p.end();
		delete pix;
		pix = newpix;
	}

	inline void HumanblueHandler::readConfig()//rehacer
	{
		//qDebug("readConfig()");
		KConfig	   *c	= new KConfig("kwinhumanbluerc");
		c->setGroup("General");
		Settings_Param.showIcons = c->readBoolEntry("ShowAppIcons", true);
		Settings_Param.shadowedText = c->readBoolEntry("UseShadowedText", true);
		Settings_Param.largeGrabBars = c->readBoolEntry("LargeGrabBars", false);
		Settings_Param.textpos = c->readNumEntry("TextPosition", 0);
		Settings_Param.shadowtype = c->readNumEntry("UseShadowedTextType", 1);
		Settings_Param.coloroption = c->readNumEntry("UseColorOption", 0);
		Settings_Param.effects = c->readNumEntry("Effect", 0);
		Settings_Param.ShadowColor = c->readColorEntry("UseShadowedTextColor");
		Settings_Param.InShadowColor = c->readColorEntry("UseShadowedInactiveTextColor");
		Settings_Param.Transparency = c->readBoolEntry("UseIconTransparent", false);
		Settings_Param.IconEffectColor = c->readColorEntry("UseIconColor");
		Settings_Param.effectvalues = c->readNumEntry("EffectValue", 50);
		Settings_Param.Colorize = c->readNumEntry("Colorize", 0);
		#ifdef ALLOWHUGETHEME

		Settings_Param.tsize = c->readBoolEntry("ThemeSize", false);
		#endif

		#ifdef AVATARENABLED

		Avatar_Params.avatarfuncURL = c->readEntry("AvatarFuncURL", "www.humanblue.com");
		Avatar_Params.avatarpix = c->readEntry("CustomAvatarPix", QString::null);
		Avatar_Params.avatarfunctype = c->readEntry("AvatarFuncType", "Konqueror");
		Avatar_Params.avatarfunc = c->readNumEntry("AvatarFunc", 0);
		Avatar_Params.avatar = c->readNumEntry("Avatar", 0);
		#endif

		delete c;
	}

	inline QImage * HumanblueHandler::loadImage(const QString &name)//, const QColor &col )
	{
		//qDebug("loadImage()");
		// if ( col.isValid() )
		//{
		QImage *img	= new QImage(imageDb->image(name)->copy());
		return img;
		// }
		//else
		// return new QImage( imageDb->image(name)->copy() );
	}

	inline QPixmap * HumanblueHandler::loadPixmap(const QString &name, bool recolor) {
		//qDebug("loadPixmap()");
		/*
			titlebar-left-act titlebar-right-act titlebar-center-act border-left
			border-right bottom-left bottom-right bottom-center titlebar-left-dis
			titlebar-right-dis titlebar-center-dis border-left-dis border-right-dis
			bottom-left-dis bottom-right-dis bottom-center-dis help-btt
			minimize-btt maximize-btt restore-btt close-btt help-btt-inactive
			minimize-btt-inactive maximize-btt-inactive restore-btt-inactive
			close-btt-inactive
			*/

		QImage img = *loadImage(name);
		if (recolor) {
			QColor activeTitleColor = KDecoration::options()->color(ColorTitleBar, true);
			QColor activeBlendColor = KDecoration::options()->color(ColorTitleBlend, true);
			QColor inactiveTitleColor = KDecoration::options()->color(ColorTitleBar, false);
			QColor inactiveBlendColor = KDecoration::options()->color(ColorTitleBlend, false);
			if (name.contains("btt-inactive") >= 1)
				KIconEffect::colorize(img, inactiveTitleColor, .99);
				//KIconEffect::colorize(img, inactiveBlendColor, .99);
			else if (name.contains("btt") >= 1)
				KIconEffect::colorize(img, activeTitleColor, .99);
				//KIconEffect::colorize(img, activeBlendColor, .99);
			else if (name.contains("dis") >= 1 || name.contains("inactive") >= 1)
				KIconEffect::colorize(img, inactiveTitleColor, .99);
			else
				KIconEffect::colorize(img, activeTitleColor, .99);
		}
		QPixmap *pix = new QPixmap(FastImageIO.convertToPixmap(img));
		return pix;
	}

	//inline void 

	inline bool HumanblueHandler::reset(unsigned long changed) {
		//qDebug("reset");
		humanblue_initialized = false;
		bool	needHardReset	= false;
		bool	pixmapsInvalid	= false;
		// Re-read the config file
		readConfig();
		if (changed & SettingBorder) {
			pixmapsInvalid = true;
			needHardReset = true;
		}
		if (changed & SettingFont) {
			pixmapsInvalid = true;
			needHardReset = true;
		}
		// Check if the color scheme has changed
		if (changed & SettingColors) {
			pixmapsInvalid = true;
		}
		// Check if button positions have changed

		if (changed & SettingButtons)
			needHardReset = true;

		// Check if tooltips options have changed
		if (changed & SettingTooltips)
			needHardReset = true;

		if (!Settings_Param.largeGrabBars) {
			pixmapsInvalid = true;
			needHardReset = true;
		}

		// Do we need to recreate the pixmaps?
		if (pixmapsInvalid) {
			destroyPixmaps();
			if (Settings_Param.Colorize == 1)
				createPixmaps(true);
			else
				createPixmaps(false);
		}
		humanblue_initialized = true;
		// Do we need to "hit the wooden hammer" ?

		if (!needHardReset)
			resetDecorations(changed);
		return needHardReset;
	}

	const QPixmap * HumanblueHandler::tile(TilePixmap tilePix, bool active) const {
		#ifdef ALLOWHUGETHEME
		if (Settings_Param.tsize)
			return (active ? hugeActiveTiles[tilePix] : hugeInactiveTiles[tilePix]);
		else
			return (active ? activeTiles[tilePix] : inactiveTiles[tilePix]);
		#else

		return (active ? activeTiles[tilePix] : inactiveTiles[tilePix]);
		#endif
	}

	#ifdef ALLOWDISBTT
	const QPixmap * HumanblueHandler::btile(Button buttonPix, bool active, bool dis) const {
		#ifdef ALLOWHUGETHEME
		if (!dis)
			if (Settings_Param.tsize)
				return (active ? hugeActiveButtons[buttonPix] : hugeInactiveButtons[buttonPix]);
			else
				return (active ? activeButtons[buttonPix] : inactiveButtons[buttonPix]);
		else if (Settings_Param.tsize)
			return hugeDisabledButtons[buttonPix];
		else
			return disabledButtons[buttonPix];
		#else

		if (!dis)
			return (active ? activeButtons[buttonPix] : inactiveButtons[buttonPix]);
		else
			return disabledButtons[buttonPix];
		#endif
	}
	#else
	const QPixmap * HumanblueHandler::btile(Button buttonPix, bool active) const {
		#ifdef ALLOWHUGETHEME
		if (Settings_Param.tsize)
			return (active ? hugeActiveButtons[buttonPix] : hugeInactiveButtons[buttonPix]);
		else
			return (active ? activeButtons[buttonPix] : inactiveButtons[buttonPix]);
		#else

		return (active ? activeButtons[buttonPix] : inactiveButtons[buttonPix]);
		#endif
	}
	#endif

	#ifdef LARGEPAINTCENTER
	inline QPixmap HumanblueHandler::iTile(bool active, int w, int h) {
		#ifdef ALLOWHUGETHEME
		if (Settings_Param.tsize)
			largecenter = active ?
						  *loadImage("titlebar-center-act-huge") :
						  *loadImage("titlebar-center-dis-huge");
		else
			largecenter = active ?
						  *loadImage("titlebar-center-act") :
						  *loadImage("titlebar-center-dis");
		return FastImageIO.convertToPixmap(largecenter.scale(w, h, QImage::ScaleFree));
		#else

		largecenter = active ?
					  *loadImage("titlebar-center-act") :
					  *loadImage("titlebar-center-dis");
		return FastImageIO.convertToPixmap(largecenter.scale(w, h, QImage::ScaleFree));
		#endif
	}
	#endif

	KDecoration * HumanblueHandler::createDecoration(KDecorationBridge *bridge) {
		//qDebug("createDecoration()");
		return new HumanblueClient(bridge, this);
	}

	QValueList< HumanblueHandler::BorderSize > HumanblueHandler::borderSizes() const {
		//qDebug("borderSizes()");
		// the list must be sorted
		return QValueList<BorderSize>() << BorderNormal << BorderLarge << BorderVeryLarge;
	}
	// revisado-----------------------------------------------------------------------------------
	HumanblueButton::HumanblueButton(HumanblueClient *c, const char *name, Button btn,
								   const QString &tip, bool bttstate, const int realizeBtns):QButton(c->widget(), name, WStaticContents | WNoAutoErase),
																							 client(c),
																							 button(btn),
																							 hover(false),
																							 lastbutton(0){
		realizeButtons = realizeBtns;
		QToolTip::add(this, tip); // FRAME
		#ifdef ALLOWDISBTT  	
		bttdis = bttstate;
		#endif
		setCursor(arrowCursor);
		#ifdef ALLOWDISBTT
		sizebtt = clientHandler->btile(btn, client->isActive(), bttdis)->width() / 3;
		sizeh = clientHandler->btile(btn, client->isActive(), bttdis)->height();
		#else
		sizebtt = clientHandler->btile(btn, client->isActive())->width() / 3;
		sizeh = clientHandler->btile(btn, client->isActive())->height();
		#endif    
		setFixedSize(sizebtt, sizeh);
		#ifndef CUSTOMBUTTONS

		setToggleButton((button == OnAllDesktopsButton));
		#endif
	}
	HumanblueButton::~HumanblueButton() {
		// Empty.
	}

	void HumanblueButton::enterEvent(QEvent *e) {
		QButton::enterEvent(e);
		hover = true;
		update();
	}

	void HumanblueButton::leaveEvent(QEvent *e) {
		QButton::leaveEvent(e);
		hover = false;
		update();
	}

	void HumanblueButton::mousePressEvent(QMouseEvent *e) {
		lastbutton = e->button();
		QMouseEvent	me	(e->type(), e->pos(), e->globalPos(),
						 (e->button() & realizeButtons) ? LeftButton : NoButton, e->state());
		QButton::mousePressEvent(&me);
	}

	void HumanblueButton::mouseReleaseEvent(QMouseEvent *e) {
		lastbutton = e->button();
		QMouseEvent	me	(e->type(), e->pos(), e->globalPos(),
						 (e->button() & realizeButtons) ? LeftButton : NoButton, e->state());
		QButton::mouseReleaseEvent(&me);
	}
	#ifndef DISABLEDOUBLEBUFFER
	inline void HumanblueButton::drawButton(QPainter *painter)
	#else
	inline void HumanblueButton::drawButton(QPainter *p)
			#endif
	{
		#ifndef DISABLEDOUBLEBUFFER
		#ifdef ALLOWDISBTT
		static QPixmap *dbuffer	= new QPixmap(clientHandler->btile(button, client->isActive(),
																   bttdis)->width() /
											  3,
											  clientHandler->btile(button, client->isActive(),
																   bttdis)->height());
		#else
		static QPixmap *dbuffer	= new QPixmap(clientHandler->btile(button, client->isActive())->width() /
											  3,
											  clientHandler->btile(button, client->isActive())->height());
		#endif    
		const QPixmap  *pix;
		QPainter		p		(dbuffer);

		#endif
		// Draw the button deco on the bevel
		p.save();
		switch (button) {
			#ifdef ALLOWDISBTT
			#ifndef CUSTOMBUTTONS
		  case MenuButton:
			pix = clientHandler->btile(MenuButton, client->isActive(), false);
			break;

		  case OnAllDesktopsButton:
			pix = clientHandler->btile(isOn() ? NotOnAllDesktops : OnAllDesktopsButton,
									   client->isActive(), false);
			break;
			#endif

		  case HelpButton:
			pix = clientHandler->btile(HelpButton, client->isActive(), false);
			break;

		  case MinButton:
			pix = clientHandler->btile(MinButton, client->isActive(), bttdis);
			break;

		  case MaxButton:
			pix = clientHandler->btile(client->maximizeMode() ==
									   HumanblueClient::MaximizeFull ?
									   Restore :
									   MaxButton,
									   client->isActive(), bttdis);
			break;

		  case CloseButton:
			pix = clientHandler->btile(CloseButton, client->isActive(), bttdis);
			break;
			#else
			#ifndef CUSTOMBUTTONS

		  case MenuButton:
			pix = clientHandler->btile(MenuButton, client->isActive());
			break;

		  case OnAllDesktopsButton:
			pix = clientHandler->btile(isOn() ? NotOnAllDesktops : OnAllDesktopsButton,
									   client->isActive());
			break;
			#endif

		  case HelpButton:
			pix = clientHandler->btile(HelpButton, client->isActive());
			break;

		  case MinButton:
			pix = clientHandler->btile(MinButton, client->isActive());
			break;

		  case MaxButton:
			pix = clientHandler->btile(client->maximizeMode() ==
									   HumanblueClient::MaximizeFull ?
									   Restore :
									   MaxButton,
									   client->isActive());
			break;

		  case CloseButton:
			pix = clientHandler->btile(CloseButton, client->isActive());
			break;
			#endif

		  default:
			pix = NULL;
		}
		if (isDown())
			p.drawPixmap(QPoint(), *pix, QRect(sizebtt, 0, sizebtt, sizebtt));
		else if (hover)
			p.drawPixmap(QPoint(), *pix, QRect(2 * sizebtt, 0, sizebtt, sizebtt));
		else
			p.drawPixmap(QPoint(), *pix, QRect(0, 0, sizebtt, sizebtt));
		p.restore();
		#ifndef DISABLEDOUBLEBUFFER

		painter->drawPixmap(0, 0, *dbuffer);
		#endif
	}

	//--------------------------------------------------------------------------------------------
	#ifdef AVATARENABLED
	HumanblueAvatarButton::HumanblueAvatarButton(HumanblueClient *c, const char *name,
											   const QString &tip):QButton(c->widget(), name, WStaticContents | WNoAutoErase),
																   client(c),over(false){
		//    setBackgroundMode( NoBackground );
		setCursor(QCursor(Qt::PointingHandCursor));
		if (Avatar_Params.avatar == 0)
			setFixedSize(24, 16);
		else if (Avatar_Params.avatar == 1)
			setFixedSize(22, 22);
		setAutoMask(true);
		QToolTip::add(this, tip);
	}

	HumanblueAvatarButton::~HumanblueAvatarButton() {
	}

	inline void HumanblueAvatarButton::updateMask() {
		QImage	img0	= LoadAvatar().copy();
		img0.setAlphaBuffer(true);
		QBitmap	Mask;
		if (img0.hasAlphaBuffer())
			Mask = img0.createAlphaMask();
		else
			Mask = img0.createHeuristicMask();
		setMask(Mask);
	}

	inline QImage HumanblueAvatarButton::LoadAvatar() {
		QImage	temp;
		if (Avatar_Params.avatar == 1)
			temp = FastScaleImage(Avatar_Params.avatarpix, 22, 22);
		else if (Avatar_Params.avatar == 0) {
			HumanblueImageDb	   *imageDb;
			imageDb = HumanblueImageDb::instance();
			temp = imageDb->image("avatar")->copy();
		}
		return temp;
	}

	inline QImage HumanblueAvatarButton::FastScaleImage(const QString &imagen, int w, int h) {
		QImage	img;
		img.load(imagen);
		QImage	imgtemp	= img.smoothScale(w, h, QImage::ScaleFree);
		return imgtemp;
	}

	void HumanblueAvatarButton::enterEvent(QEvent *e) {
		QButton::enterEvent(e);
		over = true;
		update();
	}

	void HumanblueAvatarButton::leaveEvent(QEvent *e) {
		QButton::leaveEvent(e);
		over = false;
		update();
	}

	inline void HumanblueAvatarButton::drawButton(QPainter *p) {
		QImage	img	= LoadAvatar();
		if (isDown()) {
			if (!client->isActive())
				KIconEffect::toGray(img, 100);
			else
				KIconEffect:: toGamma(img, 0);
			p->drawImage(QPoint(), img);
		} else if (over) {
			if (!client->isActive()) {
				KIconEffect::semiTransparent(img);
				KIconEffect::toGray(img, 100);
			} else
				KIconEffect::semiTransparent(img);
			p->drawImage(QPoint(), img);
		} else {
			if (!client->isActive())
				KIconEffect::toGray(img, 100);
			else
				img = img;
			p->drawImage(QPoint(), img);
		}
	}

	// revisado-----------------------------------------------------------------------------------
	#endif

	HumanblueClient::HumanblueClient(KDecorationBridge *bridge, KDecorationFactory *factory):KDecoration(bridge, factory),
																						   activeIcon(NULL),
																						   inactiveIcon(NULL),
																						   maskDirty(true),
																						   captionBufferDirty(true),
																						   iconBufferDirty(true){
		captionBufferDirty = true;
		iconBufferDirty = true;
		Settings_Param.btnposflag = LeftButton | RightButton;
	}

	void HumanblueClient::init() {
		//qDebug("init()");
		#ifdef ALLOWHUGETHEME
		if (Settings_Param.tsize)
			Settings_Param.CaptionAdjustement = HUGECAPTIONHEIGHTADJUSTEMENT;
		else
			Settings_Param.CaptionAdjustement = CAPTIONHEIGHTADJUSTEMENT;
		#else
		Settings_Param.CaptionAdjustement = CAPTIONHEIGHTADJUSTEMENT;
		#endif

		createMainWidget(WStaticContents | WNoAutoErase);
		widget()->installEventFilter(this);
		#ifdef RIGHTRISTATE

		ButtonsLeft = ButtonsOnLeft();
		switch (ButtonsLeft) {
		  case 3:
			pixNumBtt = TitleRight1;
			break;
		  case 4:
			pixNumBtt = TitleRight2;
			break;
		  case 5:
			pixNumBtt = TitleRight3;
			break;
		}
		#endif
		// Minimize flicker
		//    widget()->setBackgroundMode( NoBackground );

		for (register int i = 0; i < NumButtons; i++)
			button[i] = NULL;

		createLayout();
	}

	inline void HumanblueClient::createLayout() {
		//qDebug("createLayout()");
		QVBoxLayout	   *mainLayout		= new QVBoxLayout(widget());
		QBoxLayout	   *titleLayout		= new QBoxLayout(0, QBoxLayout::LeftToRight, 0, 0, 0);
		QHBoxLayout	   *windowLayout	= new QHBoxLayout();
		#ifdef ALLOWHUGETHEME

		if (Settings_Param.tsize)
			Settings_Param.topSpacing = HUGETOPSPACING;
		else
			Settings_Param.topSpacing = TOPSPACING;
		#else

		Settings_Param.topSpacing = TOPSPACING;
		#endif

		register int grabBarHeight = clientHandler->grabBarHeight();
		register int leftBorderWidth = clientHandler->tile(BorderLeft, isActive())->width();
		register int rightBorderWidth = clientHandler->tile(BorderRight, isActive())->width();
		topSpacer = new QSpacerItem(10, Settings_Param.topSpacing, QSizePolicy::Expanding,
									QSizePolicy::Minimum);

		mainLayout->addItem(topSpacer);

		mainLayout->addLayout(titleLayout); 	// Titlebar
		mainLayout->addLayout(windowLayout, 1); // Left border + window + right border
		mainLayout->addSpacing(grabBarHeight);  // Bottom grab bar


		#ifndef  NOBTTLEFT
		#ifdef ALLOWHUGETHEME

		if (Settings_Param.tsize) {
			titleLayout->addSpacing(hugeButtonMargin - 1);  	// Left button margin
			titleLayout->setSpacing(hugeButtonSpacing);
		} else {
			titleLayout->addSpacing(buttonMargin - 1);  	// Left button margin
			titleLayout->setSpacing(buttonSpacing);
		}
		#else
		titleLayout->addSpacing(buttonMargin - 1);  	// Left button margin
		titleLayout->setSpacing(buttonSpacing);
		#endif

		addButtons(titleLayout,
				   options()->customButtonPositions() ?
				   options()->titleButtonsLeft() :
				   QString(default_left));
		#endif

		#ifdef AVATARENABLED

		addAvatar();
		#endif

		titlebar = new QSpacerItem(10, clientHandler->titleBarHeight() - Settings_Param.topSpacing,
								   QSizePolicy::Expanding, QSizePolicy::Minimum);
		titleLayout->addItem(titlebar);


		#ifndef NOBTTRIGHT
		#ifdef ALLOWHUGETHEME

		if (Settings_Param.tsize) {
			titleLayout->addSpacing(hugeButtonSpacing);
			addButtons(titleLayout,
					   options()->customButtonPositions() ?
					   options()->titleButtonsRight() :
					   QString(default_right));
			titleLayout->addSpacing(hugeButtonMargin - 1);
		} else {
			titleLayout->addSpacing(buttonSpacing);
			addButtons(titleLayout,
					   options()->customButtonPositions() ?
					   options()->titleButtonsRight() :
					   QString(default_right));
			titleLayout->addSpacing(buttonMargin - 1);
		}
		#else
		titleLayout->addSpacing(buttonSpacing);
		addButtons(titleLayout,
				   options()->customButtonPositions() ?
				   options()->titleButtonsRight() :
				   QString(default_right));
		titleLayout->addSpacing(buttonMargin - 1);  // Right button margin
		#endif

		#endif

		windowLayout->addSpacing(leftBorderWidth);  			  // Left border
		if (isPreview())
			windowLayout->addWidget(new QLabel(i18n("<center><b><u>Evil Red</u>\n</b></center>"),
											   widget()));
		else
			windowLayout->addItem(new QSpacerItem(0, 0)); //no widget in the middle
		windowLayout->addSpacing(rightBorderWidth); 			   // Right border
	}

	HumanblueClient::~HumanblueClient() {
		delete activeIcon;
		delete inactiveIcon;
		activeIcon = inactiveIcon = NULL;
	}

	void HumanblueClient::reset(unsigned long) {
		maskDirty = true;
		captionBufferDirty = true;
		iconBufferDirty = true;

		// Only repaint the window if it's visible
		// (i.e. not minimized and on the current desktop)
		if (widget()->isVisible()) {
			widget()->update();
			#ifdef AVATARENABLED

			btt->update();
			#endif
			#ifdef RIGHTRISTATE

			ButtonsLeft = ButtonsOnLeft();
			switch (ButtonsLeft) {
			  case 3:
				pixNumBtt = TitleRight1;
				break;
			  case 4:
				pixNumBtt = TitleRight2;
				break;
			  case 5:
				pixNumBtt = TitleRight3;
				break;
			}
			#endif
			for (register int i = 0; i < NumButtons; i++)
				if (button[i])
					button[i]->update();
		}
	}

	#ifdef AVATARENABLED
	void HumanblueClient::addAvatar() {
		btt = new HumanblueAvatarButton(this, "Kwin Functional Button",
									   i18n("Kwin Functional Button"));
		connect(btt, SIGNAL(pressed()), this, SLOT(AvatarAction()));
		if (Avatar_Params.avatar == 0)
			btt->setGeometry(5, 5, this->width(), this->height());
		else if (Avatar_Params.avatar == 1)
			btt->setGeometry(((clientHandler->tile(TitleLeft, isActive())->width() - btt->width()) /
							  2) -
							 2,
							 (clientHandler->tile(TitleLeft, isActive())->height() - btt->height()) /
							 2,
							 this->width(), this->height());
	}
	#endif

	inline  void HumanblueClient::addButtons(QBoxLayout *layout, const QString &s) {
		Settings_Param.btnposflag = LeftButton | MidButton | RightButton;

		// Minimize button
		for (register uint i = 0; i < s.length(); i++)
			switch (s[i].latin1()) {
			  case 'I' :
				if (isMinimizable()) {
					button[MinButton] = new HumanblueButton(this, "minimize", MinButton,
														   i18n("Minimize"), false,
														   Settings_Param.btnposflag);
					connect(button[MinButton], SIGNAL(clicked()), this, SLOT(minimize()));
					layout->addWidget(button[MinButton]);
				}
				#ifdef ALLOWDISBTT
				else {
					button[DisMinButton] = new HumanblueButton(this, "minimizedis", MinButton,
															  i18n("Minimize Disabled"), true,
															  Settings_Param.btnposflag);
					layout->addWidget(button[DisMinButton]);
				}
				#endif
				break;

				// Maximize button
			  case 'A' :
				if (isMaximizable()) {
					button[MaxButton] = new HumanblueButton(this, "maximize", MaxButton,
														   i18n("Maximize"), false,
														   Settings_Param.btnposflag);
					connect(button[MaxButton], SIGNAL(clicked()), this, SLOT(slotMaximize()));
					layout->addWidget(button[MaxButton]);
				}
				#ifdef ALLOWDISBTT
				else {
					button[DisMaxButton] = new HumanblueButton(this, "maximizedis", MaxButton,
															  i18n("Maximize Disabled"), true,
															  Settings_Param.btnposflag);
					layout->addWidget(button[DisMaxButton]);
				}
				#endif
				break;

				// Close button
			  case 'X' :
				if (isCloseable()) {
					button[CloseButton] = new HumanblueButton(this, "close", CloseButton,
															 i18n("Close"), false,
															 Settings_Param.btnposflag);
					connect(button[CloseButton], SIGNAL(clicked()), this, SLOT(closeWindow()));
					layout->addWidget(button[CloseButton]);
				}
				#ifdef ALLOWDISBTT
				else {
					button[DisCloseButton] = new HumanblueButton(this, "closedis", CloseButton,
																i18n("Close Disabled"), true,
																Settings_Param.btnposflag);
					layout->addWidget(button[DisCloseButton]);
				}
				#endif
				break;

				// Additional spacing
			  case '_' :
				layout->addSpacing(buttonSpacing);
				break;

//			  case 'H' :
//				if (!button[HelpButton] && providesContextHelp()) {
//					button[HelpButton] = new HumanblueButton(this, "help", HelpButton, i18n("Help"),
//															false, Settings_Param.btnposflag);
//					connect(button[HelpButton], SIGNAL(clicked()), SLOT(showContextHelp()));
//					layout->addWidget(button[HelpButton]);
//				}
//				break;
				#ifndef CUSTOMBUTTONS
				// Menu button
			  case 'M' :
				if (!button[MenuButton]) {
					button[MenuButton] = new HumanblueButton(this, "menu", MenuButton, i18n("Menu"),
															false, Settings_Param.btnposflag);
					connect(button[MenuButton], SIGNAL(pressed()), SLOT(menuButtonPressed()));
					layout->addWidget(button[MenuButton]);
				}
				break;

				// OnAllDesktops button
			  case 'S' :
				if (!button[OnAllDesktopsButton]) {
					button[OnAllDesktopsButton] = new HumanblueButton(this, "on_all_desktops",
																	 OnAllDesktopsButton,
																	 isOnAllDesktops() ?
																	 i18n("Not On All Desktops") :
																	 i18n("On All Desktops"),
																	 false,
																	 Settings_Param.btnposflag);
					if (isOnAllDesktops())
						button[OnAllDesktopsButton]->toggle();
					connect(button[OnAllDesktopsButton], SIGNAL(clicked()),
							SLOT(toggleOnAllDesktops()));
					layout->addWidget(button[OnAllDesktopsButton]);
				}
				break;
				#endif
			}
	}

	inline void HumanblueClient::updateMask() {
		if ( !humanblue_initialized )
			return;

		register int w( width() );
		register int h( height() );
		QRegion mask( 0, 0, w, h );

		// QRegion(xCoord, yCoord, width, height)
		// Top left clip
		mask -= QRegion( 0, 0, 0, 0 ); 
		mask -= QRegion( 0, 0, 0, 0 );
		mask -= QRegion( 0, 0, 0, 0 );
		mask -= QRegion( 0, 0, 0, 0 );
		mask -= QRegion( 0, 0, 0, 0 );

		// Top right clip
		mask -= QRegion( w - 0, 0, 0, 0 );
		mask -= QRegion( w - 0, 0, 0, 0 );
		mask -= QRegion( w - 0, 0, 0, 0 );
		mask -= QRegion( w - 0, 0, 0, 0 );
		mask -= QRegion( w - 0, 0, 0, 0 );
	
		// Bottom left clip
		mask -= QRegion( 0, h - 0, 0, 0 ); 
		mask -= QRegion( 0, h - 0, 0, 0 );
		mask -= QRegion( 0, h - 0, 0, 0 );
		mask -= QRegion( 0, h - 0, 0, 0 );
		mask -= QRegion( 0, h - 0, 0, 0 );

		// Bottom right clip
		mask -= QRegion( w - 0, h - 0, 0, 0 );
		mask -= QRegion( w - 0, h - 0, 0, 0 );
		mask -= QRegion( w - 0, h - 0, 0, 0 );
		mask -= QRegion( w - 0, h - 0, 0, 0 );
		mask -= QRegion( w - 0, h - 0, 0, 0 );

	    setMask( mask );
	    maskDirty = false;
  }

	void HumanblueClient::captionChange() {
		//qDebug("captionChange()");
		maskDirty = true;
		captionBufferDirty = true;
		widget()->update(clientHandler->tile(TitleLeft, isActive())->width() + iconAppSpacing,
						 ((clientHandler->tile(TitleCenter, isActive())->height() - 16) / 2) + 1,
						 16, 16);
		#ifdef RIGHTRISTATE

		widget()->update(clientHandler->tile(TitleLeft, isActive())->width() +
						 iconAppSpacing +
//						 16 +
						 textSpacing,
						 0,
						 width() -
						 (clientHandler->tile(pixNumBtt, isActive())->width() +
						  clientHandler->tile(TitleLeft,
											  isActive())->width() +
						  iconAppSpacing +
//						  16 +
						  textSpacing),
						 clientHandler->tile(TitleCenter, isActive())->height());

		#else

		widget()->update(clientHandler->tile(TitleLeft, isActive())->width() +
						 iconAppSpacing +
//						 16 +
						 textSpacing,
						 0,
						 width() -
						 (clientHandler->tile(TitleRight, isActive())->width() +
						  clientHandler->tile(TitleLeft,
											  isActive())->width() +
						  iconAppSpacing +
//						  16 +
						  textSpacing),
						 clientHandler->tile(TitleCenter, isActive())->height());
		#endif
	}

	void HumanblueClient::iconChange() {
		//qDebug("iconChange()");
		if (clientHandler->showAppIcons()) {
			if (activeIcon)
				delete activeIcon;
			if (inactiveIcon)
				delete inactiveIcon;
			activeIcon = inactiveIcon = NULL;
			iconBufferDirty = true;
			widget()->update(clientHandler->tile(TitleLeft, isActive())->width() +
							 iconAppSpacing,
							 ((clientHandler->tile(TitleCenter, isActive())->height() - 16) / 2) +
							 1,
							 16, 16);
		}
	}

	inline void HumanblueClient::drawAppIcon(QPainter &p) {
		if (!humanblue_initialized)
			return;
		QPixmap	   *icon	= NULL;

		if (clientHandler->showAppIcons()) {
			if (isActive()) {
				if (!activeIcon)
					activeIcon = new QPixmap(this->icon().pixmap(QIconSet::Small, QIconSet::Normal)); // FRAME
				icon = activeIcon;
			} else {
				if (!inactiveIcon) {
					QImage	img	= this->icon().pixmap(QIconSet::Small, QIconSet::Normal).convertToImage();
					if (Settings_Param.Transparency)
						KIconEffect::semiTransparent(img);
					switch (Settings_Param.effects) {
					  case 0:
						KIconEffect::toGray(img, Settings_Param.effectvalues / 100);
						break;
					  case 1:
						KIconEffect::colorize(img, Settings_Param.IconEffectColor,
											  Settings_Param.effectvalues / 100);
						break;
					  case 2:
						KIconEffect:: toGamma(img, Settings_Param.effectvalues / 100);
						break;
					  case 3:
						KIconEffect::deSaturate(img, Settings_Param.effectvalues / 100);
						break;
					}
					inactiveIcon = new QPixmap(img);
				}
				icon = inactiveIcon;
			}
			#ifdef RIGHTRISTATE
			p.drawPixmap(clientHandler->tile(TitleLeft, isActive())->width() +
						 iconAppSpacing,
						 ((clientHandler->tile(TitleCenter, isActive())->height() - icon->height()) /
						  2) +
						 Settings_Param.CaptionAdjustement +
						 1,
						 *icon, 0, 0, icon->width(), icon->height());
			iconBufferDirty = false;
			#else

			p.drawPixmap(BttWidthOnLeft() +
						 iconAppSpacing,
						 ((clientHandler->tile(TitleCenter, isActive())->height() - icon->height()) /
						  2) +
						 Settings_Param.CaptionAdjustement /
						 2 +
						 1,
						 *icon, 0, 0, icon->width(), icon->height());
			iconBufferDirty = false;
			#endif
		}
	}

	inline void HumanblueClient::drawCaptionText(QPainter &p) {
		//qDebug("drawCaptionText()");
		if (!humanblue_initialized)
			return;
		int	flags	= 0;
		p.setFont(clientHandler->options()->font(isActive()));
		// Draw the titlebar text
		switch (Settings_Param.textpos) {
		  case 0:
			flags = AlignLeft | AlignVCenter | SingleLine;
			break;
		  case 1:
			flags = AlignCenter | AlignVCenter | SingleLine;
			break;
		  case 2:
			flags = AlignRight | AlignVCenter | SingleLine;
			break;
		}
		if (clientHandler->useShadowedText()) {
			switch (Settings_Param.shadowtype) {
			  case 0:
				p.translate(-1, 1);
				break;
			  case 1:
				p.translate(0, -0.5);
				break;
			  case 2:
				p.translate(1, 1);
				break;
			}
			if (isActive())
				p.setPen(QColor(Settings_Param.ShadowColor));
			else
				p.setPen(QColor(Settings_Param.InShadowColor));
			#ifdef RIGHTRISTATE
        p.drawText( (clientHandler->tile( TitleLeft, isActive() )->width() + textSpacing), Settings_Param.CaptionAdjustement, width()-(clientHandler->tile( pixNumBtt, isActive() )->width()+clientHandler->tile( TitleLeft, isActive() )->width() + textSpacing), (clientHandler->tile( TitleCenter, isActive() )->height()- Settings_Param.CaptionAdjustement), flags, caption() );


#else
        p.drawText( (BttWidthOnLeft() + textSpacing), Settings_Param.CaptionAdjustement, width()-(BttWidthOnLeft()+BttWidthOnRight() + textSpacing), (clientHandler->tile( TitleCenter, isActive() )->height()- Settings_Param.CaptionAdjustement), flags, caption() );

			#endif

			switch (Settings_Param.shadowtype) {
			  case 0:
				p.translate(1, -1);
				break;
			  case 1:
				p.translate(1, 1);
				break;
			  case 2:
				p.translate(-1, -1);
				break;
			}
		}
		p.setPen(options()->color(ColorFont, isActive()));
		#ifdef RIGHTRISTATE
    p.drawText( (clientHandler->tile( TitleLeft, isActive() )->width() + textSpacing), Settings_Param.CaptionAdjustement, width()-(clientHandler->tile( pixNumBtt, isActive() )->width()+clientHandler->tile( TitleLeft, isActive() )->width() + textSpacing), (clientHandler->tile( TitleCenter, isActive() )->height()- Settings_Param.CaptionAdjustement), flags, caption() );

#else
    p.drawText( (BttWidthOnLeft() + textSpacing), Settings_Param.CaptionAdjustement, width()-(BttWidthOnLeft()+BttWidthOnRight() + textSpacing), (clientHandler->tile( TitleCenter, isActive() )->height()- Settings_Param.CaptionAdjustement), flags, caption() );

		#endif

		captionBufferDirty = false;
	}

	inline void HumanblueClient::drawTitlebar(QPainter &p, QRect &updateRect) {
		//qDebug("drawTitleBar()");
		int	titleBaseY		= 0;
		int	titleBarHeight	= clientHandler->titleBarHeight();
		p.save();
		// Top left corner
		if (updateRect.y() < titleBarHeight) {
			if (updateRect.x() < clientHandler->tile(TitleLeft, isActive())->width())
				p.drawPixmap(0, titleBaseY, *clientHandler->tile(TitleLeft, isActive()));
		}
		p.restore();
		p.save();
		//center pixmap
		#ifdef RIGHTRISTATE

		p.drawTiledPixmap(clientHandler->tile(TitleLeft, isActive())->width(), titleBaseY,
						  width() -
						  (clientHandler->tile(pixNumBtt, isActive())->width() +
						   clientHandler->tile(TitleLeft,
											   isActive())->width()),
						  clientHandler->tile(TitleCenter, isActive())->height(),
						  *clientHandler->tile(TitleCenter, isActive()));

		#else

		#ifdef LARGEPAINTCENTER

		p.drawPixmap(clientHandler->tile(TitleLeft, isActive())->width(), titleBaseY,
					 clientHandler->iTile(isActive(),
										  width() -
										  (clientHandler->tile(TitleLeft, isActive())->width() +
										   clientHandler->tile(TitleRight,
															   isActive())->width()),
										  clientHandler->tile(TitleCenter, isActive())->height()));
		#else

		p.drawTiledPixmap(clientHandler->tile(TitleLeft, isActive())->width(), titleBaseY,
						  width() -
						  (clientHandler->tile(TitleRight, isActive())->width() +
						   clientHandler->tile(TitleLeft,
											   isActive())->width()),
						  clientHandler->tile(TitleCenter, isActive())->height(),
						  *clientHandler->tile(TitleCenter, isActive()));
		#endif

		#endif
		// Top right corner
		p.restore();
		p.save();
		#ifdef RIGHTRISTATE

		if (updateRect.right() >= width() - clientHandler->tile(pixNumBtt, isActive())->width())
			p.drawPixmap(width() - clientHandler->tile(pixNumBtt, isActive())->width(), titleBaseY,
						 *clientHandler->tile(pixNumBtt, isActive()));


		#else

		if (updateRect.right() >= width() - clientHandler->tile(TitleRight, isActive())->width())
			p.drawPixmap(width() - clientHandler->tile(TitleRight, isActive())->width(), titleBaseY,
						 *clientHandler->tile(TitleRight, isActive()));
		#endif

		p.restore();
	}

	inline void HumanblueClient::drawFrame(QPainter &p, QRect &updateRect, QPaintEvent *e) {
		//qDebug("drawFrame()");
		int	titleBarHeight		= clientHandler->titleBarHeight();
		int	grabBarHeight		= clientHandler->grabBarHeight();
		int	leftBorderWidth		= clientHandler->tile(BorderLeft, isActive())->width();
		int	rightBorderWidth	= clientHandler->tile(BorderRight, isActive())->width();
		p.save();
		if (updateRect.bottom() >= titleBarHeight && updateRect.top() < height() - grabBarHeight) {
			// Left border
			if (updateRect.x() < leftBorderWidth)
				p.drawTiledPixmap(0, clientHandler->tile(TitleLeft, isActive())->height(),
								  leftBorderWidth,
								  height() - clientHandler->tile(GrabBarLeft, isActive())->height(),
								  *clientHandler->tile(BorderLeft, isActive()));
			p.restore();
			p.save();
			// Right border
			#ifdef RIGHTRISTATE

			if (e->rect().right() > width() - rightBorderWidth - 1)
				p.drawTiledPixmap(width() -
								  rightBorderWidth,
								  clientHandler->tile(pixNumBtt, isActive())->height(),
								  clientHandler->tile(BorderRight, isActive())->width(),
								  height() -
								  clientHandler->tile(GrabBarRight, isActive())->height(),
								  *clientHandler->tile(BorderRight, isActive()));
			#else

			if (e->rect().right() > width() - rightBorderWidth - 1)
				p.drawTiledPixmap(width() -
								  rightBorderWidth,
								  clientHandler->tile(TitleRight, isActive())->height(),
								  clientHandler->tile(BorderRight, isActive())->width(),
								  height() -
								  clientHandler->tile(GrabBarRight, isActive())->height(),
								  *clientHandler->tile(BorderRight, isActive()));
			#endif

			p.restore();
		}

		// Bottom grab bar
		// -----------------------------------------------------------------------
		p.save();
		if (updateRect.bottom() >= height() - grabBarHeight) {
			// Bottom left corner
			if (updateRect.x() < clientHandler->tile(GrabBarLeft, isActive())->width())
				p.drawPixmap(0, height() - grabBarHeight,
							 *clientHandler->tile(GrabBarLeft, isActive()));
			p.restore();
			p.save();
			// Space between the left corner and the right corner
			if (updateRect.x() < width() - clientHandler->tile(GrabBarCenter, isActive())->width())
				p.drawTiledPixmap(clientHandler->tile(GrabBarLeft, isActive())->width(),
								  height() -
								  grabBarHeight,
								  width() -
								  (clientHandler->tile(GrabBarLeft, isActive())->width() +
								   clientHandler->tile(GrabBarRight,
													   isActive())->width()),
								  grabBarHeight, *clientHandler->tile(GrabBarCenter, isActive()));
			p.restore();
			p.save();
			// Bottom right corner
			if (updateRect.right() >
				width() -
				clientHandler->tile(GrabBarRight, isActive())->width())
				p.drawPixmap(width() - clientHandler->tile(GrabBarRight, isActive())->width(),
							 height() - grabBarHeight,
							 *clientHandler->tile(GrabBarRight, isActive()));
			p.restore();
		}
	}

	#ifdef RIGHTRISTATE

	inline int HumanblueClient::ButtonsOnLeft() {
		Settings_Param.numbuttons = 2;
		QString	s	= options()->titleButtonsRight();
		for (register uint x = 0; x < options()->titleButtonsRight().length(); x++) {
			if (s[x].latin1() == 'I' && isMinimizable())
				Settings_Param.numbuttons++;
			else if (s[x].latin1() == 'A' && isMaximizable())
				Settings_Param.numbuttons++;
			else if (s[x].latin1() == 'X' && isCloseable())
				Settings_Param.numbuttons++;
		}
		return Settings_Param.numbuttons;
	}
	#endif

	#ifndef RIGHTRISTATE
	inline int HumanblueClient::BttWidthOnLeft() {
		Settings_Param.LeftWidth = 1;
		QString	s	= options()->titleButtonsLeft();
		for (register uint x = 0; x < options()->titleButtonsLeft().length(); x++) {
			#ifdef ALLOWDISBTT
			if (s[x].latin1() == 'I' && isMinimizable())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(MinButton, isActive(), false)->width() /
											3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'A' && isMaximizable())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(MaxButton, isActive(), false)->width() /
											3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'X' && isCloseable())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(CloseButton, isActive(), false)->width() /
											3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'H' && providesContextHelp())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(HelpButton, isActive(), false)->width() /
											3) +
										   buttonSpacing;
			#ifndef CUSTOMBUTTONS

			else if (s[x].latin1() == 'M')
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(MenuButton, isActive(), false)->width() /
											3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'S')
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(OnAllDesktopsButton, isActive(),
																 false)->width() / 3) +
										   buttonSpacing;
			#endif

			else if (s[x].latin1() == '_')
				Settings_Param.LeftWidth = Settings_Param.LeftWidth + buttonSpacing;
			#else

			if (s[x].latin1() == 'I' && isMinimizable())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(MinButton, isActive())->width() / 3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'A' && isMaximizable())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(MaxButton, isActive())->width() / 3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'X' && isCloseable())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(CloseButton, isActive())->width() /
											3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'H' && providesContextHelp())
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(HelpButton, isActive())->width() /
											3) +
										   buttonSpacing;
			#ifndef CUSTOMBUTTONS

			else if (s[x].latin1() == 'M')
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(MenuButton, isActive())->width() /
											3) +
										   buttonSpacing;
			else if (s[x].latin1() == 'S')
				Settings_Param.LeftWidth = Settings_Param.LeftWidth +
										   (clientHandler->btile(OnAllDesktopsButton, isActive())->width() /
											3) +
										   buttonSpacing;
			#endif

			else if (s[x].latin1() == '_')
				Settings_Param.LeftWidth = Settings_Param.LeftWidth + buttonSpacing;
			#endif

			else
				Settings_Param.LeftWidth = 0;
		}
		if (clientHandler->tile(TitleLeft, isActive())->width() > Settings_Param.LeftWidth)
			return clientHandler->tile(TitleLeft, isActive())->width();
		else
			return Settings_Param.LeftWidth + clientHandler->tile(TitleLeft, isActive())->width();
	}

	inline int HumanblueClient::BttWidthOnRight() {
		Settings_Param.RightWidth = 1;
		QString	s	= options()->titleButtonsRight();
		for (register uint x = 0; x < options()->titleButtonsRight().length(); x++) {
			#ifdef ALLOWDISBTT
			if (s[x].latin1() == 'I' && isMinimizable())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(MinButton, isActive(), false)->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'A' && isMaximizable())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(MaxButton, isActive(), false)->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'X' && isCloseable())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(CloseButton, isActive(), false)->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'H' && providesContextHelp())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(HelpButton, isActive(), false)->width() /
											 3) +
											buttonSpacing;
			#ifndef CUSTOMBUTTONS

			else if (s[x].latin1() == 'M')
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(MenuButton, isActive(), false)->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'S')
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(OnAllDesktopsButton, isActive(),
																  false)->width() / 3) +
											buttonSpacing;
			#endif

			else if (s[x].latin1() == '_')
				Settings_Param.RightWidth = Settings_Param.RightWidth + buttonSpacing;
			#else

			if (s[x].latin1() == 'I' && isMinimizable())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(MinButton, isActive())->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'A' && isMaximizable())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(MaxButton, isActive())->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'X' && isCloseable())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(CloseButton, isActive())->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'H' && providesContextHelp())
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(HelpButton, isActive())->width() /
											 3) +
											buttonSpacing;
			#ifndef CUSTOMBUTTONS

			else if (s[x].latin1() == 'M')
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(MenuButton, isActive())->width() /
											 3) +
											buttonSpacing;
			else if (s[x].latin1() == 'S')
				Settings_Param.RightWidth = Settings_Param.RightWidth +
											(clientHandler->btile(OnAllDesktopsButton, isActive())->width() /
											 3) +
											buttonSpacing;
			#endif

			else if (s[x].latin1() == '_')
				Settings_Param.RightWidth = Settings_Param.RightWidth + buttonSpacing;
			#endif

			else
				Settings_Param.RightWidth = 0;
		}
		#ifdef RIGHTRISTATE
		if (clientHandler->tile(pixNumBtt, isActive())->width() > Settings_Param.RightWidth)
			return clientHandler->tile(pixNumBtt, isActive())->width();
		else
			return Settings_Param.RightWidth + clientHandler->tile(pixNumBtt, isActive())->width();
		#else      
		if (clientHandler->tile(TitleRight, isActive())->width() > Settings_Param.RightWidth)
			return clientHandler->tile(TitleRight, isActive())->width();
		else
			return Settings_Param.RightWidth + clientHandler->tile(TitleRight, isActive())->width();
		#endif  	
	}
	#endif

	void HumanblueClient::activeChange() {
		//qDebug("activeChange()");
		maskDirty = true;
		captionBufferDirty = true;
		iconBufferDirty = true;
		widget()->update();
		#ifdef AVATARENABLED

		btt->update();
		#endif

		for (register int i = 0; i < NumButtons; i++)
			if (button[i])
				button[i]->update();
	}

	void HumanblueClient::maximizeChange() {
		//qDebug("maximizeChange()");
		captionBufferDirty = true;
		iconBufferDirty = true;
		if (button[MaxButton]) {
			QToolTip::remove(button[MaxButton]);
			QToolTip::add(button[MaxButton],
						  maximizeMode() == MaximizeFull ? i18n("Restore") : i18n("Maximize"));
			button[MaxButton]->update();
		}
		widget()->update();
		#ifdef AVATARENABLED

		btt->update();
		#endif
	}

	void HumanblueClient::desktopChange() {
		//qDebug("desktopChange()");
		#ifndef CUSTOMBUTTONS
		if (button[OnAllDesktopsButton]) {
			QToolTip::remove(button[OnAllDesktopsButton]);
			QToolTip::add(button[OnAllDesktopsButton],
						  isOnAllDesktops() ? i18n("Not On All Desktops") : i18n("On All Desktops"));
		}
		#endif
	}

	void HumanblueClient::menuButtonPressed() {
		#ifndef CUSTOMBUTTONS
		QPoint				menuPoint	(button[MenuButton]->rect().bottomLeft().x() - 6,
										 button[MenuButton]->rect().bottomLeft().y() + 3);
		KDecorationFactory *f			= factory();
		showWindowMenu(button[MenuButton]->mapToGlobal(menuPoint));
		if (!f->exists(this)) // 'this' was destroyed
			return;
		button[MenuButton]->setDown(false);
		#endif
	}

	void HumanblueClient::slotMaximize() {
		//qDebug("slotMaximize()");
		switch (button[MaxButton]->lastButton()) {
		  case MidButton:
			maximize(maximizeMode() ^ MaximizeVertical);
			break;

		  case RightButton:
			maximize(maximizeMode() ^ MaximizeHorizontal);
			break;

		  case LeftButton:
			maximize(maximizeMode() == MaximizeFull ? MaximizeRestore : MaximizeFull);
			break;
		}
	}

	#ifdef AVATARENABLED

	void HumanblueClient::AvatarAction() {
		if (isPreview())
			return;
		else {
			KProcess   *proc	= new KProcess();
			if (Avatar_Params.avatarfunctype == "Konqueror") {
				*proc << "konqueror";
				*proc << "--profile" << "webbrowsing" << Avatar_Params.avatarfuncURL;
			} else if (Avatar_Params.avatarfunctype == "Kontact")
				*proc << "kontact";
			else if (Avatar_Params.avatarfunctype == "Kopete")
				*proc << "kopete";
			else if (Avatar_Params.avatarfunctype == "Kaffeine")
				*proc << "kaffeine";
			else if (Avatar_Params.avatarfunctype == "AmaroK")
				*proc << "amarok";
			else if (Avatar_Params.avatarfunctype == "KControl")
				*proc << "kcontrol";
			else if (Avatar_Params.avatarfunctype == "Juk")
				*proc << "juk";
			else
				return;
			proc->start();
		}
	}
	#endif

	inline void HumanblueClient::paintEvent(QPaintEvent *e) {
		//qDebug("painEvent()");
		if (!humanblue_initialized)
			return;

		QPainter	p			(widget());
		QRect		updateRect	(e->rect());
		if (maskDirty)
			updateMask();

		drawFrame(p, updateRect, e);
		drawTitlebar(p, updateRect);
		drawAppIcon(p);
		drawCaptionText(p);
	}

	void HumanblueClient::resizeEvent(QResizeEvent *e) {
		//qDebug("resizeEvent()");
		// FRAME	Client::resizeEvent( e );
		//QRect r( captionRect );
		//if ( r.size() != captionRect.size() )
		maskDirty = true;
		captionBufferDirty = true;
		iconBufferDirty = true;
		if (widget()->isVisible()) {
			widget()->update(widget()->rect());
			register int dx = 0;
			register int dy = 0;

			if (e->oldSize().width() != width())
				dx = 32 + QABS(e->oldSize().width() - width());

			if (e->oldSize().height() != height())
				dy = 8 + QABS(e->oldSize().height() - height());

			if (dy)
				widget()->update(0, height() - dy + 1, width(), dy);

			if (dx) {
				widget()->update(width() - dx + 1, 0, dx, height());
				widget()->update(QRect(QPoint(4, 4),
									   titlebar->geometry().bottomLeft() - QPoint(1, 0)));
				widget()->update(QRect(titlebar->geometry().topRight(),
									   QPoint(width() - 4, titlebar->geometry().bottom())));
				#ifdef AVATARENABLED

				btt->update();
				#endif
				// Titlebar needs no paint event
				QApplication::postEvent(this, new QPaintEvent(titlebar->geometry(), FALSE));
			}
		}
	}


	void HumanblueClient::mouseDoubleClickEvent(QMouseEvent *e) {
		if (QRect(0, 0, width(), clientHandler->titleBarHeight()).contains(e->pos()))
			titlebarDblClickOperation();
	}

	void HumanblueClient::wheelEvent(QWheelEvent *e) {
		if (QRect(0, 0, width(), clientHandler->titleBarHeight()).contains(e->pos()))
			titlebarMouseWheelOperation( e->delta());
	}

	HumanblueClient::Position HumanblueClient::mousePosition(const QPoint &p) const {
		register int titleBaseY = 0;//(largeTitlebar ? 3 : 0);
		register int leftBorder = clientHandler->tile(BorderLeft, true)->width();
		register int rightBorder = width() - clientHandler->tile(BorderRight, true)->width() - 1;
		register int bottomBorder = height() - clientHandler->grabBarHeight() - 1;
		register int bottomCornerSize = 3 * clientHandler->tile(BorderRight, true)->width() /
										2 +
										24;

		// Test if the mouse is over the titlebar area
		if (p.y() < titleBaseY + 11) {
			// Test for the top left corner
			if (p.x() < leftBorder + 11) {
				if ((p.y() < titleBaseY + 3 && p.x() < leftBorder + 11) ||
					(p.y() < titleBaseY + 6 && p.x() < leftBorder + 6) ||
					(p.y() < titleBaseY + 11 && p.x() < leftBorder + 3))
					return PositionTopLeft;
			}

			// Test for the top right corner
			if (p.x() > rightBorder - 11) {
				if ((p.y() < titleBaseY + 3 && p.x() > rightBorder - 11) ||
					(p.y() < titleBaseY + 6 && p.x() > rightBorder - 6) ||
					(p.y() < titleBaseY + 11 && p.x() > rightBorder - 3))
					return PositionTopRight;
			}

			// Test for the top border
			if (p.y() <= 3 || (p.y() <= titleBaseY + 3))
				return PositionTop;

			// The cursor must be over the center of the titlebar.
			return PositionCenter;
		}

		// Test the sides
		else if (p.y() < bottomBorder) {
			// Test for the left side
			if (p.x() < leftBorder) {
				if (p.y() < height() - bottomCornerSize)
					return PositionLeft;
				else
					return PositionBottomLeft;
			}

			// Test for the right side
			else if (p.x() > rightBorder) {
				if (p.y() < height() - bottomCornerSize)
					return PositionRight;
				else
					return PositionBottomRight;
			}

			// The cursor must be over the center of the window
			return PositionCenter;
		}

		// Test the grab bar / bottom border
		else {
			// Test for the bottom left corner
			if (p.x() < bottomCornerSize)
				return PositionBottomLeft;

			// Test for the bottom right corner
			else if (p.x() > width() - bottomCornerSize - 1)
				return PositionBottomRight;

			// The cursor must be over the bottom border
			return PositionBottom;
		}

		// We should never get here
		return PositionCenter;
	}


	void HumanblueClient::resize(const QSize &s) {
		widget()->resize(s);
	}


	void HumanblueClient::borders(register int &left, register int &right, register int &top,
								 register int &bottom) const {
		register int titleBarHeight = clientHandler->titleBarHeight();
		register int grabBarHeight = clientHandler->grabBarHeight();
		register int leftBorderWidth = clientHandler->tile(BorderLeft, isActive())->width();
		register int rightBorderWidth = clientHandler->tile(BorderRight, isActive())->width();

		left = leftBorderWidth;
		right = rightBorderWidth;
		top = titleBarHeight;
		bottom = grabBarHeight;

		if ((maximizeMode() & MaximizeHorizontal) && !options()->moveResizeMaximizedWindows())
			left = right = 0;
		if (maximizeMode() & MaximizeVertical) {
			top = clientHandler->titleBarHeight();
			if (!options()->moveResizeMaximizedWindows())
				bottom = 0;
		}
	}


	QSize HumanblueClient::minimumSize() const {
		return widget()->minimumSize();
	}


	bool HumanblueClient::eventFilter(QObject *o, QEvent *e) {
		if (o != widget())
			return false;

		switch (e->type()) {
		  case QEvent::Resize:
			resizeEvent(static_cast<QResizeEvent*>(e));
			return true;

		  case QEvent::Paint:
			paintEvent(static_cast<QPaintEvent*>(e));
			return true;

		  case QEvent::MouseButtonDblClick:
			mouseDoubleClickEvent(static_cast<QMouseEvent*>(e));
			return true;

		  case QEvent::Wheel:
			wheelEvent( static_cast< QWheelEvent* >( e ));
			return true;

		  case QEvent::MouseButtonPress:
			processMousePressEvent(static_cast<QMouseEvent*>(e));
			return true;

		  default:
			return false;
		}
	}
} // namespace Humanblue
// -------------------------------------------------------------------------------------------

extern "C" {
	KDecorationFactory * create_factory() {
		Humanblue::clientHandler = new Humanblue::HumanblueHandler();
		return Humanblue::clientHandler;
	}
}
// vim: ts=4 sw=4 noet
// kate: indent-width 4; replace-tabs off; tab-width 4; space-indent off;

