#ifndef AUtils_H
#define AUtils_H

/*
 *
 * AUtils.H --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include <nucleo/core/TimeKeeper.H>
#include <nucleo/gl/scenegraph/sgNode.H>
#include <nucleo/gl/scenegraph/sgViewpoint.H>

#ifdef HAVE_GLFT
#include <glft/FontManager.hpp>
#endif

#include <X11/Xlib.h>

#include "desktop/MetisseWindow.H"
#include "desktop/MetisseSource.H"

using namespace nucleo ;

// ---------------------------------------------------------------------------

class DefaultSettings : public sgNode {
protected:
  void display(dlPolicy policy) ;
public:
  DefaultSettings(void) ;
} ;


// ---------------------------------------------------------------------------

class ACursor : public sgNode {
private:
  GLfloat _x, _y, _size;
  GLfloat _xhot, _yhot, _width, _height;
  GLdouble _zRot;
  GLfloat _a,_r,_g,_b;
  rfbXCursorColors _colors;
  unsigned char *_Xbuf;
  CARD32 *_ARGBbuf;
  int _internal;
  GLUquadricObj *_qobj;
protected:
  void display(dlPolicy policy) ;
public:
  ACursor(std::string name, GLfloat size, double zRot, int num = 0) ;
  void updatePosition(GLfloat x, GLfloat y) ;
  void handleXCursor(
	  int xhot, int yhot, int width, int height, char *buf,
	  rfbXCursorColors colors);
  void handleARGBCursor(
	  CARD32 xhot, CARD32 yhot, CARD32 width, CARD32 height,
	  XcursorPixel *buf);
  void handleInternalCursor(
	  CARD32 xhot, CARD32 yhot, CARD32 width, CARD32 height);
} ;

// ---------------------------------------------------------------------------

class AXorDraw : public sgNode {

public:

struct point
{
  float x,y;
  float w;
  unsigned int flags;
  point(float a, float b, float c, unsigned int d) :
    x(a), y(b), w(c), flags(d) {}
  point(void) { point(0.0,0.0,0.0,0); }
};

private:
  std::list<AXorDraw::point > _points;

protected:
  void display(dlPolicy policy);

public:
  AXorDraw(std::string name, int *points, int num, int loop = 0);
  AXorDraw(std::string name, float x, float y);
  //~AXorDraw();

  void clear(void);
  void add(float x, float y);
} ;

// ---------------------------------------------------------------------------

class DropWindow : public sgNode {
private:
  GLfloat _x, _y;
  GLfloat _xhot, _yhot, _width, _height;

protected:
  void display(dlPolicy policy) ;

public:
  DropWindow(std::string name, WinRegions::region *r, GLdouble cx, GLdouble cy);
  void updatePosition(GLfloat x, GLfloat y) ;
} ;

// ---------------------------------------------------------------------------

#define AUTILS_MAX_BUTTONS 8

class VMouse : public sgNode, public ReactiveObject
{
private:
  GLfloat _x, _y;
  GLfloat _width, _height;
  TimeKeeper *_tk[AUTILS_MAX_BUTTONS];
  bool _buttons[AUTILS_MAX_BUTTONS];

protected:
  void react(Observable *obs);
  void display(dlPolicy policy);

public:
  void updateState(int button, bool on);
  bool checkClick(float x, float y);
  void move(int dx, int dy);
  VMouse(std::string name, GLdouble x, GLdouble y, GLdouble w, GLdouble h);
  ~VMouse(void);
};

// ---------------------------------------------------------------------------

class PerfMeter : public sgNode {
private:
  Chronometer _chrono ;
protected:
  void display(dlPolicy policy) ;
public:
  PerfMeter(void) : sgNode("PerfMeter",0) {
  }
  void restart(void) {
    _chrono.start() ;
  }
} ;

// ---------------------------------------------------------------------------

void
unproject(int x, int y,
	  sgViewpoint *viewpoint, GLuint *selectionBuffer, int selectionBufferSize,
	  GLdouble *ox, GLdouble *oy, GLdouble *oz) ;

void
unproject(int x, int y, float z, sgViewpoint *viewpoint, GLuint *selectionBuffer,
	  int selectionBufferSize,
	  GLdouble *ox, GLdouble *oy, GLdouble *oz);

int wc2scX(GLfloat x, GLfloat hw, GLfloat rx);
int wc2scY(GLfloat y, GLfloat hh, GLfloat ry);

// ---------------------------------------------------------------------------

#if 0
void *get_property(
	Display *disp, Window win, Atom atom, Atom type, unsigned int *size);
#endif

#endif
