/*
 *
 * main/AUtils.cxx --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "config.h"

// FIXME
#include <sstream>
#include <string>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/Xproto.h>

#include "AUtils.H"

#define DEBUG_LEVEL 0

// --------------------------------------------------------------------

void
DefaultSettings::display(dlPolicy policy)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT) ;
}

DefaultSettings::DefaultSettings(void) : sgNode("DefaultSettings")
{
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);

	//glDisable(GL_LIGHTING);
	//glShadeModel(GL_FLAT);

#if 0
	glEnable(GL_POINT_SMOOTH) ;
	glHint(GL_POINT_SMOOTH_HINT,GL_NICEST) ;
#endif

#if 0
	glEnable(GL_LINE_SMOOTH) ;
	glHint(GL_LINE_SMOOTH_HINT,GL_NICEST) ;
#endif

#if 0
	// unfortunately this cause rendering of the triangle polygone
	glEnable(GL_POLYGON_SMOOTH) ;
	glHint(GL_POLYGON_SMOOTH_HINT,GL_NICEST) ;
#endif

	glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST) ;
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	//glEnable(GL_DITHER);
	//glDisable(GL_DITHER);
}

// --------------------------------------------------------------------

ACursor::ACursor(
	std::string name, GLfloat size, double zRot, int num) : sgNode(name) {
  _x = _y = 0.0 ;
  _size = size ;
  _ARGBbuf = 0;
  _Xbuf = 0;
  _internal = 0;
  _r = _g = _b = 0;
  _internal = num;
  switch (num)
  {
  case 1:
	  _r = 1;
	  break;
  case 2:
	  _b = 1;
	  break;
  case 3:
	  _g = 1;
	  break;
  default:
	  _r = 1;
  }
  _a = .70;
  _qobj = 0;
  _width = _height = 0;
  _xhot = _yhot = 0;
  _zRot = zRot;
}

void
ACursor::display(dlPolicy policy) {
	
	glDisable(GL_DEPTH_TEST) ;

	glPushMatrix();
	glTranslatef(_x,_y,-0.01);

	//glPushMatrix();
	glRotated(-_zRot, 0,0, _zRot);
	//glPopMatrix();

	glColor4f(1,1,1,1);
  
	if (_ARGBbuf)
	{
		glBegin(GL_POINTS);
		unsigned char *data = (unsigned char *)_ARGBbuf;
		int k = 0;
		for(GLfloat i = 0; i < _height; i++)
		{
			for(GLfloat j = 0; j < _width; j++, k = k + 4)
			{
				// in fact we have "premultiplied" BGRA
				GLfloat f = (GLfloat)data[k+3]/255.0;
				f = (f==0)? 0:1/f;
				glColor4f(
					((GLfloat)data[k+2]*f/255.0), 
					((GLfloat)data[k+1]*f/255.0),
					((GLfloat)data[k]*f/255.0),
					(GLfloat)data[k+3]/255.0);
				GLfloat u = j - _xhot;
				GLfloat v = -i + _yhot;
				glVertex2f(u,v);
			}
		}
		glEnd();
	}
	else if (_Xbuf)
	{
		int bytesPerRow = ((int)_width + 7) / 8;
		int bytesData = bytesPerRow * (int)_height;
	  
		int k = 0, l = 0, m = 0;
		glBegin(GL_POINTS);
		for(GLfloat i = 0; i < _height; i++, k = k + bytesPerRow)
		{
			l = 0;
			m = k;
			for(GLfloat j = 0; j < _width; j++)
			{
				glColor4ub(
					(_Xbuf[m] & (1 << l))? 
					_colors.foreRed: _colors.backRed,
					(_Xbuf[m] & (1 << l))?
					_colors.foreGreen: _colors.backGreen,
					(_Xbuf[m] & (1 << l))?
					_colors.foreBlue: _colors.backBlue,
					(_Xbuf[bytesData+m] & (1 << l))? 255:0);
				GLfloat u = j - _xhot;
				GLfloat v = -i + _yhot;
				glVertex2f(u,v);
				l++;
				if (l>7)
				{
					l = 0;
					m++;
				}
			}
		}
		glEnd();
	}
	else if (_internal > 0 && _qobj)
	{
		gluQuadricDrawStyle(_qobj, GLU_FILL);
		glColor4f(1,1,1,_a);
		gluDisk(_qobj, _width/4, _width/4+1, 25, (int)(1));
		glColor4f(_r,_g,_b,_a);
		gluDisk(_qobj, 1+(_width/4), (_width/2), 40, (int)(1));
		glColor4f(1,1,1,_a);
		gluDisk(_qobj, (_width/2), 1+(_width/2), 40, (int)(1));		
	}
	else
	{
		// draw nothing
	}

	glPopMatrix();
	glEnable(GL_DEPTH_TEST) ;
}

void
ACursor::updatePosition(GLfloat x, GLfloat y)
{
  // std::cerr << "ACursor::updatePosition: " << x << "," << y << std::endl ;
	_x = x ;
	_y = y ;
	
	postRedisplay() ;
}

void ACursor::handleXCursor(
	int xhot, int yhot, int width, int height, char *buf,
	rfbXCursorColors colors)
{
	if (_ARGBbuf)
	{
		free(_ARGBbuf);
		_ARGBbuf = 0;
	}
	if (_Xbuf)
	{
		free(_Xbuf);
		_Xbuf = 0;
	}
	_internal = 0;
	_xhot = xhot;
	_yhot = yhot;
	_width = width;
	_height = height;
	_colors = colors;
	_Xbuf = (unsigned char *)buf;
	postRedisplay();
}

void ACursor::handleARGBCursor(
	CARD32 xhot, CARD32 yhot, CARD32 width, CARD32 height, XcursorPixel *buf)
{
	if (_ARGBbuf)
	{
		free(_ARGBbuf);
		_ARGBbuf = 0;
	}
	if (_Xbuf)
	{
		free(_Xbuf);
		_Xbuf = 0;
	}
	_internal = 0;
	_xhot = xhot;
	_yhot = yhot;
	_width = width;
	_height = height;
	_ARGBbuf = (CARD32 *)buf;
	postRedisplay() ;
}


void ACursor::handleInternalCursor(
	CARD32 xhot, CARD32 yhot, CARD32 width, CARD32 height)
{
	if (_ARGBbuf)
	{
		free(_ARGBbuf);
		_ARGBbuf = 0;
	}
	if (_Xbuf)
	{
		free(_Xbuf);
		_Xbuf = 0;
	}
	if (_qobj == 0)
	{
		_qobj = gluNewQuadric();
		gluQuadricDrawStyle(_qobj, GLU_SILHOUETTE);
		gluQuadricNormals(_qobj, GLU_NONE);
	}
	_xhot = xhot;
	_yhot = yhot;
	_width = width;
	_height = height;
	postRedisplay() ;
}

// --------------------------------------------------------------------

AXorDraw::AXorDraw(std::string name, int *p, int num, int loop) : sgNode(name)
{
	clear();
	for(int i = 0; i < num-1; i = i+2)
	{
		_points.push_front(point(p[i],p[i+1], 0, 0));
	}
}

AXorDraw::AXorDraw(std::string name, float x, float y): sgNode(name)
{
	clear();
	_points.push_front(point(x,y, 0, 0));
}

#if 0
AXorDraw::~AXorDraw()
{
	_points.clear();
}
#endif

void AXorDraw::display(dlPolicy policy)
{	
	int size = _points.size();
	if (size < 2)
	{
		return;
	}
	glDisable(GL_DEPTH_TEST) ;

	glTranslatef(0,0,-0.1);

	std::list<AXorDraw::point >::iterator i;
	std::list<AXorDraw::point >::iterator j;

	glBegin(GL_LINES);

	int s = 0;
	for (i=_points.begin(); s < size - 1; i++)
	{
		j = i;
		j++;
		glColor4f(0,0,0,1);
		glVertex2d((*i).x-1,(*i).y-1); glVertex2d((*j).x-1,(*j).y-1);
		glVertex2d((*i).x+1,(*i).y); glVertex2d((*j).x+1,(*j).y+1);
		glColor4f(1,1,1,1);
		glVertex2d((*i).x,(*i).y); glVertex2d((*j).x,(*j).y);
		s = s+1;
	}
	glEnd() ;

	glEnable(GL_DEPTH_TEST);
}

void AXorDraw::clear(void)
{
	_points.clear();
}

void AXorDraw::add(float x, float y)
{
	_points.push_front(point(x,y,0,0));
	postRedisplay();
}

// --------------------------------------------------------------------

DropWindow::DropWindow(std::string name, WinRegions::region *r,
		       GLdouble cx, GLdouble cy) : sgNode(name)
{
	_x = _y = 0.0 ;
	_width = r->w;
	_height = r->h;
	_xhot = _yhot = 0;
}

void
DropWindow::display(dlPolicy policy)
{	
	glDisable(GL_DEPTH_TEST) ;

	glTranslatef(_x,_y,-0.01);
	glColor4f(0.5,0.5,0.5,0.5);
	glRectf(-_width/2, _height/2, _width/2, -_height/2);

	glColor4f(1,1,1, 1) ;
	glBegin(GL_LINE_LOOP);
	glVertex2d(-_width/2, _height/2);
	glVertex2d(_width/2,  _height/2);
	glVertex2d(_width/2,  -_height/2);
	glVertex2d(-_width/2, -_height/2);
	glEnd() ;
	glEnable(GL_DEPTH_TEST) ;
}

void
DropWindow::updatePosition(GLfloat x, GLfloat y)
{
	_x = x ;
	_y = y ;
	
	postRedisplay() ;
}

// --------------------------------------------------------------------
void
VMouse::display(dlPolicy policy)
{	
	glDisable(GL_DEPTH_TEST) ;

	glTranslatef(_x,_y,-0.01);
	glColor4f(0.5,0.5,0.5,0.5);

	glRectf(-_width/2, _height/2, _width/2, -_height/2);

	glColor4f(1,1,1, 1) ;
	glBegin(GL_LINE_LOOP);
	glVertex2d(-_width/2, _height/2);
	glVertex2d(_width/2,  _height/2);
	glVertex2d(_width/2,  -_height/2);
	glVertex2d(-_width/2, -_height/2);
	glEnd() ;

	GLdouble w = _width/3;
	GLdouble h = _height/3;

	for (int i = 0; i < 3; i++)
	{
		glColor4f(1,1,1, 1) ;
		glBegin(GL_LINE_LOOP);
		glVertex2d(-_width/2 + (w*i),      _height/2);
		glVertex2d(-_width/2 + (w*(i+1)),  _height/2);
		glVertex2d(-_width/2 + (w*(i+1)),  (_height/2) - h);
		glVertex2d(-_width/2 + (w*i),      (_height/2) - h);
		glEnd();
		
		if (_buttons[i])
		{
			glColor4f(1,0,0, 0.7);
			glRectf(
				-_width/2 + (w*i), _height/2, -_width/2 + (w*(i+1)),
				(_height/2) - h);
		}
	}

	GLdouble ww = _width/10;
	GLdouble hw = _height/10;

	for (int i = 0; i < 2; i++)
	{
		glColor4f(1,1,1, 1) ;
		glBegin(GL_LINE_LOOP);
		glVertex2d(-ww, ((i==0)? 1:-1)*hw);
		glVertex2d(ww,  ((i==0)? 1:-1)*hw);
		glVertex2d(0,  0);

		glEnd();
		
		if (_buttons[3+i])
		{
			glColor4f(1,0,0, 0.7);
			glBegin(GL_POLYGON);
			glVertex2d(-ww, ((i==0)? 1:-1)*hw);
			glVertex2d(ww,  ((i==0)? 1:-1)*hw);
			glVertex2d(0,  0);
			glEnd();
		}
	}

	for (int i = 0; i < 2; i++)
	{
		glColor4f(1,1,1, 1) ;
		glBegin(GL_LINE_LOOP);
		glVertex2d(((i==0)? 1:-1)*ww, hw);
		glVertex2d(((i==0)? 1:-1)*ww, -hw);
		glVertex2d(0,  0);
		glEnd();
		
		if (_buttons[5+i])
		{
			glColor4f(1,0,0, 0.7);
			glBegin(GL_POLYGON);
			glVertex2d(((i==0)? 1:-1)*ww, hw);
			glVertex2d(((i==0)? 1:-1)*ww, -hw);
			glVertex2d(0,  0);
			glEnd();
		}
	}
	glEnable(GL_DEPTH_TEST) ;
}
void VMouse::react(Observable *obs)
{
	for(int i = 0; i < AUTILS_MAX_BUTTONS; i++)
	{
		if (obs == _tk[i])
		{
			_buttons[i] = false;
			unsubscribeFrom(_tk[i]);
			postRedisplay();
		}
	}
}

bool VMouse::checkClick(float x, float y)
{
	if (x > _x-_width/2 && x < _x+_width/2 && y > _y-_width/2 && y < _y+_height/2)
	{
		return true;
	}
	return false;
}

void VMouse::move(int dx, int dy)
{
	_x = - dx + _x;
	_y = dy + _y;
	postRedisplay();
}

void VMouse::updateState(int button, bool on)
{
	button--;
	if (button < 0 || button > AUTILS_MAX_BUTTONS-1)
	{
		return;
	}
	//std::cerr << "updateState: " << button << " " << on << std::endl;
	if (on)
	{
		_buttons[button] = on;
	}
	else if (button < 3)
	{
		_buttons[button] = on;
	}
	else
	{
		if (_tk[button] == 0)
		{
			_tk[button] = TimeKeeper::create();
		}
		subscribeTo(_tk[button]);
		_tk[button]->arm(25);
	}
	postRedisplay();
}

VMouse::VMouse(
	std::string name, GLdouble x, GLdouble y, GLdouble w, GLdouble h) : sgNode(name)
{
	_x = x;
	_y = y;
	_width = w;
	_height = h;
	
	memset(&_buttons, 0, sizeof(_buttons));
	memset(&_tk, 0, sizeof(_tk));
}

VMouse::~VMouse(void)
{
	for(int i = 0; i < AUTILS_MAX_BUTTONS; i++)
	{
		if (_tk[i] != 0)
		{
			unsubscribeFrom(_tk[i]);
			delete _tk[i];
		}
	}
}

// --------------------------------------------------------------------
void
PerfMeter::display(dlPolicy policy) {
  _chrono.tick() ;

  if (_chrono.read() > 0 /*5000.0*/) {
    std::cerr << _chrono.average() 
		    << " fps (" << _chrono.read()/1000.0
		    << " seconds elapsed)" << std::endl;
    _chrono.start() ;
  }
}

// --------------------------------------------------------------------

void
unproject(int x, int y, sgViewpoint *viewpoint, GLuint *selectionBuffer,
	  int selectionBufferSize,
	  GLdouble *ox, GLdouble *oy, GLdouble *oz) {
  static int first_time = 1;
  static int hack = 1;
  GLfloat z = -10.0 ;

  GLint viewport[4] ;
  glGetIntegerv(GL_VIEWPORT, viewport) ;

  viewpoint->applyTransforms() ;

  GLdouble projmatrix[16] ;
  glGetDoublev(GL_PROJECTION_MATRIX, projmatrix) ;

  for (int i=0; i<selectionBufferSize; ++i) {
    sgNode *o = (sgNode *)selectionBuffer[i] ;
    
#if 0
    std::cerr << o->getName() << " < " << std::flush ;
#endif
    o->applyTransformations() ;
  }

#if 0
  std::cerr << std::endl ;
#endif

  GLdouble mvmatrix[16] ;
  glGetDoublev(GL_MODELVIEW_MATRIX, mvmatrix) ;

  glReadBuffer(GL_FRONT) ;
  //glReadBuffer(GL_BACK) ;
  glReadPixels(x,viewport[3]-y-1, 1,1, GL_DEPTH_COMPONENT,GL_FLOAT, (GLvoid *)&z) ;

  glReadBuffer(GL_BACK) ;

  GLint ret;
  /* FIXME: !! */
  if (first_time == 1)
  {
	  if (z > 0 && z <= 0.04)
	  {
		  hack = 256;
	  }
	  first_time = 0;
  }
  ret = gluUnProject(x,viewport[3]-y-1,z*hack, mvmatrix, projmatrix, viewport, ox, oy, oz) ;
#if 0
  GLint d;
  glGetIntegerv(GL_DEPTH_BITS, &d);
  std::cerr << "depth bits: " << d << std::endl ;
  std::cerr << " x=" << x << " y=" << y << " (" << viewport[3]-y-1 << ") z=" << z << std::endl ;
  std::cerr << " ox=" << *ox << " oy=" << *oy << " oz=" << *oz << " ("<< ret << ")" << std::endl ;
#endif
}

void
unproject(
	int x, int y, float z, sgViewpoint *viewpoint, GLuint *selectionBuffer,
	int selectionBufferSize, GLdouble *ox, GLdouble *oy, GLdouble *oz)
{

	GLint viewport[4] ;
	glGetIntegerv(GL_VIEWPORT, viewport) ;

	viewpoint->applyTransforms() ;

	GLdouble projmatrix[16] ;
	glGetDoublev(GL_PROJECTION_MATRIX, projmatrix) ;

	for (int i=0; i<selectionBufferSize; ++i) {
		sgNode *o = (sgNode *)selectionBuffer[i] ;
		o->applyTransformations() ;
	}

	GLdouble mvmatrix[16] ;
	glGetDoublev(GL_MODELVIEW_MATRIX, mvmatrix) ;

	glReadBuffer(GL_BACK) ;

	GLint ret;
	ret = gluUnProject(
		x,viewport[3]-y-1,z, mvmatrix, projmatrix, viewport, ox, oy, oz);
#if 0
	std::cerr << " x=" << x << " y=" << y << " (" << viewport[3]-y-1
		  << ") z=" << z << std::endl ;
	std::cerr << " ox=" << *ox << " oy=" << *oy << " oz=" << *oz
		  << " ("<< ret << ")" << std::endl ;
#endif
}

