/*
 *
 * renderer/WindowRenderer.cxx --
 *
 * Copyright (C) Nicolas Roussel
 * Copyright (C) Olivier Chapuis
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "config.h"

#include <math.h>

#include "fvwmmodule/AFvwm.H"
#include "goodies.H"
#include "FoldablePolygon.H"

void goodies_marcking_feedback(
	GLfloat x, GLfloat y, int dist, int draw_dist, int dirs, GLfloat alpha)
{
	glColor4f(1,1,1, 1);

	glBegin(GL_LINES);
	GLfloat md = draw_dist;
	GLfloat rd = dist;
	bool draw_rect = false;

	if (dirs & MULTI_DIR_W)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x - md, y); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x - md, y + 1);
		glVertex2d(x, y + 1);
		glVertex2d(x - md, y - 1);
		glVertex2d(x, y - 1);
		draw_rect = true;
	}
	if (dirs & MULTI_DIR_NW)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x - md, y + md); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x - md, y + md + 1);
		glVertex2d(x, y + 1);
		glVertex2d(x - md, y + md - 1);
		glVertex2d(x, y - 1);
		draw_rect = true;
	}
	if (dirs & MULTI_DIR_N)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x, y + md); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x-1, y + md); glVertex2d(x-1, y);
		glVertex2d(x+1, y + md); glVertex2d(x+1, y);
		draw_rect = true;
	}
	if (dirs & MULTI_DIR_NE)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x + md, y + md); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x + md, y + md - 1);
		glVertex2d(x, y - 1);
		glVertex2d(x + md, y + md + 1);
		glVertex2d(x, y + 1);
		draw_rect = true;
	}
	if (dirs & MULTI_DIR_E)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x + md, y); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x + md, y + 1);
		glVertex2d(x, y + 1);
		glVertex2d(x + md, y - 1);
		glVertex2d(x, y - 1);
		draw_rect = true;
	}
	if (dirs & MULTI_DIR_SE)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x + md, y - md); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x + md, y - md - 1); 
		glVertex2d(x, y - 1);
		glVertex2d(x + md, y - md + 1);
		glVertex2d(x, y + 1);
		draw_rect = true;
	}
	if (dirs & MULTI_DIR_S)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x, y - md); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x + 1, y - md);
		glVertex2d(x + 1, y);
		glVertex2d(x - 1, y - md);
		glVertex2d(x - 1, y);
		draw_rect = true;
	}
	if (dirs & MULTI_DIR_SE)
	{
		glColor4f(1,1,1,1);
		glVertex2d(x - md, y - md); glVertex2d(x, y);
		glColor4f(0,0,0,1);
		glVertex2d(x - md, y - md - 1);
		glVertex2d(x, y - 1);
		glVertex2d(x - md, y - md + 1);
		glVertex2d(x, y + 1);
		draw_rect = true;
	}
	glEnd();

	if (draw_rect)
	{
		GLdouble x1,y1,x2,y2;
		x1 = x - rd + 1;
		y1 = y + rd - 1;
		x2 = x + rd - 1;
		y2 = y - rd+ 1;
		
		glColor4f(1,0,0, 0.7);
		glRectf(x - rd + 1, y + rd - 1, x + rd - 1, y - rd+ 1);
		glColor4f(1,1,1, alpha);
		glBegin(GL_LINE_LOOP);
		glVertex2d(x1,y1);
		glVertex2d(x2,y1);
		glVertex2d(x2,y2);
		glVertex2d(x1,y2);
		glEnd();
	}
}

void goodies_shadow(
	FoldablePolygon fpoly, float startAlpha, float foldAlpha, 
	GLfloat shborder)
{
	std::list<glTiledTexturedImage::point>::iterator i;
	std::list<glTiledTexturedImage::point>::iterator j;
	std::list<glTiledTexturedImage::point>::iterator k;
	std::list<glTiledTexturedImage::point>::iterator l;
	std::list<glTiledTexturedImage::point>::iterator m;

	double sx,sy,cx,cy,rx,ry;
	double rborder = shborder/sqrt(2);
	double ralpha = startAlpha;

	for (i=fpoly.poly1.begin(); i!=fpoly.poly1.end(); ++i)
	{
		j = i;
		j++;
		if (j == fpoly.poly1.end())
		{
			j=fpoly.poly1.begin();
		}
		k = j;
		k++;
		if (k == fpoly.poly1.end())
		{
			k=fpoly.poly1.begin();
		}
			
		sx = sy = cx = cy = rx = ry = 0;

		if ((*i).x < (*j).x)
		{
			sy = -shborder;
		}
		else if ((*i).x > (*j).x)
		{
			sy = shborder;
		}
		if ((*i).y < (*j).y)
		{
			sx = shborder;
		}
		else if ((*i).y > (*j).y)
		{
			sx = - shborder;
		}

		if (sx != 0 && sy != 0)
		{
			sx = sx/sqrt(2);
			sy = sy/sqrt(2);
		}

		if ((*j).x < (*k).x)
		{
			cy = -shborder;
			ry = -rborder;
		}
		else if ((*j).x > (*k).x)
		{
			cy = shborder;
			ry = rborder;
		}
		if ((*j).y < (*k).y)
		{
			cx = shborder;
			rx = rborder;
		}
		else if ((*j).y > (*k).y)
		{
			cx = - shborder;
			rx = - rborder;
		}

		if (cx != 0 && cy != 0)
		{
			cx = cx/sqrt(2);
			cy = cy/sqrt(2);
		}

		double ux = ((sx>0)? 1:0)+((cx>0)? 1:0);
		double uy = ((sy>0)? 1:0)+((cy>0)? 1:0);

		ux = (ux > 0)? ux:1;
		uy = (uy > 0)? uy:1;
		rx = (sx+cx)/(ux*sqrt(2));
		ry = (sy+cy)/(uy*sqrt(2));

		glBegin(GL_POLYGON);
		glColor4f(0.1,0.1,0.1,startAlpha);
		glVertex2f((*i).x, (*i).y);
		glVertex2f((*j).x, (*j).y);
		glColor4f(0.1,0.1,0.1,0);
		glVertex2f((*j).x+sx, (*j).y+sy);
		glVertex2f((*i).x+sx, (*i).y+sy);
		glEnd();

		glBegin(GL_POLYGON);
		glColor4f(0.1,0.1,0.1,ralpha);
		glVertex2f((*j).x, (*j).y);
		glColor4f(0.1,0.1,0.1,0);
		glVertex2f((*j).x+sx, (*j).y+sy);
		glVertex2f((*j).x+rx, (*j).y+ry);
		glVertex2f((*j).x+cx, (*j).y+cy);
		glEnd();
	}

	glTranslatef(0,0,1);
	// FIXME: not perfect yet!!
	for (i = fpoly.shadow.begin(), l = fpoly.poly2.begin();
	     i != fpoly.shadow.end() && l != fpoly.poly2.end(); i++,l++)
	{
		j = i;
		j++;
		if (j == fpoly.shadow.end())
		{
			j = fpoly.shadow.begin();
		}
		
		m = l;
		m++;
		if (m == fpoly.poly2.end())
		{
			m = fpoly.poly2.begin();
		}

		glBegin(GL_POLYGON);
		glColor4f(0.1,0.1,0.1,foldAlpha);
		glVertex2f((*l).x, (*l).y);
		glVertex2f((*m).x, (*m).y);
		glColor4f(0.1,0.1,0.1,0);
		if ((*j).x != (*m).x ||  (*j).y != (*m).y)
		{
			glVertex2f((*j).x, (*j).y);
		}
		if ((*i).x != (*l).x ||  (*i).y != (*l).y)
		{
			glVertex2f((*i).x, (*i).y);
		}
		glEnd();
#if 0
		glBegin(GL_LINE_LOOP);
		glColor4f(0.1,0.1,0.1,1);
		glVertex2f((*l).x, (*l).y);
		glVertex2f((*m).x, (*m).y);
		glColor4f(0.1,0.1,0.1,1);
		if ((*j).x != (*m).x ||  (*j).y != (*m).y)
		{
			glVertex2f((*j).x, (*j).y);
		}
		if ((*i).x != (*l).x ||  (*i).y != (*l).y)
		{
			glVertex2f((*i).x, (*i).y);
		}
		glEnd();
#endif
	}
}

void goodies_shadow(
	GLfloat hw, GLfloat hh, float startAlpha, GLfloat shborder)
{

	hw=(int)(hw/2.0); hh=(int)(hh/2.0);
	GLboolean isBlendEnabled;

	glGetBooleanv(GL_BLEND, &isBlendEnabled);
	if (!isBlendEnabled)
	{
		glEnable(GL_BLEND);
	}

	static GLUquadricObj *_qobj =  gluNewQuadric();

	gluQuadricDrawStyle(_qobj, GLU_FILL);
	gluQuadricNormals(_qobj, GLU_NONE);

#if 0
	glColor4f(0.1,0.1,0.1, startAlpha);
	glPushMatrix();
	glTranslatef(0,0,-0.05);
	glRectf(-hw+shborder,-hh-shborder, hw+shborder,hh-shborder);
	glPopMatrix();

#else

      //#define LEFTRIGHT_SHADOW

#ifdef LEFTRIGHT_SHADOW
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw+shborder, -hh);
      glVertex2f(hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw, -hh-shborder);
      glVertex2f(-hw+shborder, -hh-shborder);
      glEnd();

      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, -hh);
      glVertex2f(hw+shborder, -hh-shborder);
      glVertex2f(hw, -hh-shborder);
      glEnd();

      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(hw, -hh);
      glVertex2f(hw, hh-shborder);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, hh-shborder);
      glVertex2f(hw+shborder, -hh);
      glEnd();
#elif 0
      // top
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw, hh);
      glVertex2f(hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(+hw+shborder, hh+shborder);
      glVertex2f(-hw-shborder, hh+shborder);
      glEnd();

      // bottom
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw, -hh);
      glVertex2f(hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, -hh-shborder);
      glVertex2f(-hw-shborder, -hh-shborder);
      glEnd();

      // right
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(hw, -hh);
      glVertex2f(hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, hh+shborder);
      glVertex2f(hw+shborder, -hh-shborder);
      glEnd(); 

      // left 
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw, hh);
      glVertex2f(-hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(-hw-shborder, -hh-shborder);
      glVertex2f(-hw-shborder, +hh+shborder);
      glEnd();
#elif 0
      // top
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw, hh);
      glVertex2f(hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(+hw, hh+shborder);
      glVertex2f(-hw, hh+shborder);
      glEnd();

      // top left 
      glTranslatef(-hw, hh, 0);
      glColor4f(0.1,0.1,0.1, startAlpha/2.2);
      gluPartialDisk(_qobj, 0.0, shborder/1.4, 20, 1, 270, 90);
      glTranslatef(hw, -hh, -0);

      // top right 
      glTranslatef(hw, hh, 0);
      glColor4f(0.1,0.1,0.1, startAlpha/2.2);
      gluPartialDisk(_qobj, 0.0, shborder/1.4, 20,  1, 0, 90);
      glTranslatef(-hw, -hh, -0);

      // bottom
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1, startAlpha);
      glVertex2f(-hw, -hh);
      glVertex2f(hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw, -hh-shborder);
      glVertex2f(-hw, -hh-shborder);
      glEnd();

      // bottom left 
      glTranslatef(-hw, -hh, 0);
      glColor4f(0.1,0.1,0.1, startAlpha/2.2);
      gluPartialDisk(_qobj, 0.0, shborder/1.4, 20,  1, 180, 90);
      glTranslatef(hw, hh, -0);

      // bottom right 
      glTranslatef(hw, -hh, 0);
      glColor4f(0.1,0.1,0.1, startAlpha/2.2);
      gluPartialDisk(_qobj, 0.0, shborder/1.4, 20,  1, 90, 90);
      glTranslatef(-hw, hh, -0);

      // right
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(hw, -hh);
      glVertex2f(hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, hh);
      glVertex2f(hw+shborder, -hh);
      glEnd(); 

      // left 
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw, hh);
      glVertex2f(-hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(-hw-shborder, -hh);
      glVertex2f(-hw-shborder, +hh);
      glEnd(); 

#elif 1

      double rborder = shborder/sqrt(2);
      double ralpha = startAlpha; //startAlpha/sqrt(2);

      // top
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw, hh);
      glVertex2f(hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(+hw, hh+shborder);
      glVertex2f(-hw, hh+shborder);
      glEnd();

      // top left 
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,ralpha);
      glVertex2f(-hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(-hw-shborder, hh);
      glVertex2f(-hw-rborder , hh+rborder);
      glVertex2f(-hw, hh+shborder);
      glEnd();

      // top right 
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,ralpha);
      glVertex2f(hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, hh);
      glVertex2f(hw+rborder, hh+rborder);
      glVertex2f(hw, hh+shborder);
      glEnd();

      // bottom
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1, startAlpha);
      glVertex2f(-hw, -hh);
      glVertex2f(hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw, -hh-shborder);
      glVertex2f(-hw, -hh-shborder);
      glEnd();

      // bottom left 
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,ralpha);
      glVertex2f(-hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(-hw-shborder, -hh);
      glVertex2f(-hw-rborder, -hh-rborder);
      glVertex2f(-hw, -hh-shborder);
      glEnd();

      // bottom right 
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,ralpha);
      glVertex2f(hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, -hh);
      glVertex2f(hw+rborder, -hh-rborder);
      glVertex2f(hw, -hh-shborder);
      glEnd();


      // right
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(hw, -hh);
      glVertex2f(hw, hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(hw+shborder, hh);
      glVertex2f(hw+shborder, -hh);
      glEnd(); 

      // left 
      glBegin(GL_POLYGON);
      glColor4f(0.1,0.1,0.1,startAlpha);
      glVertex2f(-hw, hh);
      glVertex2f(-hw, -hh);
      glColor4f(0.1,0.1,0.1,0);
      glVertex2f(-hw-shborder, -hh);
      glVertex2f(-hw-shborder, +hh);
      glEnd();  
#endif

#endif
      if (!isBlendEnabled)
      {
	      glDisable(GL_BLEND);
      }
}
