#ifndef n_glTiledTexturedImage_H
#define n_glTiledTexturedImage_H

/*
 *
 * nucleo/gl/texture/glTiledTexturedImage.H --
 *
 * Copyright (C) Nicolas Roussel, Olivier Chapuis
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
*/

#include <list>

#include <nucleo/image/Image.H>
#include <nucleo/gl/glIncludes.H>

using namespace nucleo ;

#define MAX_NBR_OF_UTEXTURE 1024

class glTiledTexturedImage
{

 public:
	struct point
	{
		double x,y ;
		point(double a, double b) : x(a), y(b) {}
	};

	// for storing the tessellation
	struct utess
	{
		GLenum type;
		std::list<glTiledTexturedImage::point > points;
	};

	typedef std::list<glTiledTexturedImage::utess > tessellation;
	typedef std::list<glTiledTexturedImage::tessellation > tiledTessellation;


 protected:
	struct uTex
	{
                GLuint _texnum;
		unsigned int _width, _height;

		uTex(void) {};
		uTex(GLuint texnum, unsigned int width, unsigned int height) {
			_texnum = texnum;
			_width = width;
			_height = height;
		}

		void update(
			GLuint texnum, unsigned int width, unsigned int height)
		{
			_texnum = texnum;
			_width = width;
			_height = height;
		} ;

		GLuint getTexnum(void) { return _texnum; };
		void setTexnum(GLuint texnum) { _texnum = texnum; };
	
		unsigned int getWidth(void) { return _width; };
		unsigned int getHeight(void) { return _height; };
		void setSize(unsigned int width, unsigned int height) {
			_width = width;
			_height = height;
		} ;
	} ;

	GLuint _target;

	uTex _texSet[MAX_NBR_OF_UTEXTURE];
	Image _textureImage ;

	// hardware limit
	static GLint _potMaxTextureSize;
	static GLint _npotNVMaxTextureSize;
	static GLint _npotEXTMaxTextureSize;
	
	static GLUtesselator *_tessellator;

	static GLint _can_generate_mipmaps;

	GLint _minTextureSize;
	GLint _maxTextureSize;

	int _tex_per_col;
	int _tex_per_row;
	int _texture_count;

	int _oimageWidth;
	int _oimageHeight;

	Image _indirect_source ;

	tiledTessellation _tiledTessellation;

	void _init(void);

	int _checkImage(Image *img);

	void _bind(GLuint texture, GLdouble w, GLdouble h);
	void _getRenderingParameters(
		int col, int row, int x, int y,
		GLdouble *w, GLdouble *h, GLdouble *right, GLdouble *bottom);

	void _tessInit(void);
	void _tessDisplayCached(void);

 public:

	static bool debugMode ;
	static bool use_npot_ext ;
	static bool do_generate_mipmaps;
	
	// The tile will use some texture of size less or equal to s x s
	// where s is size or the smallest pot >= size (for GL_TEXTURE_2D).
	// If size = 0, the hardware max texture size is used (maybe not the 
	// the best solution).
	glTiledTexturedImage(int size = 0) ;
	~glTiledTexturedImage() ;

	// If image dimensions are Power-Of-Two or there's an OpenGL
	// extension to deal with non-POT textures, image will loose data
	// ownership (so the texture can live longer than the
	// image). Beware: next call to update will delete image data...

	// This setup or redefine the texture image
	bool update(Image *img) ;

	// good when the size of the image does not change. Update
	// the texture image at (x,y) with a wxh img
	bool subUpdate(
		Image *img, int x, int y, unsigned int w, unsigned int h);

	// should be call before displaying
	void enable(void) ;
	// should be call after displaying
	void disable(void) ;

	// Display the texture along the polygon, this works in general
	// only if the tile is constituted by one texture and the polygon 
	// is convex. This always work with the natural polygon
	//          (-ww,-hh) (ww, -hh) (ww, hh) (-ww, hh)
	// where ww = _oimageWidth/2 and hh = _oimageHeight/2
	// this polygon is used if poly is NULL. 
	void display(std::list<glTiledTexturedImage::point> *poly = NULL);
	// new!
	void display(
		std::list<glTiledTexturedImage::point> *poly_img,
		std::list<glTiledTexturedImage::point> *poly_tex);

	// Display the texture along the polygon. Should always work but
	// use tessellation. The tessellation is stored and can be reused
	// (useTessCache = true) and the tessellation is not "zero". This
	// must be controlled by the caller but update clear the stored 
	// tessellation. 
	void tessDisplay(
		std::list<glTiledTexturedImage::point> *poly,
		bool useTessCache = false);

	// get the last tessellation generated by tessDisplay
	void getLastTessellation(glTiledTexturedImage::tiledTessellation *tess);

	// what follows is for custumized rendering; should add a lot more
	// for that

	GLuint getTarget(void) ;

	// texture image size (in fact equal to the image used with update,
	// see USE_MINIMAL_TEXTURE_IMAGE in the code)
	unsigned int getWidth(void) ;
	unsigned int getHeight(void) ;

	// the texture image
	const Image& getTexture(void) ;

	// may add info regarding and in function of the columns and  rows

	// ...etc.

} ;


#endif
