#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>
#include <X11/Xproto.h>

#ifndef max
#define max(a,b) ((a>b)? a:b)
#endif
#ifndef min
#define min(a,b) ((a<b)? a:b)
#endif


Display *_dpy;
static char *_appname;
Window _win;
unsigned int _width, _height;
Atom _type;
Bool _hasPos = False;
int _usX = 0;
int _usY = 0;

char *_dupliacte_Name = "Duplicate";
char *_facade_Name = "Faade";
char *_optName = NULL;
Bool _doLayoutAtStartUp = True;

#define METISSE_WIN_TYPE_DUPLICATE 0
#define METISSE_WIN_TYPE_FACADE    1

Atom ATOM_WM_DELETE_WINDOW = None;
Atom _METISSE_NET_WM_DUPLICATE = None;
Atom _METISSE_NET_WM_FACADE = None;
Atom _METISSE_NET_WM_FACADE_REMOVE = None;

Atom _WM_STATE = None;
#define XIA(a) XInternAtom(_dpy,a,False)

int Development = 1;

typedef struct
{
	XID fid;  // frame id
	XID cid;  // window client id
	int src_x;
	int src_y;
	int src_w;
	int src_h;
	int dest_x;
	int dest_y;
} cut;

cut _facade[256];
int _num_facade = 0;

int myErrorHandler(Display *dpy, XErrorEvent *e)
{
	char msg[256];

	/* some errors are acceptable BadAtom? */

	if (e->error_code == BadWindow ||
	    e->request_code == X_GetGeometry ||
	    e->error_code == BadDrawable)
	{
		return 0;
	}

	XGetErrorText(dpy, e->error_code, msg, sizeof(msg));
	fprintf(stderr, "%s XError: %d (%s)\n", _appname, e->error_code, msg);
	fprintf(stderr, "   Major opcode of failed request:  %d\n",
		e->request_code);
	fprintf(stderr, "   Minor opcode of failed request:  %d \n",
		e->minor_code);
	fprintf(stderr, "   Resource id of failed request:  0x%lx \n",
		e->resourceid);

	if (Development)
	{
		fprintf(stderr, " Leaving a core dump now\n");
		abort();
		/* exit if this fails */
		exit(99);
	}

	return 0 ;
}

char *get_window_title(Display *disp, Window win, int *is_net)
{
	char *name;
	*is_net = 0;
	XTextProperty text_prop;
	char **list;
	int num;

	if (XGetWMName(disp, win, &text_prop) != 0 &&
	    text_prop.encoding == XA_STRING)
	{
		/* STRING encoding, use this as it is */
		name = (char *)text_prop.value;
		return name;
	}

	/* not STRING encoding, try to convert XA_COMPOUND_TEXT */
	if (XmbTextPropertyToTextList(disp, &text_prop, &list, &num) >= Success
	    && num > 0 && *list)
	{
		/* Does not consider the conversion is REALLY succeeded:
		 * XmbTextPropertyToTextList return 0 (== Success) on success,
		 * a negative int if it fails (and in this case we are not
		 * here), the number of unconvertible char on "partial"
		 * success*/
		XFree(text_prop.value); /* return of XGetWM(Icon)Name() */
		name = strdup(*list);
		/*ret_name->name_list = list;*/
	}
	else
	{
		name = (char *)text_prop.value;
	}
	if (list)
	{
		XFreeStringList(list);
	}
	if (name == NULL)
	{
		name = strdup("NoTitle");
	}
	else
	{
		/* ok */
	}
	return name;
}

void *get_property(
	Display *disp, Window win, Atom atom, Atom type, unsigned int *size)
{
	unsigned char *retval;
	Atom  type_ret;
	unsigned long  bytes_after, num_ret;
	long length;
	int  format_ret;
	void *data;
	int ok;

	retval = NULL;
	length = 0x7fffffff;
	ok = XGetWindowProperty(
		disp, win, atom, 0, length, False, type, &type_ret,
		&format_ret, &num_ret, &bytes_after, &retval);

	if ((ok == Success) && (retval) && (num_ret > 0) && (format_ret > 0))
	{
		data = malloc(num_ret * (format_ret >> 3));
		if (data)
		{
			memcpy(data, retval, num_ret * (format_ret >> 3));
		}
		XFree(retval);
		*size = num_ret * (format_ret >> 3);
		return data;
	}
	if (retval)
	{
		XFree(retval);
	}
	return NULL;
}


void *get_simple_property(
	Display *disp, Window win, Atom atom, Atom type)
{
	unsigned int size;

	return get_property(disp, win, atom, type, &size);
}

Bool get_wm_state(Display *disp, Window wind, unsigned long *state)
{
	unsigned long *val;
	if ((val = get_simple_property(
		     disp, wind, _WM_STATE, _WM_STATE)) == NULL)
	{
		return False;
	}

	*state = val[0];
	free(val);

	return True;
}

Bool get_client_window(Display *disp, Window wind, Window *tl)
{
	Window junkroot;
	Window parent;
	Window *filles = NULL;
	unsigned int nfilles;
	int i;
	unsigned long s;

	if (get_wm_state(disp, wind, &s))
	{
		*tl = wind;
		return True;
	}

	if (!XQueryTree(disp, wind, &junkroot, &parent, &filles, &nfilles))
	{
		if (filles)
			XFree(filles);
		return False;
	}

	for(i = 0; i < nfilles; i++)
	{
		if (get_wm_state(disp, filles[i], &s))
		{
			*tl = filles[i];
			if (filles)
				XFree(filles);
			return True;
		}
	}
	for(i = 0; i < nfilles; i++)
	{
		if (get_client_window(disp, filles[i], tl))
		{
			if (filles)
				XFree(filles);
			return True;
		}
	}
	if (filles)
		XFree(filles);

	return False;
}

Window get_toplevel_window(Display *disp, Window wind)
{
	Window junkroot;
	Window parent;
	Window *filles = NULL;
	unsigned int nfilles;
	Window toplevel = wind;

	while(XQueryTree(disp, toplevel, &junkroot, &parent, &filles, &nfilles)
	      && parent != None && parent != junkroot)
		/*&& !isVirtualRoot(disp, parent) */
	{
		toplevel = parent;
		if (filles)
		{
			XFree(filles);
		}
		filles = NULL;
	}

	if (filles)
	{
		XFree(filles);
	}

	return toplevel;
}

/*
 *
 */


static
int _found_facade_num(XID fid, int src_x, int src_y, int src_w, int src_h)
{
	int i;

	for (i = 0; i < _num_facade; i++)
	{
		if (_facade[i].fid == fid &&  _facade[i].src_x == src_x &&
		    _facade[i].src_y == src_y &&  _facade[i].src_w == src_w  &&
		    _facade[i].src_h == src_h)
		{
			return i;
		}
	}

	return -1;
}

static
void resizeMe(int w, int h)
{
	XSizeHints *size_hints;

	size_hints = XAllocSizeHints();
	
	_width = w;
	_height = h;

	size_hints->flags       = PSize | PMinSize | PMaxSize;
	size_hints->width   = _width;
	size_hints->height  = _height;
	size_hints->min_width   = _width;
	size_hints->min_height  = _height;
	size_hints->max_width   = _width;
	size_hints->max_height  = _height;
	XSetWMNormalHints(_dpy, _win, size_hints);
	XResizeWindow(_dpy, _win, _width, _height);
	
	XFree(size_hints);
}

static
void setup_metisse_layout(int startup)
{
	int i;
	int max_width = 0;
	int cur_x = 0;
	int prev_y = 0;

	_height = 0;
	_width = 0;
	for (i = 0; i < _num_facade; i++)
	{
		max_width = max(max_width, _facade[i].src_w);
	}
	for (i = 0; i < _num_facade; i++)
	{
		_width = max(_width, _facade[i].src_w);
		if (cur_x > 0 && cur_x + _facade[i].src_w < max_width)
		{
			_facade[i].dest_x = cur_x;
			_facade[i].dest_y = prev_y;
			_height = max(_height, prev_y+_facade[i].src_h);
			cur_x = cur_x + _facade[i].src_w;
		}
		else
		{
			_facade[i].dest_x = 0;
			prev_y = _facade[i].dest_y = _height;
			cur_x = _facade[i].src_w;
			_height = _height +  _facade[i].src_h;
		}
	}

	if (startup == 0)
	{
		if (_width == 0)
		{
			_width = 100;
		}
		if (_height == 0)
		{
			_height = 50;
		}
		resizeMe(_width, _height);
		i = _num_facade-1;
		if (i >= 0)
		{
			XSelectInput(
				_dpy, _facade[i].fid, StructureNotifyMask);
			XSelectInput(
				_dpy, _facade[i].cid, StructureNotifyMask);
		}
	}
}

#if 0
static
void clearWindows(void)
{
	int i;

	for (i = 0; i < _num_facade; i++)
	{
		XClearArea(_dpy, _facade[i].cid, 0, 0, 0, 0, True);
	}
}
#endif

static
void set_metisse_properties(Atom atom_type)
{
	unsigned long *duplicate_hints;
	unsigned long duplicate_count;
	int i;

	duplicate_count = 0;
	duplicate_hints = (CARD32 *)malloc(7*_num_facade*sizeof(CARD32));
	for (i = 0; i < _num_facade; i++)
	{
		duplicate_hints[duplicate_count++] = (CARD32)_facade[i].fid;
		duplicate_hints[duplicate_count++] = (CARD32)_facade[i].src_x;
		duplicate_hints[duplicate_count++] = (CARD32)_facade[i].src_y;
		duplicate_hints[duplicate_count++] = (CARD32)_facade[i].src_w;
		duplicate_hints[duplicate_count++] = (CARD32)_facade[i].src_h;
		duplicate_hints[duplicate_count++] = (CARD32)_facade[i].dest_x;
		duplicate_hints[duplicate_count++] = (CARD32)_facade[i].dest_y;
	}

	XChangeProperty(
		_dpy, _win, atom_type, XA_CARDINAL, 32,
		PropModeReplace, (unsigned char *)duplicate_hints,
		duplicate_count);

	free(duplicate_hints);
}

static
void _remove_facade_num(int num)
{
	int i;

	for (i = num; i < _num_facade-1; i++)
	{
		memcpy(&_facade[i], &_facade[i+1], sizeof(_facade[i]));
	}
	_num_facade--;
	setup_metisse_layout(0);
	set_metisse_properties(_METISSE_NET_WM_FACADE);
	XFlush(_dpy);
	XLowerWindow(_dpy,_win);
	XFlush(_dpy);
	XRaiseWindow(_dpy,_win);
	XFlush(_dpy);
	XClearArea(_dpy, _win, 0, 0, 0, 0, True);
}

void Xloop(void)
{
	while (1)
	{
		XEvent ev;

		/* Sit and wait for an event to happen */
		XNextEvent(_dpy,&ev);

		switch(ev.type)
		{
		case ConfigureNotify:
		{
			while (XCheckTypedWindowEvent(
				       _dpy, ev.xconfigure.window,
				       ConfigureNotify, &ev))
			{
			}
			if (_type == METISSE_WIN_TYPE_FACADE)
			{
				break;
			}
			if (ev.xconfigure.window == _facade[0].cid &&
			    (_width != ev.xconfigure.width ||
			     _height != ev.xconfigure.height))
			{
				_width = ev.xconfigure.width;
				_height = ev.xconfigure.height;
				//resizeMe(_width, _height);
				XResizeWindow(_dpy, _win, _width, _height);
				XSync(_dpy, True);
				/*fprintf(stderr,"XConfigure\n");*/
			}
			else if (ev.xconfigure.window == _win &&
			    (_width != ev.xconfigure.width ||
			     _height != ev.xconfigure.height))
			{
				/*fprintf(stderr,"XConfigure %i\n", count);*/
			}
			break;
		}
		case ClientMessage:
			if (ev.xclient.format == 32 &&
			    ev.xclient.data.l[0] == ATOM_WM_DELETE_WINDOW)
			{
				exit(0);
			}
			else if (ev.xclient.message_type ==
				 _METISSE_NET_WM_FACADE)
			{
				XID fid = ev.xclient.data.l[0];
				XID cid;

				fid = get_toplevel_window(_dpy,(Window)fid);
				if (fid == None)
				{
					break;
				}
				if (!get_client_window(_dpy, (Window)fid, &cid))
				{
					break;
				}
				_facade[_num_facade].src_x =
					ev.xclient.data.l[1];
				_facade[_num_facade].src_y =
					ev.xclient.data.l[2];
				_facade[_num_facade].src_w =
					ev.xclient.data.l[3];
				_facade[_num_facade].src_h =
					ev.xclient.data.l[4];
				_facade[_num_facade].dest_x = 0;
				_facade[_num_facade].dest_y = 0;
				_facade[_num_facade].fid = fid;
				_facade[_num_facade].cid = cid;
				
				_num_facade++;
				setup_metisse_layout(0);
				set_metisse_properties(_METISSE_NET_WM_FACADE);
				XFlush(_dpy);
				XLowerWindow(_dpy,_win);
				XFlush(_dpy);
				XRaiseWindow(_dpy,_win);
				XFlush(_dpy);
			}
			else if (ev.xclient.message_type ==
				 _METISSE_NET_WM_FACADE_REMOVE)
			{
				XID fid = ev.xclient.data.l[0];
				XID cid;
				int num;
				fid = get_toplevel_window(_dpy,(Window)fid);
				if (fid == None)
				{
					break;
				}
				num = _found_facade_num(
					fid,
					ev.xclient.data.l[1],
					ev.xclient.data.l[2],
					ev.xclient.data.l[3],
					ev.xclient.data.l[4]);
				_remove_facade_num(num);
			}
			break;
		default:
			break;
		}
	}
}

static
void parseArgs(int argc, char * argv[])
{
	int i;
	int x_r,y_r,ret;
	unsigned int h_r,w_r;
	XID prevID = 0;
	
	for (i = 1; i < argc; i++)
	{
		if (strcasecmp(argv[i], "--id") == 0 ||
		    strcasecmp(argv[i], "-i") == 0)
		{
			i++;
			_facade[_num_facade].fid = strtoul(argv[i], NULL, 0);
			prevID = _facade[_num_facade].fid;
		}
		else if (strcasecmp(argv[i], "--facade") == 0 ||
			 strcasecmp(argv[i], "-c") == 0)
		{
			_type = METISSE_WIN_TYPE_FACADE;
		}
		else if (strcasecmp(argv[i], "--duplicate") == 0 ||
			 strcasecmp(argv[i], "-d") == 0)
		{
			_type = METISSE_WIN_TYPE_DUPLICATE;
		}
		else if (strcasecmp(argv[i], "--name") == 0 ||
			 strcasecmp(argv[i], "-n") == 0)
		{
			i++;
			_optName = (char *)malloc(sizeof(argv[i])+1);
			_optName = strdup(argv[i]);
		}
		else if (strcasecmp(argv[i], "--position") == 0 ||
			 strcasecmp(argv[i], "-p") == 0)
		{
			i++;
			ret = XParseGeometry(argv[i], &x_r, &y_r, &w_r, &h_r);
			if ((ret & XValue) && (ret & YValue))
			{
				_hasPos = True;
				_usX = x_r;
				_usY = y_r;
			}
		}
		else if (strcasecmp(argv[i], "--geometry") == 0 ||
			 strcasecmp(argv[i], "-g") == 0)
		{
			i++;
			ret = XParseGeometry(argv[i], &x_r, &y_r, &w_r, &h_r);
			if (!((ret & WidthValue) && (ret & HeightValue) &&
			      (ret & XValue) && (ret & YValue)))
			{
				fprintf(stderr, "%s: invalid --geometry args\n",
					_appname);
				exit(1);
			}
			_facade[_num_facade].src_x = x_r;
			_facade[_num_facade].src_y = y_r;
			_facade[_num_facade].src_w = w_r;
			_facade[_num_facade].src_h = h_r;
			_facade[_num_facade].dest_x = 0;
			_facade[_num_facade].dest_y = 0;
			_facade[_num_facade].fid = prevID;
			_num_facade++;
		}
		else if (strcasecmp(argv[i], "--source") == 0 ||
			 strcasecmp(argv[i], "-s") == 0)
		{
			i++;
			_facade[_num_facade].src_x = strtol(argv[i++], NULL, 0);
			_facade[_num_facade].src_y = strtol(argv[i++], NULL, 0);
			_facade[_num_facade].src_w = strtol(argv[i++], NULL, 0);
			_facade[_num_facade].src_h = strtol(argv[i++], NULL, 0);
			_facade[_num_facade].dest_x = strtol(argv[i++], NULL, 0);
			_facade[_num_facade].dest_y = strtol(argv[i], NULL, 0);
			_facade[_num_facade].fid = prevID;
			_num_facade++;
			_doLayoutAtStartUp = False;
		}
	}
}


int main(int argc, char * argv[])
{
	int screen_num;
	Atom atom_type = None;
	char *window_name; /*= "dummy win";*/
	char *icon_name;   /*= "dummy win";*/
	int i;

	Window junkRoot;
	int frame_x, frame_y;
	unsigned int frame_width, frame_height, frame_BW, frame_depth;
	int client_x, client_y;
	unsigned int client_width, client_height, client_BW, client_depth;

	char *display_name = NULL;
	
	XSizeHints *size_hints;
	XWMHints   *wm_hints;
	XClassHint *class_hints;
	XTextProperty windowName, iconName;
	XColor bg_color;

	_appname = argv[0];

	/*  Set initial window size and position, and create it  */
	_width  = 200;
	_height = 200;

	_facade[0].fid = 0;

	parseArgs(argc, argv);

	if (_type == METISSE_WIN_TYPE_FACADE && _num_facade == 0)
	{
		fprintf(stderr, "%s: no cuts defined\n", _appname);
		exit(1);
	}
	else if (_num_facade == 0 && _facade[0].fid == 0)
	{
		fprintf(stderr, "%s: no duplicate win given\n", _appname);
		exit(1);
	}
	else if (_type == METISSE_WIN_TYPE_DUPLICATE) 
	{
		_num_facade = 1;	
	}

	if (!(size_hints = XAllocSizeHints()) ||
	    !(wm_hints = XAllocWMHints())     ||
	    !(class_hints = XAllocClassHint()))
	{
		fprintf(stderr, "%s: couldn't allocate memory.\n", _appname);
		exit(1);
	}


	/*  Connect to X server  */

	if ((_dpy = XOpenDisplay(display_name)) == NULL)
	{
		fprintf(
			stderr, "%s: couldn't connect to X server %s\n",
			_appname, display_name);
		exit(1);
	}

	XSetErrorHandler(myErrorHandler);
	_WM_STATE = XIA("WM_STATE");

	for (i = 0; i < _num_facade; i++)
	{

		if (!XGetGeometry(
			    _dpy, (Window)_facade[i].fid, &junkRoot, &frame_x,
			    &frame_y,
			    &frame_width, &frame_height, &frame_BW,
			    &frame_depth))
		{
			fprintf(
				stderr, "%s: window 0x%lx does not exit\n",
				_appname, _facade[i].fid);
			exit(1);
		}

		_facade[i].fid =
			get_toplevel_window(_dpy,(Window)_facade[i].fid);

		if (!XGetGeometry(
			    _dpy, (Window)_facade[i].fid, &junkRoot, &frame_x,
			    &frame_y, &frame_width, &frame_height, &frame_BW,
			    &frame_depth))
		{
			fprintf(
				stderr, "%s: window 0x%lx does not exit\n",
				_appname, _facade[i].fid);
			exit(1);
		}

		if (!get_client_window(
			    _dpy, (Window)_facade[i].fid, &_facade[i].cid))
		{
			fprintf(
				stderr, "%s: couldn't get client window of "
				"0x%lx\n",_appname, _facade[i].fid);
			exit(1);
		}

		if (!XGetGeometry(
			    _dpy, (Window)_facade[i].cid, &junkRoot, &client_x,
			    &client_y, &client_width, &client_height,
			    &client_BW,  &client_depth))
		{
			fprintf(
				stderr, "%s: client window 0x%lx does "
				"not exit\n", _appname, _facade[i].cid);
			exit(1);
		}

	}

	_METISSE_NET_WM_FACADE = XIA("_METISSE_NET_WM_FACADE");
	_METISSE_NET_WM_FACADE_REMOVE = XIA("_METISSE_NET_WM_FACADE_REMOVE");
	_METISSE_NET_WM_DUPLICATE = XIA("_METISSE_NET_WM_DUPLICATE");
	if (_type == METISSE_WIN_TYPE_FACADE)
	{
		if (_optName)
		{
			icon_name = _optName;
			window_name = _optName;
		}
		else
		{
			icon_name = _facade_Name;
			window_name = _facade_Name;
		}
		class_hints->res_class  = "metisse facade";
		// FIXME
		_height = 0;
		_width = 0;
		for (i = 0; i < _num_facade; i++)
		{
			if (_doLayoutAtStartUp)
			{
				_width = max(_width, _facade[i].src_w);
				_facade[i].dest_x = 0;
				_facade[i].dest_y = _height;
				_height = _height +  _facade[i].src_h;
			}
			else
			{
				_height =
					max(_height,
					    _facade[i].dest_y +
					    _facade[i].src_h);
				_width = max(_width,
					     _facade[i].dest_x +
					     _facade[i].src_w);
			}
			#if 0
			fprintf(stderr,"cut: %i %i %i %i %i %i\n",
				_facade[i].src_x, _facade[i].src_y,
				_facade[i].src_w, _facade[i].src_h,
				_facade[i].dest_x, _facade[i].dest_y);
			#endif
		}
			
		atom_type = _METISSE_NET_WM_FACADE;

		size_hints->flags = PSize | PMinSize | PMaxSize;
	}
	else
	{
		char *name;
		int is_net;

		name = get_window_title(_dpy, (Window)_facade[0].cid, &is_net);
		icon_name = (name)? name:_dupliacte_Name;
		window_name  = (name)? name:_dupliacte_Name;
		class_hints->res_class  = "metisse duplicate";
		
		_width = client_width;
		_height = client_height;
	
		atom_type = _METISSE_NET_WM_DUPLICATE;

		size_hints->flags = PSize;
	}

	size_hints->width = _width;
	size_hints->height = _height;
	size_hints->min_width   = _width;
	size_hints->min_height  = _height;
	size_hints->max_width   = _width;
	size_hints->max_height  = _height;
	
	if (_hasPos)
	{
		size_hints->flags = USPosition;
		size_hints->x = _usX;
		size_hints->y = _usY;
	}

	wm_hints->flags = StateHint;
	wm_hints->initial_state = NormalState;
	/* wm_hints->input         = True; */

	class_hints->res_name = _appname;

	/*  Get screen size from display structure macro  */
	screen_num = DefaultScreen(_dpy);
	
	bg_color.red = (int)65535/2;
	bg_color.green = (int)65535/2;
	bg_color.green = (int)65535/2;
	XAllocColor(_dpy, DefaultColormap(_dpy,screen_num), &bg_color);

	_win = XCreateSimpleWindow(
		_dpy, RootWindow(_dpy, screen_num),
		_usX, _usY, _width, _height, 0,
		bg_color.pixel, bg_color.pixel);
	//	WhitePixel(_dpy, screen_num), WhitePixel(_dpy, screen_num));
	//bg_color.pixel,
	//bg_color.pixel);
		//BlackPixel(_dpy, screen_num));
	//WhitePixel(_dpy, screen_num));

	if ( XStringListToTextProperty(&window_name, 1, &windowName) == 0 ) 
	{
		fprintf(
			stderr,
			"%s: structure allocation for windowName failed.\n",
			_appname);
		exit(1);
	}

	if (XStringListToTextProperty(&icon_name, 1, &iconName) == 0 )
	{
		fprintf(
			stderr,
			"%s: structure allocation for iconName failed.\n",
			_appname);
		exit(1);
	}


	XSetWMProperties(
		_dpy, _win, &windowName, &iconName, argv, argc,
		size_hints, wm_hints, class_hints);


	ATOM_WM_DELETE_WINDOW = XIA("WM_DELETE_WINDOW");
	{
		Atom proto[1];
		int j = 0;

		proto[j++] = ATOM_WM_DELETE_WINDOW;

		XSetWMProtocols(_dpy, _win, proto, j);
	}


	set_metisse_properties(atom_type);

	/*  Choose which events we want to handle  */
	XSelectInput(_dpy, _win, StructureNotifyMask);

	for (i = 0; i < _num_facade; i++)
	{
		XSelectInput(
			_dpy, _facade[i].fid, StructureNotifyMask);
		XSelectInput(
			_dpy, _facade[i].cid, StructureNotifyMask);
	}

	/* map */
	XMapWindow(_dpy, _win);

	Xloop();
	
	return 0;   /*  We shouldn't get here  */
}
