# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6
PYTHON_COMPAT=( python2_7 python3_6 )

inherit distutils-r1 eutils readme.gentoo-r1 systemd

DESCRIPTION="DenyHosts is a utility to help sys admins thwart ssh hackers"
HOMEPAGE="https://github.com/denyhosts/denyhosts"
SRC_URI="https://github.com/${PN}/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~alpha amd64 arm hppa ppc sparc x86"
IUSE=""

DEPEND=""
RDEPEND=""

DISABLE_AUTOFORMATTING="yes"
DOC_CONTENTS="
>=net-misc/openssh-6.7p1 dropped support for sys-apps/tcp-wrappers
(see bug#531156) that means you either have patch openssh or use
denyhosts' iptables feature to get any protection.

You can configure DenyHosts to run as a daemon by running:
# rc-update add denyhosts default
or:
# systemctl enable denyhosts.service
(if you use systemd)

To run DenyHosts as a cronjob instead of a daemon add the following
to /etc/crontab
# run DenyHosts every 10 minutes
*/10  *  * * *    root    /usr/bin/denyhosts.py -c /etc/denyhosts.conf

More information can be found at ${HOMEPAGE}faq.html"

#bring back python-2.7 support  bug #577502
PATCHES=( "${FILESDIR}"/"${P}"-python2.7.patch )

src_prepare() {
	sed -e '/^DENY_THRESHOLD_VALID =/s/=.*/= 5/' \
		-e '/^SECURE_LOG/s/^/#/' \
		-e '\@#SECURE_LOG.*/var/log/messages@s/^#//' \
		-i denyhosts.conf || die "sed failed"

	distutils-r1_src_prepare
}

src_install() {
	readme.gentoo_create_doc

	dodoc CHANGELOG.txt README.md
	distutils-r1_src_install

	dodir /etc/logrotate.d
	insinto /etc/logrotate.d
	newins "${FILESDIR}"/${PN}.logrotate-r2 ${PN}

	newinitd "${FILESDIR}"/denyhosts.init-r2 denyhosts
	systemd_dounit "${FILESDIR}"/${PN}.service

	keepdir /var/lib/denyhosts
}
