# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6

inherit toolchain-funcs udev

DESCRIPTION="A Device Firmware Update based USB programmer for Atmel chips"
HOMEPAGE="http://dfu-programmer.sourceforge.net"
SRC_URI="mirror://sourceforge/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 arm"
IUSE=""

RDEPEND="
	acct-group/plugdev
	virtual/libusb:1
	virtual/udev"
DEPEND="${RDEPEND}
	virtual/pkgconfig"

src_prepare() {
	default

	# Upstream has fixed this in their configure already.
	tc-export CPP PKG_CONFIG
	sed -i \
		-e "/LIBUSB_1_0_CFLAGS=/s:=.*:='$(${PKG_CONFIG} --cflags libusb-1.0)':" \
		-e "/LIBUSB_1_0_LIBS=/s:=.*:='$(${PKG_CONFIG} --libs libusb-1.0)':" \
		configure || die
}

src_install() {
	default

	cat <<-EOF > 70-dfu-programmer.rules
	#
	# do not edit this file, it will be overwritten on update
	#
	EOF
	printf 'SUBSYSTEM=="usb", ACTION=="add", ATTRS{idVendor}=="03eb", ATTRS{idProduct}=="%s", MODE="660", GROUP="plugdev", SYMLINK+="dfu-%%n"\n' \
		2ff{a,b,9,7,4,3} >> 70-dfu-programmer.rules

	udev_dorules 70-dfu-programmer.rules
}

pkg_postinst() {
	elog "To update device firmware as user you must be in the plugdev group:"
	elog
	elog "usermod -aG plugdev <user>"
}
