# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6

# ebuild generated by hackport 0.5.3.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="A library for various character encodings"
HOMEPAGE="http://code.haskell.org/encoding/"
SRC_URI="https://hackage.haskell.org/package/${P}/${P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="+systemencoding"

RDEPEND=">=dev-haskell/extensible-exceptions-0.1:=[profile?] <dev-haskell/extensible-exceptions-0.2:=[profile?]
	>=dev-haskell/mtl-2.0:=[profile?] <dev-haskell/mtl-2.3:=[profile?]
	>=dev-haskell/regex-compat-0.71:=[profile?]
	>=dev-lang/ghc-7.8.2:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.24
	>=dev-haskell/haxml-1.22 <dev-haskell/haxml-1.26
	test? ( dev-haskell/hunit
		dev-haskell/quickcheck )
"

PATCHES=(
	"${FILESDIR}"/${P}-cabal22.patch
)

src_prepare() {
	default

	cabal_chdeps \
		'regex-compat >=0.71 && <0.95' 'regex-compat >=0.71' \
		'containers >=0.4 && <0.6' 'containers >=0.4 && <0.7'
}

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag systemencoding systemencoding)
}
