# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=5

# ebuild generated by hackport 0.4.4.9999

# haddock is disabled as it chokes in .hsc file:
#     Database/HDBC/ODBC/Statement.hsc:462:3:
#        parse error on input `Word16'
CABAL_FEATURES="bin lib profile hoogle hscolour"
inherit haskell-cabal

MY_PN="HDBC-odbc"
MY_P="${MY_PN}-${PV}"

DESCRIPTION="ODBC driver for HDBC"
HOMEPAGE="https://github.com/hdbc/hdbc-odbc"
SRC_URI="https://hackage.haskell.org/package/${MY_P}/${MY_P}.tar.gz"

LICENSE="BSD"
SLOT="2/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="buildstresstest test"
RESTRICT="test" # requires configured ODBC

RDEPEND=">=dev-haskell/hdbc-2.1.0:2=[profile?]
	dev-haskell/mtl:=[profile?]
	dev-haskell/utf8-string:=[profile?]
	>=dev-lang/ghc-7.4.1:=
	>=dev-db/unixODBC-2.2
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.8
	buildstresstest? ( dev-haskell/random:=[profile?]
				dev-haskell/resource-pool:=[profile?] )
	test? ( dev-haskell/convertible:=[profile?]
			dev-haskell/hunit:=[profile?]
			dev-haskell/quickcheck:2=[profile?]
			dev-haskell/testpack:=[profile?] )
"

S="${WORKDIR}/${MY_P}"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag buildstresstest buildstresstest) \
		$(cabal_flag test buildtests)
}

src_test() {
	# default tests
	haskell-cabal_src_test || die "cabal test failed"

	# built custom tests
	"${S}/dist/build/runtests/runtests" || die "unit tests failed"
}

src_install() {
	cabal_src_install

	# if tests were enabled, make sure the unit test driver is deleted
	rm -f "${ED}/usr/bin/runtests"
}
