# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

# ebuild generated by hackport 0.6.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour" # test-suite: needs htfpp already installed
inherit haskell-cabal

MY_PN="HTF"
MY_P="${MY_PN}-${PV}"

DESCRIPTION="The Haskell Test Framework"
HOMEPAGE="https://github.com/skogsbaer/HTF/"
SRC_URI="https://hackage.haskell.org/package/${MY_P}/${MY_P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE=""

RESTRICT=test # needs stack, needs htfpp already installed

RDEPEND=">=dev-haskell/aeson-0.11:=[profile?]
	dev-haskell/base64-bytestring:=[profile?]
	>=dev-haskell/cpphs-1.19:=[profile?]
	>=dev-haskell/diff-0.3:=[profile?]
	dev-haskell/haskell-src:=[profile?]
	>=dev-haskell/hunit-1.2.5:=[profile?]
	>=dev-haskell/lifted-base-0.1:=[profile?]
	>=dev-haskell/monad-control-0.3:=[profile?]
	>=dev-haskell/mtl-1.1:=[profile?]
	>=dev-haskell/old-time-1.0:=[profile?]
	>=dev-haskell/quickcheck-2.3:2=[profile?]
	>=dev-haskell/random-1.0:=[profile?]
	>=dev-haskell/regex-compat-0.92:=[profile?]
	>=dev-haskell/text-0.11:=[profile?]
	dev-haskell/vector:=[profile?]
	>=dev-haskell/xmlgen-0.6:=[profile?]
	>=dev-lang/ghc-7.6.1:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.16.0
"

S="${WORKDIR}/${MY_P}"
