# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6

# ebuild generated by hackport 0.5.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="A web server for the Snap Framework"
HOMEPAGE="http://snapframework.com/"
SRC_URI="https://hackage.haskell.org/package/${P}/${P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="amd64 x86"
IUSE="build-pong debug openssl portable"

RDEPEND=">=dev-haskell/attoparsec-0.12:=[profile?] <dev-haskell/attoparsec-0.14:=[profile?]
	>=dev-haskell/blaze-builder-0.4:=[profile?] <dev-haskell/blaze-builder-0.5:=[profile?]
	>=dev-haskell/bytestring-builder-0.10.4:=[profile?] <dev-haskell/bytestring-builder-0.11:=[profile?]
	>=dev-haskell/case-insensitive-1.1:=[profile?] <dev-haskell/case-insensitive-1.3:=[profile?]
	>=dev-haskell/clock-0.7.1:=[profile?] <dev-haskell/clock-0.8:=[profile?]
	>=dev-haskell/io-streams-1.3:=[profile?] <dev-haskell/io-streams-1.4:=[profile?]
	>=dev-haskell/io-streams-haproxy-1.0:=[profile?] <dev-haskell/io-streams-haproxy-1.1:=[profile?]
	>=dev-haskell/lifted-base-0.1:=[profile?] <dev-haskell/lifted-base-0.3:=[profile?]
	>=dev-haskell/mtl-2.0:=[profile?] <dev-haskell/mtl-2.3:=[profile?]
	>=dev-haskell/network-2.3:=[profile?] <dev-haskell/network-2.7:=[profile?]
	>=dev-haskell/old-locale-1.0:=[profile?] <dev-haskell/old-locale-1.1:=[profile?]
	>=dev-haskell/snap-core-1.0:=[profile?] <dev-haskell/snap-core-1.1:=[profile?]
	>=dev-haskell/text-0.11:=[profile?] <dev-haskell/text-1.3:=[profile?]
	>=dev-haskell/unix-compat-0.2:=[profile?] <dev-haskell/unix-compat-0.5:=[profile?]
	>=dev-haskell/vector-0.7:=[profile?] <dev-haskell/vector-0.12:=[profile?]
	>=dev-lang/ghc-7.4.1:=
	openssl? ( >=dev-haskell/hsopenssl-0.10.4:=[profile?] <dev-haskell/hsopenssl-0.12:=[profile?]
			>=dev-haskell/openssl-streams-1.1:=[profile?] <dev-haskell/openssl-streams-1.3:=[profile?] )
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.10
	test? ( >=dev-haskell/base16-bytestring-0.1 <dev-haskell/base16-bytestring-0.2
		>=dev-haskell/http-common-0.7 <dev-haskell/http-common-0.9
		>=dev-haskell/http-streams-0.7 <dev-haskell/http-streams-0.9
		>=dev-haskell/hunit-1.2 <dev-haskell/hunit-2
		>=dev-haskell/monad-control-1.0 <dev-haskell/monad-control-1.1
		>=dev-haskell/parallel-3 <dev-haskell/parallel-4
		>=dev-haskell/quickcheck-2.3.0.2 <dev-haskell/quickcheck-3
		>=dev-haskell/random-1.0 <dev-haskell/random-1.2
		>=dev-haskell/test-framework-0.8.0.3 <dev-haskell/test-framework-0.9
		>=dev-haskell/test-framework-hunit-0.2.7 <dev-haskell/test-framework-hunit-0.4
		>=dev-haskell/test-framework-quickcheck2-0.2.12.1 <dev-haskell/test-framework-quickcheck2-0.4
		>=dev-haskell/threads-0.5 <dev-haskell/threads-0.6
		>=dev-haskell/transformers-0.3 <dev-haskell/transformers-0.6 )
"

src_prepare() {
	default

	cabal_chdeps \
		'directory                           >= 1.0      && < 1.3' 'directory                           >= 1.0' \
		'directory                           >= 1.1      && < 1.3' 'directory                           >= 1.1'
}

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag build-pong build-pong) \
		$(cabal_flag debug debug) \
		$(cabal_flag openssl openssl) \
		$(cabal_flag portable portable)
}
