# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=5

inherit eutils multilib

# weird failures
RESTRICT="test"

DESCRIPTION="Virtual machine designed to compile and execute bytecode for dynamic languages"
HOMEPAGE="http://www.parrot.org/"
SRC_URI="ftp://ftp.parrot.org/pub/parrot/releases/all/${PV}/${P}.tar.gz"

LICENSE="Artistic-2"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~ppc ~ppc64 ~sparc ~x86 ~amd64-linux ~x86-linux ~ppc-macos ~x64-macos ~x86-macos"
IUSE="opengl nls doc examples gdbm +gmp ssl +unicode pcre"

RDEPEND="sys-libs/readline:0=
	dev-libs/libffi
	opengl? ( media-libs/freeglut )
	nls? ( sys-devel/gettext )
	unicode? ( >=dev-libs/icu-2.6:= )
	gdbm? ( >=sys-libs/gdbm-1.8.3-r1 )
	gmp? ( >=dev-libs/gmp-4.1.4:0= )
	ssl? ( dev-libs/openssl:0= )
	pcre? ( dev-libs/libpcre )
	doc? ( dev-perl/JSON )"

DEPEND="dev-lang/perl[doc?]
	${RDEPEND}"

src_configure() {
	myconf="--disable-rpath"
	use unicode || myconf+=" --without-icu"
	use ssl     || myconf+=" --without-crypto"
	use gdbm    || myconf+=" --without-gdbm"
	use nls     || myconf+=" --without-gettext"
	use gmp     || myconf+=" --without-gmp"
	use opengl  || myconf+=" --without-opengl"
	use pcre    || myconf+=" --without-pcre"

	perl Configure.pl \
		--ccflags="${CFLAGS}" \
		--linkflags="${LDFLAGS}" \
		--prefix="${EPREFIX}"/usr \
		--libdir="${EPREFIX}"/usr/$(get_libdir) \
		--mandir="${EPREFIX}"/usr/share/man \
		--sysconfdir="${EPREFIX}"/etc \
		--sharedstatedir="${EPREFIX}"/var/lib/parrot \
		$myconf || die
}

src_compile() {
	export LD_LIBRARY_PATH=${LD_LIBRARY_PATH:+$LD_LIBRARY_PATH:}"${S}"/blib/lib
	# occasionally dies in parallel make
	emake -j1
	if use doc ; then
		emake -j1 html
	fi
}

src_test() {
	emake -j1 test
}

src_install() {
	emake -j1 install-dev DESTDIR="${D}" DOC_DIR="${EPREFIX}/usr/share/doc/${PF}"
	dodoc CREDITS DONORS.pod PBC_COMPAT PLATFORMS RESPONSIBLE_PARTIES TODO
	dosym parrot-ops2c /usr/bin/ops2c
	if use examples; then
		insinto "/usr/share/doc/${PF}/examples"
		doins -r examples/*
	fi
	if use doc; then
		insinto "/usr/share/doc/${PF}/editor"
		doins -r editor
		cd docs/html
		dohtml -r developer.html DONORS.pod.html index.html ops.html parrotbug.html pdds.html \
			pmc.html tools.html docs src tools || die
	fi
}
