# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI="5"

inherit base autotools pax-utils

MY_P="${PN}.${PV}"

DESCRIPTION="Poly/ML is a full implementation of Standard ML"
HOMEPAGE="https://www.polyml.org"
SRC_URI="mirror://sourceforge/${PN}/${MY_P}.tar.gz"

LICENSE="LGPL-2.1"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~x86"
IUSE="X elibc_glibc +gmp portable test +threads"
RESTRICT="!test? ( test )"

RDEPEND="X? ( x11-libs/motif:0 )
		gmp? ( >=dev-libs/gmp-5 )
		elibc_glibc? ( threads? ( >=sys-libs/glibc-2.13 ) )
		virtual/libffi"
DEPEND="${RDEPEND}"

S=${WORKDIR}/${MY_P}

PATCHES=(
	# Bug 256679 - patch the assembler code.  The remaining executable stacks in ./.libs/poly
	# comes from the polyml generated ./polyexport.o file.
	"${FILESDIR}/${PN}-5.5.0-asm.patch"
	# Patches from https://sourceforge.net/p/polyml/code/HEAD/tree/fixes-5.5.2
	# which are required to build and run sci-mathematics/isabelle-2015
	"${FILESDIR}/${PN}-5.5.2-r1952-check_for_negative_sized_array.patch"
	"${FILESDIR}/${PN}-5.5.2-r1954_Fix_segfault_in_FFI_when_malloc_runs_out_of_memory.patch"
	"${FILESDIR}/${PN}-5.5.2-r2007_Ensure_the_large_object_cache_pointer_is_cleared.patch"
	"${FILESDIR}/${PN}-5.5.2-r2009_Initialise_the_largeObjectCache_fully_in_the_constructor.patch"
)

src_prepare() {
	base_src_prepare
	eautoreconf
	if [ -f "${S}/Tests/Succeed/Test146.ML" ]; then
		mv "${S}/Tests/Succeed/Test146.ML" "${S}/Tests/Succeed/Test146.ML.disable-test-as-it-fails"
	fi
}

src_configure() {
	econf \
		--enable-shared \
		--disable-static \
		--with-system-libffi \
		$(use_with X x) \
		$(use_with gmp) \
		$(use_with portable) \
		$(use_with threads)
}

src_compile() {
	# Bug 453146 - dev-lang/polyml-5.5.0: fails to build (pax kernel?)
	pushd libpolyml || die "Could not cd to libpolyml"
	emake
	popd
	emake polyimport
	pax-mark m "${S}/.libs/polyimport"
	emake
	pax-mark m "${S}/.libs/poly"
}

src_test() {
	emake tests
}
