# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6

DIST_AUTHOR=SKONNO
inherit perl-module

DESCRIPTION="Perl extension for UPnP"

LICENSE="BSD"
SLOT="0"
KEYWORDS="amd64 ppc x86 ~x86-solaris"
# Package warrants IUSE examples
IUSE="examples test"
RESTRICT="!test? ( test )"

RDEPEND="virtual/perl-version"
DEPEND="${RDEPEND}
	dev-perl/Module-Build
	test? ( virtual/perl-Test-Simple )
"
src_install() {
	perl-module_src_install
	if use examples; then
		dodir usr/share/doc/${PF}/examples
		docompress -x usr/share/doc/${PF}/examples
		insinto usr/share/doc/${PF}/
		doins -r examples/
	fi
}
