# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6

PYTHON_COMPAT=( python3_6 pypy3 )

inherit distutils-r1

DESCRIPTION="A strictly RFC 4511 conforming LDAP V3 pure Python client"
HOMEPAGE="https://github.com/cannatag/ldap3 https://pypi.org/project/ldap3/"
SRC_URI="mirror://pypi/${PN:0:1}/${PN}/${P}.tar.gz"

LICENSE="LGPL-3"
SLOT="0"
KEYWORDS="~amd64"
IUSE="test"
# The tests are a mess, and the test config is not included in the
# PyPi tarball (see https://travis-ci.org/cannatag/ldap3 and
# https://github.com/cannatag/ldap3/blob/master/test/config.py).
RESTRICT="test"

RDEPEND="
	dev-python/pyasn1[${PYTHON_USEDEP}]"

DEPEND="
	dev-python/setuptools[${PYTHON_USEDEP}]
	test? (
		dev-python/nose[${PYTHON_USEDEP}]
		${RDEPEND} )"

python_test() {
	nosetests -v -s test || die
}
