# Copyright 1999-2019 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=6

inherit autotools

DESCRIPTION="Guile bindings of sqlite3"
HOMEPAGE="https://notabug.org/guile-sqlite3/guile-sqlite3"
SRC_URI="https://notabug.org/guile-sqlite3/guile-sqlite3/archive/v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="LGPL-3+ GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE=""

RDEPEND="
	>=dev-scheme/guile-2.0.11:=
	dev-db/sqlite:3=
"
DEPEND="${RDEPEND}"

S=${WORKDIR}/${PN}

src_prepare() {
	default

	# upstream tag on top of source tree. has no autogenerated files
	eautoreconf
}
