# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python3_{6,7,8} )

inherit distutils-r1

DESCRIPTION="Compiler of NML files into GRF/NFO files"
HOMEPAGE="https://dev.openttdcoop.org/projects/nml"
SRC_URI="https://bundles.openttdcoop.org/nml/releases/${PV}/${P}.tar.gz"

LICENSE="GPL-2+"
SLOT="0"
KEYWORDS="~amd64 ~arm ~x86"

RDEPEND="
	dev-python/pillow[zlib,${PYTHON_USEDEP}]
	dev-python/ply[${PYTHON_USEDEP}]
"

DEPEND="
	${RDEPEND}
	dev-python/setuptools[${PYTHON_USEDEP}]
"

DOCS=( docs/{changelog,readme}.txt )

PATCHES=(
	"${FILESDIR}"/${PN}-0.4.4-pillow3.patch
	"${FILESDIR}"/${PN}-0.4.5-pillow6.patch
	"${FILESDIR}"/${PN}-0.4.5-pillow7.patch
)

src_install() {
	distutils-r1_src_install

	doman docs/nmlc.1
}
