# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

PYTHON_COMPAT=( python2_7 )
PYTHON_REQ_USE='sqlite'

inherit python-single-r1

ARTWORK_PV="0.9.4"

DESCRIPTION="Movie collection manager"
HOMEPAGE="http://www.griffith.cc/"
SRC_URI="https://launchpad.net/${PN}/trunk/${PV}/+download/${P}.tar.gz
	https://dev.gentoo.org/~hwoarang/distfiles/${PN}-extra-artwork-${ARTWORK_PV}.tar.gz"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 x86"
IUSE="doc"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

RDEPEND="
	${PYTHON_DEPS}
	gnome-base/libglade[${PYTHON_SINGLE_USEDEP}]
	$(python_gen_cond_dep '
		dev-python/pillow[${PYTHON_MULTI_USEDEP}]
		>=dev-python/pygtk-2.6.1:2[${PYTHON_MULTI_USEDEP}]
		dev-python/pygobject:2[${PYTHON_MULTI_USEDEP}]
		>=dev-python/sqlalchemy-0.5.2[${PYTHON_MULTI_USEDEP}]
		>=dev-python/reportlab-1.19[${PYTHON_MULTI_USEDEP}]
	')"
DEPEND="${RDEPEND}
	doc? ( app-text/docbook2X )"

PATCHES=(
	"${FILESDIR}/0.10-fix_lib_path.patch"
	"${FILESDIR}/griffith-0.13-validators.patch"
)

pkg_setup() {
	python-single-r1_pkg_setup
}

src_prepare() {
	use doc || { sed -i -e '/docs/d' Makefile || die ; }
	sed -i \
		-e 's#/pl/#/pl.UTF-8/#' \
		"${S}"/docs/pl/Makefile || die "sed failed"

	sed -i \
		-e 's/ISO-8859-1/UTF-8/' \
		"${S}"/lib/gconsole.py || die "sed failed"

	default
}

src_compile() {
	# Nothing to compile and default `emake` spews an error message
	true
}

src_install() {
	if ! use doc ; then
		sed -i -e '/docs/d' Makefile || die
	fi

	emake \
		LIBDIR="${D}/usr/$(get_libdir)/griffith" \
		DESTDIR="${D}" DOC2MAN=docbook2man.pl install
	dodoc AUTHORS ChangeLog README THANKS TODO NEWS TRANSLATORS

	cd "${WORKDIR}/${PN}-extra-artwork-${ARTWORK_PV}/" || die
	emake DESTDIR="${D}" install
	# This carries over from -0.13 but appears to have no effect.
	python_optimize "${ED}"/usr/share/${PN}
}

pkg_postinst() {
	einfo
	einfo "${PN} can make use of the following optional dependencies"
	einfo "dev-python/chardet: CSV file encoding detections"
	einfo "dev-python/mysql-python: Python interface for MySQL connectivity"
	einfo ">=dev-python/psycopg-2.4: Python interface for PostgreSQL connectivity"
	einfo
}
