# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=5

PYTHON_COMPAT=( python2_7 )
DISTUTILS_SINGLE_IMPL=1

inherit distutils-r1

DESCRIPTION="A mail user agent auto configuration service"
HOMEPAGE="http://www.automx.org"
SRC_URI="https://github.com/sys4/${PN}/archive/v${PV}.tar.gz -> automx-${PV}.tgz"

LICENSE="GPL-3"
SLOT="0"
KEYWORDS="amd64 x86"
IUSE="ldap memcached sql +tools"

DEPEND="
	$(python_gen_cond_dep '
		dev-python/ipaddr[${PYTHON_MULTI_USEDEP}]
		dev-python/lxml[${PYTHON_MULTI_USEDEP}]
		dev-python/m2crypto[${PYTHON_MULTI_USEDEP}]
		dev-python/python-dateutil[${PYTHON_MULTI_USEDEP}]
		|| ( www-apache/mod_wsgi[${PYTHON_MULTI_USEDEP}] www-servers/uwsgi )
		ldap? ( dev-python/python-ldap[${PYTHON_MULTI_USEDEP}]  )
		memcached? ( dev-python/python-memcached[${PYTHON_MULTI_USEDEP}] )
		sql? ( dev-python/sqlalchemy[${PYTHON_MULTI_USEDEP}] )
	')
	tools? ( net-dns/bind-tools net-misc/wget )
	"
RDEPEND="${DEPEND}"

python_prepare_all() {
	sed -i '/py_modules=/d' setup.py || die
	distutils-r1_python_prepare_all
}

python_install_all() {
	DOCS=( INSTALL CREDITS CHANGES BASIC_CONFIGURATION_README )
	HTML_DOCS=( doc/html/. )

	distutils-r1_python_install_all

	docinto examples
	dodoc src/conf/*example*

	doman doc/man/man5/*

	if use tools; then
		dobin src/automx-test
		doman doc/man/man1/automx-test.1
	fi

	exeinto /usr/lib/${PN}
	doexe src/automx_wsgi.py
}

pkg_postinst() {
	echo
	einfo "See /usr/share/doc/${PF}/INSTALL.bz2 for setup instructions"
	echo
}
