# Copyright 1999-2020 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=5
inherit autotools eutils ltprune toolchain-funcs

DESCRIPTION="pfqueue is an ncurses console-based tool for managing Postfix queued messages"
HOMEPAGE="http://pfqueue.sourceforge.net/"
SRC_URI="mirror://sourceforge/${PN}/${P}.tar.gz"
LICENSE="GPL-2"
SLOT="0"
KEYWORDS="amd64 ppc x86"

RDEPEND="
	sys-libs/ncurses
	sys-devel/libtool
"
DEPEND="${RDEPEND}"

src_prepare() {
	epatch "${FILESDIR}"/${P}-tinfo.patch
	eautoreconf
}

src_configure() {
	econf --disable-static
}

DOCS=( README ChangeLog NEWS TODO AUTHORS )

src_install() {
	default
	prune_libtool_files
}
