# gap> LoadPackage( "ToricVarieties" );
# true
# gap> P18:=Polytope( [[0,0],[1,0],[0,1],[8,1]] );
# <A polytope in |R^2>
# gap> H7 :=ToricVariety(P18);
# <A projective toric variety of dimension 2>
# gap> CoxRing(H7);
# polymake: used package cddlib
#   Implementation of the double description method of Motzkin et al.
#   Copyright by Komei Fukuda.
#   http://www.ifor.math.ethz.ch/~fukuda/cdd_home/cdd.html
# 
# ----------------------------------------------------------------
# Loading  IO_ForHomalg 2011.07.25
# by Thomas Bächler (http://wwwb.math.rwth-aachen.de/~thomas/)
#    Mohamed Barakat (http://www.mathematik.uni-kl.de/~barakat/)
#    Max Neunhöffer (http://www-groups.mcs.st-and.ac.uk/~neunhoef/)
#    Daniel Robertz (http://wwwb.math.rwth-aachen.de/~daniel/)
# For help, type: ?IO_ForHomalg package 
# ----------------------------------------------------------------
# ================================================================
#                      SINGULAR                                 /
#  A Computer Algebra System for Polynomial Computations       /   version 3-1-3
#                                                            0<
#  by: W. Decker, G.-M. Greuel, G. Pfister, H. Schoenemann     \   March 2011
# FB Mathematik der Universitaet, D-67653 Kaiserslautern        \
# ================================================================
# Q[x_1,x_2,x_3,x_4]
# (weights: [ [ 0, 0, -7, 1 ], [ 0, 0, 1, 0 ], [ 0, 0, 1, 0 ], [ 0, 0, 0, 1 ] ])
# gap> Display(ByASmallerPresentation(ClassGroup(H7)));
# Z^(1 x 2)
# gap> CoxRing(H7);
# Q[x_1,x_2,x_3,x_4]
# (weights: [ [ -7, 1 ], [ 1, 0 ], [ 1, 0 ], [ 0, 1 ] ])
# gap> IrrelevantIdeal(H7);
# <A torsion-free (left) ideal given by 4 generators>
# gap> Display(last);
# x_3*x_4,
# x_2*x_4,
# x_1*x_3,
# x_1*x_2 
# (over a graded ring)
# 
# A (left) ideal generated by the 4 entries of the above matrix
# gap> D:=Divisor([1,2,-1,-2],H7);
# <A divisor of a toric variety with coordinates [ 1, 2, -1, -2 ]>
# gap> ClassOfDivisor(D);
# [ -6, -1 ]
# gap> MonomsOfCoxRingOfDegree(D);
# [  ]
# gap> D2:=Divisor([1,2,1,2],H7);
# <A divisor of a toric variety with coordinates [ 1, 2, 1, 2 ]>
# gap> ClassOfDivisor(D2);
# [ -4, 3 ]
# gap> MonomsOfCoxRingOfDegree(D2);
# [ x_1*x_3^3*x_4^2, x_1^2*x_3^10*x_4, x_1^3*x_3^17, x_1*x_2*x_3^2*x_4^2, x_1^2*x_2*x_3^9*x_4, x_1^3*x_2*x_3^16, x_1*x_2^2*x_3*x_4^2, x_1^2*x_2^2*x_3^8*x_4, 
#   x_1^3*x_2^2*x_3^15, x_1*x_2^3*x_4^2, x_1^2*x_2^3*x_3^7*x_4, x_1^3*x_2^3*x_3^14, x_1^2*x_2^4*x_3^6*x_4, x_1^3*x_2^4*x_3^13, x_1^2*x_2^5*x_3^5*x_4, 
#   x_1^3*x_2^5*x_3^12, x_1^2*x_2^6*x_3^4*x_4, x_1^3*x_2^6*x_3^11, x_1^2*x_2^7*x_3^3*x_4, x_1^3*x_2^7*x_3^10, x_1^2*x_2^8*x_3^2*x_4, x_1^3*x_2^8*x_3^9, 
#   x_1^2*x_2^9*x_3*x_4, x_1^3*x_2^9*x_3^8, x_1^2*x_2^10*x_4, x_1^3*x_2^10*x_3^7, x_1^3*x_2^11*x_3^6, x_1^3*x_2^12*x_3^5, x_1^3*x_2^13*x_3^4, x_1^3*x_2^14*x_3^3, 
#   x_1^3*x_2^15*x_3^2, x_1^3*x_2^16*x_3, x_1^3*x_2^17 ]

LoadPackage( "ToricVarieties" );
P18:=Polytope( [[0,0],[1,0],[0,1],[8,1]] );
H7 :=ToricVariety(P18);
CoxRing(H7);
Display(ByASmallerPresentation(ClassGroup(H7)));
CoxRing(H7);
IrrelevantIdeal(H7);
Display(last);
D:=Divisor([1,2,-1,-2],H7);
ClassOfDivisor(D);
MonomsOfCoxRingOfDegree(D);
D2:=Divisor([1,2,1,2],H7);
ClassOfDivisor(D2);
MonomsOfCoxRingOfDegree(D2);