# distutils: libraries = flint
# distutils: depends = flint/fq_poly.h

################################################################################
# This file is auto-generated by the script
#   SAGE_ROOT/src/sage_setup/autogen/flint_autogen.py.
# Do not modify by hand! Fix and rerun the script instead.
################################################################################

from libc.stdio cimport FILE
from sage.libs.gmp.types cimport *
from sage.libs.mpfr.types cimport *
from sage.libs.flint.types cimport *

cdef extern from "flint_wrap.h":
    void fq_poly_init(fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void fq_poly_init2(fq_poly_t poly, slong alloc, const fq_ctx_t ctx) noexcept
    void fq_poly_realloc(fq_poly_t poly, slong alloc, const fq_ctx_t ctx) noexcept
    void fq_poly_fit_length(fq_poly_t poly, slong len, const fq_ctx_t ctx) noexcept
    void _fq_poly_set_length(fq_poly_t poly, slong newlen, const fq_ctx_t ctx) noexcept
    void fq_poly_clear(fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void _fq_poly_normalise(fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void _fq_poly_normalise2(const fq_struct * poly, slong * length, const fq_ctx_t ctx) noexcept
    void fq_poly_truncate(fq_poly_t poly, slong newlen, const fq_ctx_t ctx) noexcept
    void fq_poly_set_trunc(fq_poly_t poly1, fq_poly_t poly2, slong newlen, const fq_ctx_t ctx) noexcept
    void _fq_poly_reverse(fq_struct * output, const fq_struct * input, slong len, slong m, const fq_ctx_t ctx) noexcept
    void fq_poly_reverse(fq_poly_t output, const fq_poly_t input, slong m, const fq_ctx_t ctx) noexcept
    slong fq_poly_degree(const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    slong fq_poly_length(const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    fq_struct * fq_poly_lead(const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void fq_poly_randtest(fq_poly_t f, flint_rand_t state, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_randtest_not_zero(fq_poly_t f, flint_rand_t state, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_randtest_monic(fq_poly_t f, flint_rand_t state, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_randtest_irreducible(fq_poly_t f, flint_rand_t state, slong len, const fq_ctx_t ctx) noexcept
    void _fq_poly_set(fq_struct * rop, const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_set(fq_poly_t poly1, const fq_poly_t poly2, const fq_ctx_t ctx) noexcept
    void fq_poly_set_fq(fq_poly_t poly, const fq_t c, const fq_ctx_t ctx) noexcept
    void fq_poly_set_fmpz_mod_poly(fq_poly_t rop, const fmpz_mod_poly_t op, const fq_ctx_t ctx) noexcept
    void fq_poly_set_nmod_poly(fq_poly_t rop, const nmod_poly_t op, const fq_ctx_t ctx) noexcept
    void fq_poly_swap(fq_poly_t op1, fq_poly_t op2, const fq_ctx_t ctx) noexcept
    void _fq_poly_zero(fq_struct * rop, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_zero(fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void fq_poly_one(fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void fq_poly_gen(fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void fq_poly_make_monic(fq_poly_t rop, const fq_poly_t op, const fq_ctx_t ctx) noexcept
    void _fq_poly_make_monic(fq_struct * rop, const fq_struct * op, slong length, const fq_ctx_t ctx) noexcept
    void fq_poly_get_coeff(fq_t x, const fq_poly_t poly, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_set_coeff(fq_poly_t poly, slong n, const fq_t x, const fq_ctx_t ctx) noexcept
    void fq_poly_set_coeff_fmpz(fq_poly_t poly, slong n, const fmpz_t x, const fq_ctx_t ctx) noexcept
    bint fq_poly_equal(const fq_poly_t poly1, const fq_poly_t poly2, const fq_ctx_t ctx) noexcept
    bint fq_poly_equal_trunc(const fq_poly_t poly1, const fq_poly_t poly2, slong n, const fq_ctx_t ctx) noexcept
    bint fq_poly_is_zero(const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    bint fq_poly_is_one(const fq_poly_t op, const fq_ctx_t ctx) noexcept
    bint fq_poly_is_gen(const fq_poly_t op, const fq_ctx_t ctx) noexcept
    bint fq_poly_is_unit(const fq_poly_t op, const fq_ctx_t ctx) noexcept
    bint fq_poly_equal_fq(const fq_poly_t poly, const fq_t c, const fq_ctx_t ctx) noexcept
    void _fq_poly_add(fq_struct * res, const fq_struct * poly1, slong len1, const fq_struct * poly2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_add(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, const fq_ctx_t ctx) noexcept
    void fq_poly_add_si(fq_poly_t res, const fq_poly_t poly1, slong c, const fq_ctx_t ctx) noexcept
    void fq_poly_add_series(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_sub(fq_struct * res, const fq_struct * poly1, slong len1, const fq_struct * poly2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_sub(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, const fq_ctx_t ctx) noexcept
    void fq_poly_sub_series(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_neg(fq_struct * rop, const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_neg(fq_poly_t res, const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    void _fq_poly_scalar_mul_fq(fq_struct * rop, const fq_struct * op, slong len, const fq_t x, const fq_ctx_t ctx) noexcept
    void fq_poly_scalar_mul_fq(fq_poly_t rop, const fq_poly_t op, const fq_t x, const fq_ctx_t ctx) noexcept
    void _fq_poly_scalar_addmul_fq(fq_struct * rop, const fq_struct * op, slong len, const fq_t x, const fq_ctx_t ctx) noexcept
    void fq_poly_scalar_addmul_fq(fq_poly_t rop, const fq_poly_t op, const fq_t x, const fq_ctx_t ctx) noexcept
    void _fq_poly_scalar_submul_fq(fq_struct * rop, const fq_struct * op, slong len, const fq_t x, const fq_ctx_t ctx) noexcept
    void fq_poly_scalar_submul_fq(fq_poly_t rop, const fq_poly_t op, const fq_t x, const fq_ctx_t ctx) noexcept
    void _fq_poly_scalar_div_fq(fq_struct * rop, const fq_struct * op, slong len, const fq_t x, const fq_ctx_t ctx) noexcept
    void fq_poly_scalar_div_fq(fq_poly_t rop, const fq_poly_t op, const fq_t x, const fq_ctx_t ctx) noexcept
    void _fq_poly_mul_classical(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_mul_classical(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, const fq_ctx_t ctx) noexcept
    void _fq_poly_mul_reorder(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_mul_reorder(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, const fq_ctx_t ctx) noexcept
    void _fq_poly_mul_univariate(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_mul_univariate(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, const fq_ctx_t ctx) noexcept
    void _fq_poly_mul_KS(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_mul_KS(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, const fq_ctx_t ctx) noexcept
    void _fq_poly_mul(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_mul(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, const fq_ctx_t ctx) noexcept
    void _fq_poly_mullow_classical(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_mullow_classical(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_mullow_univariate(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_mullow_univariate(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_mullow_KS(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_mullow_KS(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_mullow(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_mullow(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_mulhigh_classical(fq_struct * res, const fq_struct * poly1, slong len1, const fq_struct * poly2, slong len2, slong start, const fq_ctx_t ctx) noexcept
    void fq_poly_mulhigh_classical(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, slong start, const fq_ctx_t ctx) noexcept
    void _fq_poly_mulhigh(fq_struct * res, const fq_struct * poly1, slong len1, const fq_struct * poly2, slong len2, slong start, fq_ctx_t ctx) noexcept
    void fq_poly_mulhigh(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, slong start, const fq_ctx_t ctx) noexcept
    void _fq_poly_mulmod(fq_struct * res, const fq_struct * poly1, slong len1, const fq_struct * poly2, slong len2, const fq_struct * f, slong lenf, const fq_ctx_t ctx) noexcept
    void fq_poly_mulmod(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, const fq_poly_t f, const fq_ctx_t ctx) noexcept
    void _fq_poly_mulmod_preinv(fq_struct * res, const fq_struct * poly1, slong len1, const fq_struct * poly2, slong len2, const fq_struct * f, slong lenf, const fq_struct * finv, slong lenfinv, const fq_ctx_t ctx) noexcept
    void fq_poly_mulmod_preinv(fq_poly_t res, const fq_poly_t poly1, const fq_poly_t poly2, const fq_poly_t f, const fq_poly_t finv, const fq_ctx_t ctx) noexcept
    void _fq_poly_sqr_classical(fq_struct * rop, const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_sqr_classical(fq_poly_t rop, const fq_poly_t op, const fq_ctx_t ctx) noexcept
    void _fq_poly_sqr_reorder(fq_struct * rop, const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_sqr_reorder(fq_poly_t rop, const fq_poly_t op, const fq_ctx_t ctx) noexcept
    void _fq_poly_sqr_KS(fq_struct * rop, const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_sqr_KS(fq_poly_t rop, const fq_poly_t op, const fq_ctx_t ctx) noexcept
    void _fq_poly_sqr(fq_struct * rop, const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_sqr(fq_poly_t rop, const fq_poly_t op, const fq_ctx_t ctx) noexcept
    void _fq_poly_pow(fq_struct * rop, const fq_struct * op, slong len, ulong e, const fq_ctx_t ctx) noexcept
    void fq_poly_pow(fq_poly_t rop, const fq_poly_t op, ulong e, const fq_ctx_t ctx) noexcept
    void _fq_poly_powmod_ui_binexp(fq_struct * res, const fq_struct * poly, ulong e, const fq_struct * f, slong lenf, const fq_ctx_t ctx) noexcept
    void fq_poly_powmod_ui_binexp(fq_poly_t res, const fq_poly_t poly, ulong e, const fq_poly_t f, const fq_ctx_t ctx) noexcept
    void _fq_poly_powmod_ui_binexp_preinv(fq_struct * res, const fq_struct * poly, ulong e, const fq_struct * f, slong lenf, const fq_struct * finv, slong lenfinv, const fq_ctx_t ctx) noexcept
    void fq_poly_powmod_ui_binexp_preinv(fq_poly_t res, const fq_poly_t poly, ulong e, const fq_poly_t f, const fq_poly_t finv, const fq_ctx_t ctx) noexcept
    void _fq_poly_powmod_fmpz_binexp(fq_struct * res, const fq_struct * poly, const fmpz_t e, const fq_struct * f, slong lenf, const fq_ctx_t ctx) noexcept
    void fq_poly_powmod_fmpz_binexp(fq_poly_t res, const fq_poly_t poly, const fmpz_t e, const fq_poly_t f, const fq_ctx_t ctx) noexcept
    void _fq_poly_powmod_fmpz_binexp_preinv(fq_struct * res, const fq_struct * poly, const fmpz_t e, const fq_struct * f, slong lenf, const fq_struct * finv, slong lenfinv, const fq_ctx_t ctx) noexcept
    void fq_poly_powmod_fmpz_binexp_preinv(fq_poly_t res, const fq_poly_t poly, const fmpz_t e, const fq_poly_t f, const fq_poly_t finv, const fq_ctx_t ctx) noexcept
    void _fq_poly_powmod_fmpz_sliding_preinv(fq_struct * res, const fq_struct * poly, const fmpz_t e, ulong k, const fq_struct * f, slong lenf, const fq_struct * finv, slong lenfinv, const fq_ctx_t ctx) noexcept
    void fq_poly_powmod_fmpz_sliding_preinv(fq_poly_t res, const fq_poly_t poly, const fmpz_t e, ulong k, const fq_poly_t f, const fq_poly_t finv, const fq_ctx_t ctx) noexcept
    void _fq_poly_powmod_x_fmpz_preinv(fq_struct * res, const fmpz_t e, const fq_struct * f, slong lenf, const fq_struct * finv, slong lenfinv, const fq_ctx_t ctx) noexcept
    void fq_poly_powmod_x_fmpz_preinv(fq_poly_t res, const fmpz_t e, const fq_poly_t f, const fq_poly_t finv, const fq_ctx_t ctx) noexcept
    void _fq_poly_pow_trunc_binexp(fq_struct * res, const fq_struct * poly, ulong e, slong trunc, const fq_ctx_t ctx) noexcept
    void fq_poly_pow_trunc_binexp(fq_poly_t res, const fq_poly_t poly, ulong e, slong trunc, const fq_ctx_t ctx) noexcept
    void _fq_poly_pow_trunc(fq_struct * res, const fq_struct * poly, ulong e, slong trunc, const fq_ctx_t mod) noexcept
    void fq_poly_pow_trunc(fq_poly_t res, const fq_poly_t poly, ulong e, slong trunc, const fq_ctx_t ctx) noexcept
    void _fq_poly_shift_left(fq_struct * rop, const fq_struct * op, slong len, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_shift_left(fq_poly_t rop, const fq_poly_t op, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_shift_right(fq_struct * rop, const fq_struct * op, slong len, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_shift_right(fq_poly_t rop, const fq_poly_t op, slong n, const fq_ctx_t ctx) noexcept
    slong _fq_poly_hamming_weight(const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    slong fq_poly_hamming_weight(const fq_poly_t op, const fq_ctx_t ctx) noexcept
    void _fq_poly_divrem(fq_struct * Q, fq_struct * R, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_t invB, const fq_ctx_t ctx) noexcept
    void fq_poly_divrem(fq_poly_t Q, fq_poly_t R, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    void fq_poly_divrem_f(fq_t f, fq_poly_t Q, fq_poly_t R, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    void _fq_poly_rem(fq_struct * R, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_t invB, const fq_ctx_t ctx) noexcept
    void fq_poly_rem(fq_poly_t R, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    void _fq_poly_div(fq_struct * Q, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_t invB, const fq_ctx_t ctx) noexcept
    void fq_poly_div(fq_poly_t Q, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    void _fq_poly_div_newton_n_preinv(fq_struct * Q, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_struct * Binv, slong lenBinv, const fq_ctx_t ctx) noexcept
    void fq_poly_div_newton_n_preinv(fq_poly_t Q, const fq_poly_t A, const fq_poly_t B, const fq_poly_t Binv, const fq_ctx_t ctx) noexcept
    void _fq_poly_divrem_newton_n_preinv(fq_struct * Q, fq_struct * R, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_struct * Binv, slong lenBinv, const fq_ctx_t ctx) noexcept
    void fq_poly_divrem_newton_n_preinv(fq_poly_t Q, fq_poly_t R, const fq_poly_t A, const fq_poly_t B, const fq_poly_t Binv, const fq_ctx_t ctx) noexcept
    void _fq_poly_inv_series_newton(fq_struct * Qinv, const fq_struct * Q, slong n, const fq_t cinv, const fq_ctx_t ctx) noexcept
    void fq_poly_inv_series_newton(fq_poly_t Qinv, const fq_poly_t Q, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_inv_series(fq_struct * Qinv, const fq_struct * Q, slong n, const fq_t cinv, const fq_ctx_t ctx) noexcept
    void fq_poly_inv_series(fq_poly_t Qinv, const fq_poly_t Q, slong n, const fq_ctx_t ctx) noexcept
    void _fq_poly_div_series(fq_struct * Q, const fq_struct * A, slong Alen, const fq_struct * B, slong Blen, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_div_series(fq_poly_t Q, const fq_poly_t A, const fq_poly_t B, slong n, const fq_ctx_t ctx) noexcept
    void fq_poly_gcd(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, const fq_ctx_t ctx) noexcept
    slong _fq_poly_gcd(fq_struct * G, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_ctx_t ctx) noexcept
    slong _fq_poly_gcd_euclidean_f(fq_t f, fq_struct * G, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_ctx_t ctx) noexcept
    void fq_poly_gcd_euclidean_f(fq_t f, fq_poly_t G, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    slong _fq_poly_xgcd(fq_struct * G, fq_struct * S, fq_struct * T, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_ctx_t ctx) noexcept
    void fq_poly_xgcd(fq_poly_t G, fq_poly_t S, fq_poly_t T, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    slong _fq_poly_xgcd_euclidean_f(fq_t f, fq_struct * G, fq_struct * S, fq_struct * T, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_ctx_t ctx) noexcept
    void fq_poly_xgcd_euclidean_f(fq_t f, fq_poly_t G, fq_poly_t S, fq_poly_t T, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    int _fq_poly_divides(fq_struct * Q, const fq_struct * A, slong lenA, const fq_struct * B, slong lenB, const fq_t invB, const fq_ctx_t ctx) noexcept
    int fq_poly_divides(fq_poly_t Q, const fq_poly_t A, const fq_poly_t B, const fq_ctx_t ctx) noexcept
    void _fq_poly_derivative(fq_struct * rop, const fq_struct * op, slong len, const fq_ctx_t ctx) noexcept
    void fq_poly_derivative(fq_poly_t rop, const fq_poly_t op, const fq_ctx_t ctx) noexcept
    void _fq_poly_invsqrt_series(fq_struct * g, const fq_struct * h, slong n, fq_ctx_t mod) noexcept
    void fq_poly_invsqrt_series(fq_poly_t g, const fq_poly_t h, slong n, fq_ctx_t ctx) noexcept
    void _fq_poly_sqrt_series(fq_struct * g, const fq_struct * h, slong n, fq_ctx_t ctx) noexcept
    void fq_poly_sqrt_series(fq_poly_t g, const fq_poly_t h, slong n, fq_ctx_t ctx) noexcept
    int _fq_poly_sqrt(fq_struct * s, const fq_struct * p, slong n, fq_ctx_t mod) noexcept
    int fq_poly_sqrt(fq_poly_t s, const fq_poly_t p, fq_ctx_t mod) noexcept
    void _fq_poly_evaluate_fq(fq_t rop, const fq_struct * op, slong len, const fq_t a, const fq_ctx_t ctx) noexcept
    void fq_poly_evaluate_fq(fq_t rop, const fq_poly_t f, const fq_t a, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose(fq_struct * rop, const fq_struct * op1, slong len1, const fq_struct * op2, slong len2, const fq_ctx_t ctx) noexcept
    void fq_poly_compose(fq_poly_t rop, const fq_poly_t op1, const fq_poly_t op2, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose_mod_horner(fq_struct * res, const fq_struct * f, slong lenf, const fq_struct * g, const fq_struct * h, slong lenh, const fq_ctx_t ctx) noexcept
    void fq_poly_compose_mod_horner(fq_poly_t res, const fq_poly_t f, const fq_poly_t g, const fq_poly_t h, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose_mod_horner_preinv(fq_struct * res, const fq_struct * f, slong lenf, const fq_struct * g, const fq_struct * h, slong lenh, const fq_struct * hinv, slong lenhiv, const fq_ctx_t ctx) noexcept
    void fq_poly_compose_mod_horner_preinv(fq_poly_t res, const fq_poly_t f, const fq_poly_t g, const fq_poly_t h, const fq_poly_t hinv, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose_mod_brent_kung(fq_struct * res, const fq_struct * f, slong lenf, const fq_struct * g, const fq_struct * h, slong lenh, const fq_ctx_t ctx) noexcept
    void fq_poly_compose_mod_brent_kung(fq_poly_t res, const fq_poly_t f, const fq_poly_t g, const fq_poly_t h, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose_mod_brent_kung_preinv(fq_struct * res, const fq_struct * f, slong lenf, const fq_struct * g, const fq_struct * h, slong lenh, const fq_struct * hinv, slong lenhiv, const fq_ctx_t ctx) noexcept
    void fq_poly_compose_mod_brent_kung_preinv(fq_poly_t res, const fq_poly_t f, const fq_poly_t g, const fq_poly_t h, const fq_poly_t hinv, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose_mod(fq_struct * res, const fq_struct * f, slong lenf, const fq_struct * g, const fq_struct * h, slong lenh, const fq_ctx_t ctx) noexcept
    void fq_poly_compose_mod(fq_poly_t res, const fq_poly_t f, const fq_poly_t g, const fq_poly_t h, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose_mod_preinv(fq_struct * res, const fq_struct * f, slong lenf, const fq_struct * g, const fq_struct * h, slong lenh, const fq_struct * hinv, slong lenhiv, const fq_ctx_t ctx) noexcept
    void fq_poly_compose_mod_preinv(fq_poly_t res, const fq_poly_t f, const fq_poly_t g, const fq_poly_t h, const fq_poly_t hinv, const fq_ctx_t ctx) noexcept
    void _fq_poly_reduce_matrix_mod_poly (fq_mat_t A, const fq_mat_t B, const fq_poly_t f, const fq_ctx_t ctx) noexcept
    void _fq_poly_precompute_matrix (fq_mat_t A, const fq_struct * f, const fq_struct * g, slong leng, const fq_struct * ginv, slong lenginv, const fq_ctx_t ctx) noexcept
    void fq_poly_precompute_matrix (fq_mat_t A, const fq_poly_t f, const fq_poly_t g, const fq_poly_t ginv, const fq_ctx_t ctx) noexcept
    void _fq_poly_compose_mod_brent_kung_precomp_preinv(fq_struct * res, const fq_struct * f, slong lenf, const fq_mat_t A, const fq_struct * h, slong lenh, const fq_struct * hinv, slong lenhinv, const fq_ctx_t ctx) noexcept
    void fq_poly_compose_mod_brent_kung_precomp_preinv(fq_poly_t res, const fq_poly_t f, const fq_mat_t A, const fq_poly_t h, const fq_poly_t hinv, const fq_ctx_t ctx) noexcept
    int _fq_poly_fprint_pretty(FILE * file, const fq_struct * poly, slong len, const char * x, const fq_ctx_t ctx) noexcept
    int fq_poly_fprint_pretty(FILE * file, const fq_poly_t poly, const char * x, const fq_ctx_t ctx) noexcept
    int _fq_poly_print_pretty(const fq_struct * poly, slong len, const char * x, const fq_ctx_t ctx) noexcept
    int fq_poly_print_pretty(const fq_poly_t poly, const char * x, const fq_ctx_t ctx) noexcept
    int _fq_poly_fprint(FILE * file, const fq_struct * poly, slong len, const fq_ctx_t ctx) noexcept
    int fq_poly_fprint(FILE * file, const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    int _fq_poly_print(const fq_struct * poly, slong len, const fq_ctx_t ctx) noexcept
    int fq_poly_print(const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    char * _fq_poly_get_str(const fq_struct * poly, slong len, const fq_ctx_t ctx) noexcept
    char * fq_poly_get_str(const fq_poly_t poly, const fq_ctx_t ctx) noexcept
    char * _fq_poly_get_str_pretty(const fq_struct * poly, slong len, const char * x, const fq_ctx_t ctx) noexcept
    char * fq_poly_get_str_pretty(const fq_poly_t poly, const char * x, const fq_ctx_t ctx) noexcept
    void fq_poly_inflate(fq_poly_t result, const fq_poly_t input, ulong inflation, const fq_ctx_t ctx) noexcept
    void fq_poly_deflate(fq_poly_t result, const fq_poly_t input, ulong deflation, const fq_ctx_t ctx) noexcept
    ulong fq_poly_deflation(const fq_poly_t input, const fq_ctx_t ctx) noexcept
