## -*- encoding: utf-8 -*-
"""
This file (./numbertheory_doctest.sage) was *autogenerated* from ./numbertheory.tex,
with sagetex.sty version 2011/05/27 v2.3.1.
It contains the contents of all the sageexample environments from this file.
You should be able to doctest this file with:
sage -t ./numbertheory_doctest.sage
It is always safe to delete this file; it is not used in typesetting your
document.

Sage example in ./numbertheory.tex, line 107::

  sage: a = IntegerModRing(15)(3); b = IntegerModRing(17)(3); a, b
  (3, 3)
  sage: a == b
  False

Sage example in ./numbertheory.tex, line 135::

  sage: R = a.parent(); R
  Ring of integers modulo 15
  sage: R.characteristic()
  15

Sage example in ./numbertheory.tex, line 157::

  sage: a + a, a - 17, a * a + 1, a^3
  (6, 1, 10, 12)

Sage example in ./numbertheory.tex, line 199::

  sage: z = a.lift(); y = ZZ(a); y, type(y), y == z
  (3, <... 'sage.rings.integer.Integer'>, True)

Sage example in ./numbertheory.tex, line 228::

  sage: [Mod(x,15).additive_order() for x in range(0,15)]
  [1, 15, 15, 5, 15, 3, 5, 15, 15, 5, 3, 15, 5, 15, 15]

Sage example in ./numbertheory.tex, line 261::

  sage: [[x, Mod(x,15).multiplicative_order()]
  ....:   for x in range(1,15) if gcd(x,15) == 1]
  [[1, 1], [2, 4], [4, 2], [7, 4], [8, 4], [11, 2], [13, 4], [14, 2]]

Sage example in ./numbertheory.tex, line 276::

  sage: p = 10^20 + 39; mod(2,p).multiplicative_order()
  50000000000000000019
  sage: mod(3,p).multiplicative_order()
  100000000000000000038

Sage example in ./numbertheory.tex, line 367::

  sage: R = GF(17); [1/R(x) for x in range(1,17)]
  [1, 9, 6, 13, 7, 3, 5, 15, 2, 12, 14, 10, 4, 11, 8, 16]

Sage example in ./numbertheory.tex, line 403::

  sage: R = GF(9,name='x'); R
  Finite Field in x of size 3^2

Sage example in ./numbertheory.tex, line 409::

  sage: R.polynomial()
  x^2 + 2*x + 2

Sage example in ./numbertheory.tex, line 423::

  sage: Set([r for r in R])
  {0, 1, 2, x, x + 1, x + 2, 2*x, 2*x + 1, 2*x + 2}

Sage example in ./numbertheory.tex, line 429::

  sage: Q.<x> = PolynomialRing(GF(3))
  sage: R2 = GF(9, name='x', modulus=x^2+1); R2
  Finite Field in x of size 3^2

Sage example in ./numbertheory.tex, line 463::

  sage: p = R(x+1); R2(p)
  Traceback (most recent call last):
    ...
  TypeError: unable to coerce from a finite field other than the prime subfield

Sage example in ./numbertheory.tex, line 548::

  sage: rational_reconstruction(411,1000)
  -13/17
  sage: rational_reconstruction(409,1000)
  Traceback (most recent call last):
    ...
  ArithmeticError: rational reconstruction of 409 (mod 1000) does not exist

Sage example in ./numbertheory.tex, line 571::

  sage: def harmonic(n):
  ....:    return add([1/x for x in range(1,n+1)])

Sage example in ./numbertheory.tex, line 593::

  sage: def harmonic_mod(n,m):
  ....:     return add([1/x % m for x in range(1,n+1)])
  sage: def harmonic2(n):
  ....:     q = lcm(range(1,n+1))
  ....:     pmax = RR(q*(log(n)+1))
  ....:     m = ZZ(2*pmax^2)
  ....:     m = integer_ceil(m / q) * q + 1
  ....:     a = harmonic_mod(n,m)
  ....:     return rational_reconstruction(a,m)

Sage example in ./numbertheory.tex, line 707::

  sage: a = 2; b = 3; m = 5; n = 7; lambda0 = (b-a)/m % n; a + lambda0 * m
  17
  sage: crt(2,3,5,7)
  17

Sage example in ./numbertheory.tex, line 726::

  sage: def harmonic3(n):
  ....:     q = lcm(range(1,n+1))
  ....:     pmax = RR(q*(log(n)+1))
  ....:     B = ZZ(2*pmax^2)
  ....:     a = 0; m = 1; p = 2^63
  ....:     while m < B:
  ....:        p = next_prime(p)
  ....:        b = harmonic_mod(n,p)
  ....:        a = crt(a,b,m,p)
  ....:        m = m*p
  ....:     return rational_reconstruction(a,m)
  sage: harmonic(100) == harmonic3(100)
  True

Sage example in ./numbertheory.tex, line 755::

  sage: crt(15,1,30,4)
  45
  sage: crt(15,2,30,4)
  Traceback (most recent call last):
    ...
  ValueError: no solution to crt problem since gcd(30,4) does not divide 15-2

Sage example in ./numbertheory.tex, line 1008::

  sage: [560 % (x-1) for x in [3,11,17]]
  [0, 0, 0]

Sage example in ./numbertheory.tex, line 1226::

  sage: p = 10^10+19; a = mod(17,p); a.log(2)
  6954104378
  sage: mod(2,p)^6954104378
  17

"""
