##      -*-   coding: utf-8   -*-     ##
##          Sage Doctest File         ##
#**************************************#
#*    Generated from PreTeXt source   *#
#*    on 2017-08-24T11:43:34-07:00    *#
#*                                    *#
#*   http://mathbook.pugetsound.edu   *#
#*                                    *#
#**************************************#
##
"""
Please contact Rob Beezer (beezer@ups.edu) with
any test failures here that need to be changed
as a result of changes accepted into Sage.  You
may edit/change this file in any sensible way, so
that development work may procede.  Your changes
may later be replaced by the authors of "Abstract
Algebra: Theory and Applications" when the text is
updated, and a replacement of this file is proposed
for review.
"""
##
## To execute doctests in these files, run
##   $ $SAGE_ROOT/sage -t <directory-of-these-files>
## or
##   $ $SAGE_ROOT/sage -t <a-single-file>
##
## Replace -t by "-tp n" for parallel testing,
##   "-tp 0" will use a sensible number of threads
##
## See: http://www.sagemath.org/doc/developer/doctesting.html
##   or run  $ $SAGE_ROOT/sage --advanced  for brief help
##
## Generated at 2017-08-24T11:43:34-07:00
## From "Abstract Algebra"
## At commit 26d3cac0b4047f4b8d6f737542be455606e2c4b4
##
## Section 6.5 Sage
##
r"""
~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: G = SymmetricGroup(3)
    sage: a = G("(1,2)")
    sage: H = G.subgroup([a])
    sage: rc = G.cosets(H, side='right'); rc
    [[(), (1,2)], [(2,3), (1,3,2)], [(1,2,3), (1,3)]]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: lc = G.cosets(H, side='left'); lc
    [[(), (1,2)], [(2,3), (1,2,3)], [(1,3,2), (1,3)]]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: G = SymmetricGroup(3)
    sage: b = G("(1,2,3)")
    sage: H = G.subgroup([b])
    sage: rc = G.cosets(H, side='right'); rc
    [[(), (1,2,3), (1,3,2)], [(2,3), (1,3), (1,2)]]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: lc = G.cosets(H, side='left'); lc
    [[(), (1,2,3), (1,3,2)], [(2,3), (1,2), (1,3)]]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: rc == lc
    False

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: rc_sorted = sorted([sorted(coset) for coset in rc])
    sage: rc_sorted
    [[(), (1,2,3), (1,3,2)], [(2,3), (1,2), (1,3)]]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: lc_sorted = sorted([sorted(coset) for coset in lc])
    sage: lc_sorted
    [[(), (1,2,3), (1,3,2)], [(2,3), (1,2), (1,3)]]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: rc_sorted == lc_sorted
    True

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: G = SymmetricGroup(3)
    sage: sg = G.subgroups(); sg
    [Subgroup generated by [()] of (Symmetric group of order 3! as a permutation group),
     Subgroup generated by [(2,3)] of (Symmetric group of order 3! as a permutation group),
     Subgroup generated by [(1,2)] of (Symmetric group of order 3! as a permutation group),
     Subgroup generated by [(1,3)] of (Symmetric group of order 3! as a permutation group),
     Subgroup generated by [(1,2,3)] of (Symmetric group of order 3! as a permutation group),
     Subgroup generated by [(1,2,3), (2,3)] of (Symmetric group of order 3! as a permutation group)]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: H = sg[4]; H
    Subgroup generated by [(1,2,3)] of (Symmetric group of order 3! as a permutation group)

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: H.order()
    3

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: H.list()
    [(), (1,2,3), (1,3,2)]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: H.is_cyclic()
    True

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: G = AlternatingGroup(4)
    sage: sg = G.subgroups()
    sage: [H.order() for H in sg]
    [1, 2, 2, 2, 3, 3, 3, 3, 4, 12]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: G = SymmetricGroup(4)
    sage: sg = G.subgroups()
    sage: [H.order() for H in sg]
    [1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4,
     6, 6, 6, 6, 8, 8, 8, 12, 24]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: len(sg)
    30

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: G = CyclicPermutationGroup(20)
    sage: [H.order() for H in G.subgroups()]
    [1, 2, 4, 5, 10, 20]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: G = CyclicPermutationGroup(19)
    sage: [H.order() for H in G.subgroups()]
    [1, 19]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: n = 8
    sage: G = CyclicPermutationGroup(n)
    sage: [H.order() for H in G.subgroups()]
    [1, 2, 4, 8]

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: euler_phi(345)
    176

~~~~~~~~~~~~~~~~~~~~~~ ::

    sage: m = random_prime(10000)
    sage: n = random_prime(10000)
    sage: m, n, euler_phi(m*n) == euler_phi(m)*euler_phi(n)   # random
    (5881, 1277, True)

"""
