# CAP, single 12
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("cap12.tst");

# doc/_Chapter_Examples_and_Tests.xml:260-359
gap> ReadPackage( "CAP", "examples/StringsAsCategory.g" );;
gap> C := StringsAsCategory();;
gap> obj1 := StringsAsCategoryObject( C, "qaeiou" );;
gap> obj2 := StringsAsCategoryObject( C, "qxayeziouT" );;
gap> mor := StringsAsCategoryMorphism( C, obj1, "xyzaTe", obj2 );;
gap> IsWellDefined( mor );
true
gap> ## Test SimplifyObject
> IsEqualForObjects( SimplifyObject( obj1, 0 ), obj1 );
true
gap> IsEqualForObjects( SimplifyObject( obj1, 1 ), obj1 );
false
gap> ForAny( [0,1,2,3,4], i -> IsEqualForObjects( SimplifyObject( obj1, i ), SimplifyObject( obj1, i + 1 ) ) );
false
gap> ForAll( [5,6,7,8], i -> IsEqualForObjects( SimplifyObject( obj1, i ), SimplifyObject( obj1, i + 1 ) ) );
true
gap> ## Test SimplifyMorphism
> IsEqualForMorphisms( SimplifyMorphism( mor, 0 ), mor );
true
gap> IsEqualForMorphisms( SimplifyMorphism( mor, 1 ), mor );
false
gap> ForAny( [0,1], i -> IsEqualForMorphisms( SimplifyMorphism( mor, i ), SimplifyMorphism( mor, i + 1 ) ) );
false
gap> ForAll( [2,3,4,5], i -> IsEqualForMorphisms( SimplifyMorphism( mor, i ), SimplifyMorphism( mor, i + 1 ) ) );
true
gap> ## Test SimplifySource
> IsEqualForMorphismsOnMor( SimplifySource( mor, 0 ), mor );
true
gap> IsEqualForMorphismsOnMor( SimplifySource( mor, 1 ), mor );
false
gap> ForAny( [0,1,2,3,4], i -> IsEqualForMorphismsOnMor( SimplifySource( mor, i ), SimplifySource( mor, i + 1 ) ) );
false
gap> ForAll( [5,6,7,8,9], i -> IsEqualForMorphismsOnMor( SimplifySource( mor, i ), SimplifySource( mor, i + 1 ) ) );
true
gap> IsCongruentForMorphisms(
>     PreCompose( SimplifySource_IsoFromInputObject( mor, infinity ), SimplifySource( mor, infinity ) ), mor
> );
true
gap> IsCongruentForMorphisms(
>     PreCompose( SimplifySource_IsoToInputObject( mor, infinity ), mor ) , SimplifySource( mor, infinity )
> );
true
gap> ## Test SimplifyRange
> IsEqualForMorphismsOnMor( SimplifyRange( mor, 0 ), mor );
true
gap> IsEqualForMorphismsOnMor( SimplifyRange( mor, 1 ), mor );
false
gap> ForAny( [0,1,2,3,4], i -> IsEqualForMorphismsOnMor( SimplifyRange( mor, i ), SimplifyRange( mor, i + 1 ) ) );
false
gap> ForAll( [5,6,7,8,9], i -> IsEqualForMorphismsOnMor( SimplifyRange( mor, i ), SimplifyRange( mor, i + 1 ) ) );
true
gap> IsCongruentForMorphisms(
>     PreCompose( SimplifyRange( mor, infinity ), SimplifyRange_IsoToInputObject( mor, infinity ) ), mor
> );
true
gap> IsCongruentForMorphisms(
>     PreCompose( mor, SimplifyRange_IsoFromInputObject( mor, infinity ) ), SimplifyRange( mor, infinity )
> );
true
gap> ## Test SimplifySourceAndRange
> IsEqualForMorphismsOnMor( SimplifySourceAndRange( mor, 0 ), mor );
true
gap> IsEqualForMorphismsOnMor( SimplifySourceAndRange( mor, 1 ), mor );
false
gap> ForAny( [0,1,2,3,4], i -> IsEqualForMorphismsOnMor( SimplifySourceAndRange( mor, i ), SimplifySourceAndRange( mor, i + 1 ) ) );
false
gap> ForAll( [5,6,7,8,9], i -> IsEqualForMorphismsOnMor( SimplifySourceAndRange( mor, i ), SimplifySourceAndRange( mor, i + 1 ) ) );
true
gap> IsCongruentForMorphisms(
>     mor,
>     PreCompose( [ SimplifySourceAndRange_IsoFromInputSource( mor, infinity ),
>                   SimplifySourceAndRange( mor, infinity ),
>                   SimplifySourceAndRange_IsoToInputRange( mor, infinity ) ] )
> );
true
gap> IsCongruentForMorphisms(
>     SimplifySourceAndRange( mor, infinity ),
>     PreCompose( [ SimplifySourceAndRange_IsoToInputSource( mor, infinity ),
>                   mor,
>                   SimplifySourceAndRange_IsoFromInputRange( mor, infinity ) ] )
> );
true
gap> ## Test SimplifyEndo
> endo := StringsAsCategoryMorphism( C, obj1, "uoiea", obj1 );;
gap> IsWellDefined( endo );
true
gap> IsEqualForMorphismsOnMor( SimplifyEndo( endo, 0 ), endo );
true
gap> IsEqualForMorphismsOnMor( SimplifyEndo( endo, 1 ), endo );
false
gap> ForAny( [0,1,2,3,4], i -> IsEqualForMorphismsOnMor( SimplifySourceAndRange( endo, i ), SimplifySourceAndRange( endo, i + 1 ) ) );
false
gap> ForAll( [5,6,7,8,9], i -> IsEqualForMorphismsOnMor( SimplifySourceAndRange( endo, i ), SimplifySourceAndRange( endo, i + 1 ) ) );
true
gap> iota := SimplifyEndo_IsoToInputObject( endo, infinity );;
gap> iota_inv := SimplifyEndo_IsoFromInputObject( endo, infinity );;
gap> IsCongruentForMorphisms( PreCompose( [ iota_inv, SimplifyEndo( endo, infinity ), iota ] ), endo );
true

#
gap> STOP_TEST("cap12.tst", 1);
