# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Declarations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecord.gi

#! @Chapter Monoidal Categories

#! @Section Add-methods

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftDualObjectToLeftInternalHomIntoTensorUnit",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomIntoTensorUnitToLeftDualObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftInternalHomToObject`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromLeftInternalHomToObject}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftInternalHomToObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomToObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomToObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomToObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom`.
#! $F: ( a, s ) \mapsto \mathtt{IsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom}(a, s)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalHomToObjectWithGivenLeftInternalHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromObjectToLeftInternalHom`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromObjectToLeftInternalHom}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom`.
#! $F: ( a, r ) \mapsto \mathtt{IsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom}(a, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalHomWithGivenLeftInternalHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalCoevaluationMorphism`.
#! $F: ( a, b ) \mapsto \mathtt{LeftClosedMonoidalCoevaluationMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalCoevaluationMorphismWithGivenRange`.
#! $F: ( a, b, r ) \mapsto \mathtt{LeftClosedMonoidalCoevaluationMorphismWithGivenRange}(a, b, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalCoevaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalEvaluationForLeftDual`.
#! $F: ( a ) \mapsto \mathtt{LeftClosedMonoidalEvaluationForLeftDual}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDual",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct`.
#! $F: ( s, a, r ) \mapsto \mathtt{LeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct}(s, a, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationForLeftDualWithGivenTensorProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalEvaluationMorphism`.
#! $F: ( a, b ) \mapsto \mathtt{LeftClosedMonoidalEvaluationMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalEvaluationMorphismWithGivenSource`.
#! $F: ( a, b, s ) \mapsto \mathtt{LeftClosedMonoidalEvaluationMorphismWithGivenSource}(a, b, s)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalEvaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalLambdaElimination`.
#! $F: ( a, b, alpha ) \mapsto \mathtt{LeftClosedMonoidalLambdaElimination}(a, b, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalLambdaIntroduction`.
#! $F: ( alpha ) \mapsto \mathtt{LeftClosedMonoidalLambdaIntroduction}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalPostComposeMorphism`.
#! $F: ( a, b, c ) \mapsto \mathtt{LeftClosedMonoidalPostComposeMorphism}(a, b, c)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalPostComposeMorphismWithGivenObjects`.
#! $F: ( s, a, b, c, r ) \mapsto \mathtt{LeftClosedMonoidalPostComposeMorphismWithGivenObjects}(s, a, b, c, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPostComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalPreComposeMorphism`.
#! $F: ( a, b, c ) \mapsto \mathtt{LeftClosedMonoidalPreComposeMorphism}(a, b, c)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftClosedMonoidalPreComposeMorphismWithGivenObjects`.
#! $F: ( s, a, b, c, r ) \mapsto \mathtt{LeftClosedMonoidalPreComposeMorphismWithGivenObjects}(s, a, b, c, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftClosedMonoidalPreComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftDualOnMorphisms`.
#! $F: ( alpha ) \mapsto \mathtt{LeftDualOnMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftDualOnMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftDualOnMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftDualOnMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftDualOnMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftDualOnMorphismsWithGivenLeftDuals`.
#! $F: ( s, alpha, r ) \mapsto \mathtt{LeftDualOnMorphismsWithGivenLeftDuals}(s, alpha, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftDualOnMorphismsWithGivenLeftDuals",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftDualOnMorphismsWithGivenLeftDuals",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftDualOnMorphismsWithGivenLeftDuals",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftDualOnMorphismsWithGivenLeftDuals",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftDualOnObjects`.
#! $F: ( a ) \mapsto \mathtt{LeftDualOnObjects}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftDualOnObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftDualOnObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftDualOnObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftDualOnObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalHomOnMorphisms`.
#! $F: ( alpha, beta ) \mapsto \mathtt{LeftInternalHomOnMorphisms}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalHomOnMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalHomOnMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalHomOnMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalHomOnMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalHomOnMorphismsWithGivenLeftInternalHoms`.
#! $F: ( s, alpha, beta, r ) \mapsto \mathtt{LeftInternalHomOnMorphismsWithGivenLeftInternalHoms}(s, alpha, beta, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalHomOnMorphismsWithGivenLeftInternalHoms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalHomOnMorphismsWithGivenLeftInternalHoms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalHomOnMorphismsWithGivenLeftInternalHoms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalHomOnMorphismsWithGivenLeftInternalHoms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalHomOnObjects`.
#! $F: ( a, b ) \mapsto \mathtt{LeftInternalHomOnObjects}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalHomOnObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalHomOnObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalHomOnObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalHomOnObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalHomToTensorProductAdjunctMorphism`.
#! $F: ( b, c, g ) \mapsto \mathtt{LeftInternalHomToTensorProductAdjunctMorphism}(b, c, g)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct`.
#! $F: ( b, c, g, t ) \mapsto \mathtt{LeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct}(b, c, g, t)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromTensorProductToLeftInternalHom`.
#! $F: ( a, b ) \mapsto \mathtt{MorphismFromTensorProductToLeftInternalHom}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromTensorProductToLeftInternalHomWithGivenObjects`.
#! $F: ( s, a, b, r ) \mapsto \mathtt{MorphismFromTensorProductToLeftInternalHomWithGivenObjects}(s, a, b, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHomWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHomWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHomWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromTensorProductToLeftInternalHomWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismToLeftBidual`.
#! $F: ( a ) \mapsto \mathtt{MorphismToLeftBidual}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismToLeftBidual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismToLeftBidual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismToLeftBidual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismToLeftBidual",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismToLeftBidualWithGivenLeftBidual`.
#! $F: ( a, r ) \mapsto \mathtt{MorphismToLeftBidualWithGivenLeftBidual}(a, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismToLeftBidualWithGivenLeftBidual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismToLeftBidualWithGivenLeftBidual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismToLeftBidualWithGivenLeftBidual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismToLeftBidualWithGivenLeftBidual",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductLeftDualityCompatibilityMorphism`.
#! $F: ( a, b ) \mapsto \mathtt{TensorProductLeftDualityCompatibilityMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductLeftDualityCompatibilityMorphismWithGivenObjects`.
#! $F: ( s, a, b, r ) \mapsto \mathtt{TensorProductLeftDualityCompatibilityMorphismWithGivenObjects}(s, a, b, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductLeftDualityCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductLeftInternalHomCompatibilityMorphism`.
#! $F: ( list ) \mapsto \mathtt{TensorProductLeftInternalHomCompatibilityMorphism}(list)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects`.
#! $F: ( source, list, range ) \mapsto \mathtt{TensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects}(source, list, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductLeftInternalHomCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductToLeftInternalHomAdjunctMorphism`.
#! $F: ( a, b, f ) \mapsto \mathtt{TensorProductToLeftInternalHomAdjunctMorphism}(a, b, f)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom`.
#! $F: ( a, b, f, i ) \mapsto \mathtt{TensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom}(a, b, f, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalHomAdjunctMorphismWithGivenLeftInternalHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalPropertyOfLeftDual`.
#! $F: ( t, a, alpha ) \mapsto \mathtt{UniversalPropertyOfLeftDual}(t, a, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalPropertyOfLeftDual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalPropertyOfLeftDual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalPropertyOfLeftDual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalPropertyOfLeftDual",
                  [ IsCapCategory, IsList ] );
