# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Declarations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecord.gi

#! @Chapter Monoidal Categories

#! @Section Add-methods

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftCoDualObjectToLeftInternalCoHomFromTensorUnit",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomFromTensorUnitToLeftCoDualObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftInternalCoHomToObject`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromLeftInternalCoHomToObject}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObject",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObject",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObject",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObject",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom`.
#! $F: ( a, s ) \mapsto \mathtt{IsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom}(a, s)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromLeftInternalCoHomToObjectWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromObjectToLeftInternalCoHom`.
#! $F: ( a ) \mapsto \mathtt{IsomorphismFromObjectToLeftInternalCoHom}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom`.
#! $F: ( a, r ) \mapsto \mathtt{IsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom}(a, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddIsomorphismFromObjectToLeftInternalCoHomWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoDualOnMorphisms`.
#! $F: ( alpha ) \mapsto \mathtt{LeftCoDualOnMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoDualOnMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoDualOnMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoDualOnMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoDualOnMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoDualOnMorphismsWithGivenLeftCoDuals`.
#! $F: ( s, alpha, r ) \mapsto \mathtt{LeftCoDualOnMorphismsWithGivenLeftCoDuals}(s, alpha, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoDualOnMorphismsWithGivenLeftCoDuals",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoDualOnMorphismsWithGivenLeftCoDuals",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoDualOnMorphismsWithGivenLeftCoDuals",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoDualOnMorphismsWithGivenLeftCoDuals",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoDualOnObjects`.
#! $F: ( a ) \mapsto \mathtt{LeftCoDualOnObjects}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoDualOnObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoDualOnObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoDualOnObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoDualOnObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoDualityTensorProductCompatibilityMorphism`.
#! $F: ( a, b ) \mapsto \mathtt{LeftCoDualityTensorProductCompatibilityMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects`.
#! $F: ( s, a, b, r ) \mapsto \mathtt{LeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects}(s, a, b, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoDualityTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalCoevaluationMorphism`.
#! $F: ( a, b ) \mapsto \mathtt{LeftCoclosedMonoidalCoevaluationMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource`.
#! $F: ( a, b, s ) \mapsto \mathtt{LeftCoclosedMonoidalCoevaluationMorphismWithGivenSource}(a, b, s)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalCoevaluationMorphismWithGivenSource",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalEvaluationForLeftCoDual`.
#! $F: ( a ) \mapsto \mathtt{LeftCoclosedMonoidalEvaluationForLeftCoDual}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDual",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct`.
#! $F: ( s, a, r ) \mapsto \mathtt{LeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct}(s, a, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationForLeftCoDualWithGivenTensorProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalEvaluationMorphism`.
#! $F: ( a, b ) \mapsto \mathtt{LeftCoclosedMonoidalEvaluationMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalEvaluationMorphismWithGivenRange`.
#! $F: ( a, b, r ) \mapsto \mathtt{LeftCoclosedMonoidalEvaluationMorphismWithGivenRange}(a, b, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalEvaluationMorphismWithGivenRange",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalLambdaElimination`.
#! $F: ( a, b, alpha ) \mapsto \mathtt{LeftCoclosedMonoidalLambdaElimination}(a, b, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalLambdaElimination",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalLambdaIntroduction`.
#! $F: ( alpha ) \mapsto \mathtt{LeftCoclosedMonoidalLambdaIntroduction}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalLambdaIntroduction",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalPostCoComposeMorphism`.
#! $F: ( a, b, c ) \mapsto \mathtt{LeftCoclosedMonoidalPostCoComposeMorphism}(a, b, c)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects`.
#! $F: ( s, a, b, c, r ) \mapsto \mathtt{LeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects}(s, a, b, c, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPostCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalPreCoComposeMorphism`.
#! $F: ( a, b, c ) \mapsto \mathtt{LeftCoclosedMonoidalPreCoComposeMorphism}(a, b, c)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects`.
#! $F: ( s, a, b, c, r ) \mapsto \mathtt{LeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects}(s, a, b, c, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftCoclosedMonoidalPreCoComposeMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalCoHomOnMorphisms`.
#! $F: ( alpha, beta ) \mapsto \mathtt{LeftInternalCoHomOnMorphisms}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalCoHomOnMorphisms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalCoHomOnMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomOnMorphisms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomOnMorphisms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms`.
#! $F: ( s, alpha, beta, r ) \mapsto \mathtt{LeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms}(s, alpha, beta, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomOnMorphismsWithGivenLeftInternalCoHoms",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalCoHomOnObjects`.
#! $F: ( a, b ) \mapsto \mathtt{LeftInternalCoHomOnObjects}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalCoHomOnObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalCoHomOnObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomOnObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomOnObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalCoHomTensorProductCompatibilityMorphism`.
#! $F: ( list ) \mapsto \mathtt{LeftInternalCoHomTensorProductCompatibilityMorphism}(list)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects`.
#! $F: ( source, list, range ) \mapsto \mathtt{LeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects}(source, list, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomTensorProductCompatibilityMorphismWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalCoHomToTensorProductAdjunctMorphism`.
#! $F: ( a, c, f ) \mapsto \mathtt{LeftInternalCoHomToTensorProductAdjunctMorphism}(a, c, f)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct`.
#! $F: ( a, c, f, t ) \mapsto \mathtt{LeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct}(a, c, f, t)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddLeftInternalCoHomToTensorProductAdjunctMorphismWithGivenTensorProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromLeftCoBidual`.
#! $F: ( a ) \mapsto \mathtt{MorphismFromLeftCoBidual}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromLeftCoBidual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromLeftCoBidual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromLeftCoBidual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromLeftCoBidual",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromLeftCoBidualWithGivenLeftCoBidual`.
#! $F: ( a, s ) \mapsto \mathtt{MorphismFromLeftCoBidualWithGivenLeftCoBidual}(a, s)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromLeftCoBidualWithGivenLeftCoBidual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromLeftCoBidualWithGivenLeftCoBidual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromLeftCoBidualWithGivenLeftCoBidual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromLeftCoBidualWithGivenLeftCoBidual",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromLeftInternalCoHomToTensorProduct`.
#! $F: ( a, b ) \mapsto \mathtt{MorphismFromLeftInternalCoHomToTensorProduct}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProduct",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProduct",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProduct",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects`.
#! $F: ( s, a, b, r ) \mapsto \mathtt{MorphismFromLeftInternalCoHomToTensorProductWithGivenObjects}(s, a, b, r)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProductWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProductWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProductWithGivenObjects",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddMorphismFromLeftInternalCoHomToTensorProductWithGivenObjects",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductToLeftInternalCoHomAdjunctMorphism`.
#! $F: ( b, c, g ) \mapsto \mathtt{TensorProductToLeftInternalCoHomAdjunctMorphism}(b, c, g)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphism",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphism",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphism",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom`.
#! $F: ( b, c, g, i ) \mapsto \mathtt{TensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom}(b, c, g, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddTensorProductToLeftInternalCoHomAdjunctMorphismWithGivenLeftInternalCoHom",
                  [ IsCapCategory, IsList ] );

#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalPropertyOfLeftCoDual`.
#! $F: ( t, a, alpha ) \mapsto \mathtt{UniversalPropertyOfLeftCoDual}(t, a, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalPropertyOfLeftCoDual",
                  [ IsCapCategory, IsFunction ] );

DeclareOperation( "AddUniversalPropertyOfLeftCoDual",
                  [ IsCapCategory, IsFunction, IsInt ] );

DeclareOperation( "AddUniversalPropertyOfLeftCoDual",
                  [ IsCapCategory, IsList, IsInt ] );

DeclareOperation( "AddUniversalPropertyOfLeftCoDual",
                  [ IsCapCategory, IsList ] );
