# MonoidalCategories, single 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("monoidalcategories01.tst");

# doc/_Chapter_Examples_and_Tests.xml:661-702
gap> LoadPackage( "MonoidalCategories", false );
true
gap> LoadPackage( "LinearAlgebraForCAP", false );
true
gap> Q := HomalgFieldOfRationals();
Q
gap> a := VectorSpaceObject( 1, Q );
<A vector space object over Q of dimension 1>
gap> b := VectorSpaceObject( 2, Q );
<A vector space object over Q of dimension 2>
gap> c := VectorSpaceObject( 3, Q );
<A vector space object over Q of dimension 3>
gap> z := ZeroObject( CapCategory( a ) );
<A vector space object over Q of dimension 0>
gap> alpha := VectorSpaceMorphism( a, [ [ 1, 0 ] ], b );
<A morphism in Category of matrices over Q>
gap> beta := VectorSpaceMorphism( b,
>                 [ [ 1, 0, 0 ], [ 0, 1, 0 ] ], c );
<A morphism in Category of matrices over Q>
gap> gamma := VectorSpaceMorphism( c,
>                  [ [ 0, 1, 1 ], [ 1, 0, 1 ], [ 1, 1, 0 ] ], c );
<A morphism in Category of matrices over Q>
gap> IsCongruentForMorphisms(
>         TensorProductOnMorphisms( alpha, beta ),
>         TensorProductOnMorphisms( beta, alpha ) );
false
gap> IsOne( AssociatorRightToLeft( a, b, c ) );
true
gap> IsCongruentForMorphisms(
>         gamma, LambdaElimination( c, c, LambdaIntroduction( gamma ) ) );
true
gap> IsZero( TraceMap( gamma ) );
true
gap> IsCongruentForMorphisms(
>         RankMorphism( DirectSum( a, b ) ), RankMorphism( c ) );
true
gap> IsOne( Braiding( b, c ) );
false
gap> IsOne( PreCompose( Braiding( b, c ), Braiding( c, b ) ) );
true

#
gap> STOP_TEST("monoidalcategories01.tst", 1);
