# SPDX-License-Identifier: GPL-2.0-or-later
# CAP: Categories, Algorithms, Programming
#
# Declarations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

#! @Chapter Add Functions

#! @Section Available Add functions

#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AdditionForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{AdditionForMorphisms}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAdditionForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddAdditionForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AdditiveGenerators`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{AdditiveGenerators}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAdditiveGenerators",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddAdditiveGenerators",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AdditiveInverseForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{AdditiveInverseForMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAdditiveInverseForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddAdditiveInverseForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AstrictionToCoimage`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{AstrictionToCoimage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAstrictionToCoimage",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddAstrictionToCoimage",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `AstrictionToCoimageWithGivenCoimageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, C ) \mapsto \mathtt{AstrictionToCoimageWithGivenCoimageObject}(alpha, C)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddAstrictionToCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddAstrictionToCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `BasisOfExternalHom`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{BasisOfExternalHom}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddBasisOfExternalHom",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddBasisOfExternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoastrictionToImage`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{CoastrictionToImage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoastrictionToImage",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoastrictionToImage",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoastrictionToImageWithGivenImageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, I ) \mapsto \mathtt{CoastrictionToImageWithGivenImageObject}(alpha, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoastrictionToImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoastrictionToImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoefficientsOfMorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{CoefficientsOfMorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoefficientsOfMorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoefficientsOfMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Coequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms ) \mapsto \mathtt{Coequalizer}(Y, morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoequalizerFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, mu, morphismsp ) \mapsto \mathtt{CoequalizerFunctorial}(morphisms, mu, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoequalizerFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoequalizerFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoequalizerFunctorialWithGivenCoequalizers`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, morphisms, mu, morphismsp, Pp ) \mapsto \mathtt{CoequalizerFunctorialWithGivenCoequalizers}(P, morphisms, mu, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoequalizerFunctorialWithGivenCoequalizers",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoequalizerFunctorialWithGivenCoequalizers",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{CoimageObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageObjectFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, mu, alphap ) \mapsto \mathtt{CoimageObjectFunctorial}(alpha, mu, alphap)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoimageObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageObjectFunctorialWithGivenCoimageObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( C, alpha, mu, alphap, Cp ) \mapsto \mathtt{CoimageObjectFunctorialWithGivenCoimageObjects}(C, alpha, mu, alphap, Cp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageObjectFunctorialWithGivenCoimageObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoimageObjectFunctorialWithGivenCoimageObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageProjection`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{CoimageProjection}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageProjection",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoimageProjection",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoimageProjectionWithGivenCoimageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, C ) \mapsto \mathtt{CoimageProjectionWithGivenCoimageObject}(alpha, C)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoimageProjectionWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoimageProjectionWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelColift`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, T, tau ) \mapsto \mathtt{CokernelColift}(alpha, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelColift",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCokernelColift",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelColiftWithGivenCokernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, T, tau, P ) \mapsto \mathtt{CokernelColiftWithGivenCokernelObject}(alpha, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelColiftWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCokernelColiftWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{CokernelObject}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelObjectFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, mu, alphap ) \mapsto \mathtt{CokernelObjectFunctorial}(alpha, mu, alphap)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCokernelObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelObjectFunctorialWithGivenCokernelObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, alpha, mu, alphap, Pp ) \mapsto \mathtt{CokernelObjectFunctorialWithGivenCokernelObjects}(P, alpha, mu, alphap, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelObjectFunctorialWithGivenCokernelObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCokernelObjectFunctorialWithGivenCokernelObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelProjection`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{CokernelProjection}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelProjection",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCokernelProjection",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CokernelProjectionWithGivenCokernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, P ) \mapsto \mathtt{CokernelProjectionWithGivenCokernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCokernelProjectionWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCokernelProjectionWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Colift`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{Colift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddColift",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddColift",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ColiftAlongEpimorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( epsilon, tau ) \mapsto \mathtt{ColiftAlongEpimorphism}(epsilon, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddColiftAlongEpimorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddColiftAlongEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ComponentOfMorphismFromCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, I, i ) \mapsto \mathtt{ComponentOfMorphismFromCoproduct}(alpha, I, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddComponentOfMorphismFromCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddComponentOfMorphismFromCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ComponentOfMorphismFromDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, S, i ) \mapsto \mathtt{ComponentOfMorphismFromDirectSum}(alpha, S, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddComponentOfMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddComponentOfMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ComponentOfMorphismIntoDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, P, i ) \mapsto \mathtt{ComponentOfMorphismIntoDirectProduct}(alpha, P, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddComponentOfMorphismIntoDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddComponentOfMorphismIntoDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ComponentOfMorphismIntoDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, S, i ) \mapsto \mathtt{ComponentOfMorphismIntoDirectSum}(alpha, S, i)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddComponentOfMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddComponentOfMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Coproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects ) \mapsto \mathtt{Coproduct}(objects)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoproductFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, L, objectsp ) \mapsto \mathtt{CoproductFunctorial}(objects, L, objectsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoproductFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoproductFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `CoproductFunctorialWithGivenCoproducts`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, objects, L, objectsp, Pp ) \mapsto \mathtt{CoproductFunctorialWithGivenCoproducts}(P, objects, L, objectsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddCoproductFunctorialWithGivenCoproducts",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddCoproductFunctorialWithGivenCoproducts",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects ) \mapsto \mathtt{DirectProduct}(objects)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectProductFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, L, objectsp ) \mapsto \mathtt{DirectProductFunctorial}(objects, L, objectsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectProductFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddDirectProductFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectProductFunctorialWithGivenDirectProducts`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, objects, L, objectsp, Pp ) \mapsto \mathtt{DirectProductFunctorialWithGivenDirectProducts}(P, objects, L, objectsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectProductFunctorialWithGivenDirectProducts",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddDirectProductFunctorialWithGivenDirectProducts",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects ) \mapsto \mathtt{DirectSum}(objects)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSumFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, L, objectsp ) \mapsto \mathtt{DirectSumFunctorial}(objects, L, objectsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSumFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddDirectSumFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DirectSumFunctorialWithGivenDirectSums`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, objects, L, objectsp, Pp ) \mapsto \mathtt{DirectSumFunctorialWithGivenDirectSums}(P, objects, L, objectsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDirectSumFunctorialWithGivenDirectSums",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddDirectSumFunctorialWithGivenDirectSums",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `DistinguishedObjectOfHomomorphismStructure`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{DistinguishedObjectOfHomomorphismStructure}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddDistinguishedObjectOfHomomorphismStructure",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddDistinguishedObjectOfHomomorphismStructure",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EmbeddingOfEqualizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms ) \mapsto \mathtt{EmbeddingOfEqualizer}(Y, morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEmbeddingOfEqualizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEmbeddingOfEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EmbeddingOfEqualizerWithGivenEqualizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, P ) \mapsto \mathtt{EmbeddingOfEqualizerWithGivenEqualizer}(Y, morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEmbeddingOfEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEmbeddingOfEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EpimorphismFromProjectiveCoverObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A ) \mapsto \mathtt{EpimorphismFromProjectiveCoverObject}(A)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEpimorphismFromProjectiveCoverObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEpimorphismFromProjectiveCoverObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, P ) \mapsto \mathtt{EpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject}(A, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEpimorphismFromProjectiveCoverObjectWithGivenProjectiveCoverObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EpimorphismFromSomeProjectiveObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A ) \mapsto \mathtt{EpimorphismFromSomeProjectiveObject}(A)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEpimorphismFromSomeProjectiveObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEpimorphismFromSomeProjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, P ) \mapsto \mathtt{EpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject}(A, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEpimorphismFromSomeProjectiveObjectWithGivenSomeProjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Equalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms ) \mapsto \mathtt{Equalizer}(Y, morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEqualizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EqualizerFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, mu, morphismsp ) \mapsto \mathtt{EqualizerFunctorial}(morphisms, mu, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEqualizerFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEqualizerFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `EqualizerFunctorialWithGivenEqualizers`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, morphisms, mu, morphismsp, Pp ) \mapsto \mathtt{EqualizerFunctorialWithGivenEqualizers}(P, morphisms, mu, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddEqualizerFunctorialWithGivenEqualizers",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddEqualizerFunctorialWithGivenEqualizers",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `FiberProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms ) \mapsto \mathtt{FiberProduct}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddFiberProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `FiberProductFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, L, morphismsp ) \mapsto \mathtt{FiberProductFunctorial}(morphisms, L, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddFiberProductFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddFiberProductFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `FiberProductFunctorialWithGivenFiberProducts`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, morphisms, L, morphismsp, Pp ) \mapsto \mathtt{FiberProductFunctorialWithGivenFiberProducts}(P, morphisms, L, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddFiberProductFunctorialWithGivenFiberProducts",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddFiberProductFunctorialWithGivenFiberProducts",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomologyObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{HomologyObject}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomologyObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddHomologyObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomologyObjectFunctorialWithGivenHomologyObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( H_1, L, H_2 ) \mapsto \mathtt{HomologyObjectFunctorialWithGivenHomologyObjects}(H_1, L, H_2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomologyObjectFunctorialWithGivenHomologyObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddHomologyObjectFunctorialWithGivenHomologyObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomomorphismStructureOnMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{HomomorphismStructureOnMorphisms}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomomorphismStructureOnMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddHomomorphismStructureOnMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomomorphismStructureOnMorphismsWithGivenObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, alpha, beta, range ) \mapsto \mathtt{HomomorphismStructureOnMorphismsWithGivenObjects}(source, alpha, beta, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomomorphismStructureOnMorphismsWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddHomomorphismStructureOnMorphismsWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HomomorphismStructureOnObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{HomomorphismStructureOnObjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHomomorphismStructureOnObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddHomomorphismStructureOnObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HorizontalPostCompose`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{HorizontalPostCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHorizontalPostCompose",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddHorizontalPostCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `HorizontalPreCompose`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{HorizontalPreCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddHorizontalPreCompose",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddHorizontalPreCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IdentityMorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( a ) \mapsto \mathtt{IdentityMorphism}(a)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIdentityMorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIdentityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IdentityTwoCell`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IdentityTwoCell}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIdentityTwoCell",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIdentityTwoCell",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageEmbedding`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{ImageEmbedding}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageEmbedding",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddImageEmbedding",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageEmbeddingWithGivenImageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, I ) \mapsto \mathtt{ImageEmbeddingWithGivenImageObject}(alpha, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageEmbeddingWithGivenImageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddImageEmbeddingWithGivenImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{ImageObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageObjectFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, nu, alphap ) \mapsto \mathtt{ImageObjectFunctorial}(alpha, nu, alphap)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddImageObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ImageObjectFunctorialWithGivenImageObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( I, alpha, nu, alphap, Ip ) \mapsto \mathtt{ImageObjectFunctorialWithGivenImageObjects}(I, alpha, nu, alphap, Ip)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddImageObjectFunctorialWithGivenImageObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddImageObjectFunctorialWithGivenImageObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IndecomposableInjectiveObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{IndecomposableInjectiveObjects}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIndecomposableInjectiveObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIndecomposableInjectiveObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IndecomposableProjectiveObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{IndecomposableProjectiveObjects}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIndecomposableProjectiveObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIndecomposableProjectiveObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InitialObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{InitialObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInitialObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InitialObjectFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{InitialObjectFunctorial}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInitialObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInitialObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InitialObjectFunctorialWithGivenInitialObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, Pp ) \mapsto \mathtt{InitialObjectFunctorialWithGivenInitialObjects}(P, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInitialObjectFunctorialWithGivenInitialObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInitialObjectFunctorialWithGivenInitialObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k ) \mapsto \mathtt{InjectionOfCofactorOfCoproduct}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectionOfCofactorOfCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfCoproductWithGivenCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k, P ) \mapsto \mathtt{InjectionOfCofactorOfCoproductWithGivenCoproduct}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectionOfCofactorOfCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k ) \mapsto \mathtt{InjectionOfCofactorOfDirectSum}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectionOfCofactorOfDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfDirectSumWithGivenDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k, P ) \mapsto \mathtt{InjectionOfCofactorOfDirectSumWithGivenDirectSum}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectionOfCofactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfPushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, k ) \mapsto \mathtt{InjectionOfCofactorOfPushout}(morphisms, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectionOfCofactorOfPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectionOfCofactorOfPushoutWithGivenPushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, k, P ) \mapsto \mathtt{InjectionOfCofactorOfPushoutWithGivenPushout}(morphisms, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectionOfCofactorOfPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectionOfCofactorOfPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectiveColift`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{InjectiveColift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectiveColift",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectiveColift",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectiveDimension`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{InjectiveDimension}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectiveDimension",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectiveDimension",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InjectiveEnvelopeObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{InjectiveEnvelopeObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInjectiveEnvelopeObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInjectiveEnvelopeObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, alpha, range ) \mapsto \mathtt{InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects}(source, alpha, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructureWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, range, alpha ) \mapsto \mathtt{InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism}(source, range, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InverseForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{InverseForMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInverseForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInverseForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InverseOfMorphismFromCoimageToImage`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{InverseOfMorphismFromCoimageToImage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInverseOfMorphismFromCoimageToImage",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInverseOfMorphismFromCoimageToImage",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `InverseOfMorphismFromCoimageToImageWithGivenObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( I, alpha, C ) \mapsto \mathtt{InverseOfMorphismFromCoimageToImageWithGivenObjects}(I, alpha, C)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddInverseOfMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddInverseOfMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsAutomorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsAutomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsAutomorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsAutomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsBijectiveObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsBijectiveObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsBijectiveObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsBijectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsCodominating`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsCodominating}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsCodominating",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsCodominating",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsColiftable`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsColiftable}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsColiftable",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsColiftable",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsColiftableAlongEpimorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsColiftableAlongEpimorphism}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsColiftableAlongEpimorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsColiftableAlongEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsCongruentForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsCongruentForMorphisms}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsCongruentForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsCongruentForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsDominating`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsDominating}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsDominating",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsDominating",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEndomorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsEndomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEndomorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEndomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEpimorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsEpimorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEpimorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualAsFactorobjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualAsFactorobjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualAsFactorobjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualAsFactorobjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualAsSubobjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualAsSubobjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualAsSubobjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualAsSubobjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForCacheForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForCacheForMorphisms}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForCacheForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualForCacheForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForCacheForObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForCacheForObjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForCacheForObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualForCacheForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForMorphisms}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForMorphismsOnMor`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForMorphismsOnMor}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForMorphismsOnMor",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualForMorphismsOnMor",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualForObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsEqualForObjects}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualForObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualToIdentityMorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsEqualToIdentityMorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualToIdentityMorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualToIdentityMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsEqualToZeroMorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsEqualToZeroMorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsEqualToZeroMorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsEqualToZeroMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsHomSetInhabited`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsHomSetInhabited}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsHomSetInhabited",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsHomSetInhabited",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsIdempotent`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsIdempotent}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsIdempotent",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsIdempotent",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsInitial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsInitial}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsInitial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsInitial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsInjective`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsInjective}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsInjective",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsInjective",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsIsomorphicForObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( object_1, object_2 ) \mapsto \mathtt{IsIsomorphicForObjects}(object_1, object_2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsIsomorphicForObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsIsomorphicForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsIsomorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsIsomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsIsomorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsIsomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsLiftable`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsLiftable}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsLiftable",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsLiftable",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsLiftableAlongMonomorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{IsLiftableAlongMonomorphism}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsLiftableAlongMonomorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsLiftableAlongMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsMonomorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsMonomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsMonomorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsOne`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsOne}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsOne",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsOne",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsProjective`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsProjective}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsProjective",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsProjective",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsSplitEpimorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsSplitEpimorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsSplitEpimorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsSplitEpimorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsSplitMonomorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsSplitMonomorphism}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsSplitMonomorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsSplitMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsTerminal`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsTerminal}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsTerminal",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsTerminal",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsWellDefinedForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{IsWellDefinedForMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsWellDefinedForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsWellDefinedForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsWellDefinedForMorphismsWithGivenSourceAndRange`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, alpha, range ) \mapsto \mathtt{IsWellDefinedForMorphismsWithGivenSourceAndRange}(source, alpha, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsWellDefinedForMorphismsWithGivenSourceAndRange",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsWellDefinedForMorphismsWithGivenSourceAndRange",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsWellDefinedForObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsWellDefinedForObjects}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsWellDefinedForObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsWellDefinedForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsWellDefinedForTwoCells`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsWellDefinedForTwoCells}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsWellDefinedForTwoCells",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsWellDefinedForTwoCells",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsZeroForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsZeroForMorphisms}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsZeroForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsZeroForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsZeroForObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{IsZeroForObjects}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsZeroForObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsZeroForObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCoequalizerOfCoproductDiagramToPushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromCoequalizerOfCoproductDiagramToPushout}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromCoequalizerOfCoproductDiagramToPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, D ) \mapsto \mathtt{IsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct}(A, D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromCoequalizerToCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCoimageToCokernelOfKernel`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromCoimageToCokernelOfKernel}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCoimageToCokernelOfKernel",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromCoimageToCokernelOfKernel",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, D ) \mapsto \mathtt{IsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer}(A, D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromCokernelOfJointPairwiseDifferencesOfMorphismsFromCoproductToCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCokernelOfKernelToCoimage`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromCokernelOfKernelToCoimage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCokernelOfKernelToCoimage",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromCokernelOfKernelToCoimage",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromCoproductToDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromCoproductToDirectSum}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromCoproductToDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromCoproductToDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromDirectProductToDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromDirectProductToDirectSum}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromDirectProductToDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromDirectProductToDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromDirectSumToCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromDirectSumToCoproduct}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromDirectSumToCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromDirectSumToCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromDirectSumToDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromDirectSumToDirectProduct}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromDirectSumToDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromDirectSumToDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromEqualizerOfDirectProductDiagramToFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, D ) \mapsto \mathtt{IsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct}(A, D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromEqualizerToKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromFiberProductToEqualizerOfDirectProductDiagram`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromFiberProductToEqualizerOfDirectProductDiagram}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromFiberProductToEqualizerOfDirectProductDiagram",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromHomologyObjectToItsConstructionAsAnImageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{IsomorphismFromHomologyObjectToItsConstructionAsAnImageObject}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromHomologyObjectToItsConstructionAsAnImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromImageObjectToKernelOfCokernel`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromImageObjectToKernelOfCokernel}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromImageObjectToKernelOfCokernel",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromImageObjectToKernelOfCokernel",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromInitialObjectToZeroObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{IsomorphismFromInitialObjectToZeroObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromInitialObjectToZeroObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromInitialObjectToZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromItsConstructionAsAnImageObjectToHomologyObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{IsomorphismFromItsConstructionAsAnImageObjectToHomologyObject}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromItsConstructionAsAnImageObjectToHomologyObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromKernelOfCokernelToImageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{IsomorphismFromKernelOfCokernelToImageObject}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromKernelOfCokernelToImageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromKernelOfCokernelToImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, D ) \mapsto \mathtt{IsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer}(A, D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromKernelOfJointPairwiseDifferencesOfMorphismsIntoDirectProductToEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromPushoutToCoequalizerOfCoproductDiagram`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( D ) \mapsto \mathtt{IsomorphismFromPushoutToCoequalizerOfCoproductDiagram}(D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromPushoutToCoequalizerOfCoproductDiagram",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromTerminalObjectToZeroObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{IsomorphismFromTerminalObjectToZeroObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromTerminalObjectToZeroObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromTerminalObjectToZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromZeroObjectToInitialObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{IsomorphismFromZeroObjectToInitialObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromZeroObjectToInitialObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromZeroObjectToInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `IsomorphismFromZeroObjectToTerminalObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{IsomorphismFromZeroObjectToTerminalObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddIsomorphismFromZeroObjectToTerminalObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddIsomorphismFromZeroObjectToTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `JointPairwiseDifferencesOfMorphismsFromCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, D ) \mapsto \mathtt{JointPairwiseDifferencesOfMorphismsFromCoproduct}(A, D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddJointPairwiseDifferencesOfMorphismsFromCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddJointPairwiseDifferencesOfMorphismsFromCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `JointPairwiseDifferencesOfMorphismsIntoDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, D ) \mapsto \mathtt{JointPairwiseDifferencesOfMorphismsIntoDirectProduct}(A, D)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddJointPairwiseDifferencesOfMorphismsIntoDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddJointPairwiseDifferencesOfMorphismsIntoDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelEmbedding`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{KernelEmbedding}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelEmbedding",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddKernelEmbedding",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelEmbeddingWithGivenKernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, P ) \mapsto \mathtt{KernelEmbeddingWithGivenKernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelEmbeddingWithGivenKernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddKernelEmbeddingWithGivenKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelLift`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, T, tau ) \mapsto \mathtt{KernelLift}(alpha, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelLift",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddKernelLift",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelLiftWithGivenKernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, T, tau, P ) \mapsto \mathtt{KernelLiftWithGivenKernelObject}(alpha, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelLiftWithGivenKernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddKernelLiftWithGivenKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{KernelObject}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelObjectFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, mu, alphap ) \mapsto \mathtt{KernelObjectFunctorial}(alpha, mu, alphap)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddKernelObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `KernelObjectFunctorialWithGivenKernelObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, alpha, mu, alphap, Pp ) \mapsto \mathtt{KernelObjectFunctorialWithGivenKernelObjects}(P, alpha, mu, alphap, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddKernelObjectFunctorialWithGivenKernelObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddKernelObjectFunctorialWithGivenKernelObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Lift`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{Lift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLift",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddLift",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LiftAlongMonomorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( iota, tau ) \mapsto \mathtt{LiftAlongMonomorphism}(iota, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLiftAlongMonomorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddLiftAlongMonomorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `LinearCombinationOfMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, list_of_ring_elements, list_of_morphisms, range ) \mapsto \mathtt{LinearCombinationOfMorphisms}(source, list_of_ring_elements, list_of_morphisms, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddLinearCombinationOfMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddLinearCombinationOfMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MereExistenceOfSolutionOfLinearSystemInAbCategory`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{MereExistenceOfSolutionOfLinearSystemInAbCategory}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMereExistenceOfSolutionOfLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMereExistenceOfSolutionOfLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MonomorphismIntoInjectiveEnvelopeObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A ) \mapsto \mathtt{MonomorphismIntoInjectiveEnvelopeObject}(A)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMonomorphismIntoInjectiveEnvelopeObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMonomorphismIntoInjectiveEnvelopeObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, I ) \mapsto \mathtt{MonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject}(A, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMonomorphismIntoInjectiveEnvelopeObjectWithGivenInjectiveEnvelopeObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MonomorphismIntoSomeInjectiveObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A ) \mapsto \mathtt{MonomorphismIntoSomeInjectiveObject}(A)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMonomorphismIntoSomeInjectiveObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMonomorphismIntoSomeInjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, I ) \mapsto \mathtt{MonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject}(A, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMonomorphismIntoSomeInjectiveObjectWithGivenSomeInjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismBetweenDirectSums`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source_diagram, mat, range_diagram ) \mapsto \mathtt{MorphismBetweenDirectSums}(source_diagram, mat, range_diagram)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismBetweenDirectSums",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismBetweenDirectSums",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismBetweenDirectSumsWithGivenDirectSums`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( S, source_diagram, mat, range_diagram, T ) \mapsto \mathtt{MorphismBetweenDirectSumsWithGivenDirectSums}(S, source_diagram, mat, range_diagram, T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismBetweenDirectSumsWithGivenDirectSums",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismBetweenDirectSumsWithGivenDirectSums",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismConstructor`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{MorphismConstructor}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismConstructor",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismConstructor",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismDatum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{MorphismDatum}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismDatum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismDatum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromCoimageToImage`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{MorphismFromCoimageToImage}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromCoimageToImage",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromCoimageToImage",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromCoimageToImageWithGivenObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( C, alpha, I ) \mapsto \mathtt{MorphismFromCoimageToImageWithGivenObjects}(C, alpha, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromCoimageToImageWithGivenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromEqualizerToSink`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms ) \mapsto \mathtt{MorphismFromEqualizerToSink}(Y, morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromEqualizerToSink",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromEqualizerToSink",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromEqualizerToSinkWithGivenEqualizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, P ) \mapsto \mathtt{MorphismFromEqualizerToSinkWithGivenEqualizer}(Y, morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromEqualizerToSinkWithGivenEqualizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromEqualizerToSinkWithGivenEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromFiberProductToSink`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms ) \mapsto \mathtt{MorphismFromFiberProductToSink}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromFiberProductToSink",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromFiberProductToSink",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromFiberProductToSinkWithGivenFiberProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, P ) \mapsto \mathtt{MorphismFromFiberProductToSinkWithGivenFiberProduct}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromFiberProductToSinkWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromFiberProductToSinkWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromKernelObjectToSink`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{MorphismFromKernelObjectToSink}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromKernelObjectToSink",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromKernelObjectToSink",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromKernelObjectToSinkWithGivenKernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, P ) \mapsto \mathtt{MorphismFromKernelObjectToSinkWithGivenKernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromKernelObjectToSinkWithGivenKernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromKernelObjectToSinkWithGivenKernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCoequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms ) \mapsto \mathtt{MorphismFromSourceToCoequalizer}(Y, morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromSourceToCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCoequalizerWithGivenCoequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, P ) \mapsto \mathtt{MorphismFromSourceToCoequalizerWithGivenCoequalizer}(Y, morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromSourceToCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCokernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{MorphismFromSourceToCokernelObject}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCokernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromSourceToCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToCokernelObjectWithGivenCokernelObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, P ) \mapsto \mathtt{MorphismFromSourceToCokernelObjectWithGivenCokernelObject}(alpha, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromSourceToCokernelObjectWithGivenCokernelObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToPushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms ) \mapsto \mathtt{MorphismFromSourceToPushout}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromSourceToPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismFromSourceToPushoutWithGivenPushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, P ) \mapsto \mathtt{MorphismFromSourceToPushoutWithGivenPushout}(morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismFromSourceToPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismFromSourceToPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MorphismsOfExternalHom`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{MorphismsOfExternalHom}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMorphismsOfExternalHom",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMorphismsOfExternalHom",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `MultiplyWithElementOfCommutativeRingForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( r, alpha ) \mapsto \mathtt{MultiplyWithElementOfCommutativeRingForMorphisms}(r, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddMultiplyWithElementOfCommutativeRingForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddMultiplyWithElementOfCommutativeRingForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ObjectConstructor`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{ObjectConstructor}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddObjectConstructor",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddObjectConstructor",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ObjectDatum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{ObjectDatum}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddObjectDatum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddObjectDatum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PostCompose`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( beta, alpha ) \mapsto \mathtt{PostCompose}(beta, alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPostCompose",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPostCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PostComposeList`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, list_of_morphisms, range ) \mapsto \mathtt{PostComposeList}(source, list_of_morphisms, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPostComposeList",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPostComposeList",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PostInverseForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{PostInverseForMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPostInverseForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPostInverseForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PreCompose`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{PreCompose}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPreCompose",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPreCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PreComposeList`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, list_of_morphisms, range ) \mapsto \mathtt{PreComposeList}(source, list_of_morphisms, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPreComposeList",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPreComposeList",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PreInverseForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{PreInverseForMorphisms}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPreInverseForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPreInverseForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k ) \mapsto \mathtt{ProjectionInFactorOfDirectProduct}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionInFactorOfDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectProductWithGivenDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k, P ) \mapsto \mathtt{ProjectionInFactorOfDirectProductWithGivenDirectProduct}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionInFactorOfDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k ) \mapsto \mathtt{ProjectionInFactorOfDirectSum}(objects, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionInFactorOfDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfDirectSumWithGivenDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, k, P ) \mapsto \mathtt{ProjectionInFactorOfDirectSumWithGivenDirectSum}(objects, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionInFactorOfDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfFiberProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, k ) \mapsto \mathtt{ProjectionInFactorOfFiberProduct}(morphisms, k)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfFiberProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionInFactorOfFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionInFactorOfFiberProductWithGivenFiberProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, k, P ) \mapsto \mathtt{ProjectionInFactorOfFiberProductWithGivenFiberProduct}(morphisms, k, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionInFactorOfFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionInFactorOfFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionOntoCoequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms ) \mapsto \mathtt{ProjectionOntoCoequalizer}(Y, morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionOntoCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionOntoCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectionOntoCoequalizerWithGivenCoequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, P ) \mapsto \mathtt{ProjectionOntoCoequalizerWithGivenCoequalizer}(Y, morphisms, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectionOntoCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectionOntoCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectiveCoverObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{ProjectiveCoverObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectiveCoverObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectiveCoverObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectiveDimension`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{ProjectiveDimension}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectiveDimension",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectiveDimension",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ProjectiveLift`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{ProjectiveLift}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddProjectiveLift",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddProjectiveLift",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `Pushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms ) \mapsto \mathtt{Pushout}(morphisms)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PushoutFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, L, morphismsp ) \mapsto \mathtt{PushoutFunctorial}(morphisms, L, morphismsp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPushoutFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPushoutFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `PushoutFunctorialWithGivenPushouts`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, morphisms, L, morphismsp, Pp ) \mapsto \mathtt{PushoutFunctorialWithGivenPushouts}(P, morphisms, L, morphismsp, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddPushoutFunctorialWithGivenPushouts",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddPushoutFunctorialWithGivenPushouts",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismByInteger`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( n ) \mapsto \mathtt{RandomMorphismByInteger}(n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismByInteger",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismByList`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( L ) \mapsto \mathtt{RandomMorphismByList}(L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismByList",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismByList",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedRangeByInteger`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( B, n ) \mapsto \mathtt{RandomMorphismWithFixedRangeByInteger}(B, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedRangeByInteger",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismWithFixedRangeByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedRangeByList`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( B, L ) \mapsto \mathtt{RandomMorphismWithFixedRangeByList}(B, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedRangeByList",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismWithFixedRangeByList",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceAndRangeByInteger`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, B, n ) \mapsto \mathtt{RandomMorphismWithFixedSourceAndRangeByInteger}(A, B, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByInteger",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceAndRangeByList`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, B, L ) \mapsto \mathtt{RandomMorphismWithFixedSourceAndRangeByList}(A, B, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByList",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismWithFixedSourceAndRangeByList",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceByInteger`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, n ) \mapsto \mathtt{RandomMorphismWithFixedSourceByInteger}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceByInteger",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismWithFixedSourceByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomMorphismWithFixedSourceByList`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, L ) \mapsto \mathtt{RandomMorphismWithFixedSourceByList}(A, L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomMorphismWithFixedSourceByList",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomMorphismWithFixedSourceByList",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomObjectByInteger`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( n ) \mapsto \mathtt{RandomObjectByInteger}(n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomObjectByInteger",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomObjectByInteger",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `RandomObjectByList`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( L ) \mapsto \mathtt{RandomObjectByList}(L)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddRandomObjectByList",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddRandomObjectByList",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyEndo`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyEndo}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyEndo",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyEndo",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyEndo_IsoFromInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyEndo_IsoFromInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyEndo_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyEndo_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyEndo_IsoToInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyEndo_IsoToInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyEndo_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyEndo_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyMorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyMorphism}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyMorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, n ) \mapsto \mathtt{SimplifyObject}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyObject_IsoFromInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, n ) \mapsto \mathtt{SimplifyObject_IsoFromInputObject}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyObject_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyObject_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyObject_IsoToInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( A, n ) \mapsto \mathtt{SimplifyObject_IsoToInputObject}(A, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyObject_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyObject_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyRange`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyRange",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyRange",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyRange_IsoFromInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyRange_IsoFromInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyRange_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyRange_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifyRange_IsoToInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifyRange_IsoToInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifyRange_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifyRange_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySource`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySource}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySource",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySource",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySourceAndRange",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoFromInputRange`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoFromInputRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputRange",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoFromInputSource`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoFromInputSource}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputSource",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySourceAndRange_IsoFromInputSource",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoToInputRange`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoToInputRange}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoToInputRange",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySourceAndRange_IsoToInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySourceAndRange_IsoToInputSource`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySourceAndRange_IsoToInputSource}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySourceAndRange_IsoToInputSource",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySourceAndRange_IsoToInputSource",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySource_IsoFromInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySource_IsoFromInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySource_IsoFromInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySource_IsoFromInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SimplifySource_IsoToInputObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( mor, n ) \mapsto \mathtt{SimplifySource_IsoToInputObject}(mor, n)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSimplifySource_IsoToInputObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSimplifySource_IsoToInputObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SolveLinearSystemInAbCategory`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3, arg4 ) \mapsto \mathtt{SolveLinearSystemInAbCategory}(arg2, arg3, arg4)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSolveLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSolveLinearSystemInAbCategory",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeInjectiveObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{SomeInjectiveObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeInjectiveObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSomeInjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeIsomorphismBetweenObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( object_1, object_2 ) \mapsto \mathtt{SomeIsomorphismBetweenObjects}(object_1, object_2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeIsomorphismBetweenObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSomeIsomorphismBetweenObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeProjectiveObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2 ) \mapsto \mathtt{SomeProjectiveObject}(arg2)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeProjectiveObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSomeProjectiveObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeReductionBySplitEpiSummand`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{SomeReductionBySplitEpiSummand}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeReductionBySplitEpiSummand",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSomeReductionBySplitEpiSummand",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeReductionBySplitEpiSummand_MorphismFromInputRange`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{SomeReductionBySplitEpiSummand_MorphismFromInputRange}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismFromInputRange",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismFromInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SomeReductionBySplitEpiSummand_MorphismToInputRange`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha ) \mapsto \mathtt{SomeReductionBySplitEpiSummand_MorphismToInputRange}(alpha)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismToInputRange",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSomeReductionBySplitEpiSummand_MorphismToInputRange",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SubtractionForMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, beta ) \mapsto \mathtt{SubtractionForMorphisms}(alpha, beta)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSubtractionForMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSubtractionForMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `SumOfMorphisms`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( source, list_of_morphisms, range ) \mapsto \mathtt{SumOfMorphisms}(source, list_of_morphisms, range)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddSumOfMorphisms",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddSumOfMorphisms",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TerminalObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{TerminalObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTerminalObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TerminalObjectFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{TerminalObjectFunctorial}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTerminalObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddTerminalObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `TerminalObjectFunctorialWithGivenTerminalObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, Pp ) \mapsto \mathtt{TerminalObjectFunctorialWithGivenTerminalObjects}(P, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddTerminalObjectFunctorialWithGivenTerminalObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddTerminalObjectFunctorialWithGivenTerminalObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismFromCoequalizer}(Y, morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoequalizerWithGivenCoequalizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromCoequalizerWithGivenCoequalizer}(Y, morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromCoequalizerWithGivenCoequalizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismFromCoproduct}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromCoproductWithGivenCoproduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromCoproductWithGivenCoproduct}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromCoproductWithGivenCoproduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismFromDirectSum}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromDirectSumWithGivenDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromDirectSumWithGivenDirectSum}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromImage`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, tau ) \mapsto \mathtt{UniversalMorphismFromImage}(alpha, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromImage",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromImage",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromImageWithGivenImageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, tau, I ) \mapsto \mathtt{UniversalMorphismFromImageWithGivenImageObject}(alpha, tau, I)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromImageWithGivenImageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromInitialObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismFromInitialObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromInitialObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromInitialObjectWithGivenInitialObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismFromInitialObjectWithGivenInitialObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromInitialObjectWithGivenInitialObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromInitialObjectWithGivenInitialObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromPushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismFromPushout}(morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromPushoutWithGivenPushout`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismFromPushoutWithGivenPushout}(morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromPushoutWithGivenPushout",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromZeroObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismFromZeroObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromZeroObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismFromZeroObjectWithGivenZeroObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismFromZeroObjectWithGivenZeroObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismFromZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismFromZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoCoimage`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, tau ) \mapsto \mathtt{UniversalMorphismIntoCoimage}(alpha, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoCoimage",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoCoimage",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoCoimageWithGivenCoimageObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( alpha, tau, C ) \mapsto \mathtt{UniversalMorphismIntoCoimageWithGivenCoimageObject}(alpha, tau, C)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoCoimageWithGivenCoimageObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismIntoDirectProduct}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectProductWithGivenDirectProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoDirectProductWithGivenDirectProduct}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoDirectProductWithGivenDirectProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau ) \mapsto \mathtt{UniversalMorphismIntoDirectSum}(objects, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoDirectSumWithGivenDirectSum`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( objects, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoDirectSumWithGivenDirectSum}(objects, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoDirectSumWithGivenDirectSum",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoEqualizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismIntoEqualizer}(Y, morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoEqualizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoEqualizerWithGivenEqualizer`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( Y, morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoEqualizerWithGivenEqualizer}(Y, morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoEqualizerWithGivenEqualizer",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoFiberProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, T, tau ) \mapsto \mathtt{UniversalMorphismIntoFiberProduct}(morphisms, T, tau)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoFiberProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoFiberProductWithGivenFiberProduct`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( morphisms, T, tau, P ) \mapsto \mathtt{UniversalMorphismIntoFiberProductWithGivenFiberProduct}(morphisms, T, tau, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoFiberProductWithGivenFiberProduct",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoTerminalObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismIntoTerminalObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoTerminalObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoTerminalObjectWithGivenTerminalObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismIntoTerminalObjectWithGivenTerminalObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoTerminalObjectWithGivenTerminalObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoZeroObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T ) \mapsto \mathtt{UniversalMorphismIntoZeroObject}(T)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoZeroObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `UniversalMorphismIntoZeroObjectWithGivenZeroObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( T, P ) \mapsto \mathtt{UniversalMorphismIntoZeroObjectWithGivenZeroObject}(T, P)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddUniversalMorphismIntoZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddUniversalMorphismIntoZeroObjectWithGivenZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `VerticalPostCompose`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{VerticalPostCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddVerticalPostCompose",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddVerticalPostCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `VerticalPreCompose`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( arg2, arg3 ) \mapsto \mathtt{VerticalPreCompose}(arg2, arg3)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddVerticalPreCompose",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddVerticalPreCompose",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroMorphism`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( a, b ) \mapsto \mathtt{ZeroMorphism}(a, b)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroMorphism",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddZeroMorphism",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroObject`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{ZeroObject}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroObject",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddZeroObject",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroObjectFunctorial`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: (  ) \mapsto \mathtt{ZeroObjectFunctorial}()$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroObjectFunctorial",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddZeroObjectFunctorial",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup


#! @BeginGroup
#! @Description
#! The arguments are a category $C$ and a function $F$.
#! This operation adds the given function $F$
#! to the category for the basic operation `ZeroObjectFunctorialWithGivenZeroObjects`.
#! Optionally, a weight (default: 100) can be specified which should roughly correspond
#! to the computational complexity of the function (lower weight = less complex = faster execution).
#! $F: ( P, Pp ) \mapsto \mathtt{ZeroObjectFunctorialWithGivenZeroObjects}(P, Pp)$.
#! @Returns nothing
#! @Arguments C, F
DeclareOperation( "AddZeroObjectFunctorialWithGivenZeroObjects",
                  [ IsCapCategory, IsFunction ] );

#! @Arguments C, F, weight
DeclareOperation( "AddZeroObjectFunctorialWithGivenZeroObjects",
                  [ IsCapCategory, IsFunction, IsInt ] );
#! @EndGroup

