#! @Chunk ToricVarietiesFromGrading

LoadPackage( "ToricVarieties" );

#! The following example shows how to create the projective space $\mathbb{P}^2$ from the grading of its Cox ring.
#! Note that this functionality requires the package TopcomInterface.

#! @Log
g := [[1,1,1]];
#! [ [ 1,1,1 ] ]
v1 := ToricVarietyFromGrading( g );
#! <A toric variety of dimension 2>
CoxRing( v1 );
#! Q[x_1,x_2,x_3]
#! (weights: [ 1, 1, 1 ])
#! @EndLog


#! The following example shows how to create the resolved conifold(s) from the grading of its Cox ring.

#! @Log
g2 := [[1,1,-1,-1]];
#! [ [ 1,1,-1,-1 ] ]
v2 := ToricVarietiesFromGrading( g2 );
#! [ <A toric variety of dimension 3>, <A toric variety of dimension 3> ]
CoxRing( v2[ 1 ] );
#! Q[x_1,x_2,x_3,x_4]
#! (weights: [ 1, -1, -1, 1 ])
Display( SRIdeal( v2[ 1 ] ) );
#! x_2*x_3
#! 
#! A (left) ideal generated by the entry of the above matrix
#! 
#! (graded, degree of generator: -2)
Display( SRIdeal( v2[ 2 ] ) );
#! x_1*x_4
#! 
#! A (left) ideal generated by the entry of the above matrix
#! 
#! (graded, degree of generator: 2)
#! @EndLog
