gap> START_TEST( "Start highlevel tests" );
gap> coll :=  Collector(UnitriangularPcpGroup(10, 0));;
gap> dto_rs := DTP_DTObjFromCollector(coll, true);;
gap> dto_r := DTP_DTObjFromCollector(coll, false);;
gap> g := [];; h := [];;
gap> for i in [1 .. NumberOfGenerators(coll)] do 
> Add(g, Random([-10000, 10000]));;
> Add(h, Random([-10000, 10000]));;
> od;

# test Exp
gap> z := Random([-10000 .. 10000]);; 
gap> DTP_Exp(g, z, dto_rs);
[ 77590000, 77590000, 77590000, -77590000, -77590000, -77590000, -77590000, 
  77590000, 77590000, -3009716177590000, -3009716022410000, 3009716177590000, 
  -3009716177590000, -3009716022410000, -3009716177590000, 3009716022410000, 
  -3009716022410000, -155702652259432277590000, 155702640220567877590000, 
  -155702646240000077590000, 155702652259432122410000, 
  155702640220567877590000, -155702652259432122410000, 
  155702646240000077590000, 13589922437975583366716177590000, 
  -13589921503880088551283822410000, 13589921970988033290716177590000, 
  -13589922437975577347283977590000, 13589921348237648672148377590000, 
  -13589922282333119409851777590000, -562417417653395717484713539432277590000,
  562417408590334071425577443999922410000, 
  -562417399536614023691580000000077590000, 
  -562417444833240126508506460567722410000, 
  562417399533500572649805678000077590000, 
  39398903370814715083618655116142147148222410000, 
  -39398898683972845391698095541760750283977590000, 
  -39398901964952386188266395328861585148222410000, 
  -39398903558136172175801745003688832283977590000, 
  -2418478619895201935607449661395719714599658567722410000, 
  -2418478298729864390209303242750917925126019432277590000, 
  -2418478535076401355224843964758112391547520000077590000, 
  -277050135134299142661395453533265211819598773048129851622410000, 
  -277050121632339475933456649285041806850241296607688716177590000, 
  -10065996184460205856919361421814744694894142573493502890641999922410000 ]
gap> DTP_Exp(g, z, dto_r);  
[ 77590000, 77590000, 77590000, -77590000, -77590000, -77590000, -77590000, 
  77590000, 77590000, -3009716177590000, -3009716022410000, 3009716177590000, 
  -3009716177590000, -3009716022410000, -3009716177590000, 3009716022410000, 
  -3009716022410000, -155702652259432277590000, 155702640220567877590000, 
  -155702646240000077590000, 155702652259432122410000, 
  155702640220567877590000, -155702652259432122410000, 
  155702646240000077590000, 13589922437975583366716177590000, 
  -13589921503880088551283822410000, 13589921970988033290716177590000, 
  -13589922437975577347283977590000, 13589921348237648672148377590000, 
  -13589922282333119409851777590000, -562417417653395717484713539432277590000,
  562417408590334071425577443999922410000, 
  -562417399536614023691580000000077590000, 
  -562417444833240126508506460567722410000, 
  562417399533500572649805678000077590000, 
  39398903370814715083618655116142147148222410000, 
  -39398898683972845391698095541760750283977590000, 
  -39398901964952386188266395328861585148222410000, 
  -39398903558136172175801745003688832283977590000, 
  -2418478619895201935607449661395719714599658567722410000, 
  -2418478298729864390209303242750917925126019432277590000, 
  -2418478535076401355224843964758112391547520000077590000, 
  -277050135134299142661395453533265211819598773048129851622410000, 
  -277050121632339475933456649285041806850241296607688716177590000, 
  -10065996184460205856919361421814744694894142573493502890641999922410000 ]
gap> z := Random([-10000 .. 10000]); 
-1569
gap> DTP_Exp(h, z, dto_rs);
[ -15690000, 15690000, -15690000, 15690000, 15690000, 15690000, 15690000, 
  15690000, 15690000, 123166515690000, 123166515690000, 123166515690000, 
  -123166484310000, -123166484310000, -123166484310000, -123166484310000, 
  -123166515690000, -1287500480000015690000, 1287500480000015690000, 
  1287500726333015690000, -1287500479999984310000, -1287500480000015690000, 
  -1287500480000015690000, -1287500233666984310000, 
  -22735663350332508166484310000, 22735662060368451833484310000, 
  22735664637832988166484310000, -22735659485367491833484310000, 
  -22735659485367738166484310000, -22735660775331548166484310000, 
  -190171230870071013164536333015690000, 190171215687193102036189999984310000,
  190171230844298945265496333015690000, -190171185398744312499273666984310000,
  -190171139927424051800479999984310000, 
  -2692506125336223499429090914646833484310000, 
  2692506030099073601558937584860500515690000, 
  2692506410592818547140828577743166515690000, 
  -2692505142734649697439276150849499484310000, 
  -33439716064729416692098811780182264290000015690000, 
  33439715650156661853716706964517336423666984310000, 
  33439721048485879977718412280159272613666984310000, 
  -775072778016171717403193735819404546359716298166515690000, 
  775072709745491261398863274588309433190982015500515690000, 
  -5691299822584486198116773124485809754555392337001673666984310000 ]
gap> DTP_Exp(h, z, dto_r);  
[ -15690000, 15690000, -15690000, 15690000, 15690000, 15690000, 15690000, 
  15690000, 15690000, 123166515690000, 123166515690000, 123166515690000, 
  -123166484310000, -123166484310000, -123166484310000, -123166484310000, 
  -123166515690000, -1287500480000015690000, 1287500480000015690000, 
  1287500726333015690000, -1287500479999984310000, -1287500480000015690000, 
  -1287500480000015690000, -1287500233666984310000, 
  -22735663350332508166484310000, 22735662060368451833484310000, 
  22735664637832988166484310000, -22735659485367491833484310000, 
  -22735659485367738166484310000, -22735660775331548166484310000, 
  -190171230870071013164536333015690000, 190171215687193102036189999984310000,
  190171230844298945265496333015690000, -190171185398744312499273666984310000,
  -190171139927424051800479999984310000, 
  -2692506125336223499429090914646833484310000, 
  2692506030099073601558937584860500515690000, 
  2692506410592818547140828577743166515690000, 
  -2692505142734649697439276150849499484310000, 
  -33439716064729416692098811780182264290000015690000, 
  33439715650156661853716706964517336423666984310000, 
  33439721048485879977718412280159272613666984310000, 
  -775072778016171717403193735819404546359716298166515690000, 
  775072709745491261398863274588309433190982015500515690000, 
  -5691299822584486198116773124485809754555392337001673666984310000 ]

# test Inverse 
gap> g_inv := DTP_Inverse(g, dto_rs);
[ -10000, -10000, -10000, 10000, 10000, 10000, 10000, -10000, -10000, 
  -99990000, -100010000, 99990000, -99990000, -100010000, -99990000, 
  100010000, -100010000, -199990000, -200010000, 10000, 200010000, 
  -200010000, -200010000, -10000, 9997000099990000, -10000999900010000, 
  10001000099990000, -9996999899990000, 10003000299990000, -9998999699990000, 
  -199990000, 20004000000010000, 20000000000010000, -19999999800010000, 
  -2000000010000, 100049998000300010000, 99990000000100010000, 
  -100009996000300010000, 100009998000100010000, -1999199999997999800010000, 
  2000600079999999800010000, 199960000000000010000, 
  -99999998999099999998999700010000, -99999995000500039999000099990000, 
  39993999599979997999999990000 ]
gap> g_inv := DTP_Inverse(g, dto_r);
[ -10000, -10000, -10000, 10000, 10000, 10000, 10000, -10000, -10000, 
  -99990000, -100010000, 99990000, -99990000, -100010000, -99990000, 
  100010000, -100010000, -199990000, -200010000, 10000, 200010000, 
  -200010000, -200010000, -10000, 9997000099990000, -10000999900010000, 
  10001000099990000, -9996999899990000, 10003000299990000, -9998999699990000, 
  -199990000, 20004000000010000, 20000000000010000, -19999999800010000, 
  -2000000010000, 100049998000300010000, 99990000000100010000, 
  -100009996000300010000, 100009998000100010000, -1999199999997999800010000, 
  2000600079999999800010000, 199960000000000010000, 
  -99999998999099999998999700010000, -99999995000500039999000099990000, 
  39993999599979997999999990000 ]
gap> h_inv := DTP_Inverse(h, dto_rs);
[ -10000, 10000, -10000, 10000, 10000, 10000, 10000, 10000, 10000, 100010000, 
  100010000, 100010000, -99990000, -99990000, -99990000, -99990000, 
  -100010000, -10000, 10000, 200010000, 10000, -10000, -10000, 200010000, 
  -10001000099990000, 9998999899990000, 10001000099990000, -9998999899990000, 
  -9999000099990000, -10001000099990000, -20002000200010000, -2000000010000, 
  2000200010000, 200010000, 20000000000010000, -100030001999899990000, 
  99989997999700010000, 100010004000100010000, -100010000000299990000, 
  -200000002000000010000, -40002000200010000, 2000200019995999799990000, 
  -100000001000100059999000100010000, 99999998999500020000999700010000, 
  200019999999800040000000200010000 ]
gap> h_inv := DTP_Inverse(h, dto_r);
[ -10000, 10000, -10000, 10000, 10000, 10000, 10000, 10000, 10000, 100010000, 
  100010000, 100010000, -99990000, -99990000, -99990000, -99990000, 
  -100010000, -10000, 10000, 200010000, 10000, -10000, -10000, 200010000, 
  -10001000099990000, 9998999899990000, 10001000099990000, -9998999899990000, 
  -9999000099990000, -10001000099990000, -20002000200010000, -2000000010000, 
  2000200010000, 200010000, 20000000000010000, -100030001999899990000, 
  99989997999700010000, 100010004000100010000, -100010000000299990000, 
  -200000002000000010000, -40002000200010000, 2000200019995999799990000, 
  -100000001000100059999000100010000, 99999998999500020000999700010000, 
  200019999999800040000000200010000 ]

# test Order
gap> DTP_Order(g, dto_rs);
infinity
gap> DTP_Order(g, dto_r);
infinity
gap> DTP_Order(g_inv, dto_rs);
infinity
gap> DTP_Order(g_inv, dto_r);
infinity
gap> DTP_Order(h, dto_rs);
infinity
gap> DTP_Order(h, dto_r);
infinity
gap> DTP_Order(h_inv, dto_rs);
infinity
gap> DTP_Order(h_inv, dto_r);
infinity

# test SolveEquation
gap> DTP_SolveEquation(g, h, dto_rs);
[ 0, -20000, 0, 0, 0, 0, 0, -20000, -20000, 0, -200020000, -20000, 0, -20000, 
  0, 0, -200000000, 20000, 1999799980000, 0, 0, 0, -200000000, -200020000, 
  -20000, -19997999600000000, -200000000, 0, 399980000, 2000200000000, 20000, 
  199980004000200020000, -200000000, -200020000, -6000000020000, 0, 
  -1999800000001999800000000, 3999599980000, 200000000, -200000000, 
  19997999200019999999200020000, -19989999799980000, 6000200000000, 
  -199979988001800159998000200000000, -80006000400020000 ]
gap> DTP_SolveEquation(g, h, dto_r);
[ 0, -20000, 0, 0, 0, 0, 0, -20000, -20000, 0, -200020000, -20000, 0, -20000, 
  0, 0, -200000000, 20000, 1999799980000, 0, 0, 0, -200000000, -200020000, 
  -20000, -19997999600000000, -200000000, 0, 399980000, 2000200000000, 20000, 
  199980004000200020000, -200000000, -200020000, -6000000020000, 0, 
  -1999800000001999800000000, 3999599980000, 200000000, -200000000, 
  19997999200019999999200020000, -19989999799980000, 6000200000000, 
  -199979988001800159998000200000000, -80006000400020000 ]
gap> DTP_SolveEquation(h, g, dto_rs);
[ 0, 20000, 0, 0, 0, 0, 0, 20000, 20000, 0, 200020000, 20000, 0, 20000, 0, 0, 
  -200000000, -20000, -2000199980000, 0, 0, 0, 200000000, 200020000, 20000, 
  19997999600000000, -200000000, 0, -399980000, 1999800000000, -20000, 
  -200020003999800020000, 200000000, 200020000, -5999999980000, 400000000, 
  1999799999997999800000000, 8000000020000, 4000200000000, 200000000, 
  20001999599859991999599980000, 59993999799980000, 5999800000000, 
  199979991997799920001999400000000, 160010000000020000 ]
gap> DTP_SolveEquation(h, g, dto_r);
[ 0, 20000, 0, 0, 0, 0, 0, 20000, 20000, 0, 200020000, 20000, 0, 20000, 0, 0, 
  -200000000, -20000, -2000199980000, 0, 0, 0, 200000000, 200020000, 20000, 
  19997999600000000, -200000000, 0, -399980000, 1999800000000, -20000, 
  -200020003999800020000, 200000000, 200020000, -5999999980000, 400000000, 
  1999799999997999800000000, 8000000020000, 4000200000000, 200000000, 
  20001999599859991999599980000, 59993999799980000, 5999800000000, 
  199979991997799920001999400000000, 160010000000020000 ]
gap> DTP_SolveEquation(g, g, dto_rs);
[ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ]
gap> DTP_SolveEquation(g, g, dto_r);
[ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ]

# test Multiply
gap> DTP_Multiply(g, h, dto_rs);
[ 20000, 0, 20000, -20000, -20000, -20000, -20000, 0, 0, -100020000, 
  100000000, 100000000, -100020000, -100000000, -100020000, 99980000, 
  100020000, -2000200000000, -2000000000000, -2000000020000, 2000199980000, 
  1999800020000, 20000, 200000000, 40004000100000000, 39999999700020000, 
  40000000300020000, -40003999900020000, 1999900000000, 2000099980000, 
  -600019996000200000000, -599999996000200000000, -599960003999800020000, 
  199979994000400000000, 200019998000000000000, 12001200000004000299980000, 
  11999199960005999899980000, 3999200039996000100000000, 
  -4001200059998000100020000, -180018000000059999999599980000, 
  -59987998800080001999400000000, -59999999599999998000200000000, 
  1199879964000000079990000100020000, 1200039980000600039994000099980000, 
  -26005800239998001600079995999600000000 ]
gap> DTP_Multiply(g, h, dto_r);
[ 20000, 0, 20000, -20000, -20000, -20000, -20000, 0, 0, -100020000, 
  100000000, 100000000, -100020000, -100000000, -100020000, 99980000, 
  100020000, -2000200000000, -2000000000000, -2000000020000, 2000199980000, 
  1999800020000, 20000, 200000000, 40004000100000000, 39999999700020000, 
  40000000300020000, -40003999900020000, 1999900000000, 2000099980000, 
  -600019996000200000000, -599999996000200000000, -599960003999800020000, 
  199979994000400000000, 200019998000000000000, 12001200000004000299980000, 
  11999199960005999899980000, 3999200039996000100000000, 
  -4001200059998000100020000, -180018000000059999999599980000, 
  -59987998800080001999400000000, -59999999599999998000200000000, 
  1199879964000000079990000100020000, 1200039980000600039994000099980000, 
  -26005800239998001600079995999600000000 ]
gap> DTP_Multiply(h, g, dto_rs);
[ 20000, 0, 20000, -20000, -20000, -20000, -20000, 0, 0, 99980000, 
  -100000000, 100000000, -100020000, -100000000, -100020000, -100020000, 
  100020000, 2000000000000, 2000200000000, -1999800020000, 1999999980000, 
  2000000020000, -199980000, 0, -39998000100000000, -40001999699980000, 
  39998000300020000, -40001999900020000, 300000000, 99980000, 
  599920001999800000000, 600019997999800000000, -599940006000000020000, 
  -200040000000000000000, 200040002000000000000, -11999400019998000300020000, 
  -11999799940004000100020000, -4000599980009999900000000, 
  -4001000040002000500020000, 179984000999980003999800020000, 
  -60006000600039991999800000000, -60005999400119996000000000000, 
  1200060017998200060000000100020000, -1200219989999200080001999700020000, 
  26003199860014001200020000000200000000 ]
gap> DTP_Multiply(h, g, dto_r);
[ 20000, 0, 20000, -20000, -20000, -20000, -20000, 0, 0, 99980000, 
  -100000000, 100000000, -100020000, -100000000, -100020000, -100020000, 
  100020000, 2000000000000, 2000200000000, -1999800020000, 1999999980000, 
  2000000020000, -199980000, 0, -39998000100000000, -40001999699980000, 
  39998000300020000, -40001999900020000, 300000000, 99980000, 
  599920001999800000000, 600019997999800000000, -599940006000000020000, 
  -200040000000000000000, 200040002000000000000, -11999400019998000300020000, 
  -11999799940004000100020000, -4000599980009999900000000, 
  -4001000040002000500020000, 179984000999980003999800020000, 
  -60006000600039991999800000000, -60005999400119996000000000000, 
  1200060017998200060000000100020000, -1200219989999200080001999700020000, 
  26003199860014001200020000000200000000 ]
gap> DTP_Multiply(g_inv, h, dto_rs);
[ 0, -20000, 0, 0, 0, 0, 0, -20000, -20000, 0, -200020000, -20000, 0, -20000, 
  0, 0, -200000000, 20000, 1999799980000, 0, 0, 0, -200000000, -200020000, 
  -20000, -19997999600000000, -200000000, 0, 399980000, 2000200000000, 20000, 
  199980004000200020000, -200000000, -200020000, -6000000020000, 0, 
  -1999800000001999800000000, 3999599980000, 200000000, -200000000, 
  19997999200019999999200020000, -19989999799980000, 6000200000000, 
  -199979988001800159998000200000000, -80006000400020000 ]
gap> DTP_Multiply(g_inv, h, dto_r);
[ 0, -20000, 0, 0, 0, 0, 0, -20000, -20000, 0, -200020000, -20000, 0, -20000, 
  0, 0, -200000000, 20000, 1999799980000, 0, 0, 0, -200000000, -200020000, 
  -20000, -19997999600000000, -200000000, 0, 399980000, 2000200000000, 20000, 
  199980004000200020000, -200000000, -200020000, -6000000020000, 0, 
  -1999800000001999800000000, 3999599980000, 200000000, -200000000, 
  19997999200019999999200020000, -19989999799980000, 6000200000000, 
  -199979988001800159998000200000000, -80006000400020000 ]
gap> DTP_Multiply(h_inv, g, dto_rs);
[ 0, 20000, 0, 0, 0, 0, 0, 20000, 20000, 0, 200020000, 20000, 0, 20000, 0, 0, 
  -200000000, -20000, -2000199980000, 0, 0, 0, 200000000, 200020000, 20000, 
  19997999600000000, -200000000, 0, -399980000, 1999800000000, -20000, 
  -200020003999800020000, 200000000, 200020000, -5999999980000, 400000000, 
  1999799999997999800000000, 8000000020000, 4000200000000, 200000000, 
  20001999599859991999599980000, 59993999799980000, 5999800000000, 
  199979991997799920001999400000000, 160010000000020000 ]
gap> DTP_Multiply(h_inv, g, dto_r);
[ 0, 20000, 0, 0, 0, 0, 0, 20000, 20000, 0, 200020000, 20000, 0, 20000, 0, 0, 
  -200000000, -20000, -2000199980000, 0, 0, 0, 200000000, 200020000, 20000, 
  19997999600000000, -200000000, 0, -399980000, 1999800000000, -20000, 
  -200020003999800020000, 200000000, 200020000, -5999999980000, 400000000, 
  1999799999997999800000000, 8000000020000, 4000200000000, 200000000, 
  20001999599859991999599980000, 59993999799980000, 5999800000000, 
  199979991997799920001999400000000, 160010000000020000 ]
gap> coll := Collector(HeisenbergPcpGroup(20));;
gap> dto_rs := DTP_DTObjFromCollector(coll, true);;
gap> dto_r := DTP_DTObjFromCollector(coll, false);;
gap> g := [];; h := [];;
gap> for i in [1 .. NumberOfGenerators(coll)] do 
> Add(g, Random([-10000, 10000]));;
> Add(h, Random([-10000, 10000]));;
> od;

# test Exp
gap> z := Random([-10000 .. 10000]);; 
gap> DTP_Exp(g, z, dto_rs);
[ -63530000, 63530000, 63530000, 63530000, -63530000, 63530000, 63530000, 
  63530000, -63530000, -63530000, 63530000, -63530000, 63530000, 63530000, 
  -63530000, -63530000, 63530000, -63530000, -63530000, -63530000, -63530000, 
  -63530000, 63530000, -63530000, 63530000, 63530000, -63530000, 63530000, 
  63530000, 63530000, -63530000, -63530000, -63530000, -63530000, -63530000, 
  -63530000, -63530000, 63530000, 63530000, -63530000, -8073392463530000 ]
gap> DTP_Exp(g, z, dto_r);  
[ -63530000, 63530000, 63530000, 63530000, -63530000, 63530000, 63530000, 
  63530000, -63530000, -63530000, 63530000, -63530000, 63530000, 63530000, 
  -63530000, -63530000, 63530000, -63530000, -63530000, -63530000, -63530000, 
  -63530000, 63530000, -63530000, 63530000, 63530000, -63530000, 63530000, 
  63530000, 63530000, -63530000, -63530000, -63530000, -63530000, -63530000, 
  -63530000, -63530000, 63530000, 63530000, -63530000, -8073392463530000 ]
gap> z := Random([-10000 .. 10000]); 
-8508
gap> DTP_Exp(h, z, dto_rs);
[ -85080000, 85080000, 85080000, -85080000, -85080000, -85080000, -85080000, 
  -85080000, 85080000, 85080000, -85080000, -85080000, -85080000, 85080000, 
  -85080000, 85080000, -85080000, 85080000, -85080000, -85080000, 85080000, 
  -85080000, 85080000, -85080000, -85080000, -85080000, 85080000, 85080000, 
  85080000, 85080000, -85080000, 85080000, -85080000, 85080000, 85080000, 
  85080000, -85080000, -85080000, -85080000, 85080000, 14478914314920000 ]
gap> DTP_Exp(h, z, dto_r);  
[ -85080000, 85080000, 85080000, -85080000, -85080000, -85080000, -85080000, 
  -85080000, 85080000, 85080000, -85080000, -85080000, -85080000, 85080000, 
  -85080000, 85080000, -85080000, 85080000, -85080000, -85080000, 85080000, 
  -85080000, 85080000, -85080000, -85080000, -85080000, 85080000, 85080000, 
  85080000, 85080000, -85080000, 85080000, -85080000, 85080000, 85080000, 
  85080000, -85080000, -85080000, -85080000, 85080000, 14478914314920000 ]

# test Inverse 
gap> g_inv := DTP_Inverse(g, dto_rs);
[ -10000, 10000, 10000, 10000, -10000, 10000, 10000, 10000, -10000, -10000, 
  10000, -10000, 10000, 10000, -10000, -10000, 10000, -10000, -10000, -10000, 
  -10000, -10000, 10000, -10000, 10000, 10000, -10000, 10000, 10000, 10000, 
  -10000, -10000, -10000, -10000, -10000, -10000, -10000, 10000, 10000, 
  -10000, -400010000 ]
gap> g_inv := DTP_Inverse(g, dto_r);
[ -10000, 10000, 10000, 10000, -10000, 10000, 10000, 10000, -10000, -10000, 
  10000, -10000, 10000, 10000, -10000, -10000, 10000, -10000, -10000, -10000, 
  -10000, -10000, 10000, -10000, 10000, 10000, -10000, 10000, 10000, 10000, 
  -10000, -10000, -10000, -10000, -10000, -10000, -10000, 10000, 10000, 
  -10000, -400010000 ]
gap> h_inv := DTP_Inverse(h, dto_rs);
[ -10000, 10000, 10000, -10000, -10000, -10000, -10000, -10000, 10000, 10000, 
  -10000, -10000, -10000, 10000, -10000, 10000, -10000, 10000, -10000, 
  -10000, 10000, -10000, 10000, -10000, -10000, -10000, 10000, 10000, 10000, 
  10000, -10000, 10000, -10000, 10000, 10000, 10000, -10000, -10000, -10000, 
  10000, 399990000 ]
gap> h_inv := DTP_Inverse(h, dto_r);
[ -10000, 10000, 10000, -10000, -10000, -10000, -10000, -10000, 10000, 10000, 
  -10000, -10000, -10000, 10000, -10000, 10000, -10000, 10000, -10000, 
  -10000, 10000, -10000, 10000, -10000, -10000, -10000, 10000, 10000, 10000, 
  10000, -10000, 10000, -10000, 10000, 10000, 10000, -10000, -10000, -10000, 
  10000, 399990000 ]

# test Order
gap> DTP_Order(g, dto_rs);
infinity
gap> DTP_Order(g, dto_r);
infinity
gap> DTP_Order(g_inv, dto_rs);
infinity
gap> DTP_Order(g_inv, dto_r);
infinity
gap> DTP_Order(h, dto_rs);
infinity
gap> DTP_Order(h, dto_r);
infinity
gap> DTP_Order(h_inv, dto_rs);
infinity
gap> DTP_Order(h_inv, dto_r);
infinity

# test SolveEquation
gap> DTP_SolveEquation(g, h, dto_rs);
[ 0, 0, 0, 20000, 0, 20000, 20000, 20000, -20000, -20000, 20000, 0, 20000, 0, 
  0, -20000, 20000, -20000, 0, 0, -20000, 0, 0, 0, 20000, 20000, -20000, 0, 
  0, 0, 0, -20000, 0, -20000, -20000, -20000, 0, 20000, 20000, -20000, 
  -1000000000 ]
gap> DTP_SolveEquation(g, h, dto_r);
[ 0, 0, 0, 20000, 0, 20000, 20000, 20000, -20000, -20000, 20000, 0, 20000, 0, 
  0, -20000, 20000, -20000, 0, 0, -20000, 0, 0, 0, 20000, 20000, -20000, 0, 
  0, 0, 0, -20000, 0, -20000, -20000, -20000, 0, 20000, 20000, -20000, 
  -1000000000 ]
gap> DTP_SolveEquation(h, g, dto_rs);
[ 0, 0, 0, -20000, 0, -20000, -20000, -20000, 20000, 20000, -20000, 0, 
  -20000, 0, 0, 20000, -20000, 20000, 0, 0, 20000, 0, 0, 0, -20000, -20000, 
  20000, 0, 0, 0, 0, 20000, 0, 20000, 20000, 20000, 0, -20000, -20000, 20000, 
  1000000000 ]
gap> DTP_SolveEquation(h, g, dto_r);
[ 0, 0, 0, -20000, 0, -20000, -20000, -20000, 20000, 20000, -20000, 0, 
  -20000, 0, 0, 20000, -20000, 20000, 0, 0, 20000, 0, 0, 0, -20000, -20000, 
  20000, 0, 0, 0, 0, 20000, 0, 20000, 20000, 20000, 0, -20000, -20000, 20000, 
  1000000000 ]
gap> DTP_SolveEquation(g, g, dto_rs);
[ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ]
gap> DTP_SolveEquation(g, g, dto_r);
[ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ]

# test Multiply
gap> DTP_Multiply(g, h, dto_rs);
[ 20000, -20000, -20000, 0, 20000, 0, 0, 0, 0, 0, 0, 20000, 0, -20000, 20000, 
  0, 0, 0, 20000, 20000, 0, 20000, -20000, 20000, 0, 0, 0, -20000, -20000, 
  -20000, 20000, 0, 20000, 0, 0, 0, 20000, 0, 0, 0, 600020000 ]
gap> DTP_Multiply(g, h, dto_r);
[ 20000, -20000, -20000, 0, 20000, 0, 0, 0, 0, 0, 0, 20000, 0, -20000, 20000, 
  0, 0, 0, 20000, 20000, 0, 20000, -20000, 20000, 0, 0, 0, -20000, -20000, 
  -20000, 20000, 0, 20000, 0, 0, 0, 20000, 0, 0, 0, 600020000 ]
gap> DTP_Multiply(h, g, dto_rs);
[ 20000, -20000, -20000, 0, 20000, 0, 0, 0, 0, 0, 0, 20000, 0, -20000, 20000, 
  0, 0, 0, 20000, 20000, 0, 20000, -20000, 20000, 0, 0, 0, -20000, -20000, 
  -20000, 20000, 0, 20000, 0, 0, 0, 20000, 0, 0, 0, -599980000 ]
gap> DTP_Multiply(h, g, dto_r);
[ 20000, -20000, -20000, 0, 20000, 0, 0, 0, 0, 0, 0, 20000, 0, -20000, 20000, 
  0, 0, 0, 20000, 20000, 0, 20000, -20000, 20000, 0, 0, 0, -20000, -20000, 
  -20000, 20000, 0, 20000, 0, 0, 0, 20000, 0, 0, 0, -599980000 ]
gap> DTP_Multiply(g_inv, h, dto_rs);
[ 0, 0, 0, 20000, 0, 20000, 20000, 20000, -20000, -20000, 20000, 0, 20000, 0, 
  0, -20000, 20000, -20000, 0, 0, -20000, 0, 0, 0, 20000, 20000, -20000, 0, 
  0, 0, 0, -20000, 0, -20000, -20000, -20000, 0, 20000, 20000, -20000, 
  -1000000000 ]
gap> DTP_Multiply(g_inv, h, dto_r);
[ 0, 0, 0, 20000, 0, 20000, 20000, 20000, -20000, -20000, 20000, 0, 20000, 0, 
  0, -20000, 20000, -20000, 0, 0, -20000, 0, 0, 0, 20000, 20000, -20000, 0, 
  0, 0, 0, -20000, 0, -20000, -20000, -20000, 0, 20000, 20000, -20000, 
  -1000000000 ]
gap> DTP_Multiply(h_inv, g, dto_rs);
[ 0, 0, 0, -20000, 0, -20000, -20000, -20000, 20000, 20000, -20000, 0, 
  -20000, 0, 0, 20000, -20000, 20000, 0, 0, 20000, 0, 0, 0, -20000, -20000, 
  20000, 0, 0, 0, 0, 20000, 0, 20000, 20000, 20000, 0, -20000, -20000, 20000, 
  1000000000 ]
gap> DTP_Multiply(h_inv, g, dto_r);
[ 0, 0, 0, -20000, 0, -20000, -20000, -20000, 20000, 20000, -20000, 0, 
  -20000, 0, 0, 20000, -20000, 20000, 0, 0, 20000, 0, 0, 0, -20000, -20000, 
  20000, 0, 0, 0, 0, 20000, 0, 20000, 20000, 20000, 0, -20000, -20000, 20000, 
  1000000000 ]
gap> coll :=  Collector(ExamplesOfSomePcpGroups(15));;
gap> dto_rs := DTP_DTObjFromCollector(coll, true);;
gap> dto_r := DTP_DTObjFromCollector(coll, false);;
gap> g := [];; h := [];;
gap> for i in [1 .. NumberOfGenerators(coll)] do 
> Add(g, Random([-10000, 10000]));;
> Add(h, Random([-10000, 10000]));;
> od;

# test Exp
gap> z := Random([-10000 .. 10000]);; 
gap> DTP_Exp(g, z, dto_rs);
[ 92050000, -92050000, -4236141092050000, -129971868233070592050000, 
  -2990815095313503530117407950000, -55057913377599016125787937550342050000, 
  -110100880156758943073960355176342050000, 
  550799350497856193059934279513364157950000, 
  -333190132268295754567543728099433497031805134782950000, 
  -166595072468216340964820148164896246072817818592050000, 0, 0, 
  -20125361376646131996063707179733234456352487587472630611925000 ]
gap> DTP_Exp(g, z, dto_r);  
[ 92050000, -92050000, -4236141092050000, -129971868233070592050000, 
  -2990815095313503530117407950000, -55057913377599016125787937550342050000, 
  -110100880156758943073960355176342050000, 
  550799350497856193059934279513364157950000, 
  -333190132268295754567543728099433497031805134782950000, 
  -166595072468216340964820148164896246072817818592050000, 0, 0, 
  -20125361376646131996063707179733234456352487587472630611925000 ]
gap> z := Random([-10000 .. 10000]); 
-9478
gap> DTP_Exp(h, z, dto_rs);
[ 94780000, 94780000, 4492098005220000, 141927832731352944780000, 
  3363157272814930963179944780000, 63755369157364718958860578366730220000, 
  -127527555784091143451623650779180220000, 
  -637043665417674432070529958834704280220000, 
  -409136243514281764209377423913490988225176772467720000, 
  204568129312390751115854491950450885494693897055220000, 0, 0, 
  25450383745978067610171772784615454624882428543144130767170000 ]
gap> DTP_Exp(h, z, dto_r);  
[ 94780000, 94780000, 4492098005220000, 141927832731352944780000, 
  3363157272814930963179944780000, 63755369157364718958860578366730220000, 
  -127527555784091143451623650779180220000, 
  -637043665417674432070529958834704280220000, 
  -409136243514281764209377423913490988225176772467720000, 
  204568129312390751115854491950450885494693897055220000, 0, 0, 
  25450383745978067610171772784615454624882428543144130767170000 ]

# test Inverse 
gap> g_inv := DTP_Inverse(g, dto_rs);
[ -10000, 10000, -99990000, 499950010000, -1666666750010000, 
  4167500458475010000, 16664166999875010000, -41699995416333074990000, 
  833437656226042019762490000, 416583320835833417150010000, 0, 0, 
  -8331771183895508161202575015000 ]
gap> g_inv := DTP_Inverse(g, dto_r);
[ -10000, 10000, -99990000, 499950010000, -1666666750010000, 
  4167500458475010000, 16664166999875010000, -41699995416333074990000, 
  833437656226042019762490000, 416583320835833417150010000, 0, 0, 
  -8331771183895508161202575015000 ]
gap> h_inv := DTP_Inverse(h, dto_rs);
[ 10000, 10000, 99990000, 499850010000, 1665666850010000, 4162501458324990000,
  -16659167499774990000, -41600023745166874990000, 
  -832396351936476561312490000, 416416737487504250149990000, 0, 0, 
  8326564579480991690618125015000 ]
gap> h_inv := DTP_Inverse(h, dto_r);
[ 10000, 10000, 99990000, 499850010000, 1665666850010000, 4162501458324990000,
  -16659167499774990000, -41600023745166874990000, 
  -832396351936476561312490000, 416416737487504250149990000, 0, 0, 
  8326564579480991690618125015000 ]

# test Order
gap> DTP_Order(g, dto_rs);
infinity
gap> DTP_Order(g, dto_r);
infinity
gap> DTP_Order(g_inv, dto_rs);
infinity
gap> DTP_Order(g_inv, dto_r);
infinity
gap> DTP_Order(h, dto_rs);
infinity
gap> DTP_Order(h, dto_r);
infinity
gap> DTP_Order(h_inv, dto_rs);
infinity
gap> DTP_Order(h_inv, dto_r);
infinity

# test SolveEquation
gap> DTP_SolveEquation(g, h, dto_rs);
[ -20000, 0, -199980000, 1999900000000, -13333333500020000, 
  66673335166950020000, 266616671499750000000, -2000266608341666150000000, 
  26674334133120864663924980000, 19994000516659997833500020000, 0, 0, 
  -399944996222209830264653900025000 ]
gap> DTP_SolveEquation(g, h, dto_r);
[ -20000, 0, -199980000, 1999900000000, -13333333500020000, 
  66673335166950020000, 266616671499750000000, -2000266608341666150000000, 
  26674334133120864663924980000, 19994000516659997833500020000, 0, 0, 
  -399944996222209830264653900025000 ]
gap> DTP_SolveEquation(h, g, dto_rs);
[ 20000, 0, 199980000, 1999700000000, 13329333700020000, 66633339166649980000,
  -266596671499950000000, -1998666914988332950000000, 
  -26648339399045873499824980000, 19992667916530005500099980000, 0, 0, 
  399815030551635232756485400025000 ]
gap> DTP_SolveEquation(h, g, dto_r);
[ 20000, 0, 199980000, 1999700000000, 13329333700020000, 66633339166649980000,
  -266596671499950000000, -1998666914988332950000000, 
  -26648339399045873499824980000, 19992667916530005500099980000, 0, 0, 
  399815030551635232756485400025000 ]
gap> DTP_SolveEquation(g, g, dto_rs);
[ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5000 ]
gap> DTP_SolveEquation(g, g, dto_r);
[ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5000 ]

# test Multiply
gap> DTP_Multiply(g, h, dto_rs);
[ 0, -20000, 100000000, -499950020000, 1666666750000000, -4167500458475000000,
  7498000124980000, 41633328754333074980000, 833062710427277980837500000, 
  -416583437492498916350000000, 0, 0, 4169269913720441278201325000000 ]
gap> DTP_Multiply(g, h, dto_r);
[ 0, -20000, 100000000, -499950020000, 1666666750000000, -4167500458475000000,
  7498000124980000, 41633328754333074980000, 833062710427277980837500000, 
  -416583437492498916350000000, 0, 0, 4169269913720441278201325000000 ]
gap> DTP_Multiply(h, g, dto_rs);
[ 0, -20000, -100000000, -499850020000, -1665666850000000, 
  -4162501458325000000, -2499499825020000, 41633347085166074980000, 
  -832604447875220436487500000, -416416720840832749950000000, 0, 0, 
  -4164063183922582739617275000000 ]
gap> DTP_Multiply(h, g, dto_r);
[ 0, -20000, -100000000, -499850020000, -1665666850000000, 
  -4162501458325000000, -2499499825020000, 41633347085166074980000, 
  -832604447875220436487500000, -416416720840832749950000000, 0, 0, 
  -4164063183922582739617275000000 ]
gap> DTP_Multiply(g_inv, h, dto_rs);
[ -20000, 0, -199980000, 1999900000000, -13333333500020000, 
  66673335166950020000, 266616671499750000000, -2000266608341666150000000, 
  26674334133120864663924980000, 19994000516659997833500020000, 0, 0, 
  -399944996222209830264653900030000 ]
gap> DTP_Multiply(g_inv, h, dto_r);
[ -20000, 0, -199980000, 1999900000000, -13333333500020000, 
  66673335166950020000, 266616671499750000000, -2000266608341666150000000, 
  26674334133120864663924980000, 19994000516659997833500020000, 0, 0, 
  -399944996222209830264653900030000 ]
gap> DTP_Multiply(h_inv, g, dto_rs);
[ 20000, 0, 199980000, 1999700000000, 13329333700020000, 66633339166649980000,
  -266596671499950000000, -1998666914988332950000000, 
  -26648339399045873499824980000, 19992667916530005500099980000, 0, 0, 
  399815030551635232756485400030000 ]
gap> DTP_Multiply(h_inv, g, dto_r);
[ 20000, 0, 199980000, 1999700000000, 13329333700020000, 66633339166649980000,
  -266596671499950000000, -1998666914988332950000000, 
  -26648339399045873499824980000, 19992667916530005500099980000, 0, 0, 
  399815030551635232756485400030000 ]
gap> STOP_TEST( "highlevel.tst", 10000 );
