gap> START_TEST("Standard FF");

# from manual
gap> Fp := FF(2, 1);
GF(2)
gap> F := FF(2, 100);
FF(2, 100)
gap> Size(F);
1267650600228229401496703205376
gap> p := NextPrimeInt(10^50);
100000000000000000000000000000000000000000000000151
gap> K := FF(p, 60);
FF(100000000000000000000000000000000000000000000000151, 60)
gap> LogInt(Size(K), 10);
3000
gap> F := FF(13, 9*5);
FF(13, 45)
gap> IsStandardPrimeField(GF(47));
true
gap> for p in [2,5,19,1009] do Print([FF(p,1),FF(p,12),FF(p,19)],"\n"); od;
[ GF(2), FF(2, 12), FF(2, 19) ]
[ GF(5), FF(5, 12), FF(5, 19) ]
[ GF(19), FF(19, 12), FF(19, 19) ]
[ GF(1009), FF(1009, 12), FF(1009, 19) ]
gap> F := FF(47, 38);
FF(47, 38)
gap> Order(ElementSteinitzNumber(F, 100));
2208
gap> Size(F);
3465122572092046296464724059395298458186535561070143621795409889
gap> F := FF(2,18);; H := FF(2,6);; emb:=Embedding(H,F);;
gap> ForAll(H, x-> PreImageElm(emb, x^emb) =x);
true
gap> F := FF(3,15);; H := FF(3,5);; emb:=Embedding(H,F);;
gap> ForAll(H, x-> PreImageElm(emb, x^emb) =x);
true
gap> F := FF(17,12);; H := FF(17,1);; emb:=Embedding(H,F);;
gap> ForAll(H, x-> PreImageElm(emb, x^emb) =x);
true
gap> for F in [FF(107,1), FF(7,6), FF(2,13)] do Print(ForAll(F,
> x-> x = ElementSteinitzNumber(F,SteinitzNumber(x))),"\n"); od;
true
true
true

# basic arithmetic
gap> sc := SizeScreen();;
gap> SizeScreen([255, 100]);;
gap> for i in [1, 6, 250, 270, 2^15, 2^16, 2^31, 2^62, 2^100] do
>   p := NextPrimeInt(i);
>   Print("# p = ",p,"\n");
>   F := FF(p, 28);
>   x := PrimitiveElement(F);
>   y := (x+One(F))^3;
>   z := 3*One(F);
>   for a in [x*y, y*z, z*y, x+y, y+z,z+y, x/y, y/z, z/y, -z, -y, x-y] do
>     Print(a,"\n");
>   od;
> od;
# p = 2
ZZ(2,28,[0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[0,0,1,1,0,1,0,1,0,0,1,0,1,0,1,0,1,1,0,0,1,1,1,0,0,1,1,0])
ZZ(2,28,[1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[0,1,1,0,1,0,1,0,0,1,0,1,0,1,0,1,1,0,0,1,1,1,0,0,1,1,0,0])
ZZ(2,28,[1])
ZZ(2,28,[1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2,28,[1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 7
ZZ(7,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[3,2,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[3,2,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[5,1,1,0,3,2,1,2,3,5,6,4,2,4,5,3,3,5,1,0,6,2,0,4,5,1,6,2])
ZZ(7,28,[5,1,1,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[3,6,0,4,6,3,6,2,1,6,5,6,5,4,2,2,1,3,0,4,6,5,5,1,3,4,6,2])
ZZ(7,28,[4])
ZZ(7,28,[6,4,4,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(7,28,[6,5,4,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 251
ZZ(251,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[245,211,42,187,157,180,217,158,133,82,43,47,204,208,32,168,81,125,154,86,159,115,180,33,116,126,245,26])
ZZ(251,28,[84,1,1,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[131,120,59,165,38,149,223,101,246,32,141,110,122,167,2,14,124,211,7,226,94,37,99,97,127,233,78,195])
ZZ(251,28,[248])
ZZ(251,28,[250,248,248,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(251,28,[250,249,248,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 271
ZZ(271,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[156,250,228,101,139,252,3,206,255,44,267,159,255,20,118,225,121,29,178,70,43,161,39,116,51,129,164,154])
ZZ(271,28,[181,1,1,181,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[208,154,32,34,214,68,76,216,132,220,206,55,60,173,133,144,87,21,210,250,212,57,77,264,116,221,191,3])
ZZ(271,28,[268])
ZZ(271,28,[270,268,268,270,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(271,28,[270,269,268,270,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 32771
ZZ(32771,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[2648,31706,5251,29223,13782,20879,12579,23222,32159,24018,24929,4519,9099,21921,13340,20591,14955,4587,15366,31182,14188,12379,25453,5359,26009,11527,13117,31143])
ZZ(32771,28,[10924,1,1,10924,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[29576,1583,22127,15395,29866,32583,4124,20805,6512,9575,13557,7837,221,25898,29002,11028,13761,31278,28004,9793,4366,27832,16077,12485,1810,6580,27887,25873])
ZZ(32771,28,[32768])
ZZ(32771,28,[32770,32768,32768,32770,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(32771,28,[32770,32769,32768,32770,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 65537
ZZ(65537,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[39130,8128,30663,41108,52256,25606,41837,7563,54370,32416,58017,2016,16986,56015,37793,29275,7237,47611,23568,41374,30951,17329,15713,997,12030,14158,38194,27525])
ZZ(65537,28,[21846,1,1,21846,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[24384,26452,57787,50584,11281,59974,22689,2878,31711,42977,6048,17825,36971,47842,22288,14787,11759,5167,58585,59133,51987,47139,2991,59771,42474,49045,17038,21425])
ZZ(65537,28,[65534])
ZZ(65537,28,[65536,65534,65534,65536,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(65537,28,[65536,65535,65534,65536,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 2147483659
ZZ(2147483659,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[387456610,1952087750,313527668,528633032,1141130006,2052113976,1174005383,2065413871,1715587543,463028619,6061649,559847554,1046641432,1616922370,303060316,1088560293,1722175099,387377786,305960699,492776764,1511377143,124028557,
2101459279,385905620,419940194,1923454256,1173845666,1025578335])
ZZ(2147483659,28,[1431655773,1,1,1431655773,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[1561295932,1452415892,1585899096,499380226,1861374610,1374532490,1901274295,1196106989,1389085857,1526972667,1679542662,992440637,555799792,118187028,1118197220,2072518522,1162133358,917882097,1478330292,239164111,372085671,982887680,
1157716860,1259820582,1475395450,1374053339,929251346,204625131])
ZZ(2147483659,28,[2147483656])
ZZ(2147483659,28,[2147483658,2147483656,2147483656,2147483658,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(2147483659,28,[2147483658,2147483657,2147483656,2147483658,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 4611686018427388039
ZZ(4611686018427388039,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[3553849053924068892,442074719215261444,4380809091118128281,1039322008105663664,4256777440797813752,2652176551182780548,393086749086785021,3079113697696931838,3979909366113886597,3050193115099979585,1448816870772684115,
938256719214387647,2693612408595034120,638508114261406154,4090264110117148710,4182365852336549,379256541623070385,1285973333877741942,3127173863701389314,2961416459608944064,639562112348776678,4516634494135000616,2141146566851543508,4358805626457289663,
2703374792848931520,4342428285794121177,2173901248177880480,806066697372003704])
ZZ(4611686018427388039,28,[3074457345618258693,1,1,3074457345618258693,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[1326224157645784332,1612864629245610192,3117966024316990992,1873317937319227127,3344843635120953605,2104369142528283666,13969056236019436,3677065345185875460,4538893326872550716,3898667034766403619,2814770157643162941,
2027121940568629310,1915524342784218462,1522058287613315767,12547097557009647,2310606936424348185,3857920001633225826,2434770977894606803,4272563360399444153,1918686337046330034,4326531445550225770,50213383947828630,3853044842517092911,
3498438360119406521,3803912820527587453,1910017726106253401,2418200092116011112,1658177798515171164])
ZZ(4611686018427388039,28,[4611686018427388036])
ZZ(4611686018427388039,28,[4611686018427388038,4611686018427388036,4611686018427388036,4611686018427388038,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(4611686018427388039,28,[4611686018427388038,4611686018427388037,4611686018427388036,4611686018427388038,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
# p = 1267650600228229401496703205653
ZZ(1267650600228229401496703205653,28,[0,1,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[3,9,9,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[1,4,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[4,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[691501856672231367434297274922,206565266742120780234496353861,655772912274036296867476342218,524435406963985605749894253800,1200252564304074121177815848340,639190249059645929906700612169,
585735513748926105332370759902,195572548183127379091782858059,987226177163466683391979996773,447343213160622726585533154049,888765855033981514903623798324,75049019165638198127361968720,464163964925206338811619161778,28896393149943677272839221488,
981071107065370556612669292788,308885335113539164021964912353,196823101417229572125133401120,1226237204715605474099102735213,805044169826731006364786481319,47585776096907993966714977549,18824758198165729396502505142,263374827516277225042264276261,
373466066987992544213687883895,605953758745483765829047425696,601317495967982049319639411925,1075322569784527616327064425854,702379045138134244714357089232,403830660405179375039612071082])
ZZ(1267650600228229401496703205653,28,[422550200076076467165567735218,1,1,422550200076076467165567735218,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[619695800226362340703489061583,699668136593879489105725821001,305655620663727415752979555747,167284728685505149210504425132,649920146950708388223398630854,489555941018548914500409074053,
586717644549382137275348574177,1191861497258416062436141247068,74379039253638778259896256494,130996364645485741717464983666,225147057496914594382085906160,124841294547389614938154279681,86689179449831031818517664464,407912120739652866844601467058,
926656005340617492065894737059,980208843222275497436806545797,1143410413690357619303901794333,1147481909251963617597656238304,142757328290723981900144932647,56474274594497188189507515426,790124482548831675126792828783,1120398200963977632641063651685,
550210676008221895990439071435,536301887675716746462215030122,690666508897124045987786866256,839486535186173332646368062043,1211491981215538125118836213246,762301543267117989696819541795])
ZZ(1267650600228229401496703205653,28,[1267650600228229401496703205650])
ZZ(1267650600228229401496703205653,28,[1267650600228229401496703205652,1267650600228229401496703205650,1267650600228229401496703205650,1267650600228229401496703205652,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
ZZ(1267650600228229401496703205653,28,[1267650600228229401496703205652,1267650600228229401496703205651,1267650600228229401496703205650,1267650600228229401496703205652,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0])
gap> SizeScreen(sc);;

# mixed arithmetic
gap> F := FF(5,30);
FF(5, 30)
gap> x := StandardPrimitiveRoot(F)^4627462;
ZZ(5,30,[1,2,2,2,0,2,2,1,3,1,4,4,3,2,2,2,4,4,2,1,3,4,3,3,2,1,3,2,0,1])
gap> l := [];;
gap> for k in DivisorsInt(30) do Add(l, x^((5^30-1)/(5^k-1))); od;
gap> for a in l do for b in l do
> erg := [a*b, a+b, a-b, -a+b, a/b, b/a]; od;od;
gap> l[3] * l[5];
ZZ(5,30,[1,4,1,0,3,1,3,0,4,0,0,0,1,0,0,0,3,0,4,0,3,0,4,0,0,4,0,0,2,0])
gap> l1 := List(l, MoveToSmallestStandardField);;
gap> for a in l1 do for b in l do
> erg := [a*b, a+b, a-b, -a+b, a/b, b/a]; od;od;
gap> l1[3] * l[2];
ZZ(5,30,[0,4,0,1,1,1,4,0,2,0,1,3,3,0,3,4,0,3,3,3,3,2,3,3,2,4,4,2,1,0])
gap> for a in l1 do for b in l1 do
> erg := [a*b, a+b, a-b, -a+b, a/b, b/a]; od;od;
gap> for a in l1 do Print(a * l1[4], "\n"); od;
ZZ(5,5,[1,3,1,1,4])
ZZ(5,10,[1,2,4,0,2,3,1,2,1,4])
ZZ(5,15,[4,4,2,4,3,4,2,3,0,0,4,0,1,0,2])
ZZ(5,5,[2,1,3,2,1])
ZZ(5,30,[3,0,2,1,4,2,0,1,3,4,4,0,4,0,4,3,0,1,4,2,1,3,1,3,1,0,2,0,0,2])
ZZ(5,10,[1,0,4,0,0,0,2,3,1,1])
ZZ(5,15,[0,4,0,3,4,1,3,1,0,2,4,1,0,3,3])
ZZ(5,30,[0,3,3,0,2,2,2,3,3,3,4,3,2,2,1,3,2,1,4,2,1,0,1,0,0,2,1,1,0,2])
gap> Z(5)^2 + l[3];
ZZ(5,30,[4,0,0,0,4,0,1,0,3,0,4,0,2,0,2,0,0,0,2,0,2,0,2,0,3,0,1,0,4,0])
gap> Z(5)^2 * l[3];
ZZ(5,30,[0,0,0,0,1,0,4,0,2,0,1,0,3,0,3,0,0,0,3,0,3,0,3,0,2,0,4,0,1,0])
gap> l[6] * Z(5)^2;
ZZ(5,30,[2,2,2,3,2,1,1,3,1,1,4,3,3,4,0,4,3,1,0,0,1,0,3,3,4,3,2,4,1,4])
gap> l[6] + Z(5)^2;
ZZ(5,30,[2,3,3,2,3,4,4,2,4,4,1,2,2,1,0,1,2,4,0,0,4,0,2,2,1,2,3,1,4,1])
gap> STOP_TEST("Standard FF", 0);
