// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include<string>
#include <awali/sttc/history/string_history.hh>
#include <awali/sttc/algos/copy.hh>
#include <awali/sttc/algos/are-isomorphic.hh>
#include <awali/sttc/algos/left-mult.hh>
#include <awali/dyn/bridge-sttc/explicit-automaton.cc>
#include <awali/sttc/weightset/b.hh>

#include<set-types.hh>

namespace awali {

  extern "C" dyn::automaton_t copy(dyn::automaton_t aut) {
    auto a = dyn::get_stc_automaton<context_t>(aut);
    return dyn::make_automaton(sttc::copy(a));
  }

  extern "C" dyn::automaton_t support(dyn::automaton_t aut) {
    auto a = dyn::get_stc_automaton<context_t>(aut);
    using bcontext_t = sttc::context<labelset_t, sttc::b>;
    auto bcontext = bcontext_t(*a->context().labelset(), sttc::b{});
    auto r = sttc::make_mutable_automaton(bcontext);
    sttc::copy_support(a, r);
    return dyn::make_automaton(r);
  }

  extern "C" dyn::automaton_t characteristic(dyn::automaton_t aut) {
    using bcontext_t = sttc::context<labelset_t, sttc::b>;
    auto a = dyn::get_stc_automaton<bcontext_t>(aut);
    auto context = context_t(*a->context().labelset(), weightset_t{});
    auto r = sttc::make_mutable_automaton(context);
    sttc::copy_support(a, r);
    return dyn::make_automaton(r);
  }

  //extern "C" unsigned add_state(dyn::automaton_t aut, std::string s) {
    //auto a = dyn::get_stc_automaton<context_t>(aut);
    //auto h = a->history();
    //unsigned i = a->add_state();
    //a->set_state_name(i, s);
    //return i;
  //}

  extern "C" bool are_isomorphic(dyn::automaton_t aut1, dyn::automaton_t aut2) {
    auto a1 = dyn::get_stc_automaton<context_t>(aut1);
    auto a2 = dyn::get_stc_automaton<context_t>(aut2);
    return sttc::are_isomorphic(a1, a2);
  }

  extern "C" dyn::automaton_t left_mult(dyn::automaton_t aut, dyn::any_t weight) {
    auto a=dyn::get_stc_automaton<context_t>(aut);
    return dyn::make_automaton(sttc::left_mult(a, weight));
  }

  extern "C" void left_mult_here(dyn::automaton_t aut, dyn::any_t weight) {
    auto a=dyn::get_stc_automaton<context_t>(aut);
    sttc::left_mult_here(a, weight);
  }

  extern "C" dyn::automaton_t right_mult(dyn::automaton_t aut, dyn::any_t weight) {
    auto a=dyn::get_stc_automaton<context_t>(aut);
    return dyn::make_automaton(sttc::right_mult(a, weight));
  }

  extern "C" void right_mult_here(dyn::automaton_t aut, dyn::any_t weight) {
    auto a=dyn::get_stc_automaton<context_t>(aut);
    sttc::right_mult_here(a, weight);
  }

}//end of ns awali

