// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include <awali/sttc/core/mutable-automaton.hh>
#include <awali/sttc/alphabets/setalpha.hh>
#include <awali/sttc/alphabets/char.hh>
#include <awali/sttc/algos/de-bruijn.hh>
#include <awali/sttc/algos/divkbaseb.hh>
#include <awali/sttc/algos/double-ring.hh>
#include <awali/sttc/algos/ladybird.hh>
#include <awali/sttc/algos/synchronizing-word.hh>
#include <awali/sttc/algos/u.hh>
#include <awali/dyn/bridge-sttc/explicit-automaton.cc>

#include<set-types.hh>

namespace awali {

  extern "C" dyn::automaton_t de_bruijn(unsigned n, char c) {
          std::set<char> al;
          al.emplace(c);
          al.emplace(c+1);
          context_t ctx(labelset_t(sttc::set_alphabet<sttc::char_letters>(al)),weightset_t{});
          return dyn::make_automaton(sttc::de_bruijn(ctx, n));
  }

  extern "C" dyn::automaton_t divkbaseb(unsigned k, unsigned b, char c) {
          std::set<char> al;
          for(int i=0;i<b;++i)
                  al.emplace(c+i);
          context_t ctx(labelset_t(sttc::set_alphabet<sttc::char_letters>(al)),weightset_t{});
          return dyn::make_automaton(sttc::divkbaseb(ctx, k, b));
  }

  extern "C" dyn::automaton_t double_ring(unsigned n, const std::vector<unsigned>& finals, char c) {
          std::set<char> al;
          al.emplace(c);
          al.emplace(c+1);
          context_t ctx(labelset_t(sttc::set_alphabet<sttc::char_letters>(al)),weightset_t{});
          return dyn::make_automaton(sttc::double_ring(ctx, n, finals));
  }

  extern "C" dyn::automaton_t ladybird(unsigned n, char c) {
          std::set<char> al;
          for(int i=0;i<3;++i)
                  al.emplace(c+i);
          context_t ctx(labelset_t(sttc::set_alphabet<sttc::char_letters>(al)),weightset_t{});
          return dyn::make_automaton(sttc::ladybird(ctx, n));
  }

  extern "C" dyn::automaton_t cerny(unsigned n, char c) {
          std::set<char> al;
          for(int i=0;i<2;++i)
                  al.emplace(c+i);
          context_t ctx(labelset_t(sttc::set_alphabet<sttc::char_letters>(al)),weightset_t{});
          return dyn::make_automaton(sttc::cerny(ctx, n));
  }

  extern "C" dyn::automaton_t witness(unsigned n, char c) {
          std::set<char> al;
          for(int i=0;i<3;++i)
                  al.emplace(c+i);
          context_t ctx(labelset_t(sttc::set_alphabet<sttc::char_letters>(al)),weightset_t{});
          return dyn::make_automaton(sttc::u(ctx, n));
  }

}

#include <awali/dyn/core/any.cc>
