// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_ABSTRACT_CONTEXT_HH
#define DYN_ABSTRACT_CONTEXT_HH

#include<memory>

#include <awali/dyn/core/any.hh>


namespace awali { namespace dyn {

  struct abstract_context_t {

    virtual std::string sname() const =0;
    virtual std::string vname(bool full = true) const =0;
//     virtual std::string latex_name() const = 0;
    virtual std::string labelname() const =0;
    virtual std::string weightname(std::string format="text") const =0;

    virtual std::vector<any_t> alphabet() const = 0;
    virtual any_t epsilon() const = 0;
    virtual void add_letter(any_t) = 0;
    virtual bool has_letter(any_t) const = 0;
    virtual any_t weight_one() const = 0;
    virtual any_t weight_zero() const = 0;

    virtual any_t add_weights(dyn::any_t l, dyn::any_t r) const = 0;
    virtual any_t mul_weights(dyn::any_t l, dyn::any_t r) const = 0;
    virtual any_t div_weights(dyn::any_t l, dyn::any_t r) const = 0;
    
    virtual any_t get_weight(std::string w) const =0;
    virtual any_t get_label(std::string w) const =0;

    virtual std::string weight_to_string(any_t w) const=0;
    virtual std::string label_to_string(any_t w) const=0;


    virtual ~abstract_context_t() {}
  };

  using context_t = std::shared_ptr<abstract_context_t>;

}}//end of ns awali::dyn
#endif
