// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_BASIC_WEIGHTSET_HH
#define DYN_BASIC_WEIGHTSET_HH
#include <awali/dyn/core/context-description/weightsets/abstract-weightset.hh>

namespace awali {
  namespace dyn {


    struct basic_weightset : abstract_weightset {
    private:
      const std::string public_name;
      const std::string class_name;
    public:
      basic_weightset(const std::string& public_name, const std::string& class_name) :
    	public_name(public_name), class_name(class_name) {}

      const std::string& tostring(weightset_description ws, bool dynamic) const {
	return class_name;
      }

  const std::string& static_public_name() const {
    return public_name;
  }

      //Returns an empty shared pointer if the string does not correspond to the weightset
      weightset_description fromstring(const std::string &k) const {
	weightset_description ws;
	if(k==public_name) {
	  ws = make_weightset_description();
	  ws->type_ = index;
	}
	return ws;
      }

      weightset_description parse_weightset(std::istream& i) const {
	return fromstring(sttc::parsestring(i));
      }

    };

  }
}

#endif
