// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_VALUE_HH
#define DYN_VALUE_HH

#include <awali/common/tuple.hh> // tuple ostream << operator
#include <awali/sttc/empty.hh> // empty ostream << operator
#include"untyped_value.hh"
#include<typeinfo>

namespace awali { namespace dyn {
  template<typename T>
  T any_cast(const any_t& a);
  namespace internal {

    template<typename T>
    struct Value : untyped_value {
      Value(const T& val) : val(val) {}
      T val;
      Value* clone() const {
	return new Value(val);
      }

      std::ostream& output(std::ostream& o) const{
	return (o << val);
      }

      bool less(const untyped_value& uv) const;

      bool equal(const untyped_value& uv) const{
	const Value& v=dynamic_cast<const Value&>(uv);
	return (val == v.val);
      }

      std::ostream&  real_type_name(std::ostream& o) const {
	o << typeid(val).name();
	return o;
      }
     
      virtual ~Value() {}
    };

    template<typename T>
    bool Value<T>::less(const untyped_value& uv) const {
      const Value& v=dynamic_cast<const Value&>(uv);
      return (val < v.val);
    }

    template<>
    bool Value<std::string>::less(const untyped_value& uv) const {
      const Value& v=dynamic_cast<const Value&>(uv);
      if(val.length() == v.val.length())
	return (val < v.val);
      else
	return (val.length() < v.val.length());
    }
  }//end of ns internal

}}//end of ns awali::dyn
#endif //DYN_VALUE_HH
