// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef AWALI_DYN_LOADING_HANDLER_HH
#define AWALI_DYN_LOADING_HANDLER_HH
#include <dlfcn.h>
#include <iostream>
#include <awali/dyn/loading/compile.hh>
#include <unordered_map>
#include <awali/dyn/core/automaton.hh>

namespace awali {
  namespace dyn {
    namespace loading {

      /* This function returns a pointer on the function 'name' of the library
	 corresponding to the 'context'.
	 If the library does not exist or does contain this function,
	 make_library is called.
      */

      void* get_handler(const std::string name, const std::string group,
			const std::string& static_context);

      void* get_handler(const std::string name, const std::string group,
			const std::string& static_context1,
			const std::string& static_context2);

      void* get_handler(const std::string name, const std::string& static_context);

      template<typename TYPERET, TYPERET (*FCT)(automaton_t)>
      TYPERET call(std::string name, std::string group, automaton_t aut) {
	std::string stat_ctx = aut->get_context()->sname();
	typedef TYPERET (*bridge_t)(automaton_t);
	static std::unordered_map<std::string, bridge_t> bridges;
	auto it = bridges.find(stat_ctx);
	if(it == bridges.end()) {
	  auto bridge = (bridge_t) get_handler(name, group, aut->get_context()->sname());
	  bridges.emplace(stat_ctx, bridge);
	  return bridge(aut);
	}
	else {
	  return it->second(aut);
	}
      }

      template<typename TYPERET, typename T2, TYPERET (*FCT)(automaton_t,T2)>
      TYPERET call2(std::string name, std::string group, automaton_t aut, T2 arg) {
	std::string stat_ctx = aut->get_context()->sname();
	typedef TYPERET (*bridge_t)(automaton_t,T2);
	static std::unordered_map<std::string, bridge_t> bridges;
	auto it = bridges.find(stat_ctx);
	if(it == bridges.end()) {
	  auto bridge = (bridge_t) get_handler(name, group, aut->get_context()->sname());
	  bridges.emplace(stat_ctx, bridge);
	  return bridge(aut, arg);
	}
	else {
	  return it->second(aut, arg);
	}
      }

      template<typename TYPERET, typename T2, typename T3, TYPERET (*FCT)(automaton_t,T2,T3)>
      TYPERET call3(std::string name, std::string group, automaton_t aut, T2 arg2, T3 arg3) {
	std::string stat_ctx = aut->get_context()->sname();
	typedef TYPERET (*bridge_t)(automaton_t,T2,T3);
	static std::unordered_map<std::string, bridge_t> bridges;
	auto it = bridges.find(stat_ctx);
	if(it == bridges.end()) {
	  auto bridge = (bridge_t) get_handler(name, group, aut->get_context()->sname());
	  bridges.emplace(stat_ctx, bridge);
	  return bridge(aut, arg2, arg3);
	}
	else {
	  return it->second(aut, arg2, arg3);
	}
      }

      template<typename TYPERET, typename T2, typename T3, typename T4, TYPERET (*FCT)(automaton_t,T2,T3,T4)>
      TYPERET call4(std::string name, std::string group, automaton_t aut, T2 arg2, T3 arg3, T4 arg4) {
	std::string stat_ctx = aut->get_context()->sname();
	typedef TYPERET (*bridge_t)(automaton_t,T2,T3,T4);
	static std::unordered_map<std::string, bridge_t> bridges;
	auto it = bridges.find(stat_ctx);
	if(it == bridges.end()) {
	  auto bridge = (bridge_t) get_handler(name, group, aut->get_context()->sname());
	  bridges.emplace(stat_ctx, bridge);
	  return bridge(aut, arg2, arg3, arg4);
	}
	else {
	  return it->second(aut, arg2, arg3, arg4);
	}
      }

      template<typename T, T (*FCT)(automaton_t,automaton_t)>
      T call_mixte(std::string name, std::string group, automaton_t aut1, automaton_t aut2) {
	std::string stat_ctx1 = aut1->get_context()->sname();
	std::string stat_ctx2 = aut2->get_context()->sname();
	std::string stat_ctx = stat_ctx1+"_"+stat_ctx2;
	typedef T (*bridge_t)(automaton_t, automaton_t);
	static std::unordered_map<std::string, bridge_t> bridges;
	auto it = bridges.find(stat_ctx);
	if(it == bridges.end()) {
	  auto bridge = (bridge_t) get_handler(name, group, stat_ctx1, stat_ctx2);
	  bridges.emplace(stat_ctx, bridge);
	  return bridge(aut1, aut2);
	}
	else {
	  return it->second(aut1, aut2);
	}
      }

      template<typename T, typename T2, T (*FCT)(automaton_t,automaton_t,T2)>
      T call_mixte2(std::string name, std::string group, automaton_t aut1, automaton_t aut2, T2 arg2) {
	std::string stat_ctx1 = aut1->get_context()->sname();
	std::string stat_ctx2 = aut2->get_context()->sname();
	std::string stat_ctx = stat_ctx1+"_"+stat_ctx2;
	typedef T (*bridge_t)(automaton_t, automaton_t, T2);
	static std::unordered_map<std::string, bridge_t> bridges;
	auto it = bridges.find(stat_ctx);
	if(it == bridges.end()) {
	  auto bridge = (bridge_t) get_handler(name, group, stat_ctx1, stat_ctx2);
	  bridges.emplace(stat_ctx, bridge);
	  return bridge(aut1, aut2, arg2);
	}
	else {
	  return it->second(aut1, aut2, arg2);
	}
      }
    }
  }
}//end of ns awali::dyn

#endif
