// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_ACCESSIBLE_CC
#define DYN_ACCESSIBLE_CC

#include <iostream>
#include <unordered_map>
#include <set>

#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/loading/handler.hh>

#include <awali/dyn/modules/accessible.hh>

namespace awali { namespace dyn {


  std::set<state_t>
  accessible_states (automaton_t aut)
  {
    return loading::call<std::set<state_t>, &accessible_states>(
                                    "accessible_states", "accessible", aut);
  }

  std::set<state_t>
  coaccessible_states (automaton_t aut)
  {
    return loading::call<std::set<state_t>, &coaccessible_states>(
                                  "coaccessible_states", "accessible", aut);
  }

  std::set<state_t> useful_states(automaton_t aut) {
    return loading::call<std::set<state_t>, &useful_states>("useful_states", "accessible",aut);
  }

  size_t num_accessible_states(automaton_t aut) {
    return loading::call<size_t, &num_accessible_states>("num_accessible_states", "accessible",aut);
  }

  size_t num_coaccessible_states(automaton_t aut) {
    return loading::call<size_t, &num_coaccessible_states>("num_coaccessible_states", "accessible",aut);
  }

    automaton_t accessible(automaton_t aut, bool keep_history) {
      return loading::call2<automaton_t, bool, &accessible>("accessible", "accessible",aut,keep_history);
  }

  automaton_t coaccessible(automaton_t aut, bool keep_history) {
    return loading::call2<automaton_t, bool, &coaccessible>("coaccessible", "accessible",aut,keep_history);
  }

  automaton_t trim(automaton_t aut, bool keep_history) {
    return loading::call2<automaton_t, bool, &trim>("trim", "accessible",aut,keep_history);
  }

  void accessible_here(automaton_t aut) {
    loading::call<void, &accessible_here>("accessible_here", "accessible",aut);
  }

  void coaccessible_here(automaton_t aut) {
    loading::call<void, &coaccessible_here>("coaccessible_here", "accessible",aut);
  }

  void trim_here(automaton_t aut) {
    loading::call<void, &trim_here>("trim_here", "accessible",aut);
  }

  bool is_trim(automaton_t aut) {
    return loading::call<bool, &is_trim>("is_trim", "accessible",aut);
  }

  bool is_useless(automaton_t aut) {
    return loading::call<bool, &is_useless>("is_useless", "accessible",aut);
  }

  bool is_accessible(automaton_t aut) {
    return loading::call<bool, &is_accessible>("is_accessible", "accessible",aut);
  }

  bool is_coaccessible(automaton_t aut) {
    return loading::call<bool, &is_coaccessible>("is_coaccessible", "accessible",aut);
  }

  bool is_empty(automaton_t aut) {
    return loading::call<bool, &is_empty>("is_empty", "accessible",aut);
  }
}}//end of ns awali::dyn

#endif
