// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_AUTOMATON_HH
#define DYN_MODULES_AUTOMATON_HH

#include <unordered_map>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/loading/handler.hh>
#include <awali/dyn/core/context-description.hh>

namespace awali {
  namespace dyn {

    automaton_t copy(automaton_t aut);
    automaton_t support(automaton_t aut);
    automaton_t characteristic(automaton_t aut, std::string semiring);

    //state_t add_state(automaton_t aut, std::string s);
    bool are_isomorphic(automaton_t aut1, automaton_t aut2);
    automaton_t left_mult(automaton_t aut, weight_t w);
    void left_mult_here(automaton_t aut, weight_t w);

    automaton_t right_mult(automaton_t aut, weight_t w);
    void right_mult_here(automaton_t aut, weight_t w);

  }
}//end of ns awali::dyn

#endif
