// This file is part of Awali.
// Copyright 2016-2019 Sylvain Lombardy, Victor Marsault, Jacques Sakarovitch
//
// Awali is a free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef DYN_MODULES_OUTPUT_HH
#define DYN_MODULES_OUTPUT_HH

#include <map>
#include <awali/dyn/core/automaton.hh>
#include <awali/dyn/modules/automaton.hh>
#include <awali/dyn/loading/handler.hh>

namespace awali { namespace dyn {

  std::ostream& daut(automaton_t aut, std::ostream& out);
  std::ostream& dot(automaton_t aut, std::ostream& out, bool history=false,
                                                       bool horizontal=true);
  std::ostream& fado(automaton_t aut, std::ostream& out);
  std::ostream& grail(automaton_t aut, std::ostream& out);
  std::ostream& efsm(automaton_t aut, std::ostream& out);
  std::ostream& json(automaton_t aut, std::ostream& out);

  std::ostream& pdf(automaton_t aut, std::ostream& o, bool history=false, bool horizontal=true);
  std::ostream& svg(automaton_t aut, std::ostream& o, bool history=false, bool horizontal=true);

  struct io {
   private :
    io(std::string name,unsigned v) : name(name), v(v) {
      //instances.push_back(this);
    }
    const std::string name;
    const static std::vector<const io*>& instances();
   public :
    unsigned int v;
    static const io dot;
    static const io fado;
    static const io grail;
    static const io json;
    static const io pdf;
    static const io svg;
  

    static io of_string(const std::string& str) {
      if (str == "default") 
        return io::json;
      for (const io* x : instances()) {
        if (x->name == str) 
          return *x;
       }
      throw std::runtime_error("Unknown format :"+str);
    };
  };
  const io io::dot("dot",0);
  const io io::fado("fado",1);
  const io io::grail("grail",2);
  const io io::json("json",3);
  const io io::pdf("pdf",4);
  const io io::svg("svg",5);

  struct autostream {
    private :
      unsigned int v;
      std::ostream& o;
    public :
      autostream(unsigned int v, std::ostream& o) : v(v), o(o) {}
      std::ostream& operator<<(automaton_t aut);
  };

  struct autistream {
    private :
      unsigned int v;
      std::istream& i;
    public :
      autistream(unsigned int v, std::istream& i) : v(v), i(i) {}
      std::istream& operator>>(automaton_t& aut);
  };

  std::ostream& operator<<(std::ostream& o, automaton_t aut);
  autostream operator<<(std::ostream& o, const io& m);
  std::istream& operator>>(std::istream& i, automaton_t& aut);
  autistream operator>>(std::istream& i, const io& m);

  automaton_t fado(std::istream& in);
  automaton_t grail(std::istream& in);



}}//end of ns awali::dyn

#endif
